/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.appserver.tools.jaxrpc.common.ValidateWSDLUtil;
import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.PackageHelper;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDataStore {
    private static boolean DEBUG = false;
    private final Set<String> implementedPackageNames = new HashSet<String>();
    private final Set<String> implementedClassNames = new HashSet<String>();
    private final Set<String> referencedPackageNames = new HashSet<String>();
    private final HashMap<String, ClassDataStore> classDataStores = new HashMap();
    private final HashMap<String, ClassDataStore> classDataStoresByClassName = new HashMap();
    private final HashMap<String, XMLResource> documents = new HashMap();
    private final Set<String> emptyXMLFiles = new HashSet<String>();
    private final HashMap<String, JSPResource> jsps = new HashMap();
    private final HashMap<String, Properties> props = new HashMap();
    private final HashMap<String, Manifest> manifests = new HashMap();
    private final Map<String, Set<String>> mapOfReferencedPackages = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> mapOfReferencedClasses = new HashMap<String, Set<String>>();
    private final Map<String, String> mapOfSharedLibraryProjects = new HashMap<String, String>();
    private final Set<String> classFiles = new HashSet<String>();
    private final Set<String> fileNames = new HashSet<String>();
    private final HashMap<String, EnumSet<Archive.AnnotationType>> archiveToAnnoTypeMap = new HashMap();
    private Map<String, Map<String, IdentifierObject>> possibleIdentifierNames = null;
    private Map<String, Set<String>> foundIdentifierNames = null;
    private Set<String> appsUsingSessions = null;
    private final Map<String, String> mapOfWSDLValidationResult = new HashMap<String, String>();
    private boolean jaxrpcPrevalidationRan = false;
    private boolean jaxrpcPrevalRanWithoutException = true;
    private File jaxrpcPrevalTempDirectory = null;
    private Map<String, String> checksums = new HashMap<String, String>();
    private String rootAppPath = new String();
    private String currentAppBeingProcessed = null;
    private boolean hiddenJunitFlag = false;
    private final Set<String> sharedLibraryNames = new HashSet<String>();
    private boolean detectedJNDINameWithConfigRule = false;
    private List<File> projectFiles;

    public void clear() {
        this.implementedPackageNames.clear();
        this.implementedClassNames.clear();
        this.classDataStores.clear();
        this.classDataStoresByClassName.clear();
        this.documents.clear();
        this.emptyXMLFiles.clear();
        this.jsps.clear();
        this.props.clear();
        this.manifests.clear();
        this.fileNames.clear();
        this.mapOfReferencedPackages.clear();
        this.mapOfReferencedClasses.clear();
        this.mapOfWSDLValidationResult.clear();
        this.referencedPackageNames.clear();
        this.classFiles.clear();
        this.currentAppBeingProcessed = null;
        this.jaxrpcPrevalTempDirectory = null;
        this.jaxrpcPrevalidationRan = false;
    }

    public void clearType(RuleType type) {
        switch (type) {
            case FileRule: {
                this.fileNames.clear();
                this.classFiles.clear();
                break;
            }
            case JavaRule: {
                this.classDataStores.clear();
                this.classDataStoresByClassName.clear();
                break;
            }
            case JspRule: {
                this.jsps.clear();
                break;
            }
            case ManifestRule: {
                this.manifests.clear();
                break;
            }
            case PropertyRule: {
                this.props.clear();
                break;
            }
            case XmlRule: {
                this.documents.clear();
                this.emptyXMLFiles.clear();
            }
        }
    }

    public void addFileName(String name2) {
        this.fileNames.add(name2);
    }

    public Set<String> getMatchingFileNames(Pattern pattern) {
        return this.getMatchingFileNames(pattern, false, false);
    }

    public Set<String> getMatchingFileNames(Pattern pattern, boolean lowercase, boolean cacheClassNamesForInventory) {
        boolean isClassFiles;
        boolean bl = isClassFiles = pattern.pattern().equals(".*\\.class$") && cacheClassNamesForInventory;
        if (isClassFiles && !this.classFiles.isEmpty()) {
            return this.classFiles;
        }
        HashSet<String> matchingNames = new HashSet<String>();
        for (String nextFileName : this.fileNames) {
            if (!pattern.matcher(nextFileName).matches() && (!lowercase || !pattern.matcher(nextFileName.toLowerCase()).matches())) continue;
            matchingNames.add(nextFileName);
            if (!isClassFiles) continue;
            this.classFiles.add(nextFileName);
        }
        return matchingNames;
    }

    public Set<String> getMatchingFoldersMissingFile(Pattern pattern, String[] folderNames, String fileName) {
        HashSet<String> foundPatterns = new HashSet<String>();
        HashSet<String> foldersWithFile = new HashSet<String>();
        Pattern fileNameRegex = Pattern.compile(".*/" + fileName);
        block0: for (String nextFileName : this.fileNames) {
            int index = nextFileName.lastIndexOf(47);
            if (index <= -1) continue;
            String thisFolderName = nextFileName.substring(0, index);
            int j = 0;
            while (j < folderNames.length) {
                if (thisFolderName.matches(pattern + "/" + folderNames[j])) {
                    int folderIndex = thisFolderName.lastIndexOf(folderNames[j]);
                    foundPatterns.add(thisFolderName.substring(0, folderIndex - 1));
                    if (fileNameRegex.matcher(nextFileName).matches()) {
                        foldersWithFile.add(thisFolderName);
                        continue block0;
                    }
                } else if (pattern.matcher(thisFolderName).matches()) {
                    foundPatterns.add(thisFolderName);
                } else {
                    int lastIndex = thisFolderName.lastIndexOf(47);
                    String parentFolderName = thisFolderName;
                    while (lastIndex > -1) {
                        String parentFolder = parentFolderName.substring(0, lastIndex);
                        if (pattern.matcher(parentFolder).matches()) {
                            foundPatterns.add(parentFolder);
                            break;
                        }
                        parentFolderName = parentFolder;
                        lastIndex = parentFolderName.lastIndexOf(47);
                    }
                }
                ++j;
            }
        }
        Iterator it = foundPatterns.iterator();
        block3: while (it.hasNext()) {
            String nextPattern = (String)it.next();
            int j = 0;
            while (j < folderNames.length) {
                if (foldersWithFile.contains(String.valueOf(nextPattern) + "/" + folderNames[j])) {
                    it.remove();
                    continue block3;
                }
                ++j;
            }
        }
        return foundPatterns;
    }

    public boolean containsPackageName(String packageName) {
        Set<String> keys = this.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ClassDataStore data = this.getClassDataStore(key);
                if (!data.containsPackageName(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsClassName(String className) {
        Set<String> keys = this.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ClassDataStore data = this.getClassDataStore(key);
                if (!data.containsClassName(className)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsStringLiteral(Pattern name2) {
        Set<String> keys = this.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ClassDataStore data = this.getClassDataStore(key);
                if (!data.containsStringLiteral(name2)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getImplementedClassNames() {
        return this.implementedClassNames;
    }

    public boolean containsImplementedClassName(String name2) {
        return this.implementedClassNames.contains(name2);
    }

    public void addImplementedClassName(String name2) {
        this.implementedClassNames.add(name2);
        if (name2.lastIndexOf(46) > 0) {
            String packageName = name2.substring(0, name2.lastIndexOf(46));
            this.addImplementedPackageName(packageName);
            this.addImplementedPackageName(String.valueOf(packageName) + "*");
        }
    }

    public Set<String> getImplementedPackageNames() {
        return this.implementedPackageNames;
    }

    public Map<String, Set<String>> getMapReferencedPackageNames() {
        return this.mapOfReferencedPackages;
    }

    public Map<String, Set<String>> getMapOfReferencedClassNames() {
        return this.mapOfReferencedClasses;
    }

    public boolean containsImplementedPackageName(String name2) {
        return PackageHelper.matchPackageName(this.implementedPackageNames, name2);
    }

    public boolean containsImplementedPackageNames(List<String> packages) {
        return PackageHelper.matchPackageNames(this.implementedPackageNames, packages);
    }

    public void addImplementedPackageName(String name2) {
        this.implementedPackageNames.add(name2);
    }

    public Set<String> getReferencedPackageNames() {
        return this.referencedPackageNames;
    }

    public void addReferencedPackageName(String name2) {
        this.referencedPackageNames.add(name2);
    }

    public void removeReferencedPackageName(String name2) {
        this.referencedPackageNames.remove(name2);
        if (name2.endsWith("*")) {
            String actualPackageName = name2.substring(0, name2.length() - 1);
            boolean endsWithDot = actualPackageName.endsWith(".");
            String packageNameWithoutDot = endsWithDot ? actualPackageName.substring(0, actualPackageName.length() - 1) : actualPackageName;
            this.referencedPackageNames.remove(packageNameWithoutDot);
            Iterator<String> it = this.referencedPackageNames.iterator();
            while (it.hasNext()) {
                String nextPackageName = it.next();
                if (endsWithDot) {
                    if (!nextPackageName.startsWith(actualPackageName)) continue;
                    it.remove();
                    continue;
                }
                if (!nextPackageName.equals(actualPackageName) && !nextPackageName.startsWith(String.valueOf(actualPackageName) + ".")) continue;
                it.remove();
            }
        }
    }

    public void addSharedLibraries(List<File> files) {
        Pattern p = Pattern.compile(".*\\/(?=[^\\/]+\\.[a-z]{3})");
        for (File file : files) {
            this.mapOfSharedLibraryProjects.put(p.matcher(file.getAbsolutePath()).replaceFirst(""), file.getAbsolutePath());
            this.sharedLibraryNames.add(file.getAbsolutePath());
        }
    }

    public Set<String> getSharedLibraryNames() {
        return this.sharedLibraryNames;
    }

    public void addDocument(XMLResource resource, String fileName) {
        if (this.documents.containsKey(fileName)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate document added: " + fileName + " *****");
        }
        this.documents.put(fileName, resource);
    }

    public XMLResource getDocument(String key) {
        return this.documents.get(key);
    }

    public Set<String> getDocumentKeys() {
        return this.documents.keySet();
    }

    public void addEmptyXMLFile(String fileName) {
        this.emptyXMLFiles.add(fileName);
    }

    public Set<String> getEmptyXMLFiles() {
        return this.emptyXMLFiles;
    }

    public Map<String, Map<String, IdentifierObject>> getPossibleIdentifierNames() {
        return this.possibleIdentifierNames;
    }

    public void setPossibleIdentifierNames(Map<String, Map<String, IdentifierObject>> possibleIdentifierNames) {
        this.possibleIdentifierNames = possibleIdentifierNames;
    }

    public Set<String> getFoundIdentifierNames(String appName) {
        return this.foundIdentifierNames.get(appName);
    }

    public Map<String, Set<String>> getFoundIdentifierNames() {
        return this.foundIdentifierNames;
    }

    public void setFoundIdentifierNames(Map<String, Set<String>> foundIdentifierNames) {
        this.foundIdentifierNames = foundIdentifierNames;
    }

    public String removeComments(String data) {
        String dataWithoutComments = null;
        int dataLength = data.length();
        int beginIndex = data.indexOf("<!--");
        if (beginIndex > -1) {
            String remainderDataWithoutComments;
            int remainderIndex;
            int endIndex = data.indexOf("-->", beginIndex);
            dataWithoutComments = endIndex > -1 ? (dataLength > (remainderIndex = endIndex + 3) ? ((remainderDataWithoutComments = this.removeComments(data.substring(remainderIndex))) != null ? String.valueOf(data.substring(0, beginIndex)) + remainderDataWithoutComments : data.substring(0, beginIndex)) : data.substring(0, beginIndex)) : data.substring(0, beginIndex);
        } else {
            return data;
        }
        return dataWithoutComments;
    }

    public void addJsp(JSPResource data, String fileName) {
        if (this.jsps.containsKey(fileName)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate jsp added: " + fileName + " *****");
        }
        this.jsps.put(fileName, data);
    }

    public JSPResource getJsp(String key) {
        return this.jsps.get(key);
    }

    public Set<String> getJspKeys() {
        return this.jsps.keySet();
    }

    public void addPropertyFile(Properties props, String fileName) {
        if (props.containsKey(fileName)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate property file added: " + fileName + " *****");
        }
        this.props.put(fileName, props);
    }

    public Properties getProps(String key) {
        return this.props.get(key);
    }

    public Set<String> getPropsKeys() {
        return this.props.keySet();
    }

    public void addManifest(Manifest manifestFile, String fileName) {
        if (this.documents.containsKey(fileName)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate manifest added: " + fileName + " *****");
        }
        this.manifests.put(fileName, manifestFile);
        this.addFileName(fileName);
    }

    public Manifest getManifest(String key) {
        return this.manifests.get(key);
    }

    public Set<String> getManifestKeys() {
        return this.manifests.keySet();
    }

    public void addClassDataStoreByFileName(ClassDataStore data, String fileName) {
        if (this.classDataStores.containsKey(fileName)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate class added: " + fileName + " *****");
        }
        this.classDataStores.put(fileName, data);
    }

    public void addClassDataStoreByClassName(ClassDataStore data, String name2) {
        if (this.classDataStoresByClassName.containsKey(name2)) {
            ReportUtility.logger.get().log(Level.FINEST, "***** Duplicate class added: " + name2 + " *****");
        }
        this.classDataStoresByClassName.put(name2, data);
        this.addImplementedClassName(name2);
    }

    public ClassDataStore getClassDataStore(String key) {
        return this.classDataStores.get(key);
    }

    public ClassDataStore getClassDataStoreByClassName(String key) {
        return this.classDataStoresByClassName.get(key);
    }

    public Set<String> getClassDataStoreKeys() {
        return this.classDataStores.keySet();
    }

    public void addToArchiveToAnnoTypeMap(String archiveName, EnumSet<Archive.AnnotationType> annoTypeSet) {
        EnumSet<Archive.AnnotationType> existingTypes = this.archiveToAnnoTypeMap.get(archiveName);
        if (existingTypes != null) {
            existingTypes.addAll(annoTypeSet);
        } else {
            this.archiveToAnnoTypeMap.put(archiveName, annoTypeSet);
        }
    }

    public HashMap<String, EnumSet<Archive.AnnotationType>> getArchiveToAnnoTypeMap() {
        return this.archiveToAnnoTypeMap;
    }

    public boolean getHiddenJunitFlag() {
        return this.hiddenJunitFlag;
    }

    public void setHiddenJunitFlag(boolean hiddenJunitFlag) {
        this.hiddenJunitFlag = hiddenJunitFlag;
    }

    public void setAppsUsingSessions(Set<String> appsUsingSessions) {
        this.appsUsingSessions = appsUsingSessions;
    }

    public Set<String> getAppsUsingSessions() {
        return this.appsUsingSessions;
    }

    public void setCurrentAppBeingProcessed(String name2) {
        this.currentAppBeingProcessed = name2;
    }

    public String getCurrentAppBeingProcessed() {
        return this.currentAppBeingProcessed;
    }

    public boolean isJAXRPCByteCodeModifierCandidate() {
        if (!this.jaxrpcPrevalidationRan) {
            this.jaxrpcPrevalRanWithoutException = this.runJAXRPCPrevalidation();
            this.jaxrpcPrevalidationRan = true;
        }
        for (String appName : this.mapOfWSDLValidationResult.keySet()) {
            if (this.checkWSDLValidationResult(this.getWSDLValidationResult(appName))) continue;
            return false;
        }
        return this.jaxrpcPrevalRanWithoutException;
    }

    /*
     * Unable to fully structure code
     */
    private boolean runJAXRPCPrevalidation() {
        for (File app : this.projectFiles) {
            try {
                appSubDir = this.getPrevalTempAppDirectory(app);
                if (appSubDir != null && (app.getAbsolutePath().endsWith(".ear") || app.getAbsolutePath().endsWith(".war"))) {
                    resultForApp = ValidateWSDLUtil.wsdlScanner(app, appSubDir);
                    this.addWSDLValidationResult(app.getAbsolutePath(), resultForApp);
                    this.logJAXRPCPrevalidationMap();
                    parent = appSubDir.getParentFile();
                    if (!parent.getName().startsWith("JAXRPCPrevalidation")) continue;
                    this.deleteDirectoryContents(parent);
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("JAXRPC_No_Temp_Directory"), new Object[0]));
                continue;
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("JAXRPC_Prevalidation_Exception"), new Object[]{app, e.getMessage()}));
                ReportUtility.logger.get().log(Level.FINE, "Exception: " + e);
                stackTrace = e.getStackTrace();
                i = 0;
                ** while (i < stackTrace.length)
            }
lbl-1000:
            // 1 sources

            {
                stack = stackTrace[i];
                ReportUtility.logger.get().log(Level.FINE, stack.toString());
                ++i;
                continue;
            }
lbl24:
            // 1 sources

            return false;
        }
        return true;
    }

    public void deleteDirectoryContents(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children == null) {
                file.delete();
            } else {
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String childName = stringArray[n2];
                    String childFilePath = String.valueOf(file.getAbsolutePath()) + File.separator + childName;
                    this.deleteDirectoryContents(new File(childFilePath));
                    ++n2;
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private void logJAXRPCPrevalidationMap() {
        ReportUtility.logger.get().log(Level.FINE, "Map of Validation Results:");
        for (String appName : this.mapOfWSDLValidationResult.keySet()) {
            ReportUtility.logger.get().log(Level.FINE, String.valueOf(appName) + this.mapOfWSDLValidationResult.get(appName));
        }
    }

    private boolean checkWSDLValidationResult(String jsonResult) {
        if (jsonResult != null) {
            try {
                JSONObject wsdlValidationJson = JSONObject.parse(jsonResult);
                JSONArray passResults = (JSONArray)wsdlValidationJson.get("passResults");
                JSONArray failResults = (JSONArray)wsdlValidationJson.get("failResults");
                if (passResults.size() > 0 && failResults.size() == 0) {
                    return true;
                }
            }
            catch (IOException e) {
                ReportUtility.logger.get().log(Level.FINE, e.getMessage());
            }
        }
        return false;
    }

    public String getWSDLValidationResult(String name2) {
        return this.mapOfWSDLValidationResult.get(name2);
    }

    public void addWSDLValidationResult(String name2, String resultForApp) {
        ReportUtility.logger.get().log(Level.FINE, "Adding Appname: " + name2 + " Result:" + resultForApp);
        this.mapOfWSDLValidationResult.put(name2, resultForApp);
    }

    public File getPrevalTempAppDirectory(File archive) {
        File prevalTempDirectory = this.getPrevalTempDirectory();
        return ReportUtility.createTempJaxrpcPrevalAppDirectory(prevalTempDirectory, archive.getAbsolutePath());
    }

    public File getPrevalTempDirectory() {
        if (this.jaxrpcPrevalTempDirectory == null) {
            this.jaxrpcPrevalTempDirectory = ReportUtility.createTempJaxrpcPrevalDirectory("JAXRPCPrevalidation");
        }
        return this.jaxrpcPrevalTempDirectory;
    }

    public void setDetectedJNDINameWithConfigRule(boolean detectedJNDINameWithConfigRule) {
        this.detectedJNDINameWithConfigRule = detectedJNDINameWithConfigRule;
    }

    public boolean getDetectedJNDINameWithConfigRule() {
        return this.detectedJNDINameWithConfigRule;
    }

    public void addProjectFiles(List<File> projectFiles) {
        this.projectFiles = projectFiles;
    }

    public void setChecksums(Map<String, String> checksums) {
        this.checksums = checksums;
    }

    public void setRootAppPath(String rootAppPath) {
        this.rootAppPath = rootAppPath;
    }

    public String getRootAppPath() {
        return this.rootAppPath;
    }

    public boolean hasNullChecksum() {
        for (String filepath : this.checksums.keySet()) {
            if (this.checksums.get(filepath) != null) continue;
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Checksum_Detected_As_Null"), filepath));
            return true;
        }
        return false;
    }

    public String getChecksum(String appPath) {
        String absPath = appPath;
        File file = new File(appPath);
        String rootAppName = ReportUtility.getFileName(this.rootAppPath);
        if (!file.isAbsolute()) {
            Matcher m = Pattern.compile("(?i)([^\\/]+\\.[ejrw]ar.*)").matcher(appPath);
            String topAppPath = m.find() ? m.group(1) : appPath;
            absPath = topAppPath.contains("/") && topAppPath.startsWith(rootAppName) ? String.valueOf(this.rootAppPath.substring(0, this.rootAppPath.lastIndexOf("/") + 1)) + topAppPath : this.findPath(topAppPath, rootAppName);
        }
        return this.checksums.get(absPath);
    }

    private String findPath(String appName, String rootAppName) {
        if (rootAppName.equals(appName)) {
            return this.rootAppPath;
        }
        String basePath = this.rootAppPath.substring(0, this.rootAppPath.lastIndexOf("/") + 1);
        for (String appPath : this.checksums.keySet()) {
            String trimmedPath = ReportUtility.getArchiveNamePath(appPath.replace(basePath, ""));
            if (!trimmedPath.equals(appName)) continue;
            return appPath;
        }
        return appName;
    }
}

