/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLEvaluationReportWriter;
import com.ibm.ws.report.writer.json.JSONEvaluationReportWriter;
import com.ibm.ws.report.writer.text.TextEvaluationReportWriter;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class DriveScanEvaluation
extends DriveScan {
    public DriveScanEvaluation(ReportInputData data) {
        super(data);
    }

    @Override
    public String getDefaultReportName() {
        return "TechnologyReport";
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        EnumMap<ReportInputData.OutputType, String> resultMap = new EnumMap<ReportInputData.OutputType, String>(ReportInputData.OutputType.class);
        List<String> uniqueProjectNames = _data.getProjectNames();
        List<String> productArray = _data.getSpecifiedProducts();
        ReportWriter writer = null;
        BinaryReportReader brr = this.getBinaryReportReader();
        if (brr != null) {
            brr.openFile();
            SortedMap<String, TechSummary> listOfTechSummaries = brr.buildTechResults();
            Map<String, Set<String>> mapOfAppNameToDescs = brr._descriptionsForNonTechRulesFlagged;
            brr.closeFile();
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        writer = new HTMLEvaluationReportWriter(uniqueProjectNames, listOfTechSummaries, productArray, _data.getEvalReportOptions(true));
                        break;
                    }
                    case JSON: {
                        writer = new JSONEvaluationReportWriter(uniqueProjectNames, listOfTechSummaries, productArray, _data.getEvalReportOptions(false), mapOfAppNameToDescs);
                        break;
                    }
                    case TEXT: {
                        writer = new TextEvaluationReportWriter(uniqueProjectNames, listOfTechSummaries, productArray, _data.getEvalReportOptions(false));
                        break;
                    }
                }
                writer.writeReport();
                resultMap.put(outputType, writer.getResult());
            }
            if (!brr._descriptionsForNonTechRulesFlagged.isEmpty()) {
                StringBuilder resultBuffer = new StringBuilder();
                block11: for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                    String result = resultMap.get((Object)outputType);
                    switch (outputType) {
                        case HTML: {
                            Iterator<String> descs;
                            for (String appName : mapOfAppNameToDescs.keySet()) {
                                descs = mapOfAppNameToDescs.get(appName).iterator();
                                int index = result.indexOf("</table>", result.indexOf("<h3>" + appName + "</h3>"));
                                resultBuffer.append("<p class=\"disclaimer\">");
                                resultBuffer.append(Messages.getString("DriveScan_Tech_Report_Footnote"));
                                resultBuffer.append("<br>\n");
                                while (descs.hasNext()) {
                                    resultBuffer.append(descs.next());
                                    resultBuffer.append("<br>\n");
                                }
                                resultBuffer.append("</p>\n");
                                int newIndex = index + "</table>".length();
                                resultMap.put(outputType, result.substring(0, newIndex) + resultBuffer.toString() + result.substring(newIndex));
                                resultBuffer.setLength(0);
                            }
                            continue block11;
                        }
                        case JSON: {
                            break;
                        }
                        case TEXT: {
                            Iterator<String> descs;
                            resultBuffer.append(Messages.getString("DriveScan_Tech_Report_Footnote"));
                            resultBuffer.append("\n");
                            for (String appName : mapOfAppNameToDescs.keySet()) {
                                descs = mapOfAppNameToDescs.get(appName).iterator();
                                while (descs.hasNext()) {
                                    resultBuffer.append("\t");
                                    resultBuffer.append(descs.next());
                                    resultBuffer.append("\n");
                                }
                            }
                            resultMap.put(outputType, result + resultBuffer.toString());
                            break;
                        }
                    }
                }
            }
        }
        return resultMap;
    }
}

