/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.cli;

import com.ibm.ws.report.binary.cmdline.ta.cli.CLIBase;
import com.ibm.ws.report.binary.cmdline.ta.cli.HouseKeeping;
import com.ibm.ws.report.binary.cmdline.ta.cli.SourceServer;
import com.ibm.ws.report.binary.cmdline.ta.nls.NLSUtils;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_AsciiTableRenderer;
import de.vandermeer.asciitable.v2.render.WidthAbsoluteEven;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import java.util.List;
import java.util.Locale;

public class CLI
extends CLIBase {
    public static final int CLI_TABLE_WIDTH = 90;
    private static final int CLI_PROGRESS_BAR_LENGTH = 50;
    private static final int CLI_SCREEN_SIZE_ROWS = 50;
    private static final int CLI_SCREEN_SIZE_COLUMNS = 100;
    private static final int CLI_UPDATE_INTERVAL = 5;
    private static final int CLI_REDRAW_TABLE_WAIT_INTERVAL = 2000;
    private final boolean displayCLI;

    public CLI(Locale locale, boolean displayCLI, String outputDirPath, boolean saveTAScanStatusToJson) {
        super(locale, displayCLI, outputDirPath, saveTAScanStatusToJson);
        this.displayCLI = displayCLI;
    }

    @Override
    protected void reDrawTable(boolean force) {
        if (!pauseCli.booleanValue() && this.displayCLI) {
            redrawTableStopWatch.split();
            if (force || redrawTableStopWatch.getTime() > 2000L) {
                HouseKeeping.moveCursorToR1C1();
                V2_AsciiTable asciiTable = (V2_AsciiTable)this.getNewTable();
                String tableString = CLI.renderTable(asciiTable);
                System.out.println(tableString);
                redrawTableStopWatch.reset();
                redrawTableStopWatch.start();
            }
        }
    }

    @Override
    protected Object getNewTable() {
        List<String> profileSection;
        V2_AsciiTable asciiTable = new V2_AsciiTable();
        asciiTable.addStrongRule();
        asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.status") + cliAsciiTable.getCliStatusSection().getCurrentStatus());
        asciiTable.addRule();
        List<String> configFilesSection = this.getConfigFileSection();
        asciiTable.addRow(null, configFilesSection.get(0)).setAlignment(new char[]{'l', 'l'});
        asciiTable.addRule();
        if (isOutsideLocation.booleanValue()) {
            profileSection = this.getOutsideLocationSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.outside.location")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, profileSection.get(0));
            asciiTable.addRow(null, profileSection.get(1));
        } else if (sourceServer.equals((Object)SourceServer.name.WAS)) {
            profileSection = this.getProfileSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.profile.title")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, profileSection.get(0));
            asciiTable.addRow(null, profileSection.get(1));
        } else if (sourceServer.equals((Object)SourceServer.name.WEBLOGIC)) {
            List<String> weblogicDomainSection = this.getWeblogicDomainSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.weblogic.domain.title")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, weblogicDomainSection.get(0));
            asciiTable.addRow(null, weblogicDomainSection.get(1));
        } else if (sourceServer.equals((Object)SourceServer.name.JBOSS)) {
            List<String> jbossInstanceSection = this.getJbossInstanceSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.jboss.instance.title")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, jbossInstanceSection.get(0));
            asciiTable.addRow(null, jbossInstanceSection.get(1));
        } else if (sourceServer.equals((Object)SourceServer.name.TOMCAT)) {
            List<String> tomcatInstanceSection = this.getTomcatInstanceSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.tomcat.instance.title")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, tomcatInstanceSection.get(0));
            asciiTable.addRow(null, tomcatInstanceSection.get(1));
        }
        asciiTable.addRule();
        List<String> applicationSection = this.getApplicationSection();
        asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.application.title")).setAlignment(new char[]{'c', 'c'});
        asciiTable.addRow(null, applicationSection.get(0)).setAlignment(new char[]{'l', 'l'});
        asciiTable.addRow(null, applicationSection.get(1)).setAlignment(new char[]{'l', 'l'});
        asciiTable.addRule();
        if (hasSharedLibraries) {
            List<String> sharedLibrariesSection = this.getSharedLibrariesSection();
            asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.sharedlibraries.title")).setAlignment(new char[]{'c', 'c'});
            asciiTable.addRow(null, sharedLibrariesSection.get(0)).setAlignment(new char[]{'l', 'l'});
            asciiTable.addRow(null, sharedLibrariesSection.get(1)).setAlignment(new char[]{'l', 'l'});
            asciiTable.addRule();
        }
        List<String> timeSection = this.getTimeSection();
        asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.time.title")).setAlignment(new char[]{'c', 'c'});
        asciiTable.addRow(null, timeSection.get(0)).setAlignment(new char[]{'l', 'l'});
        asciiTable.addRow(null, timeSection.get(1)).setAlignment(new char[]{'l', 'l'});
        asciiTable.addRule();
        List<String> progressBarSection = this.getProgressBarSection();
        asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.progress.title")).setAlignment(new char[]{'c', 'c'});
        asciiTable.addRow(null, progressBarSection.get(0)).setAlignment(new char[]{'c', 'c'});
        asciiTable.addRule();
        List<String> currentlyAnalyzingSection = this.getCurrentOperationSection();
        asciiTable.addRow(null, NLSUtils.format(this.locale, "ta.dc.current.op"));
        asciiTable.addRow(null, currentlyAnalyzingSection.get(0));
        asciiTable.addRow(null, currentlyAnalyzingSection.get(1));
        asciiTable.addRow(null, currentlyAnalyzingSection.get(2));
        asciiTable.addStrongRule();
        return asciiTable;
    }

    private static String renderTable(V2_AsciiTable at) {
        V2_AsciiTableRenderer rend = new V2_AsciiTableRenderer();
        rend.setTheme(V2_E_TableThemes.PLAIN_7BIT_STRONG.get());
        rend.setWidth(new WidthAbsoluteEven(90));
        return rend.render(at).toString();
    }
}

