/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.cli;

import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.ta.cli.CliAsciiTable;
import com.ibm.ws.report.binary.cmdline.ta.cli.HouseKeeping;
import com.ibm.ws.report.binary.cmdline.ta.cli.SourceServer;
import com.ibm.ws.report.binary.cmdline.ta.cli.sections.CliConfigFilesSection;
import com.ibm.ws.report.binary.cmdline.ta.cli.sections.CliStatusSection;
import com.ibm.ws.report.binary.cmdline.ta.nls.NLSUtils;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.json.TAScanStatusWriter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;

public abstract class CLIBase {
    public static final int CLI_TABLE_WIDTH = 90;
    private static final int CLI_PROGRESS_BAR_LENGTH = 50;
    private static final int CLI_SCREEN_SIZE_ROWS = 50;
    private static final int CLI_SCREEN_SIZE_COLUMNS = 100;
    private static final int CLI_UPDATE_INTERVAL = 1;
    private static final int STATUS_JSON_UPDATE_INTERVAL = 5;
    private static final int STATUS_JSON_DELAY = 0;
    protected static CliAsciiTable cliAsciiTable;
    protected static Boolean isFirstApplication;
    private static Long avgTimeTakenForPreviousApps;
    private static Long timeTakenForPreviousApps;
    private static Long avgTimeTakenForPreviousSharedLibraries;
    private static Long timeTakenForPreviousSharedLibraries;
    private static Timer cliUpdatetimer;
    private static Timer statusJsonUpdateTimer;
    private static StopWatch stopWatch;
    private final String outputDirPath;
    protected static SourceServer.name sourceServer;
    protected static Boolean isOutsideLocation;
    protected static boolean hasSharedLibraries;
    protected static StopWatch redrawTableStopWatch;
    protected static Boolean pauseCli;
    private boolean migrationArtifactsParsingException = false;
    private boolean applicationExistanceOrPermsProblem = false;
    protected Locale locale;
    private final boolean displayCLI;
    private final boolean saveTAScanStatusToJson;
    public static final Logger logger;

    public CLIBase(Locale locale, boolean displayCLI, String outputDirPath, boolean saveTAScanStatusToJson) {
        this.locale = locale;
        this.displayCLI = displayCLI;
        this.outputDirPath = outputDirPath;
        this.saveTAScanStatusToJson = saveTAScanStatusToJson;
        cliAsciiTable = new CliAsciiTable(locale);
    }

    public void initialize() {
        stopWatch = new StopWatch();
        stopWatch.start();
        if (this.displayCLI) {
            HouseKeeping.initialize(50, 100);
        }
        cliAsciiTable.getCliStatusSection().setCurrentStatus(CliStatusSection.status.INITIALIZING.getString());
        cliAsciiTable.getCliProgressBarSection().setTotalLength(50);
        this.setSourceServer(SourceServer.name.WAS);
        cliAsciiTable.getCliTimeSection().setStartTime(new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date()));
        if (this.displayCLI) {
            redrawTableStopWatch.start();
            this.reDrawTable();
        }
        this.startCliUpdateTimer();
        if (this.saveTAScanStatusToJson) {
            this.startStatusJsonTimer();
        }
    }

    protected abstract void reDrawTable(boolean var1);

    protected void reDrawTable() {
        this.reDrawTable(false);
    }

    protected abstract Object getNewTable();

    protected List<String> getProfileSection() {
        ArrayList<String> profileSectionLines = new ArrayList<String>();
        profileSectionLines.add(NLSUtils.format(this.locale, "ta.dc.action.processing") + String.valueOf(cliAsciiTable.getCliProfileSection().getCurrentProfileProcessing()) + "/" + String.valueOf(cliAsciiTable.getCliProfileSection().getTotalProfiles()));
        profileSectionLines.add(NLSUtils.format(this.locale, "ta.dc.profile.name") + cliAsciiTable.getCliProfileSection().getCurrentProfileName());
        return profileSectionLines;
    }

    protected List<String> getOutsideLocationSection() {
        ArrayList<String> profileSectionLines = new ArrayList<String>();
        profileSectionLines.add(NLSUtils.format(this.locale, "ta.dc.outside.location") + String.valueOf(cliAsciiTable.getCliOutsideLocationProfileSection().getDirectoryName()));
        profileSectionLines.add(NLSUtils.format(this.locale, "ta.dc.source.server") + String.valueOf(sourceServer.getString()));
        return profileSectionLines;
    }

    protected List<String> getWeblogicDomainSection() {
        ArrayList<String> domainSectionLines = new ArrayList<String>();
        domainSectionLines.add(NLSUtils.format(this.locale, "ta.dc.action.processing") + String.valueOf(cliAsciiTable.getCliWeblogicDomainSection().getCurrentDomainProcessing()) + "/" + String.valueOf(cliAsciiTable.getCliWeblogicDomainSection().getTotalDomains()));
        domainSectionLines.add(NLSUtils.format(this.locale, "ta.dc.domain.name") + cliAsciiTable.getCliWeblogicDomainSection().getCurrentDomainName());
        return domainSectionLines;
    }

    protected List<String> getJbossInstanceSection() {
        ArrayList<String> instanceSectionLines = new ArrayList<String>();
        instanceSectionLines.add(NLSUtils.format(this.locale, "ta.dc.action.processing") + String.valueOf(cliAsciiTable.getCliJbossInstanceSection().getCurrentInstanceProcessing()) + "/" + String.valueOf(cliAsciiTable.getCliJbossInstanceSection().getTotalInstances()));
        instanceSectionLines.add(NLSUtils.format(this.locale, "ta.dc.instance.name") + cliAsciiTable.getCliJbossInstanceSection().getCurrentInstanceName());
        return instanceSectionLines;
    }

    protected List<String> getTomcatInstanceSection() {
        ArrayList<String> instanceSectionLines = new ArrayList<String>();
        instanceSectionLines.add(NLSUtils.format(this.locale, "ta.dc.action.processing") + String.valueOf(cliAsciiTable.getCliTomcatInstanceSection().getCurrentInstanceProcessing()) + "/" + String.valueOf(cliAsciiTable.getCliTomcatInstanceSection().getTotalInstances()));
        instanceSectionLines.add(NLSUtils.format(this.locale, "ta.dc.instance.name") + cliAsciiTable.getCliTomcatInstanceSection().getCurrentInstanceName());
        return instanceSectionLines;
    }

    protected List<String> getApplicationSection() {
        ArrayList<String> applicationSectionLines = new ArrayList<String>();
        applicationSectionLines.add(NLSUtils.format(this.locale, "ta.dc.total") + String.valueOf(cliAsciiTable.getCliApplicationSection().getTotalApps()));
        applicationSectionLines.add(NLSUtils.format(this.locale, "ta.dc.completed") + String.valueOf(cliAsciiTable.getCliApplicationSection().getCompletedApps()));
        return applicationSectionLines;
    }

    protected List<String> getSharedLibrariesSection() {
        ArrayList<String> sharedLibrariesSectionLines = new ArrayList<String>();
        sharedLibrariesSectionLines.add(NLSUtils.format(this.locale, "ta.dc.total") + String.valueOf(cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries()));
        sharedLibrariesSectionLines.add(NLSUtils.format(this.locale, "ta.dc.completed") + String.valueOf(cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries()));
        return sharedLibrariesSectionLines;
    }

    protected List<String> getTimeSection() {
        ArrayList<String> timeSectionLines = new ArrayList<String>();
        timeSectionLines.add(NLSUtils.format(this.locale, "ta.dc.elapsed.time") + String.valueOf(cliAsciiTable.getCliTimeSection().getElapsedTime()));
        if (isFirstApplication.booleanValue()) {
            timeSectionLines.add(NLSUtils.format(this.locale, "ta.dc.remain.time.cal"));
        } else {
            timeSectionLines.add(NLSUtils.format(this.locale, "ta.dc.remain.time") + String.valueOf(cliAsciiTable.getCliTimeSection().getRemainingTime()));
        }
        return timeSectionLines;
    }

    protected List<String> getConfigFileSection() {
        ArrayList<String> configSectionLines = new ArrayList<String>();
        configSectionLines.add(NLSUtils.format(this.locale, "ta.dc.config.analysis") + cliAsciiTable.getConfigFilesEvent().getCurrentStatus());
        return configSectionLines;
    }

    protected List<String> getProgressBarSection() {
        ArrayList<String> progressBarSectionLines = new ArrayList<String>();
        progressBarSectionLines.add(cliAsciiTable.getCliProgressBarSection().generateProgressBar(this.getProgressPercentCompleted()));
        return progressBarSectionLines;
    }

    protected List<String> getCurrentOperationSection() {
        ArrayList<String> currentOperationSectionLines = new ArrayList<String>();
        currentOperationSectionLines.add(cliAsciiTable.getCliCurrentOperationSection().getLine1());
        currentOperationSectionLines.add(cliAsciiTable.getCliCurrentOperationSection().getLine2());
        currentOperationSectionLines.add(cliAsciiTable.getCliCurrentOperationSection().getLine3());
        return currentOperationSectionLines;
    }

    public void updateStatusSection(CliStatusSection.status status2) {
        cliAsciiTable.getCliStatusSection().setCurrentStatus(status2.getString());
        this.reDrawTable();
    }

    public void updateProfileSection(int totalProfiles, String currentProfileName) {
        cliAsciiTable.getCliProfileSection().setTotalProfiles(totalProfiles);
        cliAsciiTable.getCliProfileSection().setCurrentProfileName(currentProfileName);
        cliAsciiTable.getCliProfileSection().incrementCurrentProfileProcessing();
        this.reDrawTable();
    }

    public void updateOutsideLocationSection(String outsideLocation) {
        cliAsciiTable.getCliOutsideLocationProfileSection().setDirectoryName(outsideLocation);
    }

    public void updateTotalProfiles(int totalProfiles) {
        cliAsciiTable.getCliProfileSection().setTotalProfiles(totalProfiles);
        this.reDrawTable();
    }

    public void updateProfileEvent(String currentProfileName) {
        cliAsciiTable.getCliProfileSection().setCurrentProfileName(currentProfileName);
        cliAsciiTable.getCliProfileSection().incrementCurrentProfileProcessing();
        this.reDrawTable();
    }

    public void updateTotalDomains(int totalDomains) {
        cliAsciiTable.getCliWeblogicDomainSection().setTotalDomains(totalDomains);
        this.reDrawTable();
    }

    public void updateWeblogicDomainEvent(String currentDomainName) {
        cliAsciiTable.getCliWeblogicDomainSection().setCurrentDomainName(currentDomainName);
        cliAsciiTable.getCliWeblogicDomainSection().incrementCurrentDomainProcessing();
        this.reDrawTable();
    }

    public void updateJbossInstanceEvent(String currentInstanceName) {
        cliAsciiTable.getCliJbossInstanceSection().setCurrentInstanceName(currentInstanceName);
        cliAsciiTable.getCliJbossInstanceSection().incrementCurrentInstanceProcessing();
        this.reDrawTable();
    }

    public void updateTomcatInstanceEvent(String currentInstanceName) {
        cliAsciiTable.getCliTomcatInstanceSection().setCurrentInstanceName(currentInstanceName);
        cliAsciiTable.getCliTomcatInstanceSection().incrementCurrentInstanceProcessing();
        this.reDrawTable();
    }

    public void updateJBossTotalInstances(int totalInstances) {
        cliAsciiTable.getCliJbossInstanceSection().setTotalInstances(totalInstances);
    }

    public void updateTomcatTotalInstances(int totalInstances) {
        cliAsciiTable.getCliTomcatInstanceSection().setTotalInstances(totalInstances);
    }

    public void updateTotalInstances(int totalInstances) {
        cliAsciiTable.getCliJbossInstanceSection().setTotalInstances(totalInstances);
    }

    public void updateApplicationSection(int totalApps, String applicationName) {
        cliAsciiTable.getCliApplicationSection().setTotalApps(totalApps);
        cliAsciiTable.getCliApplicationSection().setCurrentAppName(applicationName);
        cliAsciiTable.getCliApplicationSection().incrementCompletedApps();
        cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, "ta.dc.app.analyzing") + applicationName);
        this.reDrawTable();
    }

    public void updateTotalApplications(int totalApps) {
        cliAsciiTable.getCliApplicationSection().setTotalApps(totalApps);
        this.reDrawTable();
    }

    public void updateApplicationEvent(String currentApplicationName) {
        cliAsciiTable.getCliApplicationSection().setCurrentAppName(currentApplicationName);
        this.reDrawTable();
    }

    public void updateApplicationCompletedEvent(Long timeTakenInMilliSecs) {
        cliAsciiTable.getCliApplicationSection().incrementCompletedApps();
        if (isFirstApplication.booleanValue()) {
            isFirstApplication = false;
        }
        if (cliAsciiTable.getCliApplicationSection().getCompletedApps() == cliAsciiTable.getCliApplicationSection().getTotalApps() && cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries() == 0) {
            cliAsciiTable.getCliTimeSection().setRemainingTime(0L);
        } else {
            timeTakenForPreviousApps = timeTakenInMilliSecs + timeTakenForPreviousApps;
            avgTimeTakenForPreviousApps = (timeTakenInMilliSecs + timeTakenForPreviousApps) / (long)cliAsciiTable.getCliApplicationSection().getCompletedApps();
            Long totalTimeRequired = avgTimeTakenForPreviousApps * (long)(cliAsciiTable.getCliApplicationSection().getTotalApps() + cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries() - cliAsciiTable.getCliApplicationSection().getCompletedApps());
            cliAsciiTable.getCliTimeSection().setRemainingTime(totalTimeRequired);
        }
        this.reDrawTable();
    }

    public void updateSharedLibrariesSection(int totalSharedLibraries, String sharedLibraryName) {
        cliAsciiTable.getCliSharedLibrariesSection().setTotalSharedLibraries(totalSharedLibraries);
        cliAsciiTable.getCliSharedLibrariesSection().setCurrentSharedLibraryName(sharedLibraryName);
        cliAsciiTable.getCliSharedLibrariesSection().incrementCompletedSharedLibraries();
        cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, "ta.dc.app.analyzing") + sharedLibraryName);
        this.reDrawTable();
    }

    public void updateTotalSharedLibraries(int totalSharedLibraries) {
        cliAsciiTable.getCliSharedLibrariesSection().setTotalSharedLibraries(totalSharedLibraries);
        this.reDrawTable();
    }

    public void updateSharedLibrariesEvent(String currentSharedLibrariesName) {
        cliAsciiTable.getCliSharedLibrariesSection().setCurrentSharedLibraryName(currentSharedLibrariesName);
        this.reDrawTable();
    }

    public void updateSharedLibrariesCompletedEvent(Long timeTakenInMilliSecs) {
        if (isFirstApplication.booleanValue()) {
            isFirstApplication = false;
        }
        cliAsciiTable.getCliSharedLibrariesSection().incrementCompletedSharedLibraries();
        if (cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries() == cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries()) {
            cliAsciiTable.getCliTimeSection().setRemainingTime(0L);
        } else {
            timeTakenForPreviousSharedLibraries = timeTakenInMilliSecs + timeTakenForPreviousSharedLibraries;
            avgTimeTakenForPreviousSharedLibraries = (timeTakenInMilliSecs + timeTakenForPreviousSharedLibraries) / (long)cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries();
            Long totalTimeRequired = avgTimeTakenForPreviousSharedLibraries * (long)(cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries() - cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries());
            cliAsciiTable.getCliTimeSection().setRemainingTime(totalTimeRequired);
        }
        this.reDrawTable();
    }

    public void updateTotalZipFiles(int totalZipFiles) {
        cliAsciiTable.getCliZipFileSection().setTotalZips(totalZipFiles);
    }

    public void updateZipFileEvent(String currentZipFileName) {
        cliAsciiTable.getCliZipFileSection().setCurrentZipName(currentZipFileName);
    }

    public void updateZipFileCompletedEvent() {
        cliAsciiTable.getCliZipFileSection().incrementCompletedZips();
    }

    private void updateTime(long elapsedTime, long remainingTime) {
        cliAsciiTable.getCliTimeSection().setElapsedTime(elapsedTime);
        cliAsciiTable.getCliTimeSection().setRemainingTime(remainingTime);
        this.reDrawTable();
    }

    private void updateRemainingTime(long remainingTimeinMilliSecs) {
        cliAsciiTable.getCliTimeSection().setRemainingTime(remainingTimeinMilliSecs);
        this.reDrawTable();
    }

    public void updateConfigFilesSection(CliConfigFilesSection.configEventStatus configFilesStatus) {
        cliAsciiTable.getConfigFilesEvent().setCurrentStatus(configFilesStatus);
        this.reDrawTable();
    }

    public void updateCurrentOperationEvent(String line1MsgId, String line2MsgId, String line3MsgId) {
        cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, line1MsgId));
        cliAsciiTable.getCliCurrentOperationSection().setLine2(NLSUtils.format(this.locale, line2MsgId));
        cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, line3MsgId));
        this.reDrawTable();
    }

    public void updateCurrentOperationEventWithArgs(String line1MsgId, String[] line1MsgArgs, String line2MsgId, String[] line2MsgArgs, String line3MsgId, String[] line3MsgArgs) {
        if (line1MsgId == null || line1MsgId.trim().length() == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine1(line1MsgId);
        } else if (line1MsgArgs == null || line1MsgArgs.length == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, line1MsgId));
        } else {
            cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, line1MsgId, line1MsgArgs));
        }
        if (line2MsgId == null || line2MsgId.trim().length() == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine2(line2MsgId);
        } else if (line2MsgArgs == null || line2MsgArgs.length == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine2(NLSUtils.format(this.locale, line2MsgId));
        } else {
            cliAsciiTable.getCliCurrentOperationSection().setLine2(NLSUtils.format(this.locale, line2MsgId, line2MsgArgs));
        }
        if (line3MsgId == null || line3MsgId.trim().length() == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine3(line3MsgId);
        } else if (line3MsgArgs == null || line3MsgArgs.length == 0) {
            cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, line3MsgId));
        } else {
            cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, line3MsgId, line3MsgArgs));
        }
        this.reDrawTable();
    }

    public void setMigrationArtifactsParsingException(boolean migrationArtifactsParsingException) {
        this.migrationArtifactsParsingException = migrationArtifactsParsingException;
    }

    public boolean isMigrationArtifactsParsingException() {
        return this.migrationArtifactsParsingException;
    }

    public void setApplicationExistanceOrPermsProblem(boolean applicationExistanceOrPermsProblem) {
        this.applicationExistanceOrPermsProblem = applicationExistanceOrPermsProblem;
    }

    public boolean isApplicationExistanceOrPermsProblem() {
        return this.applicationExistanceOrPermsProblem;
    }

    private void startCliUpdateTimer() {
        cliUpdatetimer = new Timer(true);
        cliUpdatetimer.schedule((TimerTask)new UpdateCLIReminder(), 0L, 1000L);
    }

    private void cancelCliUpdateTimer() {
        cliUpdatetimer.cancel();
    }

    private void startStatusJsonTimer() {
        statusJsonUpdateTimer = new Timer(true);
        statusJsonUpdateTimer.schedule((TimerTask)new UpdateStatusJson(), 0L, 5000L);
    }

    private void cancelStatusJsonTimer() {
        statusJsonUpdateTimer.cancel();
    }

    public void reWriteStatusJson() {
        String startTime = cliAsciiTable.getCliTimeSection().getStartTime();
        String endTime = cliAsciiTable.getCliTimeSection().getEndTime();
        String statusFilePath = this.outputDirPath.isEmpty() ? System.getProperty("user.dir") : this.outputDirPath;
        if (!statusFilePath.endsWith(File.separator)) {
            statusFilePath = statusFilePath + File.separator;
        }
        statusFilePath = statusFilePath + "scan_status.json";
        int totalApplications = cliAsciiTable.getCliApplicationSection().getTotalApps();
        int completedApplications = cliAsciiTable.getCliApplicationSection().getCompletedApps();
        String currentApplication = cliAsciiTable.getCliApplicationSection().getCurrentAppName();
        int totalProfiles = cliAsciiTable.getCliProfileSection().getTotalProfiles();
        int completedProfiles = totalProfiles == 0 ? 0 : (completedApplications == totalApplications ? cliAsciiTable.getCliProfileSection().getCurrentProfileProcessing() : cliAsciiTable.getCliProfileSection().getCurrentProfileProcessing() - 1);
        String currentProfile = cliAsciiTable.getCliProfileSection().getCurrentProfileName();
        int totalSharedLibraries = cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries();
        int completedSharedLibraries = cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries();
        String currentSharedLibrary = cliAsciiTable.getCliSharedLibrariesSection().getCurrentSharedLibraryName();
        int totalZips = cliAsciiTable.getCliZipFileSection().getTotalZips();
        int completedZips = cliAsciiTable.getCliZipFileSection().getCompletedZips();
        String currentZip = cliAsciiTable.getCliZipFileSection().getCurrentZipName();
        TAScanStatusWriter statusWriter = new TAScanStatusWriter(startTime, endTime, statusFilePath, ReportUtility.getWarningCount(), ReportUtility.getSevereCount(), totalProfiles, completedProfiles, currentProfile, totalApplications, completedApplications, currentApplication, totalSharedLibraries, completedSharedLibraries, currentSharedLibrary, totalZips, completedZips, currentZip);
        try {
            statusWriter.writeToJsonFile(this.outputDirPath);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Generic"), "scan_status.json", e.toString()));
        }
    }

    public void finishOff() {
        if (this.applicationExistanceOrPermsProblem) {
            this.addExtraInfoToOperationEvent(NLSUtils.format(this.locale, "ta.dc.app.process.warn"));
        }
        cliAsciiTable.getCliStatusSection().setCurrentStatus(CliStatusSection.status.FINISHED.getString());
        this.reDrawTable(true);
        this.cancelCliUpdateTimer();
        cliAsciiTable.getCliTimeSection().setEndTime(new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date()));
        if (this.saveTAScanStatusToJson) {
            this.cancelStatusJsonTimer();
            this.reWriteStatusJson();
        }
        stopWatch.reset();
        redrawTableStopWatch.reset();
        this.resetFields();
    }

    public void resetFields() {
        isFirstApplication = true;
        isOutsideLocation = false;
        hasSharedLibraries = false;
        pauseCli = false;
        this.migrationArtifactsParsingException = false;
        this.applicationExistanceOrPermsProblem = false;
    }

    private void addExtraInfoToOperationEvent(String info) {
        cliAsciiTable.getCliCurrentOperationSection().setLine3(info);
        this.reDrawTable();
    }

    private float getProgressPercentCompleted() {
        float currentProgress = 0.0f;
        if (cliAsciiTable.getCliApplicationSection().getTotalApps() > 0 || cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries() > 0) {
            currentProgress = ((float)cliAsciiTable.getCliApplicationSection().getCompletedApps() + (float)cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries()) / (float)(cliAsciiTable.getCliApplicationSection().getTotalApps() + cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries()) * 100.0f;
        }
        return currentProgress;
    }

    public void throwError(String errorMessage, Boolean isExit) {
        cliAsciiTable.getCliCurrentOperationSection().setLine1(NLSUtils.format(this.locale, "ta.dc.err.occured"));
        cliAsciiTable.getCliCurrentOperationSection().setLine2(errorMessage);
        cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, "ta.dc.see.log"));
        if (isExit.booleanValue()) {
            if (this.migrationArtifactsParsingException) {
                cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, "ta.dc.migrate.artifact.parse.error"));
            } else if (this.applicationExistanceOrPermsProblem) {
                cliAsciiTable.getCliCurrentOperationSection().setLine3(NLSUtils.format(this.locale, "ta.dc.app.process.warn"));
            }
            cliAsciiTable.getCliStatusSection().setCurrentStatus(CliStatusSection.status.FAILED.getString());
        }
        this.reDrawTable(true);
    }

    public SourceServer.name getSourceServer() {
        return sourceServer;
    }

    public void setSourceServer(SourceServer.name sourceServer) {
        CLIBase.sourceServer = sourceServer;
    }

    public Boolean getIsOutsideLocation() {
        return isOutsideLocation;
    }

    public void setIsOutsideLocation(Boolean isOutsideLocation) {
        CLIBase.isOutsideLocation = isOutsideLocation;
    }

    public boolean hasSharedLibraries() {
        return hasSharedLibraries;
    }

    public void setHasSharedLibraries(boolean hasSharedLibraries) {
        CLIBase.hasSharedLibraries = hasSharedLibraries;
    }

    public Boolean getPauseCli() {
        return pauseCli;
    }

    public void setPauseCli(Boolean pauseCli) {
        CLIBase.pauseCli = pauseCli;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    static {
        isFirstApplication = true;
        avgTimeTakenForPreviousApps = 0L;
        timeTakenForPreviousApps = 0L;
        avgTimeTakenForPreviousSharedLibraries = 0L;
        timeTakenForPreviousSharedLibraries = 0L;
        isOutsideLocation = false;
        hasSharedLibraries = false;
        redrawTableStopWatch = new StopWatch();
        pauseCli = false;
        logger = ReportUtility.logger.get();
    }

    class UpdateStatusJson
    extends TimerTask {
        UpdateStatusJson() {
        }

        @Override
        public void run() {
            CLIBase.this.reWriteStatusJson();
        }
    }

    class UpdateCLIReminder
    extends TimerTask {
        UpdateCLIReminder() {
        }

        @Override
        public void run() {
            stopWatch.split();
            cliAsciiTable.getCliTimeSection().setElapsedTime(stopWatch.getTime());
            if (!isFirstApplication.booleanValue() && cliAsciiTable.getCliApplicationSection().getCompletedApps() < cliAsciiTable.getCliApplicationSection().getTotalApps()) {
                long rTime = (cliAsciiTable.getCliTimeSection().getRemainingTimeInSecs() - 1L) * 1000L;
                if (rTime <= 0L) {
                    if (avgTimeTakenForPreviousApps < 60000L) {
                        cliAsciiTable.getCliTimeSection().setRemainingTime(60000L);
                    } else {
                        cliAsciiTable.getCliTimeSection().setRemainingTime(avgTimeTakenForPreviousApps);
                    }
                } else {
                    cliAsciiTable.getCliTimeSection().setRemainingTime(rTime);
                }
            } else if (!isFirstApplication.booleanValue() && cliAsciiTable.getCliSharedLibrariesSection().getCompletedSharedLibraries() < cliAsciiTable.getCliSharedLibrariesSection().getTotalSharedLibraries()) {
                long rTime = (cliAsciiTable.getCliTimeSection().getRemainingTimeInSecs() - 1L) * 1000L;
                if (rTime <= 0L) {
                    if (avgTimeTakenForPreviousSharedLibraries < 60000L) {
                        cliAsciiTable.getCliTimeSection().setRemainingTime(60000L);
                    } else {
                        cliAsciiTable.getCliTimeSection().setRemainingTime(avgTimeTakenForPreviousSharedLibraries);
                    }
                } else {
                    cliAsciiTable.getCliTimeSection().setRemainingTime(rTime);
                }
            }
            if (redrawTableStopWatch.getTime() > 1000L) {
                CLIBase.this.reDrawTable();
            }
        }
    }
}

