/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.cli;

import com.ibm.ws.report.binary.cmdline.ta.cli.CLIBase;
import com.ibm.ws.report.binary.cmdline.ta.cli.HouseKeeping;
import com.ibm.ws.report.binary.cmdline.ta.cli.SourceServer;
import com.ibm.ws.report.binary.cmdline.ta.nls.NLSUtils;
import java.util.List;
import java.util.Locale;

public class CLIBasic
extends CLIBase {
    private static final int CLI_REDRAW_TABLE_WAIT_INTERVAL = 200;
    private final boolean displayCLI;

    public CLIBasic(Locale locale, boolean displayCLI, String outputDirPath, boolean saveTAScanStatusToJson) {
        super(locale, displayCLI, outputDirPath, saveTAScanStatusToJson);
        this.displayCLI = displayCLI;
    }

    @Override
    protected void reDrawTable(boolean force) {
        if (!pauseCli.booleanValue() && this.displayCLI) {
            redrawTableStopWatch.split();
            if (force || redrawTableStopWatch.getTime() > 200L) {
                HouseKeeping.moveCursorToR1C1();
                String strTable = (String)this.getNewTable();
                System.out.println(strTable);
                redrawTableStopWatch.reset();
                redrawTableStopWatch.start();
            }
        }
    }

    @Override
    protected Object getNewTable() {
        List<String> profileSection;
        String strTable = "\n\n" + this.outputMainDivider();
        strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.status"), cliAsciiTable.getCliStatusSection().getCurrentStatus()});
        List<String> configFilesSection = this.getConfigFileSection();
        strTable = strTable + configFilesSection.get(0) + "\n";
        strTable = strTable + this.outputDivider();
        if (isOutsideLocation.booleanValue()) {
            profileSection = this.getOutsideLocationSection();
            strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.outside.location"), profileSection.get(0), profileSection.get(1)});
        } else if (sourceServer.equals((Object)SourceServer.name.WAS)) {
            profileSection = this.getProfileSection();
            strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.profile.title"), profileSection.get(0), profileSection.get(1)});
        } else if (sourceServer.equals((Object)SourceServer.name.WEBLOGIC)) {
            List<String> weblogicDomainSection = this.getWeblogicDomainSection();
            strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.weblogic.domain.title"), weblogicDomainSection.get(0), weblogicDomainSection.get(1)});
        } else if (sourceServer.equals((Object)SourceServer.name.JBOSS)) {
            List<String> jbossInstanceSection = this.getJbossInstanceSection();
            strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.jboss.instance.title"), jbossInstanceSection.get(0), jbossInstanceSection.get(1)});
        } else if (sourceServer.equals((Object)SourceServer.name.TOMCAT)) {
            List<String> tomcatInstanceSection = this.getTomcatInstanceSection();
            strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.tomcat.instance.title"), tomcatInstanceSection.get(0), tomcatInstanceSection.get(1)});
        }
        strTable = strTable + this.outputDivider();
        List<String> applicationSection = this.getApplicationSection();
        strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.application.title"), applicationSection.get(0), applicationSection.get(1)});
        strTable = strTable + this.outputDivider();
        List<String> timeSection = this.getTimeSection();
        strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.time.title"), timeSection.get(0), timeSection.get(1)});
        strTable = strTable + this.outputDivider();
        List<String> progressBarSection = this.getProgressBarSection();
        strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.progress.title"), progressBarSection.get(0)});
        strTable = strTable + this.outputDivider();
        List<String> currentlyAnalyzingSection = this.getCurrentOperationSection();
        strTable = strTable + this.outputLine(new String[]{NLSUtils.format(this.locale, "ta.dc.current.op"), currentlyAnalyzingSection.get(0), currentlyAnalyzingSection.get(1), currentlyAnalyzingSection.get(2)});
        strTable = strTable + this.outputMainDivider();
        return strTable;
    }

    private String outputMainDivider() {
        return this.outputLine("================================================================================");
    }

    private String outputDivider() {
        return this.outputLine("--------------------------------------------------------------------------------");
    }

    private String outputLine(String[] data) {
        String line = "";
        for (String d : data) {
            if (line.length() > 0) {
                line = line + "\t";
            }
            line = line + d;
        }
        return this.outputLine(line);
    }

    private String outputLine(String line) {
        return line + "\n";
    }
}

