/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.nls;

import com.ibm.ws.report.binary.cmdline.ta.nls.TALocaleException;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;

public class TALocale {
    private String language;
    private String country;
    private static final List<String> SUPPORTED_LANG_CODES = Arrays.asList(Locale.CHINESE.getLanguage(), "cs", Locale.ENGLISH.getLanguage(), Locale.FRENCH.getLanguage(), Locale.GERMAN.getLanguage(), "hu", Locale.ITALIAN.getLanguage(), Locale.JAPANESE.getLanguage(), Locale.KOREAN.getLanguage(), "pl", "pt", "ru", "ro", "es");
    private static final List<String> SUPPORTED_COUNTRY_CODES = Arrays.asList(Locale.CHINA.getCountry(), Locale.TAIWAN.getCountry(), "BR");

    public TALocale(String langCountry) throws TALocaleException {
        if (langCountry == null || langCountry.trim().length() == 0) {
            ReportUtility.logger.get().log(Level.WARNING, "Use en as Locale because the pass in langCountry is null or empty");
            this.setLanguage(Locale.ENGLISH.getLanguage());
        } else if (langCountry.indexOf("_") > 0) {
            String[] arrays = langCountry.split("_");
            String langCode = arrays[0];
            String countryCode = null;
            if (arrays.length == 2) {
                countryCode = arrays[1];
            }
            this.setLanguage(langCode);
            this.setCountry(countryCode.toUpperCase());
        } else if (langCountry.indexOf("-") > 0) {
            String[] arrays = langCountry.split("-");
            String langCode = arrays[0];
            String countryCode = null;
            if (arrays.length == 2) {
                countryCode = arrays[1];
            }
            this.setLanguage(langCode);
            this.setCountry(countryCode.toUpperCase());
        } else {
            this.setLanguage(langCountry);
        }
    }

    public TALocale(Locale locale) throws TALocaleException {
        if (locale != null) {
            this.setLanguage(locale.getLanguage());
            this.setCountry(locale.getCountry());
        }
    }

    public TALocale(String language, String country) throws TALocaleException {
        this.setLanguage(language);
        this.setCountry(country);
    }

    private void setCountry(String country) throws TALocaleException {
        if (country != null && !country.isEmpty() && !SUPPORTED_COUNTRY_CODES.contains(country)) {
            throw new TALocaleException("Locale country code " + country + " is not supported.  The valid codes are " + SUPPORTED_COUNTRY_CODES.toString(), null);
        }
        this.country = country;
    }

    private void setLanguage(String language) throws TALocaleException {
        if (!SUPPORTED_LANG_CODES.contains(language)) {
            throw new TALocaleException("Locale language code " + language + " is not supported.  The valid codes are " + SUPPORTED_LANG_CODES.toString(), null);
        }
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public Locale toLocale() {
        if (this == null || this.language == null) {
            ReportUtility.logger.get().log(Level.WARNING, "Not able to convert to Locale, will use English as default");
            return Locale.ENGLISH;
        }
        ReportUtility.logger.get().log(Level.FINE, "this.language is " + this.language + "; this.country is " + this.country);
        if (this.country == null) {
            return new Locale(this.language);
        }
        return new Locale(this.language, this.country.toUpperCase());
    }
}

