/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileUtilities {
    private FileUtilities() {
    }

    public static Document getDocument(File xmlDocument) throws Exception {
        Document document;
        FileInputStream in = null;
        try {
            in = new FileInputStream(xmlDocument);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.parse(in);
            FileUtilities.closeInputStream(in, xmlDocument == null ? null : xmlDocument.getAbsolutePath());
        }
        catch (Exception e) {
            try {
                ReportUtility.logger.get().log(Level.FINEST, "Caught exception in getDocument", e);
                throw new Exception(Messages.getFormattedMessage(Messages.getString("FileUtilities_Cant_Parse_File"), xmlDocument == null ? null : xmlDocument.getAbsolutePath(), e));
            }
            catch (Throwable throwable) {
                FileUtilities.closeInputStream(in, xmlDocument == null ? null : xmlDocument.getAbsolutePath());
                throw throwable;
            }
        }
        return document;
    }

    public static void closeInputStream(InputStream in, String inName) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.FINEST, "Could not close input stream: " + inName);
            }
        }
    }

    public static void closeOutputStream(OutputStream out, String outName) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.FINEST, "Could not close output stream: " + outName);
            }
        }
    }

    public static File getFirstDirectoryNotDSStore(File[] files) {
        for (File f : files) {
            if (!f.isDirectory() || f.getPath().endsWith(".DS_Store")) continue;
            return f;
        }
        return null;
    }

    public static Properties getPropertiesNoComments(File file) throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Properties properties = FileUtilities.getPropertiesNoComments(is);
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesNoComments(File file, boolean trim) throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Properties properties = FileUtilities.getPropertiesNoComments(is, trim);
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static Properties getPropertiesNoComments(InputStream in) throws Exception {
        return FileUtilities.getPropertiesNoComments(in, false);
    }

    public static Properties getPropertiesNoComments(InputStream in, boolean trim) throws Exception {
        Properties props = new Properties();
        props.load(in);
        HashSet<Object> keys = new HashSet<Object>();
        for (Object key : props.keySet()) {
            keys.add(key);
        }
        for (Object key : keys) {
            String value = props.getProperty(key.toString());
            if (value.startsWith("#")) {
                value = "";
            } else if (value.indexOf("#") != -1) {
                value = value.substring(0, value.indexOf("#"));
            }
            props.setProperty(key.toString(), trim ? value.trim() : value);
        }
        return props;
    }

    public static List<File> getFiles(Set<String> fileNames, File directory) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(FileUtilities.getFiles(fileNames, f));
                continue;
            }
            if (!fileNames.contains(f.getName())) continue;
            files.add(f);
        }
        return files;
    }

    public static void stripEmptyTextNodes(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                FileUtilities.stripEmptyTextNodes(child);
                continue;
            }
            if (nodeType == 3) {
                String trimmedNodeVal = child.getNodeValue().trim();
                if (trimmedNodeVal.length() == 0) {
                    node.removeChild(child);
                    continue;
                }
                child.setNodeValue(trimmedNodeVal);
                continue;
            }
            if (nodeType != 8) continue;
            node.removeChild(child);
        }
    }

    public static void deleteFiles(File sourceLocation) {
        if (sourceLocation.isDirectory()) {
            File[] sourceFiles;
            for (File file : sourceFiles = sourceLocation.listFiles()) {
                String[] remainingFiles;
                FileUtilities.deleteFiles(file);
                if (!file.isDirectory() || (remainingFiles = file.list()).length != 0) continue;
                file.delete();
            }
        } else {
            sourceLocation.delete();
        }
    }
}

