/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import java.util.List;

public class Library
implements ScopedObject {
    private final Scope _scope;
    private final String _xmiId;
    private final String _name;
    private final String _desc;
    private final List<String> _classPath;
    private final String _xmiVersion;
    private final String _xmlnsXmi;
    private final String _xmlnsLibraries;
    private List<String> _resolvedClassPath = null;

    public Library(Scope scope, String name2, String xmiId, String desc, List<String> classPath, String xmiVersion, String xmlnsXmi, String xmlnsLibraries) {
        this._scope = scope;
        this._xmiId = xmiId;
        this._name = name2;
        this._desc = desc;
        this._classPath = classPath;
        this._xmiVersion = xmiVersion;
        this._xmlnsXmi = xmlnsXmi;
        this._xmlnsLibraries = xmlnsLibraries;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getXmiId() {
        return this._xmiId;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._desc;
    }

    public List<String> getClassPath() {
        return this._classPath;
    }

    public List<String> getResolvedClassPath() {
        if (this._resolvedClassPath == null) {
            return this._classPath;
        }
        return this._resolvedClassPath;
    }

    public String getXmiVersion() {
        return this._xmiVersion;
    }

    public String getXmlnsXmi() {
        return this._xmlnsXmi;
    }

    public String getXmlnsLibraries() {
        return this._xmlnsLibraries;
    }

    public void setResolvedClassPath(List<String> classPath) {
        this._resolvedClassPath = classPath;
    }

    public String toString() {
        return "Library[xmiId=\"" + this._xmiId + "\", name=\"" + this._name + "\", classPath=\"" + this._classPath + "\", description=\"" + this._desc + "\", xmiVersion=\"" + this._xmiVersion + "\", xmlnsXmi=\"" + this._xmlnsXmi + "\", xmlnsLibraries=\"" + this._xmlnsLibraries + "\", resolvedClassPath=\"" + this._resolvedClassPath + "\"]";
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._name;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof Library)) {
            return false;
        }
        Library library = (Library)entry;
        return CommonUtilities.equals(this._xmiId, library.getXmiId()) && CommonUtilities.equals(this._name, library.getName()) && CommonUtilities.equals(this._desc, library.getDescription()) && CommonUtilities.equals(this._classPath, library.getClassPath()) && CommonUtilities.equals(this._xmiVersion, library.getXmiVersion()) && CommonUtilities.equals(this._xmlnsXmi, library.getXmlnsXmi()) && CommonUtilities.equals(this._xmlnsLibraries, library.getXmlnsLibraries());
    }
}

