/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXmlBuilder;
import com.ibm.ws.report.binary.configutility.libertyconfig.LibertyConfigUtilities;
import com.ibm.ws.report.binary.configutility.libertyconfig.VariableDefinitionType;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedData;
import com.ibm.ws.report.binary.configutility.server.Cookie;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.server.TuningParams;
import com.ibm.ws.report.utilities.ReportUtility;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;

public class CommonUtilities {
    private static Properties userDefinedPropertyDefaults;
    private static Properties derbyPropertyDefaults;
    private static Properties db2UniversalPropertyDefaults;
    private static Properties db2IbmPropertyDefaults;
    private static Properties microsoftPropertyDefaults;
    private static Properties oraclePropertyDefaults;
    private static Pattern varFinder;
    private static Map<Class<?>, SortedMap<String, PropertyDescriptor>> propDescriptors;
    private static Set<Class<?>> acceptableClasses;
    private static Set<String> varsExclude;
    private static List<String> varsExcludeStartWith;
    private static Set<String> varsExcludeWarning;
    private static Properties sessionMgrDefaults;
    private static Properties sessionDbDefaults;
    private static Properties transactionDefaults;
    private static final Set<String> jvmPropertyKeysIgnoreList;
    private static final Set<String> jvmPropertyKeysIgnoreIfOffList;

    public static void filterVariables(Map<String, Variable> variables) {
        Iterator<Variable> iter = variables.values().iterator();
        ArrayList<Variable> add = new ArrayList<Variable>();
        while (iter.hasNext()) {
            Variable variable = iter.next();
            String newValue = CommonUtilities.getFilteredVariableValue(variable.getSymbolicName(), variable.getValue());
            if (newValue == null) {
                iter.remove();
                continue;
            }
            if (newValue.equals(variable.getValue())) continue;
            iter.remove();
            add.add(new Variable(variable.getScope(), variable.getXmiId(), variable.getSymbolicName(), newValue, variable.getDescription()));
        }
        for (Variable v : add) {
            variables.put(v.getSymbolicName(), v);
        }
    }

    public static void filterVariableDefinitionTypes(Map<String, VariableDefinitionType> variables) {
        Iterator<VariableDefinitionType> iter = variables.values().iterator();
        ArrayList<VariableDefinitionType> add = new ArrayList<VariableDefinitionType>();
        while (iter.hasNext()) {
            VariableDefinitionType variable = iter.next();
            String newValue = CommonUtilities.getFilteredVariableValue(variable.getName(), variable.getValue());
            String newDefaultValue = CommonUtilities.getFilteredVariableValue(variable.getName(), variable.getDefaultValue());
            if (newValue == null && newDefaultValue == null) {
                iter.remove();
                continue;
            }
            if ((newValue == null || newValue.equals(variable.getValue())) && (newDefaultValue == null || newDefaultValue.equals(variable.getDefaultValue()))) continue;
            iter.remove();
            VariableDefinitionType v = new VariableDefinitionType();
            v.setName(variable.getName());
            v.setValue(newValue);
            v.setDefaultValue(newDefaultValue);
            add.add(v);
        }
        for (VariableDefinitionType v : add) {
            variables.put(v.getName(), v);
        }
    }

    private static String getFilteredVariableValue(String name2, String value) {
        boolean isEmpty;
        boolean bl = isEmpty = value == null;
        if (varsExclude.contains(name2) || isEmpty) {
            return null;
        }
        for (String prefix : varsExcludeStartWith) {
            if (!name2.startsWith(prefix)) continue;
            return null;
        }
        return value;
    }

    public static void getUsedVariablesFromLibertyConfigObject(Set<String> varNames, Object obj) {
        if (obj == null) {
            return;
        }
        if (!obj.getClass().getPackage().getName().equals("com.ibm.ws.report.binary.configutility.libertyconfig")) {
            ReportUtility.logger.get().log(Level.FINEST, "Attempting to get used variables from an object that is not in com.ibm.ws.report.binary.configutility.libertyconfig");
        }
        SortedMap<String, PropertyDescriptor> pds = CommonUtilities.getPropertyDescriptors(obj.getClass());
        for (PropertyDescriptor pd : pds.values()) {
            Method read;
            if (!acceptableClasses.contains(pd.getPropertyType()) && !pd.getPropertyType().getPackage().getName().equals("com.ibm.ws.report.binary.configutility.libertyconfig") || (read = pd.getReadMethod()) == null) continue;
            try {
                if (read.getReturnType().equals(List.class) && LibertyConfigUtilities.isPropertyValueNull(pd, obj, obj.getClass())) continue;
                CommonUtilities.getUsedVariablesFromField(varNames, read.invoke(obj, new Object[0]));
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.FINE, "Caught exception searching for variables used in " + pd.getName() + " in config object " + obj, e);
            }
        }
    }

    public static void getUsedVariablesFromString(Set<String> varNames, String valueToTest) {
        Matcher matcher = varFinder.matcher(valueToTest);
        while (matcher.find()) {
            String varName = matcher.group(1);
            varNames.add(varName);
        }
    }

    public static void getUsedVariablesFromList(Set<String> varNames, List<?> list) {
        for (Object entry : list) {
            CommonUtilities.getUsedVariablesFromField(varNames, entry);
        }
    }

    public static void getUsedVariablesFromMap(Set<String> varNames, Map<?, ?> map) {
        for (Object entry : map.values()) {
            CommonUtilities.getUsedVariablesFromField(varNames, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertyDefaults(String file) {
        Properties properties;
        InputStream in = null;
        try {
            in = LibertyServerXmlBuilder.class.getResourceAsStream("/com/ibm/ws/report/binary/configutility/props/" + file);
            properties = FileUtilities.getPropertiesNoComments(in, true);
        }
        catch (Exception e) {
            Properties properties2;
            try {
                System.err.println("Can't load defaults: " + file);
                properties2 = null;
            }
            catch (Throwable throwable) {
                FileUtilities.closeInputStream(in, file);
                throw throwable;
            }
            FileUtilities.closeInputStream(in, file);
            return properties2;
        }
        FileUtilities.closeInputStream(in, file);
        return properties;
    }

    public static String getIfNotDefaultOrEmpty(Properties defaults, String key, Object value) {
        if (value instanceof MappedData) {
            MappedData mappedValue = (MappedData)value;
            if (CommonUtilities.getIfNotDefaultOrEmpty(defaults, key, mappedValue.getVariableValue()) != null) {
                return mappedValue.getValue();
            }
            return null;
        }
        return CommonUtilities.getIfNotDefaultOrEmpty(defaults, key, value, null);
    }

    public static String getIfNotDefaultOrEmpty(Properties defaults, String key, Object value, AtomicBoolean setAttribute) {
        String defaultValue = defaults.getProperty(key);
        if (value == null || value.toString().equals("")) {
            return null;
        }
        if (defaultValue != null && defaultValue.equals(value.toString())) {
            return null;
        }
        if (setAttribute != null) {
            setAttribute.set(true);
        }
        return value.toString();
    }

    public static String getValueOrDefault(Properties defaults, String key, Object value) {
        String defaultValue = defaults.getProperty(key);
        if (value == null || value.toString().equals("")) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String getIfNotEmpty(Object value) {
        return CommonUtilities.getValueOrDefault(new Properties(), "", value);
    }

    public static Properties getUserDefinedPropertyDefaults() {
        return userDefinedPropertyDefaults;
    }

    public static Properties getDerbyPropertyDefaults() {
        return derbyPropertyDefaults;
    }

    public static Properties getDb2UniversalPropertyDefaults() {
        return db2UniversalPropertyDefaults;
    }

    public static Properties getDb2IbmPropertyDefaults() {
        return db2IbmPropertyDefaults;
    }

    public static Properties getMicrosoftPropertyDefaults() {
        return microsoftPropertyDefaults;
    }

    public static Properties getOraclePropertyDefaults() {
        return oraclePropertyDefaults;
    }

    public static Properties getSessionManagerDefaults() {
        return sessionMgrDefaults;
    }

    public static Properties getSessionDbDefaults() {
        return sessionDbDefaults;
    }

    public static Properties getTransactionDefaults() {
        return transactionDefaults;
    }

    public static Set<String> getJvmPropertyKeysIgnoreList() {
        return jvmPropertyKeysIgnoreList;
    }

    public static Set<String> getJvmPropertyKeysIgnoreIfOffList() {
        return jvmPropertyKeysIgnoreIfOffList;
    }

    private static SortedMap<String, PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        try {
            if (propDescriptors.containsKey(clazz)) {
                return propDescriptors.get(clazz);
            }
            TreeMap<String, PropertyDescriptor> pds = new TreeMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                pds.put(pd.getName(), pd);
            }
            propDescriptors.put(clazz, pds);
            return pds;
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught following exception in getPropertyDescriptors, returning null", e);
            return null;
        }
    }

    private static void getUsedVariablesFromField(Set<String> varNames, Object extractVarsFrom) {
        if (extractVarsFrom == null) {
            return;
        }
        if (extractVarsFrom.getClass() == String.class) {
            CommonUtilities.getUsedVariablesFromString(varNames, (String)extractVarsFrom);
        } else if (List.class.isAssignableFrom(extractVarsFrom.getClass())) {
            CommonUtilities.getUsedVariablesFromList(varNames, (List)extractVarsFrom);
        } else if (Map.class.isAssignableFrom(extractVarsFrom.getClass())) {
            CommonUtilities.getUsedVariablesFromMap(varNames, (Map)extractVarsFrom);
        } else if (JAXBElement.class.isAssignableFrom(extractVarsFrom.getClass())) {
            CommonUtilities.getUsedVariablesFromLibertyConfigObject(varNames, ((JAXBElement)extractVarsFrom).getValue());
        } else if (extractVarsFrom.getClass().getPackage().getName().equals("com.ibm.ws.report.binary.configutility.libertyconfig")) {
            CommonUtilities.getUsedVariablesFromLibertyConfigObject(varNames, extractVarsFrom);
        } else {
            CommonUtilities.getUsedVariablesFromLibertyConfigObject(varNames, extractVarsFrom.toString());
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsAllowDifferentScopes(ScopedObject a, ScopedObject b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equalsAllowDifferentScopes(b);
    }

    public static void logConflict(String key, List<String> conflicts) {
        ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("Conflict_Info_Message_Log"), key, conflicts, conflicts.get(conflicts.size() - 1)));
    }

    public static boolean shouldWarnAboutMissingVar(String variable) {
        return !varsExcludeWarning.contains(variable);
    }

    public static String getOldestVersion(String ver1, String ver2, boolean javaVersion) {
        ver1 = ver1.trim();
        ver2 = ver2.trim();
        boolean ver1ValidFormat = ver1.matches("^([0-9]+\\.)*[0-9]+$");
        boolean ver2ValidFormat = ver2.matches("^([0-9]+\\.)*[0-9]+$");
        String oldestVer = "";
        if (!ver1ValidFormat || !ver2ValidFormat) {
            oldestVer = ver1ValidFormat ? ver1 : (ver2ValidFormat ? ver2 : "");
            ReportUtility.logger.get().log(Level.FINEST, "An invalid version format was provided for comparison. (" + ver1 + "," + ver2 + ")", new Exception().getStackTrace());
        } else {
            int i;
            oldestVer = ver1;
            String[] oVer = ver1.split("\\.");
            String[] nVer = ver2.split("\\.");
            if (javaVersion && oVer.length > 1 && nVer.length > 1) {
                String[] newArray;
                if ("1".equals(oVer[0]) && !"1".equals(nVer[0])) {
                    newArray = new String[oVer.length - 1];
                    for (i = 0; i < newArray.length; ++i) {
                        newArray[i] = oVer[i + 1];
                    }
                    oVer = newArray;
                } else if ("1".equals(nVer[0])) {
                    newArray = new String[nVer.length - 1];
                    for (i = 0; i < newArray.length; ++i) {
                        newArray[i] = nVer[i + 1];
                    }
                    nVer = newArray;
                }
            }
            int cnt = oVer.length <= nVer.length ? oVer.length : nVer.length;
            for (i = 0; i < cnt; ++i) {
                String string = oldestVer = oVer.length <= nVer.length ? ver1 : ver2;
                if (Integer.parseInt(oVer[i]) < Integer.parseInt(nVer[i])) {
                    oldestVer = ver1;
                    break;
                }
                if (Integer.parseInt(nVer[i]) >= Integer.parseInt(oVer[i])) continue;
                oldestVer = ver2;
                break;
            }
        }
        return oldestVer;
    }

    public static boolean isSessionManagerDefault(SessionManager sessionMgr) {
        Cookie cookie;
        Properties sessionMgrDefaults = CommonUtilities.getSessionManagerDefaults();
        TuningParams tuningParams = sessionMgr.getTuningParams();
        if (tuningParams != null) {
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "allowOverflow", tuningParams.getAllowOverflow()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "maxInMemorySessionCount", tuningParams.getMaxInMemorySessionCount()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "invalidationTimeout", tuningParams.getInvalidationTimeout()) != null) {
                return false;
            }
        }
        if ((cookie = sessionMgr.getDefaultCookieSettings()) != null) {
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "httpOnly", cookie.getHttpOnly()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "secure", cookie.getSecure()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "maximumAge", cookie.getMaximumAge()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "name", cookie.getName()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "path", cookie.getPath()) != null) {
                return false;
            }
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "useContextRootAsPath", cookie.getUseContextRootAsPath()) != null) {
                return false;
            }
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "enableCookies", sessionMgr.getEnableCookies()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "enableSSLTracking", sessionMgr.getEnableSSLTracking()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "enableUrlRewriting", sessionMgr.getEnableUrlRewriting()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "enableProtocolSwitchRewriting", sessionMgr.getEnableProtocolSwitchRewriting()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "enableSecurityIntegration", sessionMgr.getEnableSecurityIntegration()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "allowSerializedSessionAccess", sessionMgr.getAllowSerializedSessionAccess()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "maxWaitTime", sessionMgr.getMaxWaitTime()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, "accessSessionOnTimeout", sessionMgr.getAccessSessionOnTimeout()) != null) {
            return false;
        }
        List<Property> customProps = sessionMgr.getProperties();
        for (Property prop : customProps) {
            String value;
            String name2 = prop.getName();
            if (CommonUtilities.getIfNotDefaultOrEmpty(sessionMgrDefaults, name2, value = prop.getValue()) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isTransactionServiceDefault(TransactionService txSvc) {
        Properties txSvcDefaults = CommonUtilities.getTransactionDefaults();
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "acceptHeuristicHazard", txSvc.getAcceptHeuristicHazard()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "clientInactivityTimeout", txSvc.getClientInactivityTimeout()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "enableLoggingForHeuristicReporting", txSvc.getEnableLoggingForHeuristicReporting()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "heuristicRetryLimit", txSvc.getHeuristicRetryLimit()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "heuristicRetryWait", txSvc.getHeuristicRetryWait()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "lpsHeuristicCompletion", txSvc.getLpsHeuristicCompletion()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "propogatedOrBMTTranLifetimeTimeout", txSvc.getPropogatedOrBMTTranLifetimeTimeout()) != null) {
            return false;
        }
        if (CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "totalTranLifetimeTimeout", txSvc.getTotalTranLifetimeTimeout()) != null) {
            return false;
        }
        return CommonUtilities.getIfNotDefaultOrEmpty(txSvcDefaults, "transactionLogDirectory", txSvc.getTransactionLogDirectory()) == null;
    }

    public static String getTransactionDatabaseJndiName(String transactionLogDirectory) {
        return CommonUtilities.getDatabaseLogProperties(transactionLogDirectory).get("datasource");
    }

    private static Map<String, String> getDatabaseLogProperties(String transactionLogDirectory) {
        String[] queryPairs;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (transactionLogDirectory == null || !transactionLogDirectory.startsWith("custom://com.ibm.rls.jdbc.SQLRecoveryLog?")) {
            return queryParams;
        }
        String query = transactionLogDirectory.substring(transactionLogDirectory.indexOf(63) + 1);
        if (query.isEmpty()) {
            return queryParams;
        }
        for (String pair : queryPairs = query.split(",")) {
            int eq = (pair = pair.trim()).indexOf(61);
            if (eq <= 0) continue;
            String key = "";
            String value = null;
            try {
                key = URLDecoder.decode(pair.substring(0, eq).trim(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                key = pair.substring(0, eq).trim();
            }
            if (pair.length() > eq + 1) {
                try {
                    value = URLDecoder.decode(pair.substring(eq + 1).trim(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = pair.substring(eq + 1).trim();
                }
            } else {
                value = "";
            }
            queryParams.put(key, value);
        }
        return queryParams;
    }

    public static String getDisambiguatedId(LibertyResource resource, Set<String> usedIds) {
        int number = 2;
        String newName = resource.getLibertyId() + "_" + number;
        while (usedIds.contains(newName)) {
            newName = resource.getLibertyId() + "_" + ++number;
        }
        return newName;
    }

    public static String joinStrings(CharSequence delimiter, Iterable<? extends CharSequence> items) throws NullPointerException {
        if (delimiter == null) {
            throw new NullPointerException("Can't join string with null delimiter");
        }
        if (items == null) {
            throw new NullPointerException("Can't join string with null elements");
        }
        StringBuilder resultBuilder = new StringBuilder();
        boolean first = true;
        for (CharSequence charSequence : items) {
            if (!first) {
                resultBuilder.append(delimiter);
            }
            resultBuilder.append(charSequence);
            first = false;
        }
        return resultBuilder.toString();
    }

    public static String joinStrings(CharSequence delimiter, CharSequence ... items) throws NullPointerException {
        if (delimiter == null) {
            throw new NullPointerException("Can't join string with null delimiter");
        }
        if (items == null) {
            throw new NullPointerException("Can't join string with null elements");
        }
        StringBuilder resultBuilder = new StringBuilder();
        boolean first = true;
        for (CharSequence cs : items) {
            if (!first) {
                resultBuilder.append(delimiter);
            }
            resultBuilder.append(cs);
            first = false;
        }
        return resultBuilder.toString();
    }

    public static String resolveVariables(String path, ScopedMap<Variable> variables) {
        try {
            return CommonUtilities.resolveVariables(path, variables, new ArrayList<String>());
        }
        catch (ParseException e) {
            return path;
        }
    }

    private static String resolveVariables(String path, ScopedMap<Variable> variables, List<String> variablesProcessed) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(path, "${}()", true);
        StringBuilder variableNameBuilder = new StringBuilder();
        StringBuilder resolvedPathBuilder = new StringBuilder();
        String currentToken = null;
        while (tokenizer.hasMoreTokens()) {
            currentToken = tokenizer.nextToken();
            if (currentToken.equals("$") && ((currentToken = tokenizer.nextToken()).equals("{") || currentToken.equals("("))) {
                while (tokenizer.hasMoreTokens()) {
                    currentToken = tokenizer.nextToken();
                    if (!currentToken.equals("}") && !currentToken.equals(")")) {
                        variableNameBuilder.append(currentToken);
                    }
                    if (!currentToken.equals("}") && !currentToken.equals(")")) continue;
                    String variableName = variableNameBuilder.toString();
                    Variable valueObj = variables.getIgnoreScopeConflicts(variableName);
                    String value = null;
                    if (valueObj != null && valueObj.getValue() != null) {
                        value = valueObj.getValue();
                        if (value.matches(".*?[$][{(][^})]+[})].*")) {
                            if (variablesProcessed.contains(variableName)) {
                                ReportUtility.logger.get().log(Level.FINE, "Variable " + variableName + " is being resolved inside the value of itself or some other variable within it's value. It cannot be fully resolved.");
                                throw new ParseException(path, path.indexOf(variableName));
                            }
                            variablesProcessed.add(variableName);
                            resolvedPathBuilder.append(CommonUtilities.resolveVariables(value, variables, variablesProcessed));
                            variablesProcessed.remove(variableName);
                        } else {
                            resolvedPathBuilder.append(value);
                        }
                        while (tokenizer.hasMoreTokens()) {
                            resolvedPathBuilder.append(tokenizer.nextToken());
                        }
                        return CommonUtilities.resolveVariables(resolvedPathBuilder.toString(), variables, variablesProcessed);
                    }
                    ReportUtility.logger.get().log(Level.FINE, "Variable " + variableName + " was used in a library path but not found in the list of variables. It could not be resolved.");
                    throw new ParseException(path, path.indexOf(variableName));
                }
            }
            resolvedPathBuilder.append(currentToken);
        }
        String filePath = resolvedPathBuilder.toString().replace("\\\\", "\\");
        return filePath;
    }

    static {
        varFinder = Pattern.compile("\\$\\{([^\\}]*)\\}");
        propDescriptors = new HashMap();
        acceptableClasses = new HashSet();
        varsExclude = new HashSet<String>();
        varsExcludeStartWith = new ArrayList<String>();
        varsExcludeWarning = new HashSet<String>();
        jvmPropertyKeysIgnoreList = new HashSet<String>(Arrays.asList("KC_HOME", "java.util.prefs.userRoot"));
        jvmPropertyKeysIgnoreIfOffList = new HashSet<String>(Arrays.asList("com.ibm.security.jgss.debug", "com.ibm.security.krb5.Krb5Debug"));
        userDefinedPropertyDefaults = CommonUtilities.getPropertyDefaults("User-defined JDBC Provider_Defaults.props");
        derbyPropertyDefaults = CommonUtilities.getPropertyDefaults("Derby Network Server Using Derby Client_Defaults.props");
        db2UniversalPropertyDefaults = CommonUtilities.getPropertyDefaults("DB2 Universal JDBC Driver Provider (XA)_Defaults.props");
        db2IbmPropertyDefaults = CommonUtilities.getPropertyDefaults("DB2 Using IBM JCC Driver_Defaults.props");
        microsoftPropertyDefaults = CommonUtilities.getPropertyDefaults("Microsoft SQL Server JDBC Driver_Defaults.props");
        oraclePropertyDefaults = CommonUtilities.getPropertyDefaults("Oracle JDBC Driver (XA)_Defaults.props");
        acceptableClasses.add(String.class);
        acceptableClasses.add(List.class);
        acceptableClasses.add(Map.class);
        varsExclude.add("WAS_INSTALL_ROOT");
        varsExclude.add("USER_INSTALL_ROOT");
        varsExclude.add("WAS_PRODUCT_ROOT");
        varsExclude.add("WAS_LIBS_DIR");
        varsExclude.add("WAS_PROPS_DIR");
        varsExclude.add("WAS_TEMP_DIR");
        varsExclude.add("APP_INSTALL_ROOT");
        varsExclude.add("DRIVER_PATH");
        varsExclude.add("WAS_INSTALL_LIBRARY");
        varsExclude.add("WAS_CELL_NAME");
        varsExclude.add("JAVA_HOME");
        varsExclude.add("DEPLOY_TOOL_ROOT");
        varsExclude.add("CONNECTOR_INSTALL_ROOT");
        varsExclude.add("TRANLOG_ROOT");
        varsExclude.add("WAS_ETC_DIR");
        varsExclude.add("CLOUDSCAPE_JDBC_DRIVER_PATH");
        varsExclude.add("WEMPS_USER_ROOT");
        varsExclude.add("MQ_INSTALL_ROOT");
        varsExclude.add("WAS_SERVER_NAME");
        varsExclude.add("SERVER_LOG_ROOT");
        varsExcludeStartWith.add("WAS_SERVER_ONLY_");
        varsExcludeStartWith.add("WAS_DEFAULT_");
        varsExcludeStartWith.add("JAVA_LOCATION_");
        varsExcludeWarning.add("CELL");
        varsExcludeWarning.add("NODE");
        varsExcludeWarning.add("SERVER");
        sessionMgrDefaults = new Properties();
        sessionMgrDefaults.setProperty("allowOverflow", "true");
        sessionMgrDefaults.setProperty("maxInMemorySessionCount", "1000");
        sessionMgrDefaults.setProperty("httpOnly", "true");
        sessionMgrDefaults.setProperty("secure", "false");
        sessionMgrDefaults.setProperty("enableCookies", "true");
        sessionMgrDefaults.setProperty("enableSSLTracking", "false");
        sessionMgrDefaults.setProperty("enableUrlRewriting", "false");
        sessionMgrDefaults.setProperty("enableProtocolSwitchRewriting", "false");
        sessionMgrDefaults.setProperty("enableSecurityIntegration", "true");
        sessionMgrDefaults.setProperty("maximumAge", "-1");
        sessionMgrDefaults.setProperty("name", "JSESSIONID");
        sessionMgrDefaults.setProperty("path", "/");
        sessionMgrDefaults.setProperty("useContextRootAsPath", "false");
        sessionMgrDefaults.setProperty("invalidationTimeout", "30");
        sessionMgrDefaults.setProperty("allowSerializedSessionAccess", "false");
        sessionMgrDefaults.setProperty("maxWaitTime", "5");
        sessionMgrDefaults.setProperty("accessSessionOnTimeout", "true");
        sessionMgrDefaults.setProperty("DebugSessionCrossover", "false");
        sessionMgrDefaults.setProperty("HttpSessionIdLength", "23");
        sessionMgrDefaults.setProperty("HttpSessionIdReuse", "false");
        sessionMgrDefaults.setProperty("NoAdditionalSessionInfo", "false");
        sessionMgrDefaults.setProperty("ForceSessionInvalidationMultiple", "3");
        sessionMgrDefaults.setProperty("InvalidateOnUnauthorizedSessionRequestException", "false");
        sessionMgrDefaults.setProperty("SecurityUserIgnoreCase", "false");
        sessionMgrDefaults.setProperty("AlwaysEncodeURL", "false");
        sessionMgrDefaults.setProperty("SessionRewriteIdentifier", "jsessionid");
        sessionMgrDefaults.setProperty("CloneSeparator", ":");
        sessionDbDefaults = new Properties();
        sessionDbDefaults.setProperty("db2RowSize", "4KB");
        sessionDbDefaults.setProperty("SessionTableSkipIndexCreation", "false");
        sessionDbDefaults.setProperty("SessionTableName", "sessions");
        sessionDbDefaults.setProperty("NoAffinitySwitchBack", "false");
        sessionDbDefaults.setProperty("OptimizeCacheIdIncrements", "true");
        sessionDbDefaults.setProperty("UseInvalidatedId", "true");
        sessionDbDefaults.setProperty("UsingCustomSchemaName", "false");
        sessionDbDefaults.setProperty("UseOracleBLOB", "false");
        sessionDbDefaults.setProperty("UseMultiRowSchema", "false");
        sessionDbDefaults.setProperty("ScheduleInvalidation", "false");
        sessionDbDefaults.setProperty("ScheduleInvalidationHour", "0");
        sessionDbDefaults.setProperty("WriteContents", "ONLY_UPDATED_ATTRIBUTES");
        sessionDbDefaults.setProperty("WriteFrequency", "END_OF_SERVLET_SERVICE");
        sessionDbDefaults.setProperty("WriteInterval", "120");
        sessionDbDefaults.setProperty("OnlyCheckInCacheDuringPreInvoke", "false");
        transactionDefaults = new Properties();
        transactionDefaults.setProperty("acceptHeuristicHazard", "true");
        transactionDefaults.setProperty("clientInactivityTimeout", "60");
        transactionDefaults.setProperty("enableLoggingForHeuristicReporting", "false");
        transactionDefaults.setProperty("heuristicRetryLimit", "0");
        transactionDefaults.setProperty("heuristicRetryWait", "60");
        transactionDefaults.setProperty("lpsHeuristicCompletion", "ROLLBACK");
        transactionDefaults.setProperty("propogatedOrBMTTranLifetimeTimeout", "0");
        transactionDefaults.setProperty("totalTranLifetimeTimeout", "120");
    }
}

