/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.generator.ConfigGeneratorConstants;
import com.ibm.ws.report.binary.configutility.libertyconfig.ComIbmWsAppManagement;
import com.ibm.ws.report.binary.configutility.libertyconfig.ComIbmWsKernelFeature;
import com.ibm.ws.report.binary.configutility.libertyconfig.ComIbmWsMessagingRuntime;
import com.ibm.ws.report.binary.configutility.libertyconfig.IncludeType;
import com.ibm.ws.report.binary.configutility.libertyconfig.ServerType;
import com.ibm.ws.report.binary.configutility.libertyconfig.VariableDefinitionType;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class LibertyConfig {
    private final ServerType serverType;
    ComIbmWsKernelFeature feature;
    private ComIbmWsMessagingRuntime messagingEngine = null;
    private final Set<String> _usedVariables = new HashSet<String>();
    private final Map<String, VariableDefinitionType> _variablesJaxb = new HashMap<String, VariableDefinitionType>();
    private final List<String> _unmigratedVariables = new ArrayList<String>();
    private HashMap<String, VariableDefinitionType> _allVariables = null;
    private static Set<String> _libertyVariablesToIgnore = new HashSet<String>();

    public LibertyConfig() {
        this.serverType = new ServerType();
        this.feature = new ComIbmWsKernelFeature();
        this.addResource(this.feature);
        this.serverType.setDescription(Messages.getString("Generated_Config_Message"));
        ComIbmWsAppManagement appManagement = new ComIbmWsAppManagement();
        appManagement.setAutoExpand("true");
        this.addResource(appManagement);
    }

    public void addResource(Object resource) {
        if (resource == null) {
            return;
        }
        if (resource instanceof VariableDefinitionType) {
            this.addResource((VariableDefinitionType)resource);
        } else if (resource instanceof IncludeType) {
            this.addResourceToServerType((IncludeType)resource, false);
        } else {
            this.addResourceToServerType(resource, true);
        }
    }

    private void addResourceToServerType(Object resource, boolean checkUsedVars) {
        this.serverType.getIncludeOrVariableOrWebApplication().add(resource);
        if (checkUsedVars) {
            CommonUtilities.getUsedVariablesFromLibertyConfigObject(this._usedVariables, resource);
        }
    }

    public void addResource(VariableDefinitionType varDef) {
        if (varDef != null) {
            this._variablesJaxb.put(varDef.getName(), varDef);
        }
    }

    public ComIbmWsMessagingRuntime getMessagingEngine() {
        if (this.messagingEngine == null) {
            this.messagingEngine = new ComIbmWsMessagingRuntime();
            this.addResource(this.messagingEngine);
        }
        return this.messagingEngine;
    }

    public String getServerXmlString(Map<String, List<String>> scopeConflicts, File profileDir, List<String> modulesWithSessionManagerConfig, List<String> keyStoresWithSafKeyrings) throws Exception {
        int sessionDBIndex;
        int earIndex;
        int variableIndex;
        String string;
        int featureIndex;
        String finalResult;
        StringWriter writer = new StringWriter();
        this.addAllVariables();
        JAXBContext jaxbContext = JAXBContext.newInstance(this.serverType.getClass());
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", true);
        jaxbMarshaller.marshal((Object)this.serverType, writer);
        String result = writer.toString();
        if (scopeConflicts != null) {
            for (VariableDefinitionType variableDefinitionType : this._allVariables.values()) {
                if (this._usedVariables.contains(variableDefinitionType.getName())) continue;
                ReportUtility.logger.get().log(Level.FINEST, "Removing unused variable from conflict list " + variableDefinitionType.getName());
                scopeConflicts.remove(variableDefinitionType.getName());
            }
            StringBuilder conflictMessage = new StringBuilder();
            for (String key : scopeConflicts.keySet()) {
                List<String> conflictList = scopeConflicts.get(key);
                CommonUtilities.logConflict(key, conflictList);
                conflictMessage.append("<!--" + Messages.getFormattedMessage(Messages.getString("Conflict_Info_Message"), key, conflictList, conflictList.get(conflictList.size() - 1)) + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            }
            if (conflictMessage.length() != 0) {
                int n = result.indexOf("<server");
                int endOfServerLine = result.indexOf(62, n) + 1;
                finalResult = n != -1 && endOfServerLine != 0 ? result.substring(0, endOfServerLine + 1) + conflictMessage.toString() + result.substring(endOfServerLine + 1) : result;
            } else {
                finalResult = result;
            }
        } else {
            finalResult = result;
        }
        int includeIndex = finalResult.indexOf("<include");
        if (includeIndex != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ConfigGeneratorConstants.NEW_LINE + "    " + "<!--" + " " + Messages.getString("Sensitive_Data_Server_File_Path_Change") + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT + "    ");
            finalResult = finalResult.substring(0, includeIndex) + stringBuilder.toString() + finalResult.substring(includeIndex);
        }
        if ((featureIndex = finalResult.indexOf(string = "<featureManager/>")) != -1 && profileDir != null) {
            featureIndex = featureIndex + string.length() + 1;
            StringBuilder message = new StringBuilder();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            DateFormat df = DateFormat.getDateInstance(3, ReportUtility.getLocale());
            DateFormat tf = DateFormat.getTimeInstance(2, ReportUtility.getLocale());
            String formattedDate = df.format(timestamp);
            String formattedTime = tf.format(timestamp);
            message.append("    <!-- " + Messages.getFormattedMessage(Messages.getString("Config_Location_Used_Message"), formattedDate, formattedTime, profileDir.getAbsolutePath()) + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            message.append("    <!-- " + Messages.getString("Not_All_Config_Migrated_Message") + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            if (this._unmigratedVariables.size() != 0) {
                message.append("    <!-- " + Messages.getFormattedMessage(Messages.getString("tWAS_Variable_Not_Migrated_Message"), this._unmigratedVariables) + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            }
            if (modulesWithSessionManagerConfig.size() > 0) {
                message.append("    <!-- " + Messages.getFormattedMessage(Messages.getString("Application_Module_Sessions_Not_Migrated"), modulesWithSessionManagerConfig) + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            }
            if (keyStoresWithSafKeyrings.size() > 0) {
                message.append("    <!-- " + Messages.getFormattedMessage(Messages.getString("SAF_Keyring_Not_Migrated"), keyStoresWithSafKeyrings) + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
            }
            finalResult = finalResult.substring(0, featureIndex) + message.toString() + finalResult.substring(featureIndex);
        }
        if ((variableIndex = finalResult.indexOf("<variable ")) != -1) {
            StringBuilder message = new StringBuilder();
            message.append(ConfigGeneratorConstants.NEW_LINE + "    " + "<!--" + " " + Messages.getString("Variable_Message") + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT + "    ");
            finalResult = finalResult.substring(0, variableIndex) + message.toString() + finalResult.substring(variableIndex);
        }
        if (finalResult.contains("</enterpriseApplication>") && (earIndex = finalResult.indexOf("<enterpriseApplication")) != -1) {
            StringBuilder bndMessage = new StringBuilder();
            bndMessage.append(ConfigGeneratorConstants.NEW_LINE + "    " + "<!--" + " " + Messages.getString("Application_Bindings_Message") + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT + "    ");
            finalResult = finalResult.substring(0, earIndex) + bndMessage.toString() + finalResult.substring(earIndex);
        }
        if ((sessionDBIndex = finalResult.indexOf("<httpSessionDatabase")) != -1) {
            StringBuilder message = new StringBuilder();
            message.append(ConfigGeneratorConstants.NEW_LINE + "    " + "<!--" + " " + Messages.getString("Session_DB_Message") + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT + "    ");
            finalResult = finalResult.substring(0, sessionDBIndex) + message.toString() + finalResult.substring(sessionDBIndex);
        }
        finalResult = finalResult.replace("properties.wmqJms", "properties.mqJmsRa");
        return finalResult;
    }

    private void addAllVariables() {
        this._allVariables = new HashMap<String, VariableDefinitionType>(this._variablesJaxb);
        CommonUtilities.filterVariableDefinitionTypes(this._variablesJaxb);
        if (ConfigManagerFactory.isMigrateAllConfig()) {
            this._usedVariables.addAll(this._variablesJaxb.keySet());
        }
        this.findReferencedVariablesInValues();
        for (String varName : this._usedVariables) {
            VariableDefinitionType def = this._variablesJaxb.get(varName);
            if (def != null) {
                this.addResourceToServerType(def, false);
                ReportUtility.logger.get().log(Level.FINEST, "Adding Variable to Server.xml: [" + def.getName() + ", " + def.getValue() + "]");
                continue;
            }
            if (this._allVariables.containsKey(varName) || !CommonUtilities.shouldWarnAboutMissingVar(varName)) {
                ReportUtility.logger.get().log(Level.FINEST, "Variable: " + varName + " is not being migrated.");
                this._unmigratedVariables.add(varName);
                continue;
            }
            if (SensitiveDataHelper.getRegisteredVarKeys().contains(varName)) {
                ReportUtility.logger.get().log(Level.FINEST, "Variable: " + varName + " was created to replace sensitive data.");
                continue;
            }
            if (MappedDataHelper.getRegisteredVarKeys().contains(varName)) {
                ReportUtility.logger.get().log(Level.FINEST, "Variable: " + varName + " was created to replace configurable data.");
                continue;
            }
            if (_libertyVariablesToIgnore.contains(varName)) continue;
            ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Unrecognized_Variable"), varName));
        }
    }

    private void findReferencedVariablesInValues() {
        HashSet<String> newVariables = new HashSet<String>();
        HashSet<String> lastVariables = new HashSet<String>();
        HashSet<String> toAdd = new HashSet<String>();
        lastVariables.addAll(this._usedVariables);
        do {
            for (String name2 : lastVariables) {
                VariableDefinitionType variable = this._variablesJaxb.get(name2);
                CommonUtilities.getUsedVariablesFromLibertyConfigObject(toAdd, variable);
            }
            for (String add : toAdd) {
                if (this._usedVariables.contains(add)) continue;
                this._usedVariables.add(add);
                newVariables.add(add);
            }
            toAdd.clear();
            lastVariables = newVariables;
            newVariables = new HashSet();
        } while (lastVariables.size() > 0);
    }

    static {
        _libertyVariablesToIgnore.add("server.config.dir");
        _libertyVariablesToIgnore.add("server.output.dir");
        _libertyVariablesToIgnore.add("wlp.server.name");
        _libertyVariablesToIgnore.add("env.HOSTNAME");
    }
}

