/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.generator.ConfigGeneratorConstants;
import com.ibm.ws.report.binary.configutility.libertyconfig.ServerType;
import com.ibm.ws.report.binary.configutility.libertyconfig.VariableDefinitionType;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.StringWriter;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class LibertySensitiveDataConfig {
    private static ServerType serverType;
    private final SortedMap<String, VariableDefinitionType> _variablesJaxb = new TreeMap<String, VariableDefinitionType>();

    public LibertySensitiveDataConfig() {
        serverType = new ServerType();
        serverType.setDescription(Messages.getString("Generated_Config_Message"));
    }

    public void addResource(VariableDefinitionType varDef) {
        if (varDef != null) {
            this._variablesJaxb.put(varDef.getName(), varDef);
        }
    }

    public String getServerXmlString(boolean varsIncludeValues) throws Exception {
        StringWriter writer = new StringWriter();
        this.addAllVariables();
        JAXBContext jaxbContext = JAXBContext.newInstance(serverType.getClass());
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", true);
        jaxbMarshaller.marshal((Object)serverType, writer);
        String result = writer.toString();
        StringBuilder message = new StringBuilder();
        message.append("    <!-- " + Messages.getString("Sensitive_Data_Replacement_Vars_Liberty"));
        if (!varsIncludeValues) {
            message.append(ConfigGeneratorConstants.NEW_LINE + "    " + "     " + Messages.getString("Sensitive_Data_Values_Not_Collected"));
        }
        message.append(ConfigGeneratorConstants.NEW_LINE + "    " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
        if (!SensitiveDataHelper.getWarnAboutEncryptedDataAlgorithms().equals("")) {
            message.append("    <!-- " + Messages.getFormattedMessage(Messages.getString("Sensitive_Data_Encryption_Warning"), SensitiveDataHelper.getWarnAboutEncryptedDataAlgorithms()) + " " + ConfigGeneratorConstants.SERVER_XML_END_COMMENT);
        }
        int serverIndex = result.indexOf("<server");
        int endOfServerLine = result.indexOf(">", serverIndex) + 1;
        String finalResult = serverIndex != -1 && endOfServerLine != 0 ? result.substring(0, endOfServerLine + 1) + message.toString() + result.substring(endOfServerLine + 1) : result;
        if ("\r\n".equals(System.getProperty("line.separator"))) {
            finalResult = finalResult.replaceAll("\r?\n", "\r\n");
        }
        return finalResult;
    }

    private void addAllVariables() {
        for (String varName : this._variablesJaxb.keySet()) {
            VariableDefinitionType def = (VariableDefinitionType)this._variablesJaxb.get(varName);
            serverType.getIncludeOrVariableOrWebApplication().add(def);
            ReportUtility.logger.get().log(Level.FINEST, "Adding Sensitive Data Variable to Server.xml: [" + def.getName() + ", ********]");
        }
    }
}

