/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.generator.ConfigGeneratorConstants;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXmlBuilder;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.binary.configutility.twas.References;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

public class LibertyServerXml
extends TargetConfig {
    public static final String SENSITIVE_DATA_REPORT = "sensitiveData";
    public static final String WAS_JMS_SERVER_FEATURE = "wasJmsServer";
    public static final String WAS_JMS_CLIENT_FEATURE = "wasJmsClient";
    public static final String APP_SECURITY_FEATURE = "appSecurity";
    public static final String LDAP_REGISTRY_FEATURE = "ldapRegistry";
    public static final String TLS_FEATURE = "transportSecurity";
    public static final String SESSION_DATABASE_FEATURE = "sessionDatabase";
    private final File _serverXml;
    private File _sensitiveDataXml = null;
    private File _jvmOptions = null;
    private String _serverXmlContent = null;
    private String _sensitiveDataXmlContent = null;
    private String _jvmOptionsContent = null;
    private String _migratedConfigDirPath = "";
    private Map<String, String> _filesToMigrate;
    private boolean includeSensitiveDataVarsInServerXml = false;

    public LibertyServerXml(ConfigManager configManager, String appName, File serverXml, boolean includeSensitiveDataVarsInServerXml) throws Exception {
        super(configManager, appName);
        this._serverXml = serverXml;
        if (serverXml != null) {
            String serverXMLPath = this._serverXml.getAbsolutePath();
            File serverXMLDirFile = this._serverXml.getAbsoluteFile().getParentFile();
            if (serverXMLDirFile != null) {
                this._migratedConfigDirPath = serverXMLDirFile.getAbsolutePath();
            }
            int index = serverXMLPath.lastIndexOf(46);
            String serverXML_SensitiveData = serverXMLPath.substring(0, index) + "_" + SENSITIVE_DATA_REPORT + serverXMLPath.substring(index);
            this._sensitiveDataXml = new File(serverXML_SensitiveData);
            String serverXMLPathWithoutExtension = serverXMLPath.substring(0, index);
            StringBuilder jvmOptionsFileName = new StringBuilder();
            if (serverXMLPathWithoutExtension.endsWith("_server")) {
                jvmOptionsFileName.append(serverXMLPathWithoutExtension.substring(0, serverXMLPathWithoutExtension.length() - "_server".length()));
            } else {
                jvmOptionsFileName.append(serverXMLPathWithoutExtension);
            }
            jvmOptionsFileName.append("_jvm.options");
            this._jvmOptions = new File(jvmOptionsFileName.toString());
            this.includeSensitiveDataVarsInServerXml = includeSensitiveDataVarsInServerXml;
        }
    }

    @Override
    public void migrateConfig() throws Exception {
        LibertyServerXmlBuilder configGenerator = new LibertyServerXmlBuilder(this._configManager.getProfileDir(), this._migratedConfigDirPath, this._app);
        this.migrateConfig(configGenerator);
        this._serverXmlContent = configGenerator.export();
        if (this.includeSensitiveDataVarsInServerXml) {
            String sensitiveDataXmlContent = configGenerator.exportSensitiveData();
            if (null != sensitiveDataXmlContent) {
                this._serverXmlContent = this.addSensitiveDataVarsToServerXml(this._serverXmlContent, sensitiveDataXmlContent);
            }
            this._sensitiveDataXmlContent = null;
        } else {
            this._sensitiveDataXmlContent = configGenerator.exportSensitiveData();
        }
        this._jvmOptionsContent = configGenerator.exportJvmOptions();
        this._filesToMigrate = configGenerator.getFilesToMigrate();
    }

    private String addSensitiveDataVarsToServerXml(String serverXmlContent, String sensitiveDataXmlContent) {
        StringBuilder serverXmlWithSensitiveDataVars = new StringBuilder();
        int endOfServerXml = serverXmlContent.indexOf("</server>");
        int endOfSensitiveDataXml = sensitiveDataXmlContent.indexOf("</server>");
        int sensitiveDataServerIndex = sensitiveDataXmlContent.indexOf("<server");
        int sensitveDataEndOfServerLine = sensitiveDataXmlContent.indexOf(62, sensitiveDataServerIndex) + 1;
        if (sensitiveDataServerIndex != -1 && sensitveDataEndOfServerLine != 0 && endOfServerXml != -1 && endOfSensitiveDataXml != -1) {
            serverXmlWithSensitiveDataVars.append(serverXmlContent.substring(0, endOfServerXml - 1));
            serverXmlWithSensitiveDataVars.append(ConfigGeneratorConstants.NEW_LINE);
            serverXmlWithSensitiveDataVars.append(sensitiveDataXmlContent.substring(sensitveDataEndOfServerLine, endOfSensitiveDataXml - 1));
            serverXmlWithSensitiveDataVars.append(ConfigGeneratorConstants.NEW_LINE);
            serverXmlWithSensitiveDataVars.append(serverXmlContent.substring(endOfServerXml));
        } else {
            serverXmlWithSensitiveDataVars.append(serverXmlContent);
        }
        return serverXmlWithSensitiveDataVars.toString();
    }

    public String getServerXmlContent() {
        return this._serverXmlContent;
    }

    public String getSensitiveDataContent() {
        return this._sensitiveDataXmlContent;
    }

    public String getJvmOptionsContent() {
        return this._jvmOptionsContent;
    }

    public File getServerXml() {
        return this._serverXml;
    }

    public File getSensitiveDataXml() {
        return this._sensitiveDataXml;
    }

    public File getJvmOptions() {
        return this._jvmOptions;
    }

    public Map<String, String> getFilesToMigrate() {
        return this._filesToMigrate;
    }

    public SortedSet<String> getConfigFeatures() {
        SessionManager sessionManager;
        TreeSet<String> configFeatures = new TreeSet<String>();
        if (!this._app.getJmsAdminObjects().isEmpty()) {
            ReportUtility.logger.get().log(Level.FINEST, "Adding JMS server and client features for app " + this._app.getAppName());
            configFeatures.add(WAS_JMS_SERVER_FEATURE);
            configFeatures.add(WAS_JMS_CLIENT_FEATURE);
        }
        Security security = this._app.getResolvedSecurity();
        Reference<UserRegistry> activeUserRegistrRef = security.getActiveUserRegistry();
        if ("true".equals(security.getEnabled()) && "true".equals(security.getAppEnabled())) {
            UserRegistry activeUserRegistry;
            configFeatures.add(APP_SECURITY_FEATURE);
            if (activeUserRegistrRef != null && (activeUserRegistry = (UserRegistry)References.lookup(activeUserRegistrRef.getId())) != null) {
                configFeatures.add(LDAP_REGISTRY_FEATURE);
            }
        }
        if (this._app.usesSSLConfig()) {
            configFeatures.add(TLS_FEATURE);
        }
        if (null != (sessionManager = this._app.getSessionManager()) && "DATABASE".equals(sessionManager.getSessionPersistenceMode())) {
            configFeatures.add(SESSION_DATABASE_FEATURE);
        }
        return configFeatures;
    }

    boolean getIncludeSensitiveDataVarsInServerXml() {
        return this.includeSensitiveDataVarsInServerXml;
    }
}

