/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.mutableconfig;

import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.VariablizedDataRegistry;

public class SensitiveData {
    protected String _varName;
    protected String _value;

    public SensitiveData(String varName, String value) {
        varName = varName == null || varName.equals("") ? "DEFAULT_SENSITIVE_VARIABLE" : varName;
        this._varName = VariablizedDataRegistry.generateUniqueVarName(varName);
        this._value = !SensitiveDataHelper._includeSensitiveData || value == null ? "" : value;
    }

    public String getVarName() {
        if (!SensitiveDataHelper._varsUsedInConfig.containsKey(this._varName)) {
            SensitiveDataHelper._varsUsedInConfig.put(this._varName, this._value);
        }
        if (!this._value.equals("") && !this._value.toLowerCase().startsWith("{xor}") && this._value.matches("^\\{.*\\}.*")) {
            int closeBracket = this._value.indexOf("}");
            String algorithm = this._value.substring(1, closeBracket);
            SensitiveDataHelper.setWarnAboutEncryptedDataAlgorithm(algorithm);
        }
        return VariablizedDataRegistry._formatForLiberty ? "${" + this._varName + "}" : this._varName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveData)) {
            return false;
        }
        SensitiveData other = (SensitiveData)obj;
        return CommonUtilities.equals(this._value, other._value);
    }
}

