/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security;

import com.ibm.ws.report.binary.configutility.security.AuthDataEntry;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.security.LDAPUserRegistry;
import com.ibm.ws.report.binary.configutility.security.SSLConfigGroup;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.security.WIMUserRegistry;
import com.ibm.ws.report.binary.configutility.security.tls.DynamicSSLConfigSelection;
import com.ibm.ws.report.binary.configutility.security.tls.KeyManager;
import com.ibm.ws.report.binary.configutility.security.tls.KeyStore;
import com.ibm.ws.report.binary.configutility.security.tls.ManagementScope;
import com.ibm.ws.report.binary.configutility.security.tls.SSLConfig;
import com.ibm.ws.report.binary.configutility.security.tls.TrustManager;
import com.ibm.ws.report.binary.configutility.security.tls.WSCertificateExpirationMonitor;
import com.ibm.ws.report.binary.configutility.security.tls.WSNotification;
import com.ibm.ws.report.binary.configutility.security.tls.WSSchedule;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class Security {
    private final String _enabled;
    private final String _appEnabled;
    private final Map<String, AuthDataEntry> _authDataEntries;
    private final Reference<UserRegistry> _activeUserRegistry;
    private final LDAPUserRegistry _standaloneLDAPRegistry;
    private final WIMUserRegistry _wimUserRegistry;
    private final Map<String, SSLConfig> _repertoires;
    private final List<ManagementScope> _managementScopes;
    private final List<KeyStore> _keyStores;
    private final List<KeyManager> _keyManagers;
    private final List<TrustManager> _trustManagers;
    private final List<DynamicSSLConfigSelection> _dynamicSSLConfigSelections;
    private final WSCertificateExpirationMonitor _wsCertificateExpirationMonitor;
    private final List<WSNotification> _wsNotifications;
    private final List<WSSchedule> _wsSchedules;
    private final List<SSLConfigGroup> _sslConfigGroups;
    private final Map<String, Property> _properties;

    public Security(String enabled, String appEnabled, Map<String, AuthDataEntry> authDataEntries, Reference<UserRegistry> activeUserRegistry, LDAPUserRegistry standaloneLDAPRegistry, WIMUserRegistry wimUserRegistry, Map<String, SSLConfig> repertoires, List<ManagementScope> managementScopes, List<KeyStore> keyStores, List<KeyManager> keyManagers, List<TrustManager> trustManagers, List<DynamicSSLConfigSelection> dynamicSSLConfigSelections, WSCertificateExpirationMonitor wsCertificateExpirationMonitor, List<WSNotification> wsNotifications, List<WSSchedule> wsSchedules, List<SSLConfigGroup> sslConfigGroups, Map<String, Property> properties) {
        this._enabled = enabled;
        this._appEnabled = appEnabled;
        this._authDataEntries = authDataEntries;
        this._activeUserRegistry = activeUserRegistry;
        this._standaloneLDAPRegistry = standaloneLDAPRegistry;
        this._wimUserRegistry = wimUserRegistry;
        this._repertoires = repertoires;
        this._managementScopes = managementScopes;
        this._keyStores = keyStores;
        this._keyManagers = keyManagers;
        this._trustManagers = trustManagers;
        this._dynamicSSLConfigSelections = dynamicSSLConfigSelections;
        this._wsCertificateExpirationMonitor = wsCertificateExpirationMonitor;
        this._wsNotifications = wsNotifications;
        this._wsSchedules = wsSchedules;
        this._sslConfigGroups = sslConfigGroups;
        this._properties = properties;
        ReportUtility.logger.get().log(Level.FINEST, "Created Security: " + System.getProperty("line.separator") + this);
    }

    public String getEnabled() {
        return this._enabled;
    }

    public String getAppEnabled() {
        return this._appEnabled;
    }

    public Map<String, AuthDataEntry> getAuthDataEntries() {
        return this._authDataEntries;
    }

    public Reference<UserRegistry> getActiveUserRegistry() {
        return this._activeUserRegistry;
    }

    public LDAPUserRegistry getStandaloneLDAPRegistry() {
        return this._standaloneLDAPRegistry;
    }

    public WIMUserRegistry getWIMUserRegistry() {
        return this._wimUserRegistry;
    }

    public Map<String, SSLConfig> getRepertoires() {
        return this._repertoires;
    }

    public List<ManagementScope> getManagementScopes() {
        return this._managementScopes;
    }

    public List<KeyStore> getKeyStores() {
        return this._keyStores;
    }

    public List<KeyManager> getKeyManagers() {
        return this._keyManagers;
    }

    public List<TrustManager> getTrustManagers() {
        return this._trustManagers;
    }

    public List<DynamicSSLConfigSelection> getDynamicSslConfigSelections() {
        return this._dynamicSSLConfigSelections;
    }

    public WSCertificateExpirationMonitor getWsCertificateExpirationMonitor() {
        return this._wsCertificateExpirationMonitor;
    }

    public List<WSNotification> getWsNotifications() {
        return this._wsNotifications;
    }

    public List<WSSchedule> getWsSchedules() {
        return this._wsSchedules;
    }

    public List<SSLConfigGroup> getSslConfigGroups() {
        return this._sslConfigGroups;
    }

    public Map<String, Property> getProperties() {
        return this._properties;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Security:" + nl);
        sb.append("enabled=\"" + this._enabled + "\"" + nl);
        sb.append("appEnabled=\"" + this._appEnabled + "\"" + nl);
        sb.append("activeUserRegistry=\"" + this._activeUserRegistry + "\"" + nl);
        sb.append("authDataEntries=\"" + this._authDataEntries + "\"" + nl);
        sb.append("standaloneLDAPRegistry=\"" + this._standaloneLDAPRegistry + "\"" + nl);
        sb.append("wimUserRegistry=\"" + this._wimUserRegistry + "\"" + nl);
        sb.append("repertoires: " + nl);
        if (this._repertoires != null) {
            for (SSLConfig sSLConfig : this._repertoires.values()) {
                sb.append(sSLConfig + nl);
            }
        }
        sb.append("managementScopes: " + nl);
        if (this._managementScopes != null) {
            for (ManagementScope managementScope : this._managementScopes) {
                sb.append(managementScope + nl);
            }
        }
        sb.append("keyStores: " + nl);
        if (this._keyStores != null) {
            for (KeyStore keyStore : this._keyStores) {
                sb.append(keyStore + nl);
            }
        }
        sb.append("keyManagers: " + nl);
        if (this._keyManagers != null) {
            for (KeyManager keyManager : this._keyManagers) {
                sb.append(keyManager + nl);
            }
        }
        sb.append("trustManagers: " + nl);
        if (this._trustManagers != null) {
            for (TrustManager trustManager : this._trustManagers) {
                sb.append(trustManager + nl);
            }
        }
        sb.append("dynamicSSLConfigSelections: " + nl);
        if (this._dynamicSSLConfigSelections != null) {
            for (DynamicSSLConfigSelection dynamicSSLConfigSelection : this._dynamicSSLConfigSelections) {
                sb.append(dynamicSSLConfigSelection + nl);
            }
        }
        sb.append("wsCertificateExpirationMonitor=\"" + this._wsCertificateExpirationMonitor + "\"" + nl);
        sb.append("wsNotifications: " + nl);
        if (this._wsNotifications != null) {
            for (WSNotification wSNotification : this._wsNotifications) {
                sb.append(wSNotification + nl);
            }
        }
        sb.append("wsSchedules: " + nl);
        if (this._wsSchedules != null) {
            for (WSSchedule wSSchedule : this._wsSchedules) {
                sb.append(wSSchedule + nl);
            }
        }
        sb.append("sslConfigGroups: " + nl);
        if (this._sslConfigGroups != null) {
            for (SSLConfigGroup sSLConfigGroup : this._sslConfigGroups) {
                sb.append(sSLConfigGroup + nl);
            }
        }
        sb.append("properties: " + nl + this._properties);
        return sb.toString();
    }

    public Security withDomain(DomainSecurity domain) {
        String appEnabled = this._appEnabled;
        if (domain.getAppEnabled() != null && !domain.getAppEnabled().isEmpty()) {
            appEnabled = domain.getAppEnabled();
        }
        HashMap<String, AuthDataEntry> authDataEntries = new HashMap<String, AuthDataEntry>();
        authDataEntries.putAll(this._authDataEntries);
        if (domain.getAuthDataEntries() != null) {
            authDataEntries.putAll(domain.getAuthDataEntries());
        }
        Reference<UserRegistry> activeUserRegistry = this._activeUserRegistry;
        LDAPUserRegistry standaloneLDAPRegistry = this._standaloneLDAPRegistry;
        WIMUserRegistry wimUserRegistry = this._wimUserRegistry;
        if (domain.getActiveUserRegistry() != null) {
            UserRegistry registry = domain.getActiveUserRegistry().getValue();
            if (registry != null) {
                boolean useGlobalFederatedRepository = false;
                for (Property prop : registry.getProperties()) {
                    if (!prop.getName().equals("useGlobalFederatedRepository")) continue;
                    useGlobalFederatedRepository = true;
                    break;
                }
                if (!useGlobalFederatedRepository) {
                    activeUserRegistry = domain.getActiveUserRegistry();
                    standaloneLDAPRegistry = domain.getStandaloneLDAPRegistry();
                    wimUserRegistry = domain.getWIMUserRegistry();
                } else if (wimUserRegistry != null) {
                    activeUserRegistry = new Reference<UserRegistry>(wimUserRegistry.getId(), UserRegistry.class);
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "The property useGlobalFederatedRepository was set, but the global wim user registry is null.");
                }
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Expected to find value for activeUserRegistry with reference \"" + domain.getActiveUserRegistry().getId() + "\" in domain \"" + domain.getName() + "\". Using previously specified active user registry \"" + activeUserRegistry.getId() + "\".");
            }
        }
        TreeMap<String, Property> props = new TreeMap<String, Property>();
        props.putAll(this._properties);
        props.putAll(domain.getProperties());
        return new Security(this._enabled, appEnabled, authDataEntries, activeUserRegistry, standaloneLDAPRegistry, wimUserRegistry, this._repertoires, this._managementScopes, this._keyStores, this._keyManagers, this._trustManagers, this._dynamicSSLConfigSelections, this._wsCertificateExpirationMonitor, this._wsNotifications, this._wsSchedules, this._sslConfigGroups, props);
    }
}

