/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security;

import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveData;
import com.ibm.ws.report.binary.configutility.server.Property;
import java.util.List;

public abstract class UserRegistry
implements LibertyResource {
    private final String _id;
    private final String _realm;
    private final String _ignoreCase;
    private final List<Property> _properties;
    private final String _serverId;
    private final SensitiveData _serverPassword;
    private final String _limit;
    private final String _useRegistryServerId;
    private final SensitiveData _primaryAdminId;
    private final String _useRegistryRealm;
    private final String _libertyId;

    public UserRegistry(String id, String realm, String ignoreCase, List<Property> properties, String serverId, String serverPassword, String limit, String useRegistryServerId, String primaryAdminId, String useRegistryRealm, String cellName) {
        this._id = id;
        this._libertyId = this._id + "_" + cellName;
        this._realm = realm;
        this._ignoreCase = ignoreCase;
        this._properties = properties;
        this._serverId = serverId;
        this._serverPassword = "".equals(serverPassword) ? null : new SensitiveData(this._libertyId + "_userRegistry_serverPassword", serverPassword);
        this._limit = limit;
        this._useRegistryServerId = useRegistryServerId;
        this._primaryAdminId = "".equals(primaryAdminId) ? null : new SensitiveData(this._libertyId + "_userRegistry_primaryAdminId", primaryAdminId);
        this._useRegistryRealm = useRegistryRealm;
    }

    public String getId() {
        return this._id;
    }

    public String getRealm() {
        return this._realm;
    }

    public String getIgnoreCase() {
        return this._ignoreCase;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    public String getServerId() {
        return this._serverId;
    }

    public SensitiveData getServerPassword() {
        return this._serverPassword;
    }

    public String getLimit() {
        return this._limit;
    }

    public String getUseRegistryServerId() {
        return this._useRegistryServerId;
    }

    public SensitiveData getPrimaryAdminId() {
        return this._primaryAdminId;
    }

    public String getUseRegistryRealm() {
        return this._useRegistryRealm;
    }

    @Override
    public String getLibertyId() {
        return this._libertyId;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("UserRegistry:" + nl);
        sb.append("id=\"" + this._id + "\"" + nl);
        sb.append("libertyId=\"" + this._libertyId + "\"" + nl);
        sb.append("realm=\"" + this._realm + "\"" + nl);
        sb.append("ignoreCase=\"" + this._ignoreCase + "\"" + nl);
        sb.append("serverId=\"" + this._serverId + "\"" + nl);
        sb.append("serverPassword=\"******\"" + nl);
        sb.append("limit" + this._limit + "\"" + nl);
        sb.append("useRegistryServerId=\"" + this._useRegistryServerId + "\"" + nl);
        sb.append("primaryAdminId=\"******\"" + nl);
        sb.append("useRegistryRealm=\"" + this._useRegistryRealm + "\"" + nl);
        sb.append("properties=\"" + this._properties + "\"" + nl);
        return sb.toString();
    }
}

