/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.server;

import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class JvmEntry {
    private final List<String> _classpath;
    private final String _initialHeapSize;
    private final String _maximumHeapSize;
    private final String _genericJvmArguments;
    private final List<Property> _systemProperties;

    public JvmEntry(List<String> classpath, String initialHeapSize, String maximumHeapSize, String genericJvmArguments, List<Property> systemProperties) {
        this._classpath = classpath;
        this._initialHeapSize = initialHeapSize;
        this._maximumHeapSize = maximumHeapSize;
        this._genericJvmArguments = genericJvmArguments;
        this._systemProperties = systemProperties;
        ReportUtility.logger.get().log(Level.FINEST, "Created JvmEntry: " + System.getProperty("line.separator") + this);
    }

    public List<String> getClasspath() {
        return this._classpath;
    }

    public String getInitialHeapSize() {
        return this._initialHeapSize;
    }

    public String getMaximumHeapSize() {
        return this._maximumHeapSize;
    }

    public String getGenericJvmArguments() {
        return this._genericJvmArguments;
    }

    public List<Property> getSystemProperties() {
        return this._systemProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._classpath == null ? 0 : this._classpath.hashCode());
        result = 31 * result + (this._genericJvmArguments == null ? 0 : this._genericJvmArguments.hashCode());
        result = 31 * result + (this._initialHeapSize == null ? 0 : this._initialHeapSize.hashCode());
        result = 31 * result + (this._maximumHeapSize == null ? 0 : this._maximumHeapSize.hashCode());
        result = 31 * result + (this._systemProperties == null ? 0 : this._systemProperties.hashCode());
        return result;
    }

    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof JvmEntry)) {
            return false;
        }
        JvmEntry jvmEntry = (JvmEntry)entry;
        return CommonUtilities.equals(this._classpath, jvmEntry.getClasspath()) && CommonUtilities.equals(this._initialHeapSize, jvmEntry.getInitialHeapSize()) && CommonUtilities.equals(this._maximumHeapSize, jvmEntry.getMaximumHeapSize()) && CommonUtilities.equals(this._genericJvmArguments, jvmEntry.getGenericJvmArguments()) && CommonUtilities.equals(this._systemProperties, jvmEntry.getSystemProperties());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("JvmEntry: " + nl);
        sb.append("initialHeapSize=\"" + this._initialHeapSize + "\"" + nl);
        sb.append("maximumHeapSize=\"" + this._maximumHeapSize + "\"" + nl);
        sb.append("genericJvmArguments=\"" + this._genericJvmArguments + "\"" + nl);
        sb.append("classpath: " + nl);
        if (this._classpath != null) {
            for (String entry : this._classpath) {
                sb.append(entry + nl);
            }
        }
        if (this._systemProperties != null) {
            for (Property prop : this._systemProperties) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }
}

