/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.configutility.Application;
import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.JeeProviders;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.appmodules.AppModule;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.resource.DataSource;
import com.ibm.ws.report.binary.configutility.resource.J2CActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2CAdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2CConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.JavaEEDefaultResource;
import com.ibm.ws.report.binary.configutility.resource.JdbcProvider;
import com.ibm.ws.report.binary.configutility.resource.MqConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqQueue;
import com.ibm.ws.report.binary.configutility.resource.MqQueueConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqTopic;
import com.ibm.ws.report.binary.configutility.resource.MqTopicConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.resource.SIBus;
import com.ibm.ws.report.binary.configutility.security.AuthDataEntry;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.security.LDAPUserRegistry;
import com.ibm.ws.report.binary.configutility.security.SSLConfigGroup;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.security.SecurityRole;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.security.WIMUserRegistry;
import com.ibm.ws.report.binary.configutility.security.tls.ActiveSSLConfigGroups;
import com.ibm.ws.report.binary.configutility.security.tls.DynamicSSLConfigSelection;
import com.ibm.ws.report.binary.configutility.security.tls.ManagementScope;
import com.ibm.ws.report.binary.configutility.security.wim.LdapRepository;
import com.ibm.ws.report.binary.configutility.security.wim.LdapServerConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.WimConfig;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.server.SessionDatabasePersistence;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.twas.Cell;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.Nodes;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.binary.configutility.twas.References;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.binary.configutility.twas.TwasBindingScanningUtilities;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Apps {
    private final SortedMap<String, App> _apps = new TreeMap<String, App>();
    protected Cell _cell;
    private final Map<String, Exception> _failedApps = new HashMap<String, Exception>();
    private static final String nl = System.getProperty("line.separator");

    Apps(Cell cell, Clusters clusters, Servers servers) {
        File appsDir = new File(cell.getCellPath(), "applications");
        File[] appList = appsDir.listFiles();
        this._cell = cell;
        if (appList == null) {
            if (!appsDir.exists()) {
                ReportUtility.logger.get().log(Level.FINE, "Applications directory " + appsDir.getAbsolutePath() + " for cell " + cell.getCellName() + " does not exist.");
            } else if (!appsDir.isDirectory()) {
                ReportUtility.logger.get().log(Level.FINE, "Applications directory " + appsDir.getAbsolutePath() + " for cell " + cell.getCellName() + " exists but is a file, not a directory.");
            } else if (!appsDir.canRead()) {
                ReportUtility.logger.get().log(Level.FINE, "Applications directory " + appsDir.getAbsolutePath() + " for cell " + cell.getCellName() + " exists but could not be read.");
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Applications directory " + appsDir.getAbsolutePath() + " for cell " + cell.getCellName() + " could not be accessed due to an unknown error.");
            }
            return;
        }
        Arrays.sort(appList, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        for (File appDir : appList) {
            if (!appDir.getPath().toLowerCase().endsWith(".ear")) continue;
            try {
                File[] deploymentFiles;
                File deploymentsFolder = new File(appDir, "deployments");
                for (File file : deploymentFiles = deploymentsFolder.listFiles()) {
                    try {
                        File deploymentFile = new File(file, "deployment.xml");
                        if (!deploymentFile.exists()) continue;
                        File appDeploymentDir = file;
                        App app = new App(appDeploymentDir, clusters, servers, file.getName().concat(".ear"), appDir.getName());
                        this._apps.put(app.getAppName(), app);
                    }
                    catch (Exception e) {
                        if (file == null) continue;
                        ReportUtility.logger.get().log(Level.FINEST, "Unable to read app " + file.getPath() + " because of following exception", e);
                        Exception wrapper = new Exception(Messages.getFormattedMessage(Messages.getString("Apps_Unable_To_Read_App"), file.getPath(), e));
                        wrapper.initCause(e);
                        this._failedApps.put(file.getName(), wrapper);
                    }
                }
            }
            catch (Exception e) {
                if (appDir == null) continue;
                ReportUtility.logger.get().log(Level.FINEST, "Unable to read app " + appDir.getPath() + " because of following exception", e);
                Exception wrapper = new Exception(Messages.getFormattedMessage(Messages.getString("Apps_Unable_To_Read_App"), appDir.getPath(), e));
                wrapper.initCause(e);
                this._failedApps.put(appDir.getName(), wrapper);
            }
        }
    }

    protected Apps() {
    }

    void loadScopedData() {
        for (App app : this._apps.values()) {
            app.loadScopedData();
        }
    }

    public App getApp(String name2) {
        return (App)this._apps.get(name2);
    }

    public Exception getFailedAppError(String appName) {
        return this._failedApps.get(appName);
    }

    public int getAppCount() {
        return this._apps.size();
    }

    public Iterable<App> getApps() {
        return this._apps.values();
    }

    public String toString() {
        if (this._apps.isEmpty()) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (App ad : this._apps.values()) {
            if (!first) {
                sb.append(nl);
            }
            sb.append(ad.toString());
            first = false;
        }
        return sb.toString();
    }

    public class App
    implements Application {
        protected final File _appDeploymentDir;
        protected final String _appName;
        protected Document _resourcesXml;
        protected Document _variablesXml;
        protected Document _librariesXml;
        protected Element _sessionManagerElement;
        protected Application.ApplicationType _appType;
        protected final String _appBinaryName;
        protected String _appVersion;
        protected List<AppModule> _appModuleData = new ArrayList<AppModule>();
        protected List<SecurityRole> _securityRoles = new ArrayList<SecurityRole>();
        protected String _displayName = "";
        protected final ScopedMap<SessionManager> _sessionManager = new ScopedMap();
        protected final ScopedMap<TransactionService> _transactionService = new ScopedMap();
        protected String _minimumWebSphereRelease = "";
        protected String _minimumJavaRelease = "";
        protected String _minimumJpaProvider = "";
        protected String _minimumJsfProvider = "";
        protected String _minimumJaxrsProvider = "";
        protected final SortedMap<String, Clusters.Cluster> _clusterTargets = new TreeMap<String, Clusters.Cluster>();
        protected final SortedMap<String, Servers.Server> _serverTargets = new TreeMap<String, Servers.Server>();
        protected final Set<String> _usedIdentifierNames = new HashSet<String>();
        protected final ScopedMap<Variable> _variables = new ScopedMap();
        protected final ScopedMap<Library> _libraries = new ScopedMap();
        protected final Set<String> _libraryReferences = new HashSet<String>();
        protected final Resources _resources = new Resources();
        protected final SortedMap<String, List<String>> _scopeConflicts = new TreeMap<String, List<String>>();
        protected final List<String> _modulesWithSessionManagerConfig = new ArrayList<String>();
        protected List<AuthDataEntry> _authDataEntryCache;
        protected List<DataSource> _dataSourceCache;
        protected List<JdbcProvider> _jdbcProviderCache;
        protected List<J2CAdminObject> _j2cAdminObjectCache;
        protected List<J2CActivationSpec> _j2cActivationSpecCache;
        protected List<J2CConnectionFactory> _j2cConnectionFactoryCache;
        protected List<MqQueueConnectionFactory> _mqQueueConnectionFactoryCache;
        protected List<MqTopicConnectionFactory> _mqTopicConnectionFactoryCache;
        protected List<MqConnectionFactory> _mqConnectionFactoryCache;
        protected List<MqQueue> _mqQueueCache;
        protected List<MqTopic> _mqTopicCache;
        protected List<ProcessDefinition> _processDefinitionCache;
        protected Set<String> _appReferencedSSLConfigCache;
        protected ActiveSSLConfigGroups _activeSSLConfigCache;
        protected Security _resolvedSecurityCache;

        private App(File appDeploymentDir, Clusters clusters, Servers servers, String appName, String applicationNameWithoutEditions) throws Exception {
            File resFile;
            File libFile;
            this._appDeploymentDir = appDeploymentDir;
            File deploymentFile = new File(this._appDeploymentDir, "deployment.xml");
            Document deployXml = FileUtilities.getDocument(deploymentFile);
            NodeList targets = deployXml.getElementsByTagName("deploymentTargets");
            this._appName = appName;
            ArrayList<String> serversNotFound = new ArrayList<String>();
            for (int i = 0; i < targets.getLength(); ++i) {
                Element target = (Element)targets.item(i);
                String name2 = target.getAttribute("name");
                String nodeName = target.getAttribute("nodeName");
                if (nodeName.isEmpty()) {
                    Clusters.Cluster cluster = clusters.getCluster(name2);
                    if (cluster == null) {
                        ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Apps_Cluster_Target_Doesnt_Exist"), this._appName, name2));
                        continue;
                    }
                    this._clusterTargets.put(name2, cluster);
                    cluster.addApp(this);
                    continue;
                }
                String serverName = nodeName + "/" + (String)name2;
                Servers.Server server = servers.getServer(serverName);
                if (server == null) {
                    serversNotFound.add(serverName);
                    continue;
                }
                this._serverTargets.put(serverName, server);
                server.addApp(this);
            }
            if (serversNotFound.size() != 0) {
                if ((this._serverTargets.size() > 0 || this._clusterTargets.size() > 0) && servers.getServerCount() > 0 && servers.getServers().iterator().next().getOwningNode().isFederatedNode()) {
                    for (String serverName : serversNotFound) {
                        ReportUtility.logger.get().log(Level.FINEST, "Unable to find server deployment target " + serverName + " while running from federated node.");
                    }
                } else {
                    for (String serverName : serversNotFound) {
                        ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Apps_Server_Target_Doesnt_Exist"), this._appName, serverName));
                    }
                }
            }
            for (Servers.Server server : this._serverTargets.values()) {
                this._minimumWebSphereRelease = CommonUtilities.getOldestVersion(this._minimumWebSphereRelease, server.getOwningNode().getProductVersion(), false);
                this._minimumJavaRelease = CommonUtilities.getOldestVersion(this._minimumJavaRelease, server.getOwningNode().getJavaVersion(), true);
                this._minimumJpaProvider = CommonUtilities.getOldestVersion(this._minimumJpaProvider, server.getJeeProviders().getJpaProvider(), false);
                this._minimumJaxrsProvider = CommonUtilities.getOldestVersion(this._minimumJaxrsProvider, server.getJeeProviders().getJaxRSProvider(), false);
                this._minimumJsfProvider = CommonUtilities.getOldestVersion(this._minimumJsfProvider, server.getJeeProviders().getJsfProvider(), false);
            }
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                for (Servers.Server server : cluster.getServers()) {
                    this._minimumWebSphereRelease = CommonUtilities.getOldestVersion(this._minimumWebSphereRelease, server.getOwningNode().getProductVersion(), false);
                    this._minimumJavaRelease = CommonUtilities.getOldestVersion(this._minimumJavaRelease, server.getOwningNode().getJavaVersion(), true);
                    this._minimumJpaProvider = CommonUtilities.getOldestVersion(this._minimumJpaProvider, cluster.getJeeProviders().getJpaProvider(), false);
                    this._minimumJaxrsProvider = CommonUtilities.getOldestVersion(this._minimumJaxrsProvider, cluster.getJeeProviders().getJaxRSProvider(), false);
                    this._minimumJsfProvider = CommonUtilities.getOldestVersion(this._minimumJsfProvider, cluster.getJeeProviders().getJsfProvider(), false);
                }
            }
            JeeProviders jp = JeeProviders.fromProductVersion(this._minimumWebSphereRelease);
            if (jp != null) {
                this._minimumJpaProvider = CommonUtilities.getOldestVersion(this._minimumJpaProvider, jp.getJpaProvider(), false);
                this._minimumJaxrsProvider = CommonUtilities.getOldestVersion(this._minimumJaxrsProvider, jp.getJaxRSProvider(), false);
                this._minimumJsfProvider = CommonUtilities.getOldestVersion(this._minimumJsfProvider, jp.getJsfProvider(), false);
            }
            ReportUtility.logger.get().log(Level.FINE, "Oldest WebSphere release used in cell: " + this._minimumWebSphereRelease);
            ReportUtility.logger.get().log(Level.FINE, "Oldest Java version used in cell: " + this._minimumJavaRelease);
            ReportUtility.logger.get().log(Level.FINE, "Oldest JPA version configured for app: " + this._minimumJpaProvider);
            ReportUtility.logger.get().log(Level.FINE, "Oldest JAXRS version configured for app: " + this._minimumJaxrsProvider);
            ReportUtility.logger.get().log(Level.FINE, "Oldest JSF version configured for app: " + this._minimumJsfProvider);
            File varFile = new File(this._appDeploymentDir, "variables.xml");
            if (varFile.exists()) {
                this._variablesXml = FileUtilities.getDocument(varFile);
            }
            if ((libFile = new File(this._appDeploymentDir, "libraries.xml")).exists()) {
                this._librariesXml = FileUtilities.getDocument(libFile);
            }
            if ((resFile = new File(this._appDeploymentDir, "resources.xml")).exists()) {
                this._resourcesXml = FileUtilities.getDocument(resFile);
            }
            TwasBindingScanningUtilities.scanFilesForIdentifierNames(this._appDeploymentDir, this._usedIdentifierNames, this._appName);
            File applicationFile = new File(appDeploymentDir + "/META-INF", "application.xml");
            Document applicationXml = null;
            if (applicationFile.exists()) {
                applicationXml = FileUtilities.getDocument(applicationFile);
                this._displayName = TwasXmlUtilities.loadApplicationDisplayName(applicationXml);
                this._appVersion = TwasXmlUtilities.loadApplicationVersion(applicationXml);
                this._appModuleData = TwasXmlUtilities.loadApplicationModules(applicationXml, appDeploymentDir);
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Unable to find application.xml for app " + this._appName + " at " + applicationFile.getAbsolutePath() + ". Certain data, such as modules, will not be migrated.");
            }
            boolean xmi = "1.2".equals(this._appVersion) || "1.3".equals(this._appVersion) || "1.4".equals(this._appVersion);
            File ibmApplicationBndXmlFile = new File(appDeploymentDir + "/META-INF", "ibm-application-bnd.xml");
            File ibmApplicationBndXmiFile = new File(appDeploymentDir + "/META-INF", "ibm-application-bnd.xmi");
            if (ibmApplicationBndXmlFile.exists() && !xmi) {
                ReportUtility.logger.get().log(Level.FINEST, "Loading security bindings from xml file. Application version: " + this._appVersion);
                Document ibmApplicationBndXml = FileUtilities.getDocument(ibmApplicationBndXmlFile);
                this._securityRoles = TwasXmlUtilities.loadApplicationSecurityRolesXml(ibmApplicationBndXml, Apps.this._cell.getCellName());
            } else if (ibmApplicationBndXmiFile.exists() && xmi) {
                ReportUtility.logger.get().log(Level.FINEST, "Loading security bindings from xmi file. Application version: " + this._appVersion);
                Document ibmApplicationBndXmi = FileUtilities.getDocument(ibmApplicationBndXmiFile);
                this._securityRoles = TwasXmlUtilities.loadApplicationSecurityRolesXmi(ibmApplicationBndXmi, applicationXml, this._appName, Apps.this._cell.getCellName());
            }
            NodeList deployedObjectList = deployXml.getElementsByTagName("deployedObject");
            boolean standaloneModule = false;
            if (deployedObjectList.getLength() > 0) {
                Element deployedObject = (Element)deployedObjectList.item(0);
                standaloneModule = Boolean.parseBoolean(deployedObject.getAttribute("standaloneModule"));
            }
            if (standaloneModule) {
                this._appType = Application.ApplicationType.WAR;
                if (!this._appModuleData.isEmpty()) {
                    this._appBinaryName = this._appModuleData.get(0).getModulePath();
                    if (this._appModuleData.size() != 1) {
                        ReportUtility.logger.get().log(Level.FINE, "There should be only one web module in a war, but found " + this._appModuleData.size() + ". Setting appBinaryName to first module: " + this._appBinaryName);
                    }
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "Found no web modules in war, setting appBinaryName to appName: " + this._appName);
                    this._appBinaryName = this._appName;
                }
            } else {
                this._appType = Application.ApplicationType.EAR;
                this._appBinaryName = applicationNameWithoutEditions != null ? applicationNameWithoutEditions : this._appName;
            }
            NodeList libraries = deployXml.getElementsByTagName("libraries");
            for (int i = 0; i < libraries.getLength(); ++i) {
                Element library = (Element)libraries.item(i);
                String libraryName = library.getAttribute("libraryName");
                if (libraryName.length() <= 0) continue;
                this._libraryReferences.add(libraryName);
            }
            NodeList configsList = deployXml.getElementsByTagName("configs");
            for (int i = 0; i < configsList.getLength(); ++i) {
                NodeList sessionManagementList;
                Element configElement = (Element)configsList.item(i);
                if (!"appcfg:ApplicationConfig".equals(configElement.getAttribute("xmi:type")) || (sessionManagementList = configElement.getElementsByTagName("sessionManagement")).getLength() <= 0) continue;
                this._sessionManagerElement = (Element)sessionManagementList.item(0);
                break;
            }
            NodeList modulesList = deployXml.getElementsByTagName("modules");
            for (int i = 0; i < modulesList.getLength(); ++i) {
                Element sessionManagementElement;
                Element moduleElement = (Element)modulesList.item(i);
                NodeList sessionManagementList = moduleElement.getElementsByTagName("sessionManagement");
                if (sessionManagementList.getLength() <= 0 || !"true".equalsIgnoreCase((sessionManagementElement = (Element)sessionManagementList.item(0)).getAttribute("enable"))) continue;
                this._modulesWithSessionManagerConfig.add(moduleElement.getAttribute("uri"));
            }
        }

        protected App(String appName, String appBinaryName, File appDeploymentDir) {
            this._appName = appName;
            this._appBinaryName = appBinaryName;
            this._appDeploymentDir = appDeploymentDir;
        }

        private void loadScopedData() {
            SessionManager sessionManager;
            TransactionService nonDefaultTransactionService;
            Scope scope = new Scope(Scope.Level.APPLICATION, this._appName, this._appDeploymentDir);
            ArrayList listOfSessionManagers = new ArrayList();
            ArrayList listOfTransactionServices = new ArrayList();
            for (Servers.Server server : this._serverTargets.values()) {
                this._variables.putAll(server.getVariables());
                this._libraries.putAll(server.getLibraries());
                this._resources.putAll(server.getResources());
                listOfSessionManagers.add(server.getSessionManager());
                listOfTransactionServices.add(server.getTransactionService());
            }
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                for (Servers.Server server : cluster.getServers()) {
                    this._variables.putAll(server.getVariables());
                    this._libraries.putAll(server.getLibraries());
                    this._resources.putAll(server.getResources());
                    listOfSessionManagers.add(server.getSessionManager());
                    listOfTransactionServices.add(server.getTransactionService());
                }
            }
            SessionManager nonDefaultSessionManager = this.getNonDefaultObject(listOfSessionManagers, SessionManager.class);
            if (nonDefaultSessionManager != null) {
                this._sessionManager.put("SessionManager", nonDefaultSessionManager);
            }
            if ((nonDefaultTransactionService = this.getNonDefaultObject(listOfTransactionServices, TransactionService.class)) != null) {
                this._transactionService.put("TransactionService", nonDefaultTransactionService);
            }
            if (this._variablesXml != null) {
                TwasXmlUtilities.loadVariables(this._variables, this._variablesXml, scope);
            }
            if (this._librariesXml != null) {
                TwasXmlUtilities.loadLibraries(this._libraries, this._librariesXml, scope);
            }
            if (this._resourcesXml != null) {
                TwasXmlUtilities.loadResources(this._resources, this._resourcesXml, scope);
            }
            if (this._sessionManagerElement != null && (sessionManager = TwasXmlUtilities.loadSessionManager(this._sessionManagerElement, scope)).getEnable().equalsIgnoreCase("true")) {
                this._sessionManager.put("SessionManager", sessionManager);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._appName);
            for (Clusters.Cluster cd : this._clusterTargets.values()) {
                sb.append(nl + "- Cluster                  : " + cd.getClusterName());
            }
            for (Servers.Server sd : this._serverTargets.values()) {
                sb.append(nl + "- Server                   : " + sd.getServerName());
            }
            sb.append(nl + "- Libraries                : " + this._libraries.keySet());
            sb.append(nl + "- Library References       : " + this._libraryReferences);
            sb.append(nl + "- DataSources              : " + this._resources.getDataSources().keySet());
            sb.append(nl + "- J2C Admin Objects        : " + this._resources.getJ2CAdminObjects().keySet());
            sb.append(nl + "- J2C Connection Factories : " + this._resources.getJ2CConnectionFactories().keySet());
            sb.append(nl + "- J2C Activation Specs     : " + this._resources.getJ2CActivationSpecs().keySet());
            sb.append(nl + "- MQ Queue CFs             : " + this._resources.getMqQueueConnectionFactories().keySet());
            sb.append(nl + "- MQ Topic CFs             : " + this._resources.getMqTopicConnectionFactories().keySet());
            sb.append(nl + "- MQ CFs                   : " + this._resources.getMqConnectionFactories().keySet());
            sb.append(nl + "- MQ Queues                : " + this._resources.getMqQueues().keySet());
            sb.append(nl + "- MQ Topics                : " + this._resources.getMqTopics().keySet());
            sb.append(nl + "- Variables                : " + this._variables.valuesIgnoreScopeConflicts());
            sb.append(nl + "- Application Type         : " + (Object)((Object)this._appType));
            sb.append(nl + "- Display Name             : " + this._displayName);
            sb.append(nl + "- Application Binary Name  : " + this._appBinaryName);
            sb.append(nl + "- Security Roles           : " + this._securityRoles);
            sb.append(nl);
            return sb.toString();
        }

        public String getAppName() {
            return this._appName;
        }

        public Iterable<Clusters.Cluster> getClusterTargets() {
            return this._clusterTargets.values();
        }

        public Iterable<Servers.Server> getServerTargets() {
            return this._serverTargets.values();
        }

        public int getClusterTargetCount() {
            return this._clusterTargets.size();
        }

        public Clusters.Cluster getClusterTarget(String name2) {
            return (Clusters.Cluster)this._clusterTargets.get(name2);
        }

        public int getServerTargetCount() {
            return this._serverTargets.size();
        }

        public Servers.Server getServerTarget(String name2) {
            return (Servers.Server)this._serverTargets.get(name2);
        }

        public SortedMap<String, List<String>> getScopeConflicts() {
            return this._scopeConflicts;
        }

        public List<String> getModulesWithSessionManagerConfig() {
            return this._modulesWithSessionManagerConfig;
        }

        public ScopedMap<Variable> getVariables() {
            return this._variables;
        }

        public ScopedMap<Library> getLibraries() {
            return this._libraries;
        }

        public Set<String> getLibraryPaths() {
            Object[] targets;
            Set<Object> serverReferencedLibraries = new HashSet();
            if (!this._clusterTargets.isEmpty()) {
                targets = this._clusterTargets.values().toArray(new Clusters.Cluster[0]);
                Iterable<Servers.Server> targetServers = targets[targets.length - 1].getServers();
                Iterator<Servers.Server> iter = targetServers.iterator();
                while (iter.hasNext()) {
                    Servers.Server current = iter.next();
                    if (iter.hasNext()) continue;
                    serverReferencedLibraries = current.getLibraryReferences();
                    ReportUtility.logger.get().log(Level.FINEST, "Using server libraries referenced from server " + current.getServerName() + " in cluster " + current.getOwningCluster().getClusterName() + " for app " + this._appName);
                }
            } else if (!this._serverTargets.isEmpty()) {
                targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                serverReferencedLibraries = ((Servers.Server)targets[targets.length - 1]).getLibraryReferences();
                ReportUtility.logger.get().log(Level.FINEST, "Using server libraries referenced from server " + ((Servers.Server)targets[targets.length - 1]).getServerName() + " for app " + this._appName);
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Did not find any applicable targets for server libraries for app " + this._appName);
            }
            HashSet<String> libraryPaths = new HashSet<String>();
            for (Library lib : this._libraries.values(this._scopeConflicts)) {
                String libName = lib.getName();
                if (!this._libraryReferences.contains(libName) && !serverReferencedLibraries.contains(libName)) continue;
                for (String libPath : lib.getClassPath()) {
                    String result = CommonUtilities.resolveVariables(libPath, this._variables);
                    if (result == null) continue;
                    libraryPaths.add(result);
                }
            }
            ReportUtility.logger.get().log(Level.FINEST, "Found the following library paths to be scanned:" + System.getProperty("line.separator") + ((Object)libraryPaths).toString());
            return libraryPaths;
        }

        public Set<Library> getAppLibraries() {
            Object[] targets;
            Set<Object> serverReferencedLibraries = new HashSet();
            if (!this._clusterTargets.isEmpty()) {
                targets = this._clusterTargets.values().toArray(new Clusters.Cluster[0]);
                Iterable<Servers.Server> targetServers = targets[targets.length - 1].getServers();
                Iterator<Servers.Server> iter = targetServers.iterator();
                while (iter.hasNext()) {
                    Servers.Server current = iter.next();
                    if (iter.hasNext()) continue;
                    serverReferencedLibraries = current.getLibraryReferences();
                    ReportUtility.logger.get().log(Level.FINEST, "Using server libraries referenced from server " + current.getServerName() + " in cluster " + current.getOwningCluster().getClusterName() + " for app " + this._appName);
                }
            } else if (!this._serverTargets.isEmpty()) {
                targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                serverReferencedLibraries = ((Servers.Server)targets[targets.length - 1]).getLibraryReferences();
                ReportUtility.logger.get().log(Level.FINEST, "Using server libraries referenced from server " + ((Servers.Server)targets[targets.length - 1]).getServerName() + " for app " + this._appName);
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Did not find any applicable targets for server libraries for app " + this._appName);
            }
            HashSet<Library> libraries = new HashSet<Library>();
            for (Library lib : this._libraries.values(this._scopeConflicts)) {
                String libName = lib.getName();
                if (!this._libraryReferences.contains(libName) && !serverReferencedLibraries.contains(libName)) continue;
                ArrayList<String> resolvedClassPaths = new ArrayList<String>();
                for (String classPath : lib.getClassPath()) {
                    String result = CommonUtilities.resolveVariables(classPath, this._variables);
                    if (result == null) continue;
                    resolvedClassPaths.add(result);
                }
                lib.setResolvedClassPath(resolvedClassPaths);
                libraries.add(lib);
            }
            return libraries;
        }

        public Map<Servers.Server, Set<String>> getServerLibraryNamesMap() {
            HashMap<Servers.Server, Set<String>> serverNameToLibraryNames = new HashMap<Servers.Server, Set<String>>();
            Set<Object> serverReferencedLibraries = new HashSet();
            if (!this._serverTargets.isEmpty()) {
                Servers.Server[] targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                Servers.Server server = targets[targets.length - 1];
                serverReferencedLibraries = server.getLibraryReferences();
                serverNameToLibraryNames.put(server, serverReferencedLibraries);
                return serverNameToLibraryNames;
            }
            return serverNameToLibraryNames;
        }

        public Set<String> getUsedIdentifierNames() {
            return this._usedIdentifierNames;
        }

        public Resources getResources() {
            return this._resources;
        }

        public List<ProcessDefinition> getProcessDefinitions() {
            if (this._processDefinitionCache == null) {
                Object[] targets;
                String serverName = "";
                this._processDefinitionCache = new ArrayList<ProcessDefinition>();
                if (!this._clusterTargets.isEmpty()) {
                    targets = this._clusterTargets.values().toArray(new Clusters.Cluster[0]);
                    Iterable<Servers.Server> targetServers = targets[targets.length - 1].getServers();
                    Iterator<Servers.Server> iter = targetServers.iterator();
                    while (iter.hasNext()) {
                        Servers.Server current = iter.next();
                        if (iter.hasNext()) continue;
                        this._processDefinitionCache = current.getProcessDefinitions();
                        serverName = current.getServerName();
                        ReportUtility.logger.get().log(Level.FINEST, "Using process options from server " + current.getServerName() + " in cluster " + current.getOwningCluster().getClusterName() + " for app " + this._appName);
                    }
                } else if (!this._serverTargets.isEmpty()) {
                    targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                    this._processDefinitionCache = ((Servers.Server)targets[targets.length - 1]).getProcessDefinitions();
                    serverName = ((Servers.Server)targets[targets.length - 1]).getServerName();
                    ReportUtility.logger.get().log(Level.FINEST, "Using process options from server " + ((Servers.Server)targets[targets.length - 1]).getServerName() + " for app " + this._appName);
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "Did not find any applicable targets for process options for app " + this._appName);
                }
                for (ProcessDefinition pd : this._processDefinitionCache) {
                    pd.serverName = serverName;
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using ProcessDefinition cache for app " + this._appName);
            }
            return new ArrayList<ProcessDefinition>(this._processDefinitionCache);
        }

        public List<DataSource> getDataSources() {
            if (this._dataSourceCache == null) {
                this._dataSourceCache = new ArrayList<DataSource>();
                ScopedMap<DataSource> datasources = this._resources.getDataSources();
                for (DataSource ds : datasources.values(this._scopeConflicts)) {
                    if (this._usedIdentifierNames.contains(ds.getJndiName())) {
                        ReportUtility.logger.get().log(Level.FINEST, "Added datasource " + ds.getJndiName() + " to map of datasources for app " + this._appName);
                        this._dataSourceCache.add(ds);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINEST, "Resource " + ds.getJndiName() + " was not used as a datasource by app " + this._appName);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using DataSource cache for app " + this._appName);
            }
            return new ArrayList<DataSource>(this._dataSourceCache);
        }

        public List<JdbcProvider> getJdbcProviders() {
            if (this._jdbcProviderCache == null) {
                this._jdbcProviderCache = new ArrayList<JdbcProvider>();
                for (DataSource ds : this.getDataSources()) {
                    JdbcProvider provider = ds.getProvider();
                    this._jdbcProviderCache.add(provider);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using JdbcProvider cache for app " + this._appName);
            }
            return new ArrayList<JdbcProvider>(this._jdbcProviderCache);
        }

        public LinkedHashMap<JdbcProvider, List<DataSource>> getDataSourcesByJdbcProviders() {
            List<JdbcProvider> providers = this.getJdbcProviders();
            List<DataSource> dataSources = this.getDataSources();
            LinkedHashMap<JdbcProvider, List<DataSource>> map = new LinkedHashMap<JdbcProvider, List<DataSource>>();
            for (JdbcProvider provider : providers) {
                ArrayList<DataSource> sources = new ArrayList<DataSource>();
                for (DataSource ds : dataSources) {
                    if (ds.getProvider().getName() != provider.getName()) continue;
                    sources.add(ds);
                }
                map.put(provider, sources);
            }
            return map;
        }

        public List<AuthDataEntry> getAuthDataEntries() {
            if (this._authDataEntryCache == null) {
                AuthDataEntry entry;
                AuthDataEntry entry2;
                AuthDataEntry entry3;
                String recoveryAlias;
                String componentAlias;
                String alias;
                Map<String, AuthDataEntry> entries = this.getResolvedSecurity().getAuthDataEntries();
                LinkedHashSet<AuthDataEntry> used = new LinkedHashSet<AuthDataEntry>();
                for (AuthDataEntry authDataEntry : entries.values()) {
                    if (!this._usedIdentifierNames.contains(authDataEntry.getAlias())) continue;
                    used.add(authDataEntry);
                }
                for (DataSource dataSource : this.getDataSources()) {
                    AuthDataEntry entry22;
                    AuthDataEntry entry32;
                    alias = dataSource.getContainerAuthDataAlias();
                    if (alias != null && (entry32 = entries.get(alias)) != null) {
                        used.add(entry32);
                    }
                    if ((componentAlias = dataSource.getComponentAuthDataAlias()) != null && (entry22 = entries.get(componentAlias)) != null) {
                        used.add(entry22);
                    }
                    if ((recoveryAlias = dataSource.getXaRecoveryAuthAlias()) == null || (entry3 = entries.get(recoveryAlias)) == null) continue;
                    used.add(entry3);
                }
                for (J2CActivationSpec j2CActivationSpec : this.getJ2CActivationSpecs()) {
                    alias = j2CActivationSpec.getAuthenticationAlias();
                    if (alias == null || (entry2 = entries.get(alias)) == null) continue;
                    used.add(entry2);
                }
                for (J2CConnectionFactory j2CConnectionFactory : this.getJ2CConnectionFactories()) {
                    alias = j2CConnectionFactory.getContainerAuthDataAlias();
                    if (alias != null && (entry2 = entries.get(alias)) != null) {
                        used.add(entry2);
                    }
                    if ((componentAlias = j2CConnectionFactory.getComponentAuthDataAlias()) != null && (entry = entries.get(componentAlias)) != null) {
                        used.add(entry);
                    }
                    if ((recoveryAlias = j2CConnectionFactory.getXaRecoveryAuthAlias()) == null || (entry3 = entries.get(recoveryAlias)) == null) continue;
                    used.add(entry3);
                }
                for (MqQueueConnectionFactory mqQueueConnectionFactory : this.getMqQueueConnectionFactories()) {
                    alias = mqQueueConnectionFactory.getContainerAuthDataAlias();
                    if (alias != null && (entry2 = entries.get(alias)) != null) {
                        used.add(entry2);
                    }
                    if ((componentAlias = mqQueueConnectionFactory.getComponentAuthDataAlias()) != null && (entry = entries.get(componentAlias)) != null) {
                        used.add(entry);
                    }
                    if ((recoveryAlias = mqQueueConnectionFactory.getXaRecoveryAuthAlias()) == null || (entry3 = entries.get(recoveryAlias)) == null) continue;
                    used.add(entry3);
                }
                for (MqTopicConnectionFactory mqTopicConnectionFactory : this.getMqTopicConnectionFactories()) {
                    alias = mqTopicConnectionFactory.getContainerAuthDataAlias();
                    if (alias != null && (entry2 = entries.get(alias)) != null) {
                        used.add(entry2);
                    }
                    if ((componentAlias = mqTopicConnectionFactory.getComponentAuthDataAlias()) != null && (entry = entries.get(componentAlias)) != null) {
                        used.add(entry);
                    }
                    if ((recoveryAlias = mqTopicConnectionFactory.getXaRecoveryAuthAlias()) == null || (entry3 = entries.get(recoveryAlias)) == null) continue;
                    used.add(entry3);
                }
                for (MqConnectionFactory mqConnectionFactory : this.getMqConnectionFactories()) {
                    alias = mqConnectionFactory.getContainerAuthDataAlias();
                    if (alias != null && (entry2 = entries.get(alias)) != null) {
                        used.add(entry2);
                    }
                    if ((componentAlias = mqConnectionFactory.getComponentAuthDataAlias()) != null && (entry = entries.get(componentAlias)) != null) {
                        used.add(entry);
                    }
                    if ((recoveryAlias = mqConnectionFactory.getXaRecoveryAuthAlias()) == null || (entry3 = entries.get(recoveryAlias)) == null) continue;
                    used.add(entry3);
                }
                this._authDataEntryCache = new ArrayList<AuthDataEntry>(used);
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using AuthDataEntry cache for app " + this._appName);
            }
            return new ArrayList<AuthDataEntry>(this._authDataEntryCache);
        }

        public List<J2CAdminObject> getJmsAdminObjects() {
            if (this._j2cAdminObjectCache == null) {
                this._j2cAdminObjectCache = new ArrayList<J2CAdminObject>();
                for (J2CAdminObject jmsObject : this._resources.getJ2CAdminObjects().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(jmsObject.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added JMS admin object " + jmsObject.getJndiName() + " to map of JMS admin objects for app " + this._appName);
                    this._j2cAdminObjectCache.add(jmsObject);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using J2CAdminObject cache for app " + this._appName);
            }
            return new ArrayList<J2CAdminObject>(this._j2cAdminObjectCache);
        }

        public Iterable<JNDIBinding> getJNDIBinding() {
            ScopedMap<JNDIBinding> bindings = new ScopedMap<JNDIBinding>();
            Nodes nodes = Apps.this._cell.getNodes();
            for (Nodes.Node node : nodes.getNodes()) {
                for (Servers.Server server : node.getServers()) {
                    for (JNDIBinding binding : server.getJNDIBindings().values(this._scopeConflicts)) {
                        if (!binding.isFullName() || !this._usedIdentifierNames.contains(binding.getJndiName())) continue;
                        bindings.put(binding.getJndiName(), binding);
                    }
                }
            }
            for (Servers.Server server : this._serverTargets.values()) {
                for (JNDIBinding binding : server.getJNDIBindings().values(this._scopeConflicts)) {
                    if (binding.isFullName() || !this._usedIdentifierNames.contains(binding.getJndiName())) continue;
                    bindings.put(binding.getJndiName(), binding);
                }
            }
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                for (Servers.Server server : cluster.getServers()) {
                    for (JNDIBinding binding : server.getJNDIBindings().values(this._scopeConflicts)) {
                        if (binding.isFullName() || !this._usedIdentifierNames.contains(binding.getJndiName())) continue;
                        bindings.put(binding.getJndiName(), binding);
                    }
                }
            }
            return bindings.values(this._scopeConflicts);
        }

        public List<J2CConnectionFactory> getJ2CConnectionFactories() {
            if (this._j2cConnectionFactoryCache == null) {
                this._j2cConnectionFactoryCache = new ArrayList<J2CConnectionFactory>();
                for (J2CConnectionFactory j2cFactory : this._resources.getJ2CConnectionFactories().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(j2cFactory.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added J2C connection factory " + j2cFactory.getJndiName() + " to map of J2C connection factories for app " + this._appName);
                    this._j2cConnectionFactoryCache.add(j2cFactory);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using J2CConnectionFactory cache for app " + this._appName);
            }
            return new ArrayList<J2CConnectionFactory>(this._j2cConnectionFactoryCache);
        }

        public List<J2CActivationSpec> getJ2CActivationSpecs() {
            if (this._j2cActivationSpecCache == null) {
                this._j2cActivationSpecCache = new ArrayList<J2CActivationSpec>();
                for (J2CActivationSpec activationSpec : this._resources.getJ2CActivationSpecs().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(activationSpec.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added J2C Activation Spec " + activationSpec.getJndiName() + " to map of J2C Activation Specs for app " + this._appName);
                    this._j2cActivationSpecCache.add(activationSpec);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using J2CActivationSpec cache for app " + this._appName);
            }
            return new ArrayList<J2CActivationSpec>(this._j2cActivationSpecCache);
        }

        public List<SIBus> getAllServiceIntegrationBuses() {
            return new ArrayList<SIBus>(Apps.this._cell.getSIBuses().values());
        }

        public List<MqQueueConnectionFactory> getMqQueueConnectionFactories() {
            if (this._mqQueueConnectionFactoryCache == null) {
                this._mqQueueConnectionFactoryCache = new ArrayList<MqQueueConnectionFactory>();
                for (MqQueueConnectionFactory factory : this._resources.getMqQueueConnectionFactories().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(factory.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added MQ queue connection factory " + factory.getJndiName() + " to map of MQ queue connection factories for app " + this._appName);
                    this._mqQueueConnectionFactoryCache.add(factory);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using MqQueueConnectionFactory cache for app " + this._appName);
            }
            return new ArrayList<MqQueueConnectionFactory>(this._mqQueueConnectionFactoryCache);
        }

        public List<MqTopicConnectionFactory> getMqTopicConnectionFactories() {
            if (this._mqTopicConnectionFactoryCache == null) {
                this._mqTopicConnectionFactoryCache = new ArrayList<MqTopicConnectionFactory>();
                for (MqTopicConnectionFactory factory : this._resources.getMqTopicConnectionFactories().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(factory.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added MQ topic connection factory " + factory.getJndiName() + " to map of MQ topic connection factories for app " + this._appName);
                    this._mqTopicConnectionFactoryCache.add(factory);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using MqTopicConnectionFactory cache for app " + this._appName);
            }
            return new ArrayList<MqTopicConnectionFactory>(this._mqTopicConnectionFactoryCache);
        }

        public List<MqConnectionFactory> getMqConnectionFactories() {
            if (this._mqConnectionFactoryCache == null) {
                this._mqConnectionFactoryCache = new ArrayList<MqConnectionFactory>();
                for (MqConnectionFactory factory : this._resources.getMqConnectionFactories().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(factory.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added MQ connection factory " + factory.getJndiName() + " to map of MQ connection factories for app " + this._appName);
                    this._mqConnectionFactoryCache.add(factory);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using MqConnectionFactory cache for app " + this._appName);
            }
            return new ArrayList<MqConnectionFactory>(this._mqConnectionFactoryCache);
        }

        public List<MqQueue> getMqQueues() {
            if (this._mqQueueCache == null) {
                this._mqQueueCache = new ArrayList<MqQueue>();
                for (MqQueue queue : this._resources.getMqQueues().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(queue.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added MQ queue " + queue.getJndiName() + " to map of MQ queues for app " + this._appName);
                    this._mqQueueCache.add(queue);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using MqQueue cache for app " + this._appName);
            }
            return new ArrayList<MqQueue>(this._mqQueueCache);
        }

        public List<MqTopic> getMqTopics() {
            if (this._mqTopicCache == null) {
                this._mqTopicCache = new ArrayList<MqTopic>();
                for (MqTopic topic : this._resources.getMqTopics().values(this._scopeConflicts)) {
                    if (!this._usedIdentifierNames.contains(topic.getJndiName())) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Added MQ topic " + topic.getJndiName() + " to map of MQ topics for app " + this._appName);
                    this._mqTopicCache.add(topic);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using MqTopic cache for app " + this._appName);
            }
            return new ArrayList<MqTopic>(this._mqTopicCache);
        }

        @Override
        public Application.AppServer getSourceAppServer() {
            return Application.AppServer.TWAS;
        }

        public void addUsedIdentifierNames(Set<String> usedIdentifierNames) {
            String txLogJndiName;
            String txLogDir;
            TransactionService txSvc;
            SessionDatabasePersistence sessionDb;
            SessionManager sessionManager;
            if (usedIdentifierNames != null) {
                ReportUtility.logger.get().log(Level.FINEST, "Adding used identifier names to " + this._appName + System.getProperty("line.separator") + usedIdentifierNames);
                this._usedIdentifierNames.addAll(usedIdentifierNames);
            }
            if (null != (sessionManager = this.getSessionManager()) && "DATABASE".equals(sessionManager.getSessionPersistenceMode()) && null != (sessionDb = sessionManager.getSessionDatabasePersistence())) {
                String sessionDbJndiName = sessionDb.getDataSourceJNDIName();
                this._usedIdentifierNames.add(sessionDbJndiName);
            }
            if (null != (txSvc = this._transactionService.get("TransactionService", null)) && null != (txLogDir = CommonUtilities.getIfNotEmpty(txSvc.getTransactionLogDirectory())) && txLogDir.startsWith("custom://com.ibm.rls.jdbc.SQLRecoveryLog?") && null != (txLogJndiName = CommonUtilities.getTransactionDatabaseJndiName(txLogDir))) {
                this._usedIdentifierNames.add(txLogJndiName);
            }
        }

        public SessionManager getSessionManager() {
            return this._sessionManager.get("SessionManager", this._scopeConflicts);
        }

        public TransactionService getTransactionService() {
            return this._transactionService.get("TransactionService", this._scopeConflicts);
        }

        public void mapDefaultResources() {
            JavaEEDefaultResource defaultJMSCf;
            JavaEEDefaultResource defaultDs;
            if (this._usedIdentifierNames.contains(JavaEEDefaultResource.Type.DEFAULT_DS.toString()) && (defaultDs = this._resources.getDefaultResources().get(JavaEEDefaultResource.Type.DEFAULT_DS.toString(), this._scopeConflicts)) != null) {
                this._usedIdentifierNames.add(defaultDs.getJndiName());
            }
            if (this._usedIdentifierNames.contains(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString()) && (defaultJMSCf = this._resources.getDefaultResources().get(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), this._scopeConflicts)) != null) {
                this._usedIdentifierNames.add(defaultJMSCf.getJndiName());
            }
        }

        public Map<String, IdentifierObject> getUnknownIdentifierNames() {
            JavaEEDefaultResource defaultJMSCf;
            String containerAuthAlias;
            String componentAuthAlias;
            ArrayList<String> rules;
            HashMap<String, IdentifierObject> names = new HashMap<String, IdentifierObject>();
            String componentAuthRule = "DetectComponentAuth";
            Nodes nodes = Apps.this._cell.getNodes();
            for (Nodes.Node node : nodes.getNodes()) {
                for (Servers.Server server : node.getServers()) {
                    ScopedMap<JNDIBinding> bindings = server.getJNDIBindings();
                    for (JNDIBinding binding : bindings.valuesIgnoreScopeConflicts()) {
                        names.put(binding.getJndiName(), new IdentifierObject(binding.getJndiName(), new ArrayList<String>(), IdentifierObject.ResourceType.JNDI_ENTRY));
                    }
                }
            }
            for (AuthDataEntry entry : this.getResolvedSecurity().getAuthDataEntries().values()) {
                names.put(entry.getAlias(), new IdentifierObject(entry.getAlias(), new ArrayList<String>(), IdentifierObject.ResourceType.AUTH_ALIAS));
            }
            for (DataSource ds : this._resources.getDataSources().valuesIgnoreScopeConflicts()) {
                rules = new ArrayList<String>();
                componentAuthAlias = ds.getComponentAuthDataAlias();
                containerAuthAlias = ds.getContainerAuthDataAlias();
                if (!("".equals(componentAuthAlias) || "".equals(containerAuthAlias) || componentAuthAlias.equals(containerAuthAlias))) {
                    rules.add(componentAuthRule);
                }
                names.put(ds.getJndiName(), new IdentifierObject(ds.getJndiName(), rules, IdentifierObject.ResourceType.DATA_SOURCE));
            }
            for (J2CActivationSpec ac : this._resources.getJ2CActivationSpecs().valuesIgnoreScopeConflicts()) {
                names.put(ac.getJndiName(), new IdentifierObject(ac.getJndiName(), new ArrayList<String>(), IdentifierObject.ResourceType.J2C_ACTIVATION_SPEC));
            }
            for (J2CAdminObject ao : this._resources.getJ2CAdminObjects().valuesIgnoreScopeConflicts()) {
                names.put(ao.getJndiName(), new IdentifierObject(ao.getJndiName(), new ArrayList<String>(), IdentifierObject.ResourceType.J2C_ADMIN_OBJECT));
            }
            for (J2CConnectionFactory cf : this._resources.getJ2CConnectionFactories().valuesIgnoreScopeConflicts()) {
                rules = new ArrayList();
                componentAuthAlias = cf.getComponentAuthDataAlias();
                containerAuthAlias = cf.getContainerAuthDataAlias();
                if (!("".equals(componentAuthAlias) || "".equals(containerAuthAlias) || componentAuthAlias.equals(containerAuthAlias))) {
                    rules.add(componentAuthRule);
                }
                names.put(cf.getJndiName(), new IdentifierObject(cf.getJndiName(), rules, IdentifierObject.ResourceType.J2C_CONNECTION_FACTORY));
            }
            for (MqConnectionFactory mqcf : this._resources.getMqConnectionFactories().valuesIgnoreScopeConflicts()) {
                rules = new ArrayList();
                componentAuthAlias = mqcf.getComponentAuthDataAlias();
                containerAuthAlias = mqcf.getContainerAuthDataAlias();
                if (!("".equals(componentAuthAlias) || "".equals(containerAuthAlias) || componentAuthAlias.equals(containerAuthAlias))) {
                    rules.add(componentAuthRule);
                }
                names.put(mqcf.getJndiName(), new IdentifierObject(mqcf.getJndiName(), rules, IdentifierObject.ResourceType.MQ_CONNECTION_FACTORY));
            }
            for (MqQueueConnectionFactory mqqcf : this._resources.getMqQueueConnectionFactories().valuesIgnoreScopeConflicts()) {
                rules = new ArrayList();
                componentAuthAlias = mqqcf.getComponentAuthDataAlias();
                containerAuthAlias = mqqcf.getContainerAuthDataAlias();
                if (!("".equals(componentAuthAlias) || "".equals(containerAuthAlias) || componentAuthAlias.equals(containerAuthAlias))) {
                    rules.add(componentAuthRule);
                }
                names.put(mqqcf.getJndiName(), new IdentifierObject(mqqcf.getJndiName(), rules, IdentifierObject.ResourceType.MQ_QUEUE_CONNECTION_FACTORY));
            }
            for (MqTopicConnectionFactory mqtcf : this._resources.getMqTopicConnectionFactories().valuesIgnoreScopeConflicts()) {
                rules = new ArrayList();
                componentAuthAlias = mqtcf.getComponentAuthDataAlias();
                containerAuthAlias = mqtcf.getContainerAuthDataAlias();
                if (!("".equals(componentAuthAlias) || "".equals(containerAuthAlias) || componentAuthAlias.equals(containerAuthAlias))) {
                    rules.add(componentAuthRule);
                }
                names.put(mqtcf.getJndiName(), new IdentifierObject(mqtcf.getJndiName(), rules, IdentifierObject.ResourceType.MQ_TOPIC_CONNECTION_FACTORY));
            }
            for (MqQueue mqq : this._resources.getMqQueues().valuesIgnoreScopeConflicts()) {
                names.put(mqq.getJndiName(), new IdentifierObject(mqq.getJndiName(), new ArrayList<String>(), IdentifierObject.ResourceType.MQ_QUEUE));
            }
            for (MqTopic mqt : this._resources.getMqTopics().valuesIgnoreScopeConflicts()) {
                names.put(mqt.getJndiName(), new IdentifierObject(mqt.getJndiName(), new ArrayList<String>(), IdentifierObject.ResourceType.MQ_TOPIC));
            }
            JavaEEDefaultResource defaultDs = this._resources.getDefaultResources().get(JavaEEDefaultResource.Type.DEFAULT_DS.toString(), this._scopeConflicts);
            if (defaultDs != null) {
                String mappedJndiName = defaultDs.getJndiName();
                DataSource ds = this._resources.getDataSources().getIgnoreScopeConflicts(mappedJndiName);
                if (ds != null) {
                    ArrayList<String> rules2 = new ArrayList<String>();
                    String componentAuthAlias2 = ds.getComponentAuthDataAlias();
                    String containerAuthAlias2 = ds.getContainerAuthDataAlias();
                    if (!("".equals(componentAuthAlias2) || "".equals(containerAuthAlias2) || componentAuthAlias2.equals(containerAuthAlias2))) {
                        rules2.add(componentAuthRule);
                    }
                    names.put(JavaEEDefaultResource.Type.DEFAULT_DS.toString(), new IdentifierObject(JavaEEDefaultResource.Type.DEFAULT_DS.toString(), rules2, IdentifierObject.ResourceType.DATA_SOURCE));
                }
            }
            if ((defaultJMSCf = this._resources.getDefaultResources().get(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), this._scopeConflicts)) != null) {
                String mappedJndiName = defaultJMSCf.getJndiName();
                J2CConnectionFactory j2cCf = this._resources.getJ2CConnectionFactories().getIgnoreScopeConflicts(mappedJndiName);
                MqConnectionFactory mqCf = this._resources.getMqConnectionFactories().getIgnoreScopeConflicts(mappedJndiName);
                MqQueueConnectionFactory mqQueueCf = this._resources.getMqQueueConnectionFactories().getIgnoreScopeConflicts(mappedJndiName);
                MqTopicConnectionFactory mqTopicCf = this._resources.getMqTopicConnectionFactories().getIgnoreScopeConflicts(mappedJndiName);
                ArrayList<String> rules3 = new ArrayList<String>();
                if (j2cCf != null) {
                    String componentAuthAlias3 = j2cCf.getComponentAuthDataAlias();
                    String containerAuthAlias3 = j2cCf.getContainerAuthDataAlias();
                    if (!("".equals(componentAuthAlias3) || "".equals(containerAuthAlias3) || componentAuthAlias3.equals(containerAuthAlias3))) {
                        rules3.add(componentAuthRule);
                    }
                    names.put(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), new IdentifierObject(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), null, IdentifierObject.ResourceType.JMS_CONNECTION_FACTORY));
                } else if (mqCf != null) {
                    String componentAuthAlias4 = mqCf.getComponentAuthDataAlias();
                    String containerAuthAlias4 = mqCf.getContainerAuthDataAlias();
                    if (!("".equals(componentAuthAlias4) || "".equals(containerAuthAlias4) || componentAuthAlias4.equals(containerAuthAlias4))) {
                        rules3.add(componentAuthRule);
                    }
                    names.put(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), new IdentifierObject(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), null, IdentifierObject.ResourceType.JMS_CONNECTION_FACTORY));
                } else if (mqQueueCf != null) {
                    String componentAuthAlias5 = mqQueueCf.getComponentAuthDataAlias();
                    String containerAuthAlias5 = mqQueueCf.getContainerAuthDataAlias();
                    if (!("".equals(componentAuthAlias5) || "".equals(containerAuthAlias5) || componentAuthAlias5.equals(containerAuthAlias5))) {
                        rules3.add(componentAuthRule);
                    }
                    names.put(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), new IdentifierObject(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), null, IdentifierObject.ResourceType.JMS_CONNECTION_FACTORY));
                } else if (mqTopicCf != null) {
                    String componentAuthAlias6 = mqTopicCf.getComponentAuthDataAlias();
                    String containerAuthAlias6 = mqTopicCf.getContainerAuthDataAlias();
                    if (!("".equals(componentAuthAlias6) || "".equals(containerAuthAlias6) || componentAuthAlias6.equals(containerAuthAlias6))) {
                        rules3.add(componentAuthRule);
                    }
                    names.put(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), new IdentifierObject(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), null, IdentifierObject.ResourceType.JMS_CONNECTION_FACTORY));
                }
            }
            return names;
        }

        @Override
        public Application.ApplicationType getApplicationType() {
            return this._appType;
        }

        public String getAppBinaryName() {
            return this._appBinaryName;
        }

        public List<AppModule> getAppModuleData() {
            return this._appModuleData;
        }

        protected QosSessionPersistenceType getSessionReplicationTypeForCluster(String clusterName) {
            SessionManager appSessionMgr = this.getSessionManager();
            boolean appDefinedReplicationDomain = false;
            if (appSessionMgr != null && appSessionMgr.getSessionDRSPersistence() != null && "DATA_REPLICATION".equals(appSessionMgr.getSessionPersistenceMode())) {
                boolean bl = appDefinedReplicationDomain = !appSessionMgr.getSessionDRSPersistence().getMessageBrokerDomainName().equals("") && appSessionMgr.getScope().getLevel().equals((Object)Scope.Level.APPLICATION);
            }
            if (appSessionMgr != null && "DATABASE".equals(appSessionMgr.getSessionPersistenceMode()) && appSessionMgr.getScope().getLevel().equals((Object)Scope.Level.APPLICATION)) {
                return QosSessionPersistenceType.DATABASE;
            }
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                if (!cluster.getClusterName().equals(clusterName)) continue;
                if (cluster.getServerCount() > 1) {
                    if (appDefinedReplicationDomain) {
                        return QosSessionPersistenceType.MEMORY_TO_MEMORY;
                    }
                    HashSet<String> replicationDomains = new HashSet<String>();
                    boolean useDBSessionPersistence = false;
                    boolean useInMemorySessionPersistence = false;
                    for (Servers.Server server : cluster.getServers()) {
                        SessionManager sessionMgr = server.getSessionManager().get("SessionManager", null);
                        if (sessionMgr == null) continue;
                        if ("DATA_REPLICATION".equals(sessionMgr.getSessionPersistenceMode())) {
                            String replicationDomain;
                            if (sessionMgr.getSessionDRSPersistence() == null || "".equals(replicationDomain = sessionMgr.getSessionDRSPersistence().getMessageBrokerDomainName())) continue;
                            if (replicationDomains.contains(replicationDomain)) {
                                useInMemorySessionPersistence = true;
                                continue;
                            }
                            replicationDomains.add(replicationDomain);
                            continue;
                        }
                        if (!"DATABASE".equals(sessionMgr.getSessionPersistenceMode())) continue;
                        useDBSessionPersistence = true;
                        break;
                    }
                    if (useDBSessionPersistence) {
                        return QosSessionPersistenceType.DATABASE;
                    }
                    if (!useInMemorySessionPersistence) continue;
                    return QosSessionPersistenceType.MEMORY_TO_MEMORY;
                }
                for (Servers.Server server : cluster.getServers()) {
                    SessionManager sessionMgr = server.getSessionManager().get("SessionManager", null);
                    if (sessionMgr == null || sessionMgr.getSessionDRSPersistence() == null || !"DATABASE".equals(sessionMgr.getSessionPersistenceMode())) continue;
                    return QosSessionPersistenceType.DATABASE;
                }
            }
            return QosSessionPersistenceType.NONE;
        }

        public Map<String, QosSessionPersistenceType> getClustersSessionReplicationType() {
            HashMap<String, QosSessionPersistenceType> clustersSessionPersistenceTypes = new HashMap<String, QosSessionPersistenceType>();
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                QosSessionPersistenceType clusterSessionPersistenceType = cluster.getClusterSessionPersistenceType();
                if (null == clusterSessionPersistenceType || clusterSessionPersistenceType.equals((Object)QosSessionPersistenceType.NONE)) continue;
                clustersSessionPersistenceTypes.put(cluster.getClusterName(), clusterSessionPersistenceType);
            }
            return clustersSessionPersistenceTypes;
        }

        protected QosTransactionLogType getTransactionLogTypeForCluster(String clusterName) {
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                if (!cluster.getClusterName().equals(clusterName)) continue;
                boolean useDBTransactionLog = false;
                boolean useFileTransactionLog = false;
                for (Servers.Server server : cluster.getServers()) {
                    TransactionService txSvc = server.getTransactionService().get("TransactionService", null);
                    if (txSvc == null) continue;
                    if (txSvc.getTransactionLogDirectory().startsWith("custom://com.ibm.rls.jdbc.SQLRecoveryLog?")) {
                        useDBTransactionLog = true;
                        break;
                    }
                    if (txSvc.getTransactionLogDirectory().isEmpty()) continue;
                    useFileTransactionLog = true;
                }
                if (useDBTransactionLog) {
                    return QosTransactionLogType.DATABASE;
                }
                if (!useFileTransactionLog) continue;
                return QosTransactionLogType.FILE;
            }
            return QosTransactionLogType.NONE;
        }

        public Map<String, QosTransactionLogType> getClustersTransactionLogType() {
            HashMap<String, QosTransactionLogType> clusterTransactionLogTypes = new HashMap<String, QosTransactionLogType>();
            for (Clusters.Cluster cluster : this._clusterTargets.values()) {
                QosTransactionLogType clusterTransactionLogType = cluster.getClusterTransactionLogType();
                if (null == clusterTransactionLogType || clusterTransactionLogType.equals((Object)QosTransactionLogType.NONE)) continue;
                clusterTransactionLogTypes.put(cluster.getClusterName(), clusterTransactionLogType);
            }
            return clusterTransactionLogTypes;
        }

        public String getOldestJava() {
            return this._minimumJavaRelease;
        }

        public String getOldestWebSphere() {
            return this._minimumWebSphereRelease;
        }

        public String getOldestJpaProvider() {
            return this._minimumJpaProvider;
        }

        public String getOldestJaxrsProvider() {
            return this._minimumJaxrsProvider;
        }

        public String getOldestJsfProvider() {
            return this._minimumJsfProvider;
        }

        public Cell getCell() {
            return Apps.this._cell;
        }

        public Security getSecurity() {
            return Apps.this._cell.getSecurity();
        }

        public Security getResolvedSecurity() {
            if (this._resolvedSecurityCache == null) {
                DomainSecurity activeDomain = null;
                if (!this._clusterTargets.isEmpty()) {
                    Clusters.Cluster[] targets = this._clusterTargets.values().toArray(new Clusters.Cluster[0]);
                    activeDomain = targets[targets.length - 1].getDomainSecurity();
                    if (activeDomain == null) {
                        ReportUtility.logger.get().log(Level.FINEST, "Did not find security domain on cluster " + targets[targets.length - 1].getClusterName() + " for app " + this._appName);
                    } else {
                        ReportUtility.logger.get().log(Level.FINEST, "Using security domain \"" + activeDomain.getName() + "\" from cluster " + targets[targets.length - 1].getClusterName() + " for app " + this._appName);
                    }
                } else if (!this._serverTargets.isEmpty()) {
                    Servers.Server[] targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                    activeDomain = targets[targets.length - 1].getDomainSecurity();
                    if (activeDomain == null) {
                        ReportUtility.logger.get().log(Level.FINEST, "Did not find security domain on server " + targets[targets.length - 1].getServerName() + " for app " + this._appName);
                    } else {
                        ReportUtility.logger.get().log(Level.FINEST, "Using security domain \"" + activeDomain.getName() + "\" from server " + targets[targets.length - 1].getServerName() + " for app " + this._appName);
                    }
                }
                if (activeDomain == null && Apps.this._cell.getDomainSecurity() != null) {
                    activeDomain = Apps.this._cell.getDomainSecurity();
                    ReportUtility.logger.get().log(Level.FINE, "Using cell-level security domain \"" + activeDomain.getName() + "\" for app " + this._appName);
                }
                if (activeDomain == null) {
                    ReportUtility.logger.get().log(Level.FINE, "Using only global security configuration for app " + this._appName);
                    this._resolvedSecurityCache = Apps.this._cell.getSecurity();
                } else {
                    this._resolvedSecurityCache = Apps.this._cell.getSecurity().withDomain(activeDomain);
                }
            } else {
                ReportUtility.logger.get().log(Level.FINEST, "Using resolved security cache for app " + this._appName);
            }
            return this._resolvedSecurityCache;
        }

        public List<SecurityRole> getSecurityRoles() {
            return this._securityRoles;
        }

        public boolean usesSSLConfig() {
            if (!this.getReferencedSSLIds().isEmpty()) {
                return true;
            }
            ActiveSSLConfigGroups activeSSLConfig = this.getDefaultSSLConfig();
            return activeSSLConfig.getInboundGroup() != null || activeSSLConfig.getOutboundGroup() != null || !activeSSLConfig.getActiveDynamicSSLConfigSelections().isEmpty();
        }

        public Set<String> getReferencedSSLIds() {
            UserRegistry activeUserRegistry;
            if (this._appReferencedSSLConfigCache != null) {
                ReportUtility.logger.get().log(Level.FINEST, "Using resolved referenced ssl config cache for app " + this._appName);
                return this._appReferencedSSLConfigCache;
            }
            TreeSet<String> appReferencedSSLIds = new TreeSet<String>();
            Security security = this.getResolvedSecurity();
            Reference<UserRegistry> activeUserRegistrRef = security.getActiveUserRegistry();
            if (activeUserRegistrRef != null && "true".equals(security.getEnabled()) && "true".equals(security.getAppEnabled()) && (activeUserRegistry = (UserRegistry)References.lookup(activeUserRegistrRef.getId())) != null) {
                if (activeUserRegistry instanceof LDAPUserRegistry) {
                    String sslConfig = ((LDAPUserRegistry)activeUserRegistry).getSslConfig();
                    if (!"".equals(sslConfig)) {
                        appReferencedSSLIds.add(sslConfig);
                    }
                } else if (activeUserRegistry instanceof WIMUserRegistry) {
                    WimConfig wimConfig = ((WIMUserRegistry)activeUserRegistry).getWimConfig();
                    List<LdapRepository> ldapRepos = wimConfig.getRepositories();
                    for (LdapRepository ldapRepo : ldapRepos) {
                        LdapServerConfiguration ldapServerConfig = ldapRepo.getLdapServerConfiguration();
                        String sslConfig = ldapServerConfig.getSslConfiguration();
                        if ("".contentEquals(sslConfig)) continue;
                        appReferencedSSLIds.add(sslConfig);
                    }
                }
            }
            this._appReferencedSSLConfigCache = appReferencedSSLIds;
            return appReferencedSSLIds;
        }

        public ActiveSSLConfigGroups getDefaultSSLConfig() {
            Object targets;
            if (this._activeSSLConfigCache != null) {
                ReportUtility.logger.get().log(Level.FINEST, "Using resolved default ssl config cache for app " + this._appName);
                return this._activeSSLConfigCache;
            }
            Security security = Apps.this._cell.getSecurity();
            List<SSLConfigGroup> configGroups = security.getSslConfigGroups();
            String serverName = "";
            String nodeName = "";
            String cellName = Apps.this._cell.getCellManagementScopeName();
            String clusterName = "";
            SSLConfigGroup serverGroupInbound = null;
            SSLConfigGroup nodeGroupInbound = null;
            SSLConfigGroup cellGroupInbound = null;
            SSLConfigGroup clusterGroupInbound = null;
            SSLConfigGroup serverGroupOutbound = null;
            SSLConfigGroup nodeGroupOutbound = null;
            SSLConfigGroup cellGroupOutbound = null;
            SSLConfigGroup clusterGroupOutbound = null;
            if (!this._clusterTargets.isEmpty()) {
                targets = this._clusterTargets.values().toArray(new Clusters.Cluster[0]);
                Clusters.Cluster cluster = targets[((Clusters.Cluster[])targets).length - 1];
                clusterName = cluster.getClusterManagementScopeName();
                Iterable<Servers.Server> targetServers = ((Clusters.Cluster)targets[((Object[])targets).length - 1]).getServers();
                Iterator<Servers.Server> iter = targetServers.iterator();
                while (iter.hasNext()) {
                    Servers.Server current = iter.next();
                    if (iter.hasNext()) continue;
                    serverName = current.getServerManagementScopeName();
                    nodeName = current.getOwningNode().getNodeManagementScopeName();
                    ReportUtility.logger.get().log(Level.FINEST, "Using SSL config from server " + serverName + " in cluster " + clusterName + " for app " + this._appName);
                }
            } else if (!this._serverTargets.isEmpty()) {
                targets = this._serverTargets.values().toArray(new Servers.Server[0]);
                Object server = targets[((Object[])targets).length - 1];
                serverName = ((Servers.Server)server).getServerManagementScopeName();
                nodeName = ((Servers.Server)server).getOwningNode().getNodeManagementScopeName();
                ReportUtility.logger.get().log(Level.FINEST, "Using SSL config from server " + serverName + " for app " + this._appName);
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Did not find any applicable targets for SSL config for app " + this._appName);
            }
            for (SSLConfigGroup group : configGroups) {
                Reference<ManagementScope> managementScopeRef = group.getManagementScope();
                if (managementScopeRef != null) {
                    String direction = group.getDirection();
                    ManagementScope scope = managementScopeRef.getValue();
                    if (scope != null) {
                        String scopeName = scope.getScopeName();
                        if (serverName.equals(scopeName)) {
                            if ("inbound".equalsIgnoreCase(direction)) {
                                serverGroupInbound = group;
                                continue;
                            }
                            if ("outbound".equalsIgnoreCase(direction)) {
                                serverGroupOutbound = group;
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had unknown direction " + direction);
                            continue;
                        }
                        if (nodeName.equals(scopeName)) {
                            if ("inbound".equalsIgnoreCase(direction)) {
                                nodeGroupInbound = group;
                                continue;
                            }
                            if ("outbound".equalsIgnoreCase(direction)) {
                                nodeGroupOutbound = group;
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had unknown direction " + direction);
                            continue;
                        }
                        if (cellName.equals(scopeName)) {
                            if ("inbound".equalsIgnoreCase(direction)) {
                                cellGroupInbound = group;
                                continue;
                            }
                            if ("outbound".equalsIgnoreCase(direction)) {
                                cellGroupOutbound = group;
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had unknown direction " + direction);
                            continue;
                        }
                        if (!clusterName.equals(scopeName)) continue;
                        if ("inbound".equalsIgnoreCase(direction)) {
                            clusterGroupInbound = group;
                            continue;
                        }
                        if ("outbound".equalsIgnoreCase(direction)) {
                            clusterGroupOutbound = group;
                            continue;
                        }
                        ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had unknown direction " + direction);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had unregistered management scope reference.");
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "SSL Group " + group.getName() + " had null management scope reference.");
            }
            SSLConfigGroup activeInboundGroup = null;
            if (serverGroupInbound != null) {
                activeInboundGroup = serverGroupInbound;
            } else if (clusterGroupInbound != null) {
                activeInboundGroup = clusterGroupInbound;
            } else if (nodeGroupInbound != null) {
                activeInboundGroup = nodeGroupInbound;
            } else if (cellGroupInbound != null) {
                activeInboundGroup = cellGroupInbound;
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Did not find any inbound SSL config for app " + this._appName);
            }
            SSLConfigGroup activeOutboundGroup = null;
            if (serverGroupOutbound != null) {
                activeOutboundGroup = serverGroupOutbound;
            } else if (clusterGroupOutbound != null) {
                activeOutboundGroup = clusterGroupOutbound;
            } else if (nodeGroupOutbound != null) {
                activeOutboundGroup = nodeGroupOutbound;
            } else if (cellGroupOutbound != null) {
                activeOutboundGroup = cellGroupOutbound;
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Did not find any outbound SSL config for app " + this._appName);
            }
            HashSet<String> activeManagementScopes = new HashSet<String>();
            activeManagementScopes.add(cellName);
            if (!"".equals(nodeName)) {
                activeManagementScopes.add(nodeName);
            }
            if (!"".equals(serverName)) {
                activeManagementScopes.add(serverName);
            }
            if (!"".equals(clusterName)) {
                activeManagementScopes.add(clusterName);
            }
            List<DynamicSSLConfigSelection> dynamicSSLConfigs = security.getDynamicSslConfigSelections();
            ArrayList<DynamicSSLConfigSelection> activeDynamicSSLConfigSelections = new ArrayList<DynamicSSLConfigSelection>();
            for (DynamicSSLConfigSelection dynamicSSLConfig : dynamicSSLConfigs) {
                Reference<ManagementScope> managementScopeRef = dynamicSSLConfig.getManagementScope();
                if (managementScopeRef != null) {
                    ManagementScope managementScope = managementScopeRef.getValue();
                    if (managementScope != null) {
                        String scopeName = managementScope.getScopeName();
                        if (!activeManagementScopes.contains(scopeName)) continue;
                        activeDynamicSSLConfigSelections.add(dynamicSSLConfig);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "Dynamic SSL Group " + dynamicSSLConfig.getName() + " had unregistered management scope reference.");
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "Dynamic SSL Group " + dynamicSSLConfig.getName() + " had null management scope reference.");
            }
            ActiveSSLConfigGroups activeSSLConfigGroups = new ActiveSSLConfigGroups(activeInboundGroup, activeOutboundGroup, activeDynamicSSLConfigSelections);
            ReportUtility.logger.get().log(Level.FINE, "Active SSL Config Groups for app " + this._appName + ":" + System.getProperty("line.separator") + activeSSLConfigGroups);
            this._activeSSLConfigCache = activeSSLConfigGroups;
            return activeSSLConfigGroups;
        }

        private <T extends ScopedObject> T getNonDefaultObject(List<ScopedMap<T>> listOfObjects, Class<T> objectClass) {
            T nonDefaultObject;
            block5: {
                block4: {
                    nonDefaultObject = null;
                    if (!objectClass.equals(SessionManager.class)) break block4;
                    for (ScopedMap<T> entry : listOfObjects) {
                        T sessionMgr = entry.getIgnoreScopeConflicts("SessionManager");
                        if (sessionMgr == null) continue;
                        if (nonDefaultObject == null && !CommonUtilities.isSessionManagerDefault((SessionManager)sessionMgr)) {
                            nonDefaultObject = sessionMgr;
                            continue;
                        }
                        this._sessionManager.put("SessionManager", (SessionManager)sessionMgr);
                    }
                    break block5;
                }
                if (!objectClass.equals(TransactionService.class)) break block5;
                for (ScopedMap<T> entry : listOfObjects) {
                    T txSvc = entry.getIgnoreScopeConflicts("TransactionService");
                    if (txSvc == null) continue;
                    if (nonDefaultObject == null && !CommonUtilities.isTransactionServiceDefault((TransactionService)txSvc)) {
                        nonDefaultObject = txSvc;
                        continue;
                    }
                    this._transactionService.put("TransactionService", (TransactionService)txSvc);
                }
            }
            return nonDefaultObject;
        }
    }
}

