/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.resource.SIBus;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.Nodes;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import java.io.File;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Cell {
    protected final File _cellDir;
    protected final String _cellType;
    protected final String _cellName;
    private final ScopedMap<Variable> _variables = new ScopedMap();
    private final ScopedMap<Library> _libraries = new ScopedMap();
    private final SortedMap<String, SIBus> _buses = new TreeMap<String, SIBus>();
    private final ScopedMap<JNDIBinding> _jndiBindings = new ScopedMap();
    private final Resources _resources = new Resources();
    protected Security _security;
    private DomainSecurity _domainSecurity;
    private Document _resourcesXml;
    private Document _variablesXml;
    private Document _librariesXml;
    private Document _securityXml;
    private Document _wimconfigXml;
    private Document _nameBindingsXml;
    private File _busesDir;
    private Nodes _nodes;
    private Clusters _clusters;
    private String _cellAdminHost = "";
    private int _cellAdminPort = 0;
    private String _cellAdminWASVersion = "";
    private String _cellAdminWASEdition = "";
    private boolean _isCellZos = false;

    Cell(File configDir) throws Exception {
        File bindingsFile;
        File busesDir;
        File wimFile;
        File secFile;
        File resFile;
        File libFile;
        this._cellDir = FileUtilities.getFirstDirectoryNotDSStore(new File(configDir, "cells").listFiles());
        Document cellXml = FileUtilities.getDocument(new File(this._cellDir, "cell.xml"));
        Element cellElem = (Element)cellXml.getElementsByTagName("topology.cell:Cell").item(0);
        this._cellType = cellElem.getAttribute("cellType").toLowerCase();
        if (!this._cellType.matches("^(distributed|standalone)$")) {
            throw new Exception("Incorrect cell type specified in cell.xml file: " + this._cellType);
        }
        this._cellName = cellElem.getAttribute("name");
        File varFile = new File(this._cellDir, "variables.xml");
        if (varFile.exists()) {
            this._variablesXml = FileUtilities.getDocument(varFile);
        }
        if ((libFile = new File(this._cellDir, "libraries.xml")).exists()) {
            this._librariesXml = FileUtilities.getDocument(libFile);
        }
        if ((resFile = new File(this._cellDir, "resources.xml")).exists()) {
            this._resourcesXml = FileUtilities.getDocument(resFile);
        }
        if ((secFile = new File(this._cellDir, "security.xml")).exists()) {
            this._securityXml = FileUtilities.getDocument(secFile);
        }
        if ((wimFile = new File(this._cellDir, "wim/config/wimconfig.xml")).exists()) {
            this._wimconfigXml = FileUtilities.getDocument(wimFile);
        }
        if ((busesDir = new File(this._cellDir, "buses")).exists()) {
            this._busesDir = busesDir;
        }
        if ((bindingsFile = new File(this._cellDir, "namebindings.xml")).exists()) {
            this._nameBindingsXml = FileUtilities.getDocument(bindingsFile);
        }
    }

    protected Cell(File cellDir, String cellType, String cellName) {
        this._cellDir = cellDir;
        this._cellType = cellType;
        this._cellName = cellName;
    }

    void loadScopedData() {
        Scope scope = new Scope(Scope.Level.CELL, this._cellName, this._cellDir);
        if (this._variablesXml != null) {
            TwasXmlUtilities.loadVariables(this._variables, this._variablesXml, scope);
        }
        if (this._librariesXml != null) {
            TwasXmlUtilities.loadLibraries(this._libraries, this._librariesXml, scope);
        }
        if (this._securityXml != null) {
            this._security = TwasXmlUtilities.loadSecurity(this._securityXml, this._wimconfigXml, this._cellName);
        }
        if (this._resourcesXml != null) {
            TwasXmlUtilities.loadResources(this._resources, this._resourcesXml, scope);
        }
        if (this._busesDir != null) {
            TwasXmlUtilities.loadBuses(this._buses, this._busesDir);
        }
        if (this._nameBindingsXml != null) {
            for (JNDIBinding binding : TwasXmlUtilities.loadJNDIBinding(this._nameBindingsXml, scope, "cell/persistent/")) {
                this._jndiBindings.put(binding.getJndiName(), binding);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append("Cell Directory  : " + this._cellDir.getPath());
        sb.append(nl + "Cell Type                : " + this._cellType);
        sb.append(nl + "Cell Name                : " + this._cellName);
        sb.append(nl + "Cell Admin Host          : " + this._cellAdminHost);
        sb.append(nl + "Cell Admin Port          : " + this._cellAdminPort);
        sb.append(nl + "Cell Admin Version       : " + this._cellAdminWASVersion);
        sb.append(nl + "Cell Admin Edition       : " + this._cellAdminWASEdition);
        sb.append(nl + "Cell is z/OS-based       : " + this._isCellZos);
        sb.append(nl + "Libraries                : " + this._libraries.keySet());
        sb.append(nl + "DataSources              : " + this._resources.getDataSources().keySet());
        sb.append(nl + "J2C Admin Objects        : " + this._resources.getJ2CAdminObjects().keySet());
        sb.append(nl + "J2C Connection Factories : " + this._resources.getJ2CConnectionFactories().keySet());
        sb.append(nl + "J2C Activation Specs     : " + this._resources.getJ2CActivationSpecs().keySet());
        sb.append(nl + "MQ Queue CFs             : " + this._resources.getMqQueueConnectionFactories().keySet());
        sb.append(nl + "MQ Topic CFs             : " + this._resources.getMqTopicConnectionFactories().keySet());
        sb.append(nl + "MQ CFs                   : " + this._resources.getMqConnectionFactories().keySet());
        sb.append(nl + "MQ Queues                : " + this._resources.getMqQueues().keySet());
        sb.append(nl + "MQ Topics                : " + this._resources.getMqTopics().keySet());
        sb.append(nl + "Variables                : " + this._variables.valuesIgnoreScopeConflicts());
        sb.append(nl + "Buses                    : " + this._buses.keySet());
        sb.append(nl + "JNDI Bindings            : " + this._jndiBindings.keySet());
        sb.append(nl + "Security                 : " + this._security);
        sb.append(nl + "Domain Security          : " + this._domainSecurity);
        return sb.toString();
    }

    public void setCellAdminInfo(Nodes nodes) {
        String adminServerType;
        this._nodes = nodes;
        String string = this._cellType.equals("distributed") ? "DEPLOYMENT_MANAGER" : (adminServerType = this._cellType.equals("standalone") ? "APPLICATION_SERVER" : "");
        if (!adminServerType.isEmpty()) {
            for (Nodes.Node node : nodes.getNodes()) {
                if (!node.getNodeType().equals(adminServerType)) continue;
                this._cellAdminHost = node.getHostName();
                this._cellAdminPort = node.getAdminHostPort();
                this._cellAdminWASEdition = node.getProductShortName();
                this._cellAdminWASVersion = node.getProductVersion();
                String dmgrNodeOperatingSystem = node.getNodeOperatingSystem();
                this._isCellZos = dmgrNodeOperatingSystem != null ? dmgrNodeOperatingSystem.equals("os390") : false;
            }
        }
    }

    public String getCellAdminHost() {
        return this._cellAdminHost;
    }

    public int getCellAdminPort() {
        return this._cellAdminPort;
    }

    public String getCellAdminWASEdition() {
        return this._cellAdminWASEdition;
    }

    public String getCellAdminWASVersion() {
        return this._cellAdminWASVersion;
    }

    public boolean isCellZos() {
        return this._isCellZos;
    }

    public File getCellPath() {
        return this._cellDir;
    }

    public Nodes getNodes() {
        return this._nodes;
    }

    public void setClusters(Clusters clusters) {
        this._clusters = clusters;
    }

    public Clusters getClusters() {
        return this._clusters;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellManagementScopeName() {
        return "(cell):" + this._cellName;
    }

    public ScopedMap<Variable> getVariables() {
        return this._variables;
    }

    public ScopedMap<Library> getLibraries() {
        return this._libraries;
    }

    public Resources getResources() {
        return this._resources;
    }

    public SortedMap<String, SIBus> getSIBuses() {
        return this._buses;
    }

    public ScopedMap<JNDIBinding> getJNDIBindings() {
        return this._jndiBindings;
    }

    public Security getSecurity() {
        return this._security;
    }

    public DomainSecurity getDomainSecurity() {
        return this._domainSecurity;
    }

    public void setDomainSecurity(DomainSecurity ds) {
        this._domainSecurity = ds;
    }
}

