/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.JeeProviders;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Cell;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Clusters {
    private final SortedMap<String, Cluster> _clusters = new TreeMap<String, Cluster>();
    private Cell _cell;
    private static final String nl = System.getProperty("line.separator");

    public Clusters(Cell cell, Servers servers) {
        this._cell = cell;
        File clustersDir = new File(this._cell.getCellPath(), "clusters");
        File dynamicClustersDir = new File(this._cell.getCellPath(), "dynamicclusters");
        File[] clusterList = clustersDir.listFiles();
        if (clusterList == null) {
            return;
        }
        for (File clusterDir : clusterList) {
            if (clusterDir.getPath().endsWith(".DS_Store")) continue;
            File dynamicClusterDir = new File(dynamicClustersDir, clusterDir.getName());
            try {
                Cluster cluster = null;
                cluster = dynamicClusterDir.exists() ? new Cluster(clusterDir, dynamicClusterDir, servers) : new Cluster(clusterDir, servers);
                this._clusters.put(cluster.getClusterName(), cluster);
            }
            catch (Exception e) {
                ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Clusters_Unable_To_Read_Cluster"), clusterDir.getPath(), e));
            }
        }
    }

    protected Clusters() {
    }

    void loadScopedData() {
        for (Cluster cluster : this._clusters.values()) {
            cluster.loadScopedData();
        }
    }

    public String toString() {
        if (this._clusters.isEmpty()) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Cluster sd : this._clusters.values()) {
            if (!first) {
                sb.append(nl);
            }
            sb.append(sd.toString());
            first = false;
        }
        return sb.toString();
    }

    public int getClusterCount() {
        return this._clusters.size();
    }

    public Iterable<Cluster> getClusters() {
        return this._clusters.values();
    }

    public Cluster getCluster(String clusterName) {
        return (Cluster)this._clusters.get(clusterName);
    }

    public class DynamicCluster {
        private final File _dynamicClusterDir;
        private final String _dynamicClusterName;
        private final String _dynamicClusterXmiId;
        private final String _minInstances;
        private final String _maxInstances;
        private final String _numVerticalInstances;
        private final String _operationalMode;
        private final String _minNodes;
        private final String _maxNodes;
        private final String _isolationGroup;
        private final String _membershipPolicy;
        private final String _serverType;
        private final String _strictIsolationEnabled;

        public DynamicCluster(File dynamicClusterDir) throws Exception {
            this._dynamicClusterDir = dynamicClusterDir;
            Document clusterXml = FileUtilities.getDocument(new File(dynamicClusterDir, "dynamiccluster.xml"));
            Element clusterElem = (Element)clusterXml.getElementsByTagName("dynamiccluster:DynamicCluster").item(0);
            this._dynamicClusterName = clusterElem.getAttribute("name");
            this._dynamicClusterXmiId = clusterElem.getAttribute("xmi:id");
            this._minInstances = clusterElem.getAttribute("minInstances");
            this._maxInstances = clusterElem.getAttribute("maxInstances");
            this._numVerticalInstances = clusterElem.getAttribute("numVerticalInstances");
            this._operationalMode = clusterElem.getAttribute("operationalMode");
            this._minNodes = clusterElem.getAttribute("minNodes");
            this._maxNodes = clusterElem.getAttribute("maxNodes");
            this._isolationGroup = clusterElem.getAttribute("isolationGroup");
            this._membershipPolicy = clusterElem.getAttribute("membershipPolicy");
            this._serverType = clusterElem.getAttribute("serverType");
            this._strictIsolationEnabled = clusterElem.getAttribute("strictIsolationEnabled");
        }

        protected DynamicCluster(File dynamicClusterDir, String dynamicClusterName, String dynamicClusterXmiId, String minInstances, String maxInstances, String numVerticalInstances, String operationalMode, String minNodes, String maxNodes, String isolationGroup, String membershipPolicy, String serverType, String strictIsolationEnabled) {
            this._dynamicClusterDir = dynamicClusterDir;
            this._dynamicClusterName = dynamicClusterName;
            this._dynamicClusterXmiId = dynamicClusterXmiId;
            this._minInstances = minInstances;
            this._maxInstances = maxInstances;
            this._numVerticalInstances = numVerticalInstances;
            this._operationalMode = operationalMode;
            this._minNodes = minNodes;
            this._maxNodes = maxNodes;
            this._isolationGroup = isolationGroup;
            this._membershipPolicy = membershipPolicy;
            this._serverType = serverType;
            this._strictIsolationEnabled = strictIsolationEnabled;
        }

        public File getDynamicClusterDir() {
            return this._dynamicClusterDir;
        }

        public String getDynamicClusterName() {
            return this._dynamicClusterName;
        }

        public String getDynamicClusterXmiId() {
            return this._dynamicClusterXmiId;
        }

        public String getMinInstances() {
            return this._minInstances;
        }

        public String getMaxInstances() {
            return this._maxInstances;
        }

        public String getNumVerticalInstances() {
            return this._numVerticalInstances;
        }

        public String getOperationalMode() {
            return this._operationalMode;
        }

        public String getMinNodes() {
            return this._minNodes;
        }

        public String getMaxNodes() {
            return this._maxNodes;
        }

        public String getIsolationGroup() {
            return this._isolationGroup;
        }

        public String getMembershipPolicy() {
            return this._membershipPolicy;
        }

        public String getServerType() {
            return this._serverType;
        }

        public String getStrictIsolationEnabled() {
            return this._strictIsolationEnabled;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._dynamicClusterName);
            sb.append(nl + this._dynamicClusterXmiId);
            sb.append(nl + "- Directory  : " + this._dynamicClusterDir);
            sb.append(nl + "- Minimum instances             : " + this._minInstances);
            sb.append(nl + "- Maximum instances             : " + this._maxInstances);
            sb.append(nl + "- Vertical instances per node   : " + this._numVerticalInstances);
            sb.append(nl + "- Operational mode              : " + this._operationalMode);
            sb.append(nl + "- Minimum nodes                 : " + this._minNodes);
            sb.append(nl + "- Maximum nodes                 : " + this._maxNodes);
            sb.append(nl + "- Isolation group               : " + this._isolationGroup);
            sb.append(nl + "- Membership policy             : " + this._membershipPolicy);
            sb.append(nl + "- Server type                   : " + this._serverType);
            sb.append(nl + "- Strict isolation enabled      : " + this._strictIsolationEnabled);
            sb.append(nl);
            return sb.toString();
        }
    }

    public class Cluster {
        protected final File _clusterDir;
        protected final String _clusterName;
        protected final String _clusterXmiId;
        protected final ScopedMap<Variable> _variables = new ScopedMap();
        protected final ScopedMap<Library> _libraries = new ScopedMap();
        protected final ScopedMap<JNDIBinding> _jndiBindings = new ScopedMap();
        protected final SortedMap<String, Servers.Server> _servers = new TreeMap<String, Servers.Server>();
        protected final JeeProviders _jeeProviders = new JeeProviders();
        protected final SortedMap<String, Apps.App> _apps = new TreeMap<String, Apps.App>();
        protected final Resources _resources = new Resources();
        protected DomainSecurity _domainSecurity;
        protected final DynamicCluster _dynamicCluster;
        private Document _resourcesXml;
        private Document _variablesXml;
        private Document _librariesXml;
        private Document _nameBindingsXml;
        private QosSessionPersistenceType _sessionPersistenceType = null;
        private QosTransactionLogType _transactionLogType = null;

        protected Cluster(File clusterDir, Servers servers) throws Exception {
            this(clusterDir, null, servers);
        }

        private Cluster(File clusterDir, File dynamicClusterDir, Servers servers) throws Exception {
            File bindingsFile;
            File resFile;
            File libFile;
            File varFile;
            this._clusterDir = clusterDir;
            Document clusterXml = FileUtilities.getDocument(new File(clusterDir, "cluster.xml"));
            Element clusterElem = (Element)clusterXml.getElementsByTagName("topology.cluster:ServerCluster").item(0);
            this._clusterName = clusterElem.getAttribute("name");
            this._clusterXmiId = clusterElem.getAttribute("xmi:id");
            this._jeeProviders.setJpaProvider(clusterElem.getAttribute("jpaProvider"));
            this._jeeProviders.setJaxRSProvider(clusterElem.getAttribute("jaxrsProvider"));
            this._jeeProviders.setJsfProvider(clusterElem.getAttribute("jsfProvider"));
            NodeList serverList = clusterElem.getChildNodes();
            ArrayList<String> serversNotFound = new ArrayList<String>();
            for (int i = 0; i < serverList.getLength(); ++i) {
                Node node = serverList.item(i);
                if (!(node instanceof Element)) continue;
                Element server = (Element)node;
                String serverName = server.getAttribute("memberName");
                String nodeName = server.getAttribute("nodeName");
                String fullServerName = nodeName + "/" + serverName;
                Servers.Server sd = servers.getServer(fullServerName);
                if (sd == null) {
                    serversNotFound.add(serverName);
                    continue;
                }
                if (sd.hasOwningCluster()) {
                    ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Clusters_Server_In_Multiple_Clusters"), fullServerName, sd.getOwningCluster().getClusterName(), this._clusterName));
                    continue;
                }
                sd.setOwningCluster(this);
                this._servers.put(sd.getServerName(), sd);
            }
            if (serversNotFound.size() != 0) {
                if (servers.getServerCount() > 0 && servers.getServers().iterator().next().getOwningNode().isFederatedNode()) {
                    for (String serverName : serversNotFound) {
                        ReportUtility.logger.get().log(Level.FINEST, "Server " + serverName + " in cluster " + this._clusterName + " does not exist while running from a federated node. The server will not be processed.");
                    }
                } else {
                    for (String serverName : serversNotFound) {
                        ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Clusters_Server_Doesnt_Exist"), serverName, this._clusterName));
                    }
                }
            }
            if ((varFile = new File(this._clusterDir, "variables.xml")).exists()) {
                this._variablesXml = FileUtilities.getDocument(varFile);
            }
            if ((libFile = new File(this._clusterDir, "libraries.xml")).exists()) {
                this._librariesXml = FileUtilities.getDocument(libFile);
            }
            if ((resFile = new File(this._clusterDir, "resources.xml")).exists()) {
                this._resourcesXml = FileUtilities.getDocument(resFile);
            }
            if ((bindingsFile = new File(this._clusterDir, "namebindings.xml")).exists()) {
                this._nameBindingsXml = FileUtilities.getDocument(bindingsFile);
            }
            this._dynamicCluster = dynamicClusterDir != null ? new DynamicCluster(dynamicClusterDir) : null;
        }

        protected Cluster(File clusterDir, String clusterName, String clusterXmiId, DynamicCluster dynamicCluster) {
            this._clusterDir = clusterDir;
            this._clusterName = clusterName;
            this._clusterXmiId = clusterXmiId;
            this._dynamicCluster = dynamicCluster;
        }

        private void loadScopedData() {
            Scope scope = new Scope(Scope.Level.CLUSTER, this._clusterName, this._clusterDir);
            if (this._variablesXml != null) {
                TwasXmlUtilities.loadVariables(this._variables, this._variablesXml, scope);
            }
            if (this._librariesXml != null) {
                TwasXmlUtilities.loadLibraries(this._libraries, this._librariesXml, scope);
            }
            if (this._resourcesXml != null) {
                TwasXmlUtilities.loadResources(this._resources, this._resourcesXml, scope);
            }
            if (this._nameBindingsXml != null) {
                for (JNDIBinding binding : TwasXmlUtilities.loadJNDIBinding(this._nameBindingsXml, scope, "cell/clusters/" + this._clusterName + "/")) {
                    this._jndiBindings.put(binding.getJndiName(), binding);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._clusterName);
            sb.append(nl + this._clusterXmiId);
            sb.append(nl + "- Directory  : " + this._clusterDir);
            for (Servers.Server sd : this._servers.values()) {
                sb.append(nl + "- Server      : " + sd.getServerName());
            }
            sb.append(nl + "- JPA Provider             : " + this._jeeProviders.getJpaProvider());
            sb.append(nl + "- JAX-RS Provider          : " + this._jeeProviders.getJaxRSProvider());
            sb.append(nl + "- JSF Provider             : " + this._jeeProviders.getJsfProvider());
            sb.append(nl + "- Libraries                : " + this._libraries.keySet());
            sb.append(nl + "- Apps                     : " + this._apps.keySet());
            sb.append(nl + "- DataSources              : " + this._resources.getDataSources().keySet());
            sb.append(nl + "- J2C Admin Objects        : " + this._resources.getJ2CAdminObjects().keySet());
            sb.append(nl + "- J2C Connection Factories : " + this._resources.getJ2CConnectionFactories().keySet());
            sb.append(nl + "- J2C Activation Specs     : " + this._resources.getJ2CActivationSpecs().keySet());
            sb.append(nl + "- MQ Queue CFs             : " + this._resources.getMqQueueConnectionFactories().keySet());
            sb.append(nl + "- MQ Topic CFs             : " + this._resources.getMqTopicConnectionFactories().keySet());
            sb.append(nl + "- MQ CFs                   : " + this._resources.getMqConnectionFactories().keySet());
            sb.append(nl + "- MQ Queues                : " + this._resources.getMqQueues().keySet());
            sb.append(nl + "- MQ Topics                : " + this._resources.getMqTopics().keySet());
            sb.append(nl + "- Variables                : " + this._variables.valuesIgnoreScopeConflicts());
            sb.append(nl + "- JNDI Bindings            : " + this._jndiBindings.keySet());
            sb.append(nl + "- Domain Security          : " + this._domainSecurity);
            sb.append(nl + "- Dynamic cluster: " + this._dynamicCluster);
            sb.append(nl);
            return sb.toString();
        }

        public File getClusterPath() {
            return this._clusterDir;
        }

        public String getClusterName() {
            return this._clusterName;
        }

        public String getClusterXmiId() {
            return this._clusterXmiId;
        }

        public String getClusterManagementScopeName() {
            return Clusters.this._cell.getCellManagementScopeName() + ":(cluster):" + this._clusterName;
        }

        public int getServerCount() {
            return this._servers.size();
        }

        public Iterable<Servers.Server> getServers() {
            return this._servers.values();
        }

        public Servers.Server getServer(String serverName) {
            return (Servers.Server)this._servers.get(serverName);
        }

        public ScopedMap<Variable> getVariables() {
            return this._variables;
        }

        public ScopedMap<Library> getLibraries() {
            return this._libraries;
        }

        public ScopedMap<JNDIBinding> getJNDIBindings() {
            return this._jndiBindings;
        }

        public JeeProviders getJeeProviders() {
            return this._jeeProviders;
        }

        public int getAppCount() {
            return this._apps.size();
        }

        public Apps.App getApp(String name2) {
            return (Apps.App)this._apps.get(name2);
        }

        public Iterable<Apps.App> getApps() {
            return this._apps.values();
        }

        protected void addApp(Apps.App app) {
            this._apps.put(app.getAppName(), app);
        }

        public Resources getResources() {
            return this._resources;
        }

        public DomainSecurity getDomainSecurity() {
            return this._domainSecurity;
        }

        public void setDomainSecurity(DomainSecurity ds) {
            this._domainSecurity = ds;
        }

        public DynamicCluster getDynamicCluster() {
            return this._dynamicCluster;
        }

        public QosSessionPersistenceType getClusterSessionPersistenceType() {
            if (null != this._sessionPersistenceType) {
                return this._sessionPersistenceType;
            }
            boolean foundInMemorySessionPersistence = false;
            for (Apps.App app : this._apps.values()) {
                QosSessionPersistenceType appSessionPersistenceType = app.getSessionReplicationTypeForCluster(this._clusterName);
                if (appSessionPersistenceType.equals((Object)QosSessionPersistenceType.DATABASE)) {
                    this._sessionPersistenceType = QosSessionPersistenceType.DATABASE;
                    return this._sessionPersistenceType;
                }
                if (!appSessionPersistenceType.equals((Object)QosSessionPersistenceType.MEMORY_TO_MEMORY)) continue;
                foundInMemorySessionPersistence = true;
            }
            this._sessionPersistenceType = foundInMemorySessionPersistence ? QosSessionPersistenceType.MEMORY_TO_MEMORY : QosSessionPersistenceType.NONE;
            return this._sessionPersistenceType;
        }

        public QosTransactionLogType getClusterTransactionLogType() {
            if (null != this._transactionLogType) {
                return this._transactionLogType;
            }
            boolean foundFileTransactionLog = false;
            for (Apps.App app : this._apps.values()) {
                QosTransactionLogType appTransactionLogType = app.getTransactionLogTypeForCluster(this._clusterName);
                if (appTransactionLogType.equals((Object)QosTransactionLogType.DATABASE)) {
                    this._transactionLogType = QosTransactionLogType.DATABASE;
                    return this._transactionLogType;
                }
                if (!appTransactionLogType.equals((Object)QosTransactionLogType.FILE)) continue;
                foundFileTransactionLog = true;
            }
            this._transactionLogType = foundFileTransactionLog ? QosTransactionLogType.FILE : QosTransactionLogType.NONE;
            return this._transactionLogType;
        }

        public int getMaxReplicasValueForCluster() {
            if (this._dynamicCluster != null) {
                try {
                    int specifiedMax = Integer.valueOf(this._dynamicCluster.getMaxInstances());
                    if (specifiedMax == -1) {
                        ReportUtility.logger.get().log(Level.FINE, "Cluster maximum instances is -1, so cluster size is maximum.");
                        return this.getServerCount();
                    }
                    if (this.getServerCount() < specifiedMax) {
                        ReportUtility.logger.get().log(Level.FINE, "Cluster maximum instances is " + specifiedMax + " but cluster only has " + this.getServerCount() + " members, so using cluster size as maximum instance count.");
                        return this.getServerCount();
                    }
                    return specifiedMax;
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.FINE, "Could not convert value for maximum replicas to integer: " + this._dynamicCluster.getMaxInstances());
                }
            }
            return -1;
        }

        public int getMinReplicasValueForCluster() {
            if (this._dynamicCluster != null) {
                try {
                    int specifiedMin = Integer.valueOf(this._dynamicCluster.getMinInstances());
                    if (this.getServerCount() < specifiedMin) {
                        ReportUtility.logger.get().log(Level.FINE, "Cluster minimum instances is " + specifiedMin + " but cluster only has " + this.getServerCount() + " members, so using cluster size as minimum instance count.");
                        return this.getServerCount();
                    }
                    return specifiedMin;
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.FINE, "Could not convert value for minimum replicas to integer: " + this._dynamicCluster.getMinInstances());
                }
            }
            return -1;
        }
    }
}

