/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.twas.Cell;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Nodes {
    private final SortedMap<String, Node> _nodes;
    private final File _nodesDir;
    private final Cell _cell;
    private static final String nl = System.getProperty("line.separator");

    /*
     * WARNING - void declaration
     */
    Nodes(Cell cell) {
        block15: {
            void var6_10;
            this._nodes = new TreeMap<String, Node>();
            this._cell = cell;
            File cellDir = cell.getCellPath();
            this._nodesDir = new File(cellDir, "nodes");
            HashMap<File, Exception> nodeErrors = new HashMap<File, Exception>();
            File[] fileArray = this._nodesDir.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                File nodeDir = fileArray[var6_10];
                if (!nodeDir.getPath().endsWith(".DS_Store")) {
                    try {
                        Node nd = new Node(nodeDir);
                        this._nodes.put(nd.getNodeName(), nd);
                    }
                    catch (Exception e) {
                        nodeErrors.put(nodeDir, e);
                    }
                }
                ++var6_10;
            }
            if (nodeErrors.size() == 0) break block15;
            boolean runningFromDmgr = false;
            if (this._nodes.size() > 0) {
                for (Node node : this._nodes.values()) {
                    if (!node.getNodeType().equals("DEPLOYMENT_MANAGER")) continue;
                    runningFromDmgr = true;
                    break;
                }
                if (runningFromDmgr) {
                    for (Map.Entry entry : nodeErrors.entrySet()) {
                        ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Nodes_Unable_To_Read_Node"), ((File)entry.getKey()).getPath(), entry.getValue()));
                    }
                } else if (this._nodes.size() == 1) {
                    for (Map.Entry entry : nodeErrors.entrySet()) {
                        ReportUtility.logger.get().log(Level.FINEST, "Expected error processing federated node at " + ((File)entry.getKey()).getPath() + ". This node will not be processed. Error: " + entry.getValue());
                    }
                    this._nodes.values().iterator().next().setFederatedNode(true);
                    ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Running_Against_Fed_Node_Warning"), this._cell.getCellPath()));
                } else {
                    for (Map.Entry entry : nodeErrors.entrySet()) {
                        ReportUtility.logger.get().log(Level.FINE, "Found no deployment manager but found complete data for " + this._nodes.size() + ". Logging messages for the errors found during node initialization");
                        ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Nodes_Unable_To_Read_Node"), ((File)entry.getKey()).getPath(), entry.getValue()));
                    }
                }
            } else {
                for (Map.Entry entry : nodeErrors.entrySet()) {
                    ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Nodes_Unable_To_Read_Node"), ((File)entry.getKey()).getPath(), entry.getValue()));
                }
            }
        }
    }

    protected Nodes(File nodesDir, Cell cell) {
        this._nodes = new TreeMap<String, Node>();
        this._nodesDir = nodesDir;
        this._cell = cell;
    }

    public int getNodeCount() {
        return this._nodes.size();
    }

    public Iterable<Node> getNodes() {
        return this._nodes.values();
    }

    public Node getNode(String nodeName) {
        return (Node)this._nodes.get(nodeName);
    }

    void loadScopedData() {
        for (Node node : this._nodes.values()) {
            node.loadScopedData();
        }
    }

    public String toString() {
        if (this._nodes.isEmpty()) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Node nd : this._nodes.values()) {
            if (!first) {
                sb.append(nl);
            }
            sb.append(nd.toString());
            first = false;
        }
        return sb.toString();
    }

    public class Node {
        protected final File _nodeDir;
        protected final String _nodeName;
        protected String _nodeType;
        protected final String _hostName;
        protected final ScopedMap<Variable> _variables = new ScopedMap();
        protected final ScopedMap<Library> _libraries = new ScopedMap();
        protected final ScopedMap<JNDIBinding> _jndiBindings = new ScopedMap();
        protected final SortedMap<String, Servers.Server> _servers = new TreeMap<String, Servers.Server>();
        protected final Resources _resources = new Resources();
        protected boolean _federatedNode = false;
        protected String _javaArchitecture;
        protected String _javaVersion;
        protected String _javaPlatform;
        protected final String _nodeOperatingSystem;
        protected final String _productName;
        protected final String _productVersion;
        private Document _resourcesXml;
        private Document _variablesXml;
        private Document _librariesXml;
        private Document _nameBindingsXml;

        private Node(File nodeDir) throws Exception {
            File bindingsFile;
            File resFile;
            File libFile;
            File varFile;
            this._nodeDir = nodeDir;
            Document nodeXml = FileUtilities.getDocument(new File(nodeDir, "node.xml"));
            Document serverIndexXml = FileUtilities.getDocument(new File(nodeDir, "serverindex.xml"));
            Element nodeElem = (Element)nodeXml.getElementsByTagName("topology.node:Node").item(0);
            Element serverIndexElem = (Element)serverIndexXml.getElementsByTagName("serverindex:ServerIndex").item(0);
            this._nodeName = nodeElem.getAttribute("name");
            this._hostName = serverIndexElem.getAttribute("hostName");
            this.findNodeType(serverIndexElem.getElementsByTagName("serverEntries"));
            Properties metaProps = new Properties();
            metaProps.load(new FileInputStream(new File(nodeDir, "node-metadata.properties")));
            this._productName = metaProps.getProperty("com.ibm.websphere.baseProductShortName");
            this._productVersion = metaProps.getProperty("com.ibm.websphere.baseProductVersion");
            this._nodeOperatingSystem = metaProps.getProperty("com.ibm.websphere.nodeOperatingSystem");
            for (Object k : metaProps.keySet()) {
                String key = (String)k;
                if (key.startsWith("com.ibm.websphere.sdk.architecture") && (!key.endsWith("bundled") || this._javaArchitecture == null)) {
                    this._javaArchitecture = metaProps.getProperty(key);
                    continue;
                }
                if (key.startsWith("com.ibm.websphere.sdk.version") && (!key.endsWith("bundled") || this._javaVersion == null)) {
                    this._javaVersion = metaProps.getProperty(key);
                    continue;
                }
                if (!key.startsWith("com.ibm.websphere.sdk.platform") || key.endsWith("bundled") && this._javaPlatform != null) continue;
                this._javaPlatform = metaProps.getProperty(key);
            }
            if (this._javaVersion == null && this._productVersion != null) {
                String string = this._productVersion.startsWith("6.0") ? "1.4" : (this._productVersion.startsWith("6.1") ? "1.5" : (this._productVersion.matches("8\\.5\\.5\\.(1[4-7]|[2-9][0-9])") ? "1.7" : (this._javaVersion = this._productVersion.startsWith("9.0") ? "1.8" : "1.6")));
            }
            if ((varFile = new File(this._nodeDir, "variables.xml")).exists()) {
                this._variablesXml = FileUtilities.getDocument(varFile);
            }
            if ((libFile = new File(this._nodeDir, "libraries.xml")).exists()) {
                this._librariesXml = FileUtilities.getDocument(libFile);
            }
            if ((resFile = new File(this._nodeDir, "resources.xml")).exists()) {
                this._resourcesXml = FileUtilities.getDocument(resFile);
            }
            if ((bindingsFile = new File(this._nodeDir, "namebindings.xml")).exists()) {
                this._nameBindingsXml = FileUtilities.getDocument(bindingsFile);
            }
        }

        protected Node(File nodeDir, String nodeName, String hostName, String nodeOperatingSystem, String productName, String productVersion) {
            this._nodeDir = nodeDir;
            this._nodeName = nodeName;
            this._hostName = hostName;
            this._nodeOperatingSystem = nodeOperatingSystem;
            this._productName = productName;
            this._productVersion = productVersion;
        }

        private void loadScopedData() {
            Scope scope = new Scope(Scope.Level.NODE, this._nodeName, this._nodeDir);
            this._variables.putAll(Nodes.this._cell.getVariables());
            if (this._variablesXml != null) {
                TwasXmlUtilities.loadVariables(this._variables, this._variablesXml, scope);
            }
            this._libraries.putAll(Nodes.this._cell.getLibraries());
            if (this._librariesXml != null) {
                TwasXmlUtilities.loadLibraries(this._libraries, this._librariesXml, scope);
            }
            this._resources.putAll(Nodes.this._cell.getResources());
            if (this._resourcesXml != null) {
                TwasXmlUtilities.loadResources(this._resources, this._resourcesXml, scope);
            }
            this._jndiBindings.putAll(Nodes.this._cell.getJNDIBindings());
            if (this._nameBindingsXml != null) {
                for (JNDIBinding binding : TwasXmlUtilities.loadJNDIBinding(this._nameBindingsXml, scope, "cell/nodes/" + this._nodeName + "/persistent/")) {
                    this._jndiBindings.put(binding.getJndiName(), binding);
                }
            }
        }

        private void findNodeType(NodeList serverEntries) {
            if (serverEntries == null || serverEntries.getLength() == 0) {
                this._nodeType = "UNMANAGED";
            } else {
                for (int i = 0; i < serverEntries.getLength(); ++i) {
                    Element se = (Element)serverEntries.item(i);
                    String nt = se.getAttribute("serverType");
                    if (!(this._nodeType == null || nt.equals("DEPLOYMENT_MANAGER") && !this._nodeType.equals("DEPLOYMENT_MANAGER") || nt.equals("NODE_AGENT") && !this._nodeType.matches("(DEPLOYMENT_MANAGER|NODE_AGENT)")) && (!nt.equals("APPLICATION_SERVER") || this._nodeType.matches("(DEPLOYMENT_MANAGER|NODE_AGENT|APPLICATION_SERVER)"))) continue;
                    this._nodeType = nt;
                }
            }
        }

        void addServer(Servers.Server server) {
            this._servers.put(server.getServerName(), server);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._nodeName);
            sb.append(nl + "- Type                     : " + this._nodeType);
            sb.append(nl + "- Directory                : " + this._nodeDir);
            sb.append(nl + "- Host Name                : " + this._hostName);
            sb.append(nl + "- Java                     : " + this._javaVersion + " " + this._javaArchitecture + " " + this._javaPlatform);
            sb.append(nl + "- Product                  : " + this._productName + " " + this._productVersion);
            sb.append(nl + "- Operating System         : " + this._nodeOperatingSystem);
            for (Servers.Server sd : this._servers.values()) {
                sb.append(nl + "- Server                   : " + sd.getServerName());
            }
            sb.append(nl + "- Libraries                : " + this._libraries.keySet());
            sb.append(nl + "- DataSources              : " + this._resources.getDataSources().keySet());
            sb.append(nl + "- J2C Admin Objects        : " + this._resources.getJ2CAdminObjects().keySet());
            sb.append(nl + "- J2C Connection Factories : " + this._resources.getJ2CConnectionFactories().keySet());
            sb.append(nl + "- J2C Activation Specs     : " + this._resources.getJ2CActivationSpecs().keySet());
            sb.append(nl + "- MQ Queue CFs             : " + this._resources.getMqQueueConnectionFactories().keySet());
            sb.append(nl + "- MQ Topic CFs             : " + this._resources.getMqTopicConnectionFactories().keySet());
            sb.append(nl + "- MQ CFs                   : " + this._resources.getMqConnectionFactories().keySet());
            sb.append(nl + "- MQ Queues                : " + this._resources.getMqQueues().keySet());
            sb.append(nl + "- MQ Topics                : " + this._resources.getMqTopics().keySet());
            sb.append(nl + "- Variables                : " + this._variables.valuesIgnoreScopeConflicts());
            sb.append(nl + "- JNDI Bindings            : " + this._jndiBindings.keySet());
            sb.append(nl);
            return sb.toString();
        }

        public int getAdminHostPort() {
            int port;
            block9: {
                port = 0;
                try {
                    int i;
                    Document serverIndexXml = FileUtilities.getDocument(new File(this._nodeDir, "serverindex.xml"));
                    Element serverIndexElem = null;
                    if (this._nodeType.equals("DEPLOYMENT_MANAGER")) {
                        serverIndexElem = (Element)serverIndexXml.getElementsByTagName("serverindex:ServerIndex").item(0);
                    } else if (this._nodeType.equals("APPLICATION_SERVER")) {
                        NodeList servers = serverIndexXml.getElementsByTagName("serverindex:ServerIndex");
                        block2: for (i = 0; i < servers.getLength(); ++i) {
                            Element server = (Element)servers.item(i);
                            NodeList deployedApps = server.getElementsByTagName("deployedApplications");
                            for (int j = 0; j < deployedApps.getLength(); ++j) {
                                Element da = (Element)deployedApps.item(j);
                                if (!da.getTextContent().equals("isclite.ear/deployments/isclite")) continue;
                                serverIndexElem = server;
                                continue block2;
                            }
                        }
                    }
                    if (serverIndexElem != null) {
                        NodeList specialEPs = serverIndexElem.getElementsByTagName("specialEndpoints");
                        for (i = 0; i < specialEPs.getLength(); ++i) {
                            Element sep = (Element)specialEPs.item(i);
                            if (!sep.getAttribute("endPointName").equals("WC_adminhost")) continue;
                            Element ep = (Element)sep.getElementsByTagName("endPoint").item(0);
                            port = Integer.parseInt(ep.getAttribute("port"));
                        }
                        break block9;
                    }
                    throw new Exception("WC_adminhost endpoint is not defined for the admin server under node " + this._nodeName + ".");
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.FINEST, "Caught exception tying to discover the cell's WC_adminhost port. ", e);
                }
            }
            return port;
        }

        public File getNodePath() {
            return this._nodeDir;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public String getNodeManagementScopeName() {
            return Nodes.this._cell.getCellManagementScopeName() + ":(node):" + this._nodeName;
        }

        public String getNodeType() {
            return this._nodeType;
        }

        public String getHostName() {
            return this._hostName;
        }

        public int getServerCount() {
            return this._servers.size();
        }

        public Iterable<Servers.Server> getServers() {
            return this._servers.values();
        }

        public Servers.Server getServer(String serverName) {
            return (Servers.Server)this._servers.get(serverName);
        }

        public ScopedMap<Variable> getVariables() {
            return this._variables;
        }

        public ScopedMap<Library> getLibraries() {
            return this._libraries;
        }

        public Document getNameBindings() {
            return this._nameBindingsXml;
        }

        public ScopedMap<JNDIBinding> getJNDIBindings() {
            return this._jndiBindings;
        }

        public String getJavaArchitecture() {
            return this._javaArchitecture;
        }

        public String getJavaVersion() {
            return this._javaVersion;
        }

        public String getJavaPlatform() {
            return this._javaPlatform;
        }

        public String getProductShortName() {
            return this._productName;
        }

        public String getProductVersion() {
            return this._productVersion;
        }

        public String getNodeOperatingSystem() {
            return this._nodeOperatingSystem;
        }

        public Resources getResources() {
            return this._resources;
        }

        public boolean isFederatedNode() {
            return this._federatedNode;
        }

        public void setFederatedNode(boolean isFederatedNode) {
            this._federatedNode = isFederatedNode;
        }
    }
}

