/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.JeeProviders;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.Nodes;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Servers {
    private final SortedMap<String, Server> _servers = new TreeMap<String, Server>();
    private static final String nl = System.getProperty("line.separator");

    public void addServersFromNode(Nodes.Node node) throws Exception {
        File serversDir = new File(node.getNodePath(), "servers");
        Document serverIndexXml = FileUtilities.getDocument(new File(node.getNodePath(), "serverindex.xml"));
        File[] serverList = serversDir.listFiles();
        if (serverList == null) {
            ReportUtility.logger.get().log(Level.FINEST, "No servers found in directory " + serversDir.getPath() + ", skipping");
            return;
        }
        for (File serverDir : serverList) {
            if (serverDir.getPath().endsWith(".DS_Store")) continue;
            try {
                Server server = new Server(node, serverDir, serverIndexXml);
                this._servers.put(server.getServerName(), server);
                node.addServer(server);
            }
            catch (Exception e) {
                ReportUtility.logger.get().severe(Messages.getFormattedMessage(Messages.getString("Servers_Unable_To_Read_Server"), serverDir.getPath(), e.getLocalizedMessage()));
                ReportUtility.logger.get().log(Level.FINE, "Caught exception reading server", e);
            }
        }
    }

    void loadScopedData() {
        for (Server server : this._servers.values()) {
            server.loadScopedData();
        }
    }

    public String toString() {
        if (this._servers.isEmpty()) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Server sd : this._servers.values()) {
            if (!first) {
                sb.append(nl);
            }
            sb.append(sd.toString());
            first = false;
        }
        return sb.toString();
    }

    public Server getServer(String name2) {
        return (Server)this._servers.get(name2);
    }

    public int getServerCount() {
        return this._servers.size();
    }

    public Iterable<Server> getServers() {
        return this._servers.values();
    }

    public class Server {
        protected final File _serverDir;
        protected final String _serverName;
        protected final String _localServerName;
        protected String _serverType;
        protected final Nodes.Node _owningNode;
        protected Clusters.Cluster _owningCluster;
        protected final ScopedMap<Variable> _variables = new ScopedMap();
        protected final ScopedMap<Library> _libraries = new ScopedMap();
        protected final Set<String> _libraryReferences = new HashSet<String>();
        protected final JeeProviders _jeeProviders = new JeeProviders();
        protected final SortedMap<String, Apps.App> _apps = new TreeMap<String, Apps.App>();
        protected final Resources _resources = new Resources();
        protected final List<ProcessDefinition> _processDefinitions = new ArrayList<ProcessDefinition>();
        protected final ScopedMap<SessionManager> _sessionManager = new ScopedMap();
        protected final ScopedMap<JNDIBinding> _jndiBindings = new ScopedMap();
        protected DomainSecurity _domainSecurity;
        protected final ScopedMap<TransactionService> _transactionService = new ScopedMap();
        private Document _resourcesXml;
        private Document _variablesXml;
        private Document _librariesXml;
        private Document _nameBindingsXml;
        private Element _sessionManagerElement;
        private Element _transactionServiceElement;
        private Element _recoveryLogElement;

        private Server(Nodes.Node owningNode, File serverDir, Document serverIndexXml) throws Exception {
            File bindingsFile;
            File resFile;
            File libFile;
            this._owningNode = owningNode;
            this._serverDir = serverDir;
            String nodeName = owningNode.getNodeName();
            Document serverXml = FileUtilities.getDocument(new File(serverDir, "server.xml"));
            Element serverElem = (Element)serverXml.getElementsByTagName("process:Server").item(0);
            NodeList components = serverElem.getElementsByTagName("components");
            for (int i = 0; i < components.getLength(); ++i) {
                Element comp = (Element)components.item(i);
                if (!comp.getAttribute("xmi:type").equals("applicationserver:ApplicationServer")) continue;
                this._jeeProviders.setJpaProvider(comp.getAttribute("jpaProvider"));
                this._jeeProviders.setJaxRSProvider(comp.getAttribute("jaxrsProvider"));
                this._jeeProviders.setJsfProvider(comp.getAttribute("jsfProvider"));
            }
            this._localServerName = serverElem.getAttribute("name");
            this._serverName = nodeName + "/" + this._localServerName;
            NodeList processDefs = serverElem.getElementsByTagName("processDefinitions");
            for (int i = 0; i < processDefs.getLength(); ++i) {
                ProcessDefinition pd = TwasXmlUtilities.loadProcessDefinition((Element)processDefs.item(i));
                this._processDefinitions.add(pd);
            }
            NodeList serverEntries = serverIndexXml.getElementsByTagName("serverEntries");
            for (int i = 0; i < serverEntries.getLength(); ++i) {
                Element se = (Element)serverEntries.item(i);
                String name2 = se.getAttribute("serverName");
                if (!name2.equals(this._localServerName)) continue;
                this._serverType = se.getAttribute("serverType");
                NodeList recoveryLogs = se.getElementsByTagName("recoveryLog");
                if (recoveryLogs.getLength() <= 0) break;
                this._recoveryLogElement = (Element)recoveryLogs.item(0);
                break;
            }
            if (this._serverType == null) {
                throw new Exception(Messages.getFormattedMessage(Messages.getString("Unknown_Server_Type"), this._serverName));
            }
            NodeList servicesEntries = serverElem.getElementsByTagName("services");
            for (int i = 0; i < servicesEntries.getLength(); ++i) {
                Element currentElement = (Element)servicesEntries.item(i);
                if ("applicationserver.webcontainer:SessionManager".equals(currentElement.getAttribute("xmi:type"))) {
                    this._sessionManagerElement = currentElement;
                }
                if (!"applicationserver:TransactionService".equals(currentElement.getAttribute("xmi:type"))) continue;
                this._transactionServiceElement = currentElement;
            }
            File varFile = new File(this._serverDir, "variables.xml");
            if (varFile.exists()) {
                this._variablesXml = FileUtilities.getDocument(varFile);
            }
            if ((libFile = new File(this._serverDir, "libraries.xml")).exists()) {
                this._librariesXml = FileUtilities.getDocument(libFile);
            }
            if ((resFile = new File(this._serverDir, "resources.xml")).exists()) {
                this._resourcesXml = FileUtilities.getDocument(resFile);
            }
            if ((bindingsFile = new File(this._serverDir, "namebindings.xml")).exists()) {
                this._nameBindingsXml = FileUtilities.getDocument(bindingsFile);
            }
            NodeList libraries = serverXml.getElementsByTagName("libraries");
            for (int i = 0; i < libraries.getLength(); ++i) {
                Element library = (Element)libraries.item(i);
                String libraryName = library.getAttribute("libraryName");
                if (libraryName.length() <= 0) continue;
                this._libraryReferences.add(libraryName);
            }
        }

        protected Server(File serverDir, String serverName, String localServerName, Nodes.Node owningNode) {
            this._serverDir = serverDir;
            this._serverName = serverName;
            this._localServerName = localServerName;
            this._owningNode = owningNode;
        }

        void loadScopedData() {
            Scope scope = new Scope(Scope.Level.SERVER, this._serverName, this._serverDir);
            this._jndiBindings.putAll(this._owningNode.getJNDIBindings());
            this._variables.putAll(this._owningNode.getVariables());
            this._libraries.putAll(this._owningNode.getLibraries());
            this._resources.putAll(this._owningNode.getResources());
            if (this._owningCluster != null) {
                this._jndiBindings.putAll(this._owningCluster.getJNDIBindings());
                this._variables.putAll(this._owningCluster.getVariables());
                this._libraries.putAll(this._owningCluster.getLibraries());
                this._resources.putAll(this._owningCluster.getResources());
            }
            if (this._variablesXml != null) {
                TwasXmlUtilities.loadVariables(this._variables, this._variablesXml, scope);
            }
            if (this._librariesXml != null) {
                TwasXmlUtilities.loadLibraries(this._libraries, this._librariesXml, scope);
            }
            if (this._resourcesXml != null) {
                TwasXmlUtilities.loadResources(this._resources, this._resourcesXml, scope);
            }
            if (this._nameBindingsXml != null) {
                for (JNDIBinding binding : TwasXmlUtilities.loadJNDIBinding(this._nameBindingsXml, scope, "cell/nodes/" + this._owningNode.getNodeName() + "/servers/" + this._localServerName + "/")) {
                    this._jndiBindings.put(binding.getJndiName(), binding);
                }
            }
            if (this._sessionManagerElement != null) {
                this._sessionManager.put("SessionManager", TwasXmlUtilities.loadSessionManager(this._sessionManagerElement, scope));
            }
            if (this._transactionServiceElement != null) {
                this._transactionService.put("TransactionService", TwasXmlUtilities.loadTransactionService(this._transactionServiceElement, this._recoveryLogElement, scope));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._serverName);
            sb.append(nl + "- Type                     : " + this._serverType);
            sb.append(nl + "- Directory               : " + this._serverDir);
            sb.append(nl + "- Owning Node              : " + this._owningNode.getNodeName());
            if (this.hasOwningCluster()) {
                sb.append(nl + "- Owning Cluster           : " + this._owningCluster.getClusterName());
            }
            sb.append(nl + "- JPA Provider             : " + this._jeeProviders.getJpaProvider());
            sb.append(nl + "- JAX-RS Provider          : " + this._jeeProviders.getJaxRSProvider());
            sb.append(nl + "- JSF Provider             : " + this._jeeProviders.getJsfProvider());
            sb.append(nl + "- Libraries                : " + this._libraries.keySet());
            sb.append(nl + "- Library References       : " + this._libraryReferences);
            sb.append(nl + "- Apps                     : " + this._apps.keySet());
            sb.append(nl + "- DataSources              : " + this._resources.getDataSources().keySet());
            sb.append(nl + "- J2C Admin Objects        : " + this._resources.getJ2CAdminObjects().keySet());
            sb.append(nl + "- J2C Connection Factories : " + this._resources.getJ2CConnectionFactories().keySet());
            sb.append(nl + "- J2C Activation Specs     : " + this._resources.getJ2CActivationSpecs().keySet());
            sb.append(nl + "- MQ Queue CFs             : " + this._resources.getMqQueueConnectionFactories().keySet());
            sb.append(nl + "- MQ Topic CFs             : " + this._resources.getMqTopicConnectionFactories().keySet());
            sb.append(nl + "- MQ CFs                   : " + this._resources.getMqConnectionFactories().keySet());
            sb.append(nl + "- MQ Queues                : " + this._resources.getMqQueues().keySet());
            sb.append(nl + "- MQ Topics                : " + this._resources.getMqTopics().keySet());
            sb.append(nl + "- Variables                : " + this._variables.valuesIgnoreScopeConflicts());
            sb.append(nl + "- ProcessDefinitions       : " + this._processDefinitions);
            sb.append(nl + "- JNDI Bindings            : " + this._jndiBindings.keySet());
            sb.append(nl + "- Domain Security          : " + this._domainSecurity);
            sb.append(nl + "- Transaction Service      : " + this._transactionService);
            sb.append(nl);
            return sb.toString();
        }

        public File getServerPath() {
            return this._serverDir;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getServerManagementScopeName() {
            return this._owningNode.getNodeManagementScopeName() + ":(server):" + this._localServerName;
        }

        public String getLocalServerName() {
            return this._localServerName;
        }

        public String getServerType() {
            return this._serverType;
        }

        public Clusters.Cluster getOwningCluster() {
            return this._owningCluster;
        }

        public Nodes.Node getOwningNode() {
            return this._owningNode;
        }

        void setOwningCluster(Clusters.Cluster cluster) {
            this._owningCluster = cluster;
        }

        public boolean hasOwningCluster() {
            return this._owningCluster != null;
        }

        public ScopedMap<Variable> getVariables() {
            return this._variables;
        }

        public ScopedMap<Library> getLibraries() {
            return this._libraries;
        }

        public Set<String> getLibraryReferences() {
            return this._libraryReferences;
        }

        public JeeProviders getJeeProviders() {
            return this._jeeProviders;
        }

        public int getAppCount() {
            return this._apps.size();
        }

        public Apps.App getApp(String name2) {
            return (Apps.App)this._apps.get(name2);
        }

        public Iterable<Apps.App> getApps() {
            return this._apps.values();
        }

        void addApp(Apps.App app) {
            this._apps.put(app.getAppName(), app);
        }

        public Resources getResources() {
            return this._resources;
        }

        public List<ProcessDefinition> getProcessDefinitions() {
            return this._processDefinitions;
        }

        public ScopedMap<SessionManager> getSessionManager() {
            return this._sessionManager;
        }

        public ScopedMap<JNDIBinding> getJNDIBindings() {
            return this._jndiBindings;
        }

        public DomainSecurity getDomainSecurity() {
            return this._domainSecurity;
        }

        public void setDomainSecurity(DomainSecurity ds) {
            this._domainSecurity = ds;
        }

        public ScopedMap<TransactionService> getTransactionService() {
            return this._transactionService;
        }
    }
}

