/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import com.ibm.ws.report.binary.featurelist.Feature;
import com.ibm.ws.report.binary.featurelist.FeatureUtil;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureList {
    private static ConcurrentHashMap<String, Feature> publicFeaturesByName = null;
    private static ConcurrentHashMap<String, Feature> allFeaturesBySymbolicName = null;

    public static boolean isValidFeature(String feature, Document featureListResource) {
        return FeatureList.getFeature(feature, featureListResource) != null;
    }

    public static String getCanonicalFeatureName(String featureName, Document featureListResource) {
        Feature feature = FeatureList.getFeature(featureName, featureListResource);
        if (feature != null) {
            return feature.getName();
        }
        return null;
    }

    public static List<String> getFeatures(boolean sort, Document featureListResource) {
        Set<String> features = FeatureList.getRuntimeFeatureSet(featureListResource);
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        featureList.addAll(features);
        if (sort) {
            Collections.sort(featureList);
        }
        return featureList;
    }

    public static List<String> getSymbolicNameFeatures(boolean sort, Document featureListResource) {
        Collection<Feature> features = FeatureList.getFeatureMap(featureListResource).values();
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        for (Feature f : features) {
            if (f.getSymbolicName() == null) continue;
            featureList.add(f.getSymbolicName());
        }
        if (sort) {
            Collections.sort(featureList);
        }
        return featureList;
    }

    public static Set<String> getRuntimeFeatureSet(Document featureListResource) {
        return FeatureList.getFeatureMap(featureListResource).keySet();
    }

    public static Set<String> getFeatureChildren(String feature, Document featureListResource) {
        HashSet<String> children = new HashSet<String>();
        ConcurrentHashMap<String, Feature> map = FeatureList.getFeatureMap(featureListResource);
        FeatureList.getFeatureChildren(children, feature, map);
        return children;
    }

    private static void getFeatureChildren(Set<String> set, String featureName, ConcurrentHashMap<String, Feature> map) {
        Feature f = FeatureList.getFeature(featureName, map);
        if (f == null) {
            return;
        }
        Set<String> children = f.getEnables();
        if (children != null) {
            for (String child : children) {
                if (FeatureList.containsIgnoreCase(set, child) || featureName.equalsIgnoreCase(child)) continue;
                set.add(child);
                FeatureList.getFeatureChildren(set, child, map);
            }
        }
    }

    public static boolean isFeatureSuperseded(String feature, Document featureListResource) {
        Feature f = FeatureList.getFeature(feature, featureListResource);
        return f == null ? false : f.isSuperseded();
    }

    public static Set<String> getFeatureSupersededBy(String feature, Document featureListResource) {
        Feature f = FeatureList.getFeature(feature, featureListResource);
        return f == null ? null : f.getSupersededBy();
    }

    public static Set<String> getFeatureParents(String featureName, Document featureListResource) {
        HashSet<String> set = new HashSet<String>();
        ConcurrentHashMap<String, Feature> map = FeatureList.getFeatureMap(featureListResource);
        FeatureList.getFeatureParents(set, featureName, map);
        return set;
    }

    private static void getFeatureParents(Set<String> set, String featureName, ConcurrentHashMap<String, Feature> map) {
        Set<Map.Entry<String, Feature>> entries = map.entrySet();
        for (Map.Entry<String, Feature> entry : entries) {
            String key = entry.getKey();
            Feature f = entry.getValue();
            if (key == null || f == null || !FeatureList.containsIgnoreCase(f.getEnables(), featureName) || FeatureList.containsIgnoreCase(set, key) || featureName.equalsIgnoreCase(key)) continue;
            set.add(key);
            FeatureList.getFeatureParents(set, key, map);
        }
    }

    public static boolean isEnabledBy(String feature1, String feature2, Document featureListResource) {
        if (feature1.equalsIgnoreCase(feature2) || FeatureUtil.isSupportedBy(feature1, feature2)) {
            return true;
        }
        return FeatureList.isContainedBy(feature1, feature2, featureListResource);
    }

    public static boolean featuresEnabled(List<String> featuresToCheck, List<String> allFeatures, Document featureListResource) {
        for (String feature : featuresToCheck) {
            if (FeatureList.featureEnabled(feature, allFeatures, featureListResource)) continue;
            return false;
        }
        return true;
    }

    public static boolean featureEnabled(String featureToCheck, List<String> allFeatures, Document featureListResource) {
        for (String feature : allFeatures) {
            if (!FeatureList.isEnabledBy(featureToCheck, feature, featureListResource)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(String feature1, String feature2, Document featureListResource) {
        Set<String> children = FeatureList.getFeatureChildren(feature2, featureListResource);
        return FeatureList.isSupportedBy(children, feature1);
    }

    public static synchronized ConcurrentHashMap<String, Feature> getFeatureMap(Document featureListResource) {
        if (publicFeaturesByName == null) {
            publicFeaturesByName = new ConcurrentHashMap();
            FeatureList.getFeaturesForType("feature", featureListResource, Feature.FeatureType.PUBLIC, publicFeaturesByName, false);
        }
        return publicFeaturesByName;
    }

    protected static void getFeaturesForType(String featureElementName, Document featureListResource, Feature.FeatureType type, ConcurrentHashMap<String, Feature> allInclusiveFeatureMap, boolean useSymbolicName) {
        NodeList listOfFeatures = featureListResource.getElementsByTagName(featureElementName);
        int size = listOfFeatures.getLength();
        int i = 0;
        while (i < size) {
            Element featureElement = (Element)listOfFeatures.item(i);
            NamedNodeMap featureAttrs = featureElement.getAttributes();
            String name2 = null;
            if (featureAttrs != null) {
                Feature nextFeature = null;
                Node nameNode = featureAttrs.getNamedItem("name");
                if (nameNode != null) {
                    name2 = nameNode.getNodeValue();
                    nextFeature = new Feature(name2, type);
                    FeatureList.addFeatureInfo(featureElement, nextFeature);
                } else {
                    String symName = XMLRuleUtil.getFirstChildElementValue(featureElement, null, "symbolicName");
                    if (symName != null) {
                        nextFeature = new Feature(symName, type);
                        FeatureList.addFeatureInfo(featureElement, nextFeature);
                    }
                }
                if (nextFeature != null) {
                    if (useSymbolicName) {
                        allInclusiveFeatureMap.put(nextFeature.getSymbolicName(), nextFeature);
                    } else {
                        allInclusiveFeatureMap.put(nextFeature.getName(), nextFeature);
                    }
                }
            }
            ++i;
        }
    }

    protected static void addFeatureInfo(Element featureElement, Feature feature) {
        String symName = XMLRuleUtil.getFirstChildElementValue(featureElement, null, "symbolicName");
        feature.setSymbolicName(symName);
        String singleton = XMLRuleUtil.getFirstChildElementValue(featureElement, null, "singleton");
        feature.setSingleton(Boolean.parseBoolean(singleton));
        List<Element> children = XMLRuleUtil.getChildElements(featureElement, null, "enables");
        for (Element next : children) {
            String enables = XMLRuleUtil.getTextWithoutWhitespace(next);
            feature.addEnables(enables);
        }
        children = XMLRuleUtil.getChildElements(featureElement, null, "supersededBy");
        for (Element next : children) {
            String supersededBy = XMLRuleUtil.getTextWithoutWhitespace(next);
            feature.addSupersededBy(supersededBy);
        }
        children = XMLRuleUtil.getChildElements(featureElement, null, "autoProvision");
        for (Element next : children) {
            String autoProvision = XMLRuleUtil.getTextWithoutWhitespace(next);
            feature.addAutoProvision(autoProvision);
        }
        children = XMLRuleUtil.getChildElements(featureElement, null, "include");
        for (Element next : children) {
            Node nameNode;
            NamedNodeMap includeAttrs = next.getAttributes();
            String name2 = null;
            if (includeAttrs == null || (nameNode = includeAttrs.getNamedItem("symbolicName")) == null) continue;
            name2 = nameNode.getNodeValue();
            Node tolerates = includeAttrs.getNamedItem("tolerates");
            if (tolerates != null) {
                String tolerateVersion = tolerates.getNodeValue();
                String[] tolerateVersions = tolerateVersion.split(",");
                ArrayList<String> versions = new ArrayList<String>();
                String[] stringArray = tolerateVersions;
                int n = tolerateVersions.length;
                int n2 = 0;
                while (n2 < n) {
                    String version = stringArray[n2];
                    versions.add(version);
                    ++n2;
                }
                feature.addIncludes(name2, versions);
                continue;
            }
            feature.addIncludes(name2, null);
        }
    }

    public static synchronized ConcurrentHashMap<String, Feature> getAllFeaturesKeyedBySymbolicName(Document featureListResource) {
        if (allFeaturesBySymbolicName == null) {
            allFeaturesBySymbolicName = new ConcurrentHashMap();
            FeatureList.getFeaturesForType("feature", featureListResource, Feature.FeatureType.PUBLIC, allFeaturesBySymbolicName, true);
            FeatureList.getFeaturesForType("protectedFeature", featureListResource, Feature.FeatureType.PROTECTED, allFeaturesBySymbolicName, true);
            FeatureList.getFeaturesForType("privateFeature", featureListResource, Feature.FeatureType.PRIVATE, allFeaturesBySymbolicName, true);
            FeatureList.getFeaturesForType("kernelFeature", featureListResource, Feature.FeatureType.KERNEL, allFeaturesBySymbolicName, true);
            FeatureList.getFeaturesForType("autoFeature", featureListResource, Feature.FeatureType.AUTO, allFeaturesBySymbolicName, true);
        }
        return allFeaturesBySymbolicName;
    }

    private static Feature getFeature(String featureName, Document featureListResource) {
        return FeatureList.getFeature(featureName, FeatureList.getFeatureMap(featureListResource));
    }

    private static Feature getFeature(String featureName, Map<String, Feature> featureMap) {
        if (featureMap != null) {
            Set<Map.Entry<String, Feature>> entrySet = featureMap.entrySet();
            for (Map.Entry<String, Feature> entry : entrySet) {
                String key = entry.getKey();
                if (!key.equalsIgnoreCase(featureName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsIgnoreCase(Set<String> set, String val) {
        for (String entry : set) {
            if (!val.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupportedBy(Set<String> set, String val) {
        for (String entry : set) {
            if (!val.equalsIgnoreCase(entry) && !FeatureUtil.isSupportedBy(val, entry)) continue;
            return true;
        }
        return false;
    }

    public static String getPublicFeatureName(String symbolicName, Document featureListResource) {
        Feature feature = FeatureList.getAllFeaturesKeyedBySymbolicName(featureListResource).get(symbolicName);
        if (feature != null) {
            String name2 = feature.getName();
            if (name2 != null) {
                return name2;
            }
        } else {
            return null;
        }
        return symbolicName;
    }

    public static String getFeatureSymbolicName(String publicFeatureName, Document featureListResource) {
        ConcurrentHashMap<String, Feature> featureMap = FeatureList.getFeatureMap(featureListResource);
        Feature feature = featureMap.get(publicFeatureName);
        if (feature != null) {
            return feature.getSymbolicName();
        }
        return null;
    }

    public static enum FeatureMapType {
        PUBLIC_FEATURES_KEYED_BY_NAME,
        ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME;

    }
}

