/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import com.ibm.ws.report.binary.featurelist.FeatureList;
import com.ibm.ws.report.binary.featurelist.FeatureResolverFeature;
import com.ibm.ws.report.binary.featurelist.FeatureSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;

public class FeatureUtil {
    static final String FEATURE_SEPARATOR = "-";

    public static boolean isLowerVersion(String feature1, String feature2) {
        int index = feature1.indexOf(FEATURE_SEPARATOR);
        if (index == -1 || feature2.indexOf(FEATURE_SEPARATOR) == -1) {
            return false;
        }
        if (feature2.toLowerCase().startsWith(feature1.substring(0, index + 1).toLowerCase())) {
            return FeatureUtil.compareFeatureVersions(feature1, feature2) < 0;
        }
        return false;
    }

    public static boolean isLowerVersionWithoutNameCheck(String feature1, String feature2) {
        int index = feature1.indexOf(FEATURE_SEPARATOR);
        if (index == -1 || feature2.indexOf(FEATURE_SEPARATOR) == -1) {
            return false;
        }
        return FeatureUtil.compareFeatureVersions(feature1, feature2) < 0;
    }

    public static boolean isSupportedBy(String feature1, String feature2) {
        int index = feature2.indexOf(FEATURE_SEPARATOR);
        if (index == -1) {
            return false;
        }
        String feature2Name = feature2.substring(0, index).toLowerCase();
        if (!feature1.toLowerCase().startsWith(feature2Name)) {
            return false;
        }
        if (feature1.indexOf(FEATURE_SEPARATOR) == -1) {
            return true;
        }
        return FeatureUtil.compareFeatureVersions(feature1, feature2) <= 0;
    }

    public static int compareFeatureVersions(String featureA, String featureB) {
        String[] splitB;
        String versionA = featureA.substring(featureA.indexOf(FEATURE_SEPARATOR) + 1);
        String versionB = featureB.substring(featureB.indexOf(FEATURE_SEPARATOR) + 1);
        String[] splitA = versionA.split("\\.");
        int comparisonLimit = splitA.length < (splitB = versionB.split("\\.")).length ? splitA.length : splitB.length;
        int i = 0;
        while (i < comparisonLimit) {
            int valB;
            int valA = Integer.valueOf(splitA[i]);
            if (valA > (valB = Integer.valueOf(splitB[i]).intValue())) {
                return 1;
            }
            if (valA < valB) {
                return -1;
            }
            ++i;
        }
        if (versionA.length() > versionB.length()) {
            return 1;
        }
        if (versionA.length() < versionB.length()) {
            return -1;
        }
        return 0;
    }

    public static String findLowerVersion(List<String> featureList, String featureToCheck) {
        int index = featureToCheck.indexOf(FEATURE_SEPARATOR);
        if (index == -1) {
            return null;
        }
        String f = featureToCheck.substring(0, index + 1).toLowerCase();
        for (String feature : featureList) {
            if (!feature.toLowerCase().startsWith(f) || !FeatureUtil.isLowerVersion(feature, featureToCheck)) continue;
            return feature;
        }
        return null;
    }

    public static String findHigherVersion(List<String> featureList, String featureToCheck) {
        int index = featureToCheck.indexOf(FEATURE_SEPARATOR);
        if (index == -1) {
            return null;
        }
        float previousVersion = Float.MAX_VALUE;
        String higherVersionFeature = null;
        String f = featureToCheck.substring(0, index + 1).toLowerCase();
        for (String feature : featureList) {
            float currentVersion;
            if (!feature.toLowerCase().startsWith(f) || !FeatureUtil.isLowerVersion(featureToCheck, feature) || !((currentVersion = Float.valueOf(feature.substring(feature.indexOf(FEATURE_SEPARATOR) + 1)).floatValue()) < previousVersion)) continue;
            previousVersion = currentVersion;
            higherVersionFeature = feature;
        }
        return higherVersionFeature;
    }

    static String getName(String feature) {
        int index = feature.indexOf(FEATURE_SEPARATOR);
        if (index == -1) {
            return feature;
        }
        return feature.substring(0, index);
    }

    public static String getVersion(String feature) {
        int index = feature.indexOf(FEATURE_SEPARATOR);
        if (index == -1) {
            return feature;
        }
        return feature.substring(index + 1);
    }

    public static void checkAndAddFeature(Document featureListResource, Set<FeatureResolverFeature> previousRequiredFeatures, FeatureSet existingFeatures, String feature, boolean includeAll) {
        FeatureUtil.checkAndAddFeature(featureListResource, previousRequiredFeatures, existingFeatures, new FeatureResolverFeature(feature), includeAll);
    }

    public static void checkAndAddFeature(Document featureListResource, Set<FeatureResolverFeature> previousRequiredFeatures, FeatureSet existingFeatures, FeatureResolverFeature feature, boolean includeAll) {
        String featureName = feature.getName();
        if (existingFeatures != null && existingFeatures.supports(featureName)) {
            return;
        }
        if (previousRequiredFeatures.contains(feature)) {
            return;
        }
        if (!includeAll) {
            for (FeatureResolverFeature nextFeature : previousRequiredFeatures) {
                if (FeatureList.isEnabledBy(featureName, nextFeature.getName(), featureListResource)) {
                    return;
                }
                if (!FeatureList.isEnabledBy(nextFeature.getName(), featureName, featureListResource)) continue;
                if (!previousRequiredFeatures.contains(feature)) {
                    previousRequiredFeatures.remove(nextFeature);
                    previousRequiredFeatures.add(feature);
                    continue;
                }
                previousRequiredFeatures.remove(nextFeature);
            }
        }
        if (!previousRequiredFeatures.contains(feature)) {
            previousRequiredFeatures.add(feature);
        }
    }
}

