/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.report.binary.featurelist.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ResolverFeatureAdapter
implements ProvisioningFeatureDefinition {
    private final Feature feature;

    public ResolverFeatureAdapter(Feature feature) {
        this.feature = feature;
    }

    @Override
    public String getApiServices() {
        return null;
    }

    @Override
    public AppForceRestart getAppForceRestart() {
        return null;
    }

    @Override
    public String getFeatureName() {
        if (this.feature.getFeatureType() == Feature.FeatureType.PUBLIC) {
            return this.feature.getName();
        }
        return this.feature.getSymbolicName();
    }

    @Override
    public String getSymbolicName() {
        return this.feature.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return Version.emptyVersion;
    }

    @Override
    public Visibility getVisibility() {
        Feature.FeatureType featureType = this.feature.getFeatureType();
        if (featureType != null) {
            switch (featureType) {
                case PUBLIC: {
                    return Visibility.PUBLIC;
                }
                case PROTECTED: {
                    return Visibility.PROTECTED;
                }
                case PRIVATE: 
                case AUTO: 
                case KERNEL: {
                    return Visibility.PRIVATE;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isKernel() {
        return Feature.FeatureType.KERNEL == this.feature.getFeatureType();
    }

    @Override
    public String getBundleRepositoryType() {
        return "";
    }

    @Override
    public Collection<FeatureResource> getConstituents(SubsystemContentType subsystemContentType) {
        if (subsystemContentType == SubsystemContentType.FEATURE_TYPE) {
            Map<String, List<String>> includes = this.feature.getIncludes();
            ArrayList<FeatureResource> constituents = new ArrayList<FeatureResource>();
            for (String symbolicName : includes.keySet()) {
                constituents.add(new FeatureResourceAdapter(symbolicName, includes.get(symbolicName)));
            }
            return constituents;
        }
        return null;
    }

    @Override
    public File getFeatureChecksumFile() {
        return null;
    }

    @Override
    public File getFeatureDefinitionFile() {
        return null;
    }

    @Override
    public String getHeader(String arg0) {
        return null;
    }

    @Override
    public String getHeader(String arg0, Locale arg1) {
        return null;
    }

    @Override
    public Collection<HeaderElementDefinition> getHeaderElements(String arg0) {
        return null;
    }

    @Override
    public int getIbmFeatureVersion() {
        return -1;
    }

    @Override
    public String getIbmShortName() {
        if (this.feature.getFeatureType() == Feature.FeatureType.PUBLIC) {
            String name2 = this.feature.getName();
            int index = name2.indexOf(58);
            if (index != -1) {
                name2 = name2.substring(index + 1);
            }
            return name2;
        }
        return null;
    }

    @Override
    public Collection<String> getIcons() {
        return null;
    }

    @Override
    public Collection<File> getLocalizationFiles() {
        return null;
    }

    @Override
    public String getSupersededBy() {
        return null;
    }

    @Override
    public boolean isAutoFeature() {
        return this.feature.getAutoProvisions().size() > 0;
    }

    @Override
    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        if (!this.feature.isAutoFeature()) {
            return true;
        }
        boolean isCapabilitySatisfied = true;
        HashSet<ProvisioningFeatureDefinition> satisfiedFeatureDefs = new HashSet<ProvisioningFeatureDefinition>();
        for (String autoProvision : this.feature.getAutoProvisions()) {
            try {
                Filter filter = FrameworkUtil.createFilter(autoProvision);
                Iterator<ProvisioningFeatureDefinition> featureDefIter = featureDefinitionsToCheck.iterator();
                boolean featureMatch = false;
                while (featureDefIter.hasNext() && !featureMatch) {
                    ProvisioningFeatureDefinition featureDef = featureDefIter.next();
                    if (satisfiedFeatureDefs.contains(featureDef)) continue;
                    HashMap<String, String> filterProps = new HashMap<String, String>();
                    filterProps.put("osgi.identity", featureDef.getSymbolicName());
                    filterProps.put("type", "osgi.subsystem.feature");
                    if (!filter.matches(filterProps)) continue;
                    satisfiedFeatureDefs.add(featureDef);
                    featureMatch = true;
                }
                isCapabilitySatisfied = featureMatch;
                if (isCapabilitySatisfied) continue;
                break;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                invalidSyntaxException.printStackTrace();
            }
        }
        return isCapabilitySatisfied;
    }

    @Override
    public boolean isSingleton() {
        return this.feature.isSingleton();
    }

    @Override
    public boolean isSuperseded() {
        return this.feature.isSuperseded();
    }

    @Override
    public boolean isSupportedFeatureVersion() {
        return true;
    }

    @Override
    public EnumSet<ProcessType> getProcessTypes() {
        return EnumSet.of(ProcessType.SERVER);
    }

    public String toString() {
        return this.getFeatureName();
    }

    public class FeatureResourceAdapter
    implements FeatureResource {
        private final String symbolicName;
        private final List<String> tolerates;

        public FeatureResourceAdapter(String symbolicName, List<String> tolerates) {
            this.symbolicName = symbolicName;
            this.tolerates = tolerates;
        }

        @Override
        public String getSymbolicName() {
            return this.symbolicName;
        }

        @Override
        public Map<String, String> getDirectives() {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> getAttributes() {
            return new HashMap<String, String>();
        }

        @Override
        public String setExecutablePermission() {
            return null;
        }

        @Override
        public boolean isType(SubsystemContentType subsystemContentType) {
            return subsystemContentType == SubsystemContentType.FEATURE_TYPE;
        }

        @Override
        public VersionRange getVersionRange() {
            return null;
        }

        @Override
        public SubsystemContentType getType() {
            return SubsystemContentType.FEATURE_TYPE;
        }

        @Override
        public List<String> getTolerates() {
            return this.tolerates;
        }

        @Override
        public int getStartLevel() {
            return 0;
        }

        @Override
        public String getRawType() {
            return SubsystemContentType.FEATURE_TYPE.toString();
        }

        @Override
        public List<String> getOsList() {
            return null;
        }

        @Override
        public String getMatchString() {
            return null;
        }

        @Override
        public String getLocation() {
            return null;
        }

        @Override
        public String getFileEncoding() {
            return null;
        }

        @Override
        public String getExtendedAttributes() {
            return null;
        }

        @Override
        public String getBundleRepositoryType() {
            return null;
        }

        @Override
        public Integer getRequireJava() {
            return null;
        }

        @Override
        public ActivationType getActivationType() {
            return null;
        }
    }
}

