/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class DetectJspTaglib
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule);
    protected String[] taglibs = null;

    public DetectJspTaglib(String ruleName, String desc, String[] taglibs, boolean flagOnce) {
        this(ruleName, desc, taglibs, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false);
    }

    public DetectJspTaglib(String ruleName, String desc, String[] taglibs, DetectRule.FlagOnce flagOnceType, boolean hideResult) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.taglibs = taglibs;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                if (!this.shouldFlag(key)) continue;
                if (this.taglibs != null && this.taglibs.length > 0) {
                    JSPResource jspData = store.getJsp(key);
                    List<JspNode> jspNodes = jspData.getJSPNodes();
                    for (JspNode node : jspNodes) {
                        String data;
                        if (node.getJspNodeType() != JspNodeType.DIRECTIVE || !(data = node.getData()).contains("taglib")) continue;
                        String[] stringArray = this.taglibs;
                        int n = this.taglibs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String taglib = stringArray[n2];
                            if (data.contains(taglib)) {
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, taglib));
                                }
                                if (detectOnce || this.flagOnce) {
                                    return;
                                }
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
                if (this.flag(key)) {
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, "*" + key.substring(key.lastIndexOf(46))));
                }
                if (!detectOnce && !this.flagOnce) continue;
                return;
            }
        }
    }
}

