/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DetectRule
implements Rule {
    protected String ruleName = null;
    protected String ruleDescription = null;
    protected FlagOnce flagOnceType = FlagOnce.NONE;
    protected boolean flagOnce = false;
    protected boolean hideResult = false;
    protected List<DetailResult> detailResults = new ArrayList<DetailResult>();
    protected Set<String> modulesFlagged = new HashSet<String>();
    protected Set<String> filesFlagged = new HashSet<String>();
    protected LinkedHashSet<String> recipes = null;

    public DetectRule() {
    }

    public DetectRule(String ruleName, String desc, boolean flagOnce) {
        this(ruleName, desc, flagOnce ? FlagOnce.ARCHIVE : FlagOnce.NONE);
    }

    public DetectRule(String ruleName, String desc, FlagOnce flagOnceType) {
        this(ruleName, desc, flagOnceType, false);
    }

    public DetectRule(String ruleName, String desc, FlagOnce flagOnceType, boolean hideResult) {
        this.ruleName = ruleName;
        this.ruleDescription = Messages.getRuleDescription(desc);
        this.flagOnceType = flagOnceType;
        this.hideResult = hideResult;
        this.flagOnce = flagOnceType != FlagOnce.NONE;
    }

    @Override
    public boolean detectRule(SimpleDataStore store) {
        List<DetailResult> results = this.getResults(store);
        return results != null && !results.isEmpty();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce, RuleType type) {
        if (type == null || this.getRuleTypes().contains((Object)type)) {
            this.analyze(store, detectOnce);
        }
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    public String getRuleDescription() {
        return this.ruleDescription;
    }

    @Override
    public boolean isFlagOnce() {
        return this.flagOnce;
    }

    @Override
    public void setRecipes(String[] recipes) {
        if (recipes != null) {
            this.recipes = new LinkedHashSet(recipes.length);
            String[] stringArray = recipes;
            int n = recipes.length;
            int n2 = 0;
            while (n2 < n) {
                String recipe = stringArray[n2];
                this.recipes.add(recipe);
                ++n2;
            }
        }
    }

    @Override
    public LinkedHashSet<String> getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean shouldHideResult() {
        return this.hideResult;
    }

    @Override
    public FlagOnce getFlagOnceType() {
        return this.flagOnceType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        return this.detailResults;
    }

    @Override
    public void clearResults() {
        this.detailResults = new ArrayList<DetailResult>();
        this.modulesFlagged.clear();
        this.filesFlagged.clear();
    }

    @Override
    public String[] getClassNames() {
        return new String[0];
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public String[] getAnnotations() {
        return new String[0];
    }

    @Override
    public String getEnum() {
        return null;
    }

    @Override
    public String[] getFileNames() {
        return new String[0];
    }

    @Override
    public Set<String> getModulesFlagged() {
        return this.modulesFlagged;
    }

    @Override
    public Set<String> getFilesFlagged() {
        return this.filesFlagged;
    }

    @Override
    public boolean shouldFlag(String fileName) {
        String moduleName;
        return !(this.flagOnceType == FlagOnce.ARCHIVE ? this.modulesFlagged.contains(moduleName = this.getModuleName(fileName)) : this.flagOnceType == FlagOnce.FILE && this.filesFlagged.contains(fileName));
    }

    @Override
    public boolean flag(String fileName) {
        if (this.flagOnceType == FlagOnce.ARCHIVE) {
            String moduleName = this.getModuleName(fileName);
            if (!this.modulesFlagged.contains(moduleName)) {
                this.modulesFlagged.add(moduleName);
                return true;
            }
            return false;
        }
        if (this.flagOnceType == FlagOnce.FILE) {
            if (!this.filesFlagged.contains(fileName)) {
                this.filesFlagged.add(fileName);
                return true;
            }
            return false;
        }
        return true;
    }

    protected String getModuleName(String fileName) {
        String path = fileName;
        int index = fileName.lastIndexOf(47);
        while (index > -1) {
            if (Constants.ARCHIVE_EXTENSION_REGEX.matcher(path = path.substring(0, index)).matches()) break;
            index = path.lastIndexOf(47);
        }
        if (index < 0) {
            path = fileName;
        }
        return path;
    }

    public static enum FlagOnce {
        ARCHIVE,
        FILE,
        NONE;

    }

    public static enum XMLFileType {
        SPRING("spring"),
        ALL("all");

        private static final Map<String, XMLFileType> stringToXMLFileType;
        private final String name;

        static {
            stringToXMLFileType = new HashMap<String, XMLFileType>();
            for (XMLFileType xft : EnumSet.allOf(XMLFileType.class)) {
                stringToXMLFileType.put(xft.name, xft);
            }
        }

        private XMLFileType(String name2) {
            this.name = name2;
        }

        public static XMLFileType getXMLFileType(String s) {
            XMLFileType requestedFileType = stringToXMLFileType.get(s);
            return requestedFileType != null ? requestedFileType : ALL;
        }
    }
}

