/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansXmlElementsNotEnabled
extends DetectElement {
    protected static final String RULE_NAME = "BeansXmlElementsNotEnabled";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.BeansXmlElementsNotEnabled";
    protected static final String INTERCEPTORS = "interceptors";
    protected static final String DECORATORS = "decorators";
    protected static final String ALTERNATIVES = "alternatives";
    protected static final String[] fileNames = new String[]{"META-INF/beans.xml"};
    protected static final String namespace = "*";
    protected static final String[] tags = new String[]{"interceptors", "decorators", "alternatives"};
    protected Set<String> _filesWithBeanDiscoveryModeNoneSet = new HashSet<String>();
    protected Set<String> _filesWithBeanDiscoveryModeNoneNotSet = new HashSet<String>();
    protected Set<String> _filesWithInterceptorsFlagged = new HashSet<String>();
    protected Set<String> _filesWithDecoratorsFlagged = new HashSet<String>();
    protected Set<String> _filesWithAlternativesFlagged = new HashSet<String>();

    public BeansXmlElementsNotEnabled() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, namespace, false, null, null, null, false);
    }

    public BeansXmlElementsNotEnabled(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._filesWithBeanDiscoveryModeNoneSet.clear();
        this._filesWithBeanDiscoveryModeNoneNotSet.clear();
        this._filesWithInterceptorsFlagged.clear();
        this._filesWithDecoratorsFlagged.clear();
        this._filesWithAlternativesFlagged.clear();
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource resource) {
        String name2;
        if (key.indexOf(".war/") > -1 || this._filesWithBeanDiscoveryModeNoneSet.contains(key)) {
            return false;
        }
        if (!this._filesWithBeanDiscoveryModeNoneNotSet.contains(key)) {
            Node parentNode = result.getParentNode();
            NamedNodeMap attrMap = parentNode.getAttributes();
            Node item = attrMap.getNamedItem("bean-discovery-mode");
            if (item != null && item.getNodeValue().equals("none")) {
                this._filesWithBeanDiscoveryModeNoneSet.add(key);
                return false;
            }
            this._filesWithBeanDiscoveryModeNoneNotSet.add(key);
        }
        if (!((name2 = result.getLocalName()).equals(INTERCEPTORS) && this._filesWithInterceptorsFlagged.contains(key) || name2.equals(DECORATORS) && this._filesWithDecoratorsFlagged.contains(key) || name2.equals(ALTERNATIVES) && this._filesWithAlternativesFlagged.contains(key) || !this.isClassDefined(result))) {
            if (name2.equals(INTERCEPTORS)) {
                this._filesWithInterceptorsFlagged.add(key);
            } else if (name2.equals(DECORATORS)) {
                this._filesWithDecoratorsFlagged.add(key);
            } else if (name2.equals(ALTERNATIVES)) {
                this._filesWithAlternativesFlagged.add(key);
            }
            return true;
        }
        return false;
    }

    public boolean isClassDefined(Node nd) {
        Node childNd = XMLRuleUtil.getFirstChildNode(nd, "class");
        return childNd != null;
    }
}

