/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.CoreJspNodeModelMapper;
import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.model.TagLibInfo;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectJspTaglib;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class BehaviorTaglibPrefixRedefinition
extends DetectJspTaglib {
    protected static final String RULE_NAME = "BehaviorTaglibPrefixRedefinition";
    protected static final String RULE_DESC = "appconversion.was2was.70.websphere.BehaviorTaglibPrefixRedefinition";
    List<String> listOfBaseJsps = new ArrayList<String>();
    Map<String, List<JspNode>> mapOfJspDirectiveNodes = new HashMap<String, List<JspNode>>();
    Map<String, List<String>> mapOfIncludeNode = new HashMap<String, List<String>>();
    List<String> processedJSPFiles = null;
    List<DetailResult> finalResults = null;
    String baseFileName;
    int baseJspCurrentIndex = -1;

    public BehaviorTaglibPrefixRedefinition() {
        this(RULE_NAME, RULE_DESC, (String[])null, false);
    }

    public BehaviorTaglibPrefixRedefinition(String ruleName, String desc, String[] taglibs, boolean flagOnce) {
        super(ruleName, desc, taglibs, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.listOfBaseJsps.clear();
        this.mapOfJspDirectiveNodes.clear();
        this.mapOfIncludeNode.clear();
        if (this.processedJSPFiles != null) {
            this.processedJSPFiles.clear();
        }
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                JSPResource jspResource = store.getJsp(key);
                if (key.endsWith(".jsp")) {
                    this.listOfBaseJsps.add(key);
                }
                ArrayList<String> includeNodeFileURLs = new ArrayList<String>();
                List<JspNode> directiveNodes = CoreJspHelper.filterForNodeType(jspResource.getJSPNodes(), JspNodeType.DIRECTIVE);
                for (JspNode jspNode : directiveNodes) {
                    String data = jspNode.getData();
                    String url = null;
                    if (!data.contains("include") || !jspNode.getData().contains("file") || (url = CoreJspNodeModelMapper.getAttributeValue("file", data).getValue()) == null) continue;
                    includeNodeFileURLs.add(url);
                }
                if (directiveNodes != null) {
                    this.mapOfJspDirectiveNodes.put(key, directiveNodes);
                }
                if (includeNodeFileURLs.isEmpty()) continue;
                this.mapOfIncludeNode.put(key, includeNodeFileURLs);
            }
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this.finalResults = new ArrayList<DetailResult>();
        if (!this.listOfBaseJsps.isEmpty()) {
            for (String key : this.listOfBaseJsps) {
                ++this.baseJspCurrentIndex;
                this.baseFileName = this.getBaseFile(key);
                this.processedJSPFiles = new ArrayList<String>();
                Map<String, TagLibInfo> allTaglibs = this.getTaglibs(key);
                this.processedJSPFiles.add(key);
                this.checkRedundantTaglib(allTaglibs, key);
            }
        }
        return this.finalResults;
    }

    String getBaseFile(String key) {
        String fileName = "";
        int index = key.indexOf(".war");
        if (index > -1) {
            fileName = key.substring(0, index + 4);
        }
        return fileName;
    }

    private void checkRedundantTaglib(Map<String, TagLibInfo> previousTaglibs, String key) {
        List<String> staticIncludes = this.mapOfIncludeNode.get(key);
        if (staticIncludes != null) {
            for (String si : staticIncludes) {
                Set<String> keySet = this.mapOfJspDirectiveNodes.keySet();
                String includeFileURL = null;
                for (String item : keySet) {
                    if (!item.startsWith(this.baseFileName) || !item.endsWith(si)) continue;
                    includeFileURL = item;
                    break;
                }
                if (includeFileURL != null) {
                    if (this.processedJSPFiles.contains(includeFileURL)) continue;
                    this.processedJSPFiles.add(includeFileURL);
                    Map<String, TagLibInfo> includedTaglibs = this.getTaglibs(includeFileURL);
                    this.flagRedundantPrefix(previousTaglibs, includedTaglibs, includeFileURL, key);
                    this.checkRedundantTaglib(previousTaglibs, includeFileURL);
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Report_Included_Jsp_Not_Found"), this.getRuleDescription(), si, key));
            }
        }
    }

    private Map<String, TagLibInfo> getTaglibs(String jspResource) {
        HashMap<String, TagLibInfo> tagPrefixToURIMap = new HashMap<String, TagLibInfo>();
        List<JspNode> directiveNodes = this.mapOfJspDirectiveNodes.get(jspResource);
        for (JspNode jspNode : directiveNodes) {
            TagLibInfo tli = CoreJspNodeModelMapper.getTagLibInfo(jspNode);
            if (tli == null) continue;
            String prefix = tli.getPrefix();
            if (tagPrefixToURIMap.containsKey(prefix)) {
                this.addResult(jspNode, jspResource, ((TagLibInfo)tagPrefixToURIMap.get(prefix)).getNode(), true);
            }
            tagPrefixToURIMap.put(prefix, tli);
        }
        return tagPrefixToURIMap;
    }

    private void flagRedundantPrefix(Map<String, TagLibInfo> previousTaglibs, Map<String, TagLibInfo> includedTaglibs, String fileName, String redefinedLocation) {
        Set<String> keys = includedTaglibs.keySet();
        for (String key : keys) {
            if (previousTaglibs.containsKey(key)) {
                if (previousTaglibs.get(key).getUri().equals(includedTaglibs.get(key).getUri())) continue;
                JspNode jspNode = includedTaglibs.get(key).getNode();
                this.addResult(jspNode, fileName, previousTaglibs.get(key).getNode(), false);
                continue;
            }
            previousTaglibs.put(key, includedTaglibs.get(key));
        }
    }

    private void addResult(JspNode jspNode, String key, JspNode redefinedNode, boolean sameFile) {
        String jspFileName = this.listOfBaseJsps.get(this.baseJspCurrentIndex);
        int lastIndexofSlash = jspFileName.lastIndexOf(47);
        jspFileName = jspFileName.substring(lastIndexofSlash + 1);
        DetailResult result = sameFile ? new DetailResult(this.ruleName, key, this.ruleDescription, Messages.getFormattedMessage(Messages.getString("Report_Taglib_Prefix_Redefined_Same_File"), redefinedNode.getData(), jspNode.getData()), 1, null, jspNode.getLine()) : new DetailResult(this.ruleName, key, this.ruleDescription, Messages.getFormattedMessage(Messages.getString("Report_Taglib_Prefix_Redefined"), redefinedNode.getData(), jspNode.getData(), jspFileName), 1, null, jspNode.getLine());
        if (!this.finalResults.contains(result)) {
            this.finalResults.add(result);
        }
    }
}

