/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectHibernateConfig
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectHibernateConfig";
    protected static final String RULE_DESC = "appconversion.framework.hibernate.configuration";
    protected static final String[] className = new String[]{"org.hibernate.cfg.Configuration"};
    protected static final String HIBERNATE_PROPERTIES_FILE = ".*/hibernate\\.properties";
    protected static final String HIBERNATE_CFG_XML_FILE = "/hibernate.cfg.xml";
    protected static final String XML_FILE = ".xml";
    protected static final String FACTORY_CLASS_VALUE = "hibernate.transaction.factory_class";
    protected static final String MANAGER_LOOKUP_VALUE = "hibernate.transaction.manager_lookup_class";
    protected static final String USER_TRANSACTION_VALUE = "jta.UserTransaction";
    protected static final String PROPERTY_TAG = "property";
    protected static final String HIBERNATE_CONFIG_TAG = "hibernate-configuration";
    protected static final String[] allXMLFiles = new String[]{".xml", ".*/hibernate\\.properties"};
    protected static final Pattern[] hibernatePropertiesFiles = new Pattern[]{Pattern.compile(".*/hibernate\\.properties")};
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String NAME_ATTRIBUTE_VALUE_REG = "(hibernate\\.)?transaction\\.factory_class|(hibernate\\.)?transaction\\.manager_lookup_class|jta\\.UserTransaction|(hibernate\\.)?connection\\.datasource";
    private static final String factory_class_regex = "org\\.hibernate\\.transaction\\.(CMT|JTA)TransactionFactory";
    private static final String manager_lookup_regex = "org\\.hibernate\\.transaction\\.WebSphereExtendedJTATransactionLookup";
    private static final String user_transaction_regex = "java:comp/UserTransaction";
    private Set<String> flaggedHibernateConfigFiles = new HashSet<String>();
    DetectClass _detectConfigClass = null;
    DetectElement _detectHibConfigElement = null;
    DetectFile _detectHibPropFile = null;
    DetectAttribute _detectNameAttribute = null;

    public DetectHibernateConfig() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public DetectHibernateConfig(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this._detectConfigClass = new DetectClass(ruleName, desc, className, false, false, false, null, null, null, null, null, null);
        this._detectHibConfigElement = new DetectElement(ruleName, desc, new String[]{HIBERNATE_CONFIG_TAG}, new String[]{XML_FILE}, null, null, false, null, null, null, false);
        this._detectHibPropFile = new DetectFile(ruleName, desc, hibernatePropertiesFiles, false);
        this._detectNameAttribute = new DetectAttribute(RULE_NAME, RULE_DESC, new String[]{PROPERTY_TAG}, new String[]{HIBERNATE_CFG_XML_FILE}, null, NAME_ATTRIBUTE, NAME_ATTRIBUTE_VALUE_REG, null, false, null, null){

            @Override
            protected boolean includeInResults(String fileName, Node node) {
                boolean includeInResults = true;
                includeInResults = this.shouldFlag(node);
                if (includeInResults) {
                    DetectHibernateConfig.this.flaggedHibernateConfigFiles.add(fileName);
                }
                return includeInResults;
            }

            private boolean shouldFlag(Node node) {
                boolean shouldFlag = true;
                Element ownerNode = ((Attr)node).getOwnerElement();
                String nameValue = node.getNodeValue().trim();
                if (nameValue != null) {
                    if (nameValue.equals(DetectHibernateConfig.FACTORY_CLASS_VALUE)) {
                        shouldFlag = !this.isValidClass(ownerNode, DetectHibernateConfig.factory_class_regex);
                    } else if (nameValue.equals(DetectHibernateConfig.MANAGER_LOOKUP_VALUE)) {
                        shouldFlag = !this.isValidClass(ownerNode, DetectHibernateConfig.manager_lookup_regex);
                    } else if (nameValue.equals(DetectHibernateConfig.USER_TRANSACTION_VALUE)) {
                        shouldFlag = !this.isValidClass(ownerNode, DetectHibernateConfig.user_transaction_regex);
                    }
                }
                return shouldFlag;
            }

            private boolean isValidClass(Node node, String regex) {
                boolean isValidClass = false;
                String nodeText = XMLRuleUtil.getTextWithoutWhitespace(node);
                if (nodeText != null) {
                    isValidClass = nodeText.matches(regex);
                }
                return isValidClass;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectNameAttribute.clearResults();
        this._detectConfigClass.clearResults();
        this._detectHibConfigElement.clearResults();
        this._detectHibPropFile.clearResults();
        this.flaggedHibernateConfigFiles.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectNameAttribute.analyze(store, detectOnce);
        this._detectConfigClass.analyze(store, detectOnce);
        this._detectHibConfigElement.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allXMLFiles;
    }

    @Override
    public String[] getClassNames() {
        return className;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this._detectHibPropFile.analyze(store, false);
        List<DetailResult> finalResults = this._detectNameAttribute.getResults(store);
        finalResults.addAll(this._detectConfigClass.getResults(store));
        List<DetailResult> hibConfigResults = this._detectHibConfigElement.getResults(store);
        finalResults.addAll(this._detectHibPropFile.getResults(store));
        for (DetailResult result : hibConfigResults) {
            if (this.flaggedHibernateConfigFiles.contains(result.getFileName())) continue;
            finalResults.add(result);
        }
        return finalResults;
    }
}

