/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.rules.custom.DetectJAXRPCPrevalidatedExtraValidationRule;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DetectJAXRPCInvalid
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.FileRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectJAXRPCInvalid";
    protected static final String RULE_DESC = "com.ibm.rrd.liberty.rules.impl.java.DetectJAXRPCInvalid.rulename";
    protected static final String WEBSERVICESXML = "webservices.xml";
    protected static final String[] jaxrpcMappingFileXml = new String[]{"(.*/)?(META-INF|WEB-INF)/webservices\\.xml", "(.*/)?WEB-INF/web\\.xml", "(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml", "(.*/)?META-INF/application\\.xml"};
    protected static final String[] jaxrpcMappingFileTag = new String[]{"jaxrpc-mapping-file"};
    protected static final String[] jaxrpcPackage = new String[]{"javax.xml.rpc*"};
    protected static final String[] webservicesPackage = new String[]{"com.ibm.ws.webservices*"};
    protected static final String[] jaxrpcPackageImpl = new String[]{"javax.xml.rpc", "javax.xml.rpc.encoding", "javax.xml.rpc.handler", "javax.xml.rpc.handler.soap", "javax.xml.rpc.holders", "javax.xml.rpc.server", "javax.xml.rpc.soap", "org.apache.axis"};
    protected static final Pattern[] jaxrpcFiles = new Pattern[]{Pattern.compile(".*/ibm-webservices(client)?-(ext|bnd)\\.xmi$"), Pattern.compile(".*/ws-security\\.xml$")};
    protected DetectClass _detectRmiRemoteOrSessionBean = null;
    protected boolean foundRmiRemoteOrSessionbean = false;
    protected static final String[] webServiceExtendClassNames = new String[]{"java.rmi.Remote"};
    protected static final String[] webServiceImplementClassNames = new String[]{"javax.ejb.SessionBean"};
    protected DetectFile _detectJaxrpcFiles = null;
    protected DetectElement _detectJaxrpcElement = null;
    protected DetectPackage _detectJaxrpcPackages = null;
    protected DetectPackage _detectWebservicesPackages = null;
    protected DetectJAXRPCPrevalidatedExtraValidationRule _detectExtraValidation = null;

    public DetectJAXRPCInvalid() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public DetectJAXRPCInvalid(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this._detectJaxrpcFiles = new DetectFile(ruleName, desc, jaxrpcFiles, flagOnce);
        this._detectJaxrpcElement = new DetectElement(ruleName, desc, jaxrpcMappingFileTag, jaxrpcMappingFileXml, null, null, flagOnce, null, null, null, false);
        this._detectJaxrpcPackages = new DetectPackage(ruleName, desc, jaxrpcPackage, true, false, null, null, flagOnce);
        this._detectExtraValidation = new DetectJAXRPCPrevalidatedExtraValidationRule();
        this._detectWebservicesPackages = new DetectPackage(ruleName, desc, webservicesPackage, false, false, null, null, true);
        this._detectRmiRemoteOrSessionBean = new DetectClass(ruleName, desc, null, false, false, false, webServiceExtendClassNames, webServiceImplementClassNames, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                DetectJAXRPCInvalid.this.foundRmiRemoteOrSessionbean = true;
                return false;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectJaxrpcFiles.clearResults();
        this._detectJaxrpcElement.clearResults();
        this._detectJaxrpcPackages.clearResults();
        this._detectExtraValidation.clearResults();
        this._detectWebservicesPackages.clearResults();
        this.foundRmiRemoteOrSessionbean = false;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectJaxrpcElement.analyze(store, detectOnce);
        this._detectJaxrpcPackages.analyze(store, detectOnce);
        this._detectExtraValidation.analyze(store, detectOnce);
        this._detectRmiRemoteOrSessionBean.analyze(store, detectOnce);
        this._detectWebservicesPackages.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this._detectJaxrpcFiles.analyze(store, false);
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        finalResults.addAll(this._detectJaxrpcPackages.getResults(store));
        if (!finalResults.isEmpty() || this._detectWebservicesPackages.getResults(store).size() > 0 || this.foundRmiRemoteOrSessionbean) {
            finalResults.addAll(this._detectJaxrpcFiles.getResults(store));
            finalResults.addAll(this._detectJaxrpcElement.getResults(store));
            List<DetailResult> extraValidationResults = this._detectExtraValidation.getResults(store);
            this.logDetailResults(extraValidationResults, "DetectJAXRPC: extraValidationResults detections here mean the bytecode modifier cannot run:\n");
            if (this.isCorrectJAXRPCRule(extraValidationResults, store)) {
                return finalResults;
            }
        }
        return new ArrayList<DetailResult>();
    }

    public void logDetailResults(List<DetailResult> finalResults, String message) {
        if (finalResults != null && finalResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, String.valueOf(message) + finalResults.toString());
        }
    }

    @Override
    public String[] getFileNames() {
        ArrayList resultList = new ArrayList(jaxrpcMappingFileXml.length + this._detectExtraValidation.getFileNames().length);
        Collections.addAll(resultList, jaxrpcMappingFileXml);
        Collections.addAll(resultList, this._detectExtraValidation.getFileNames());
        String[] resultArr = (String[])Array.newInstance(jaxrpcMappingFileXml.getClass().getComponentType(), 0);
        return resultList.toArray(resultArr);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    public boolean isCorrectJAXRPCRule(List<DetailResult> extraValidationResults, SimpleDataStore store) {
        return (extraValidationResults != null && !extraValidationResults.isEmpty() || !store.isJAXRPCByteCodeModifierCandidate()) && !store.containsImplementedPackageNames(Arrays.asList(jaxrpcPackageImpl));
    }
}

