/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectJndiObjectFactoryBean
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectJndiObjectFactoryBean";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.jndiObjectFactoryBean";
    protected static final String XML_FILE = ".xml";
    protected static final String WEB_XML_FILE = "/web.xml";
    protected static final String PROPERTY_TAG = "property";
    protected static final String RES_REF_NAME_TAG = "res-ref-name";
    protected static final String NAME_ATTRIBUTE_VALUE_REG = "jndiName";
    protected static final String NAMESPACE = "*";
    protected static final Pattern CONTAINS_WAR_PATTERN = Pattern.compile(".*\\.war/.*");
    protected static final String JAVA_COMP_ENV = "java:comp/env/";
    protected SimpleDataStore store;
    Map<String, Set<String>> mapOfWarToResRefNames = new HashMap<String, Set<String>>();
    Map<String, String> mapOfBeanToJNDIValue = new HashMap<String, String>();
    DetectElement _detectResRefElement = null;

    public DetectJndiObjectFactoryBean() {
        this(RULE_NAME, RULE_DESC, new String[]{PROPERTY_TAG}, new String[]{XML_FILE}, DetectRule.XMLFileType.SPRING, null, "name", NAME_ATTRIBUTE_VALUE_REG, null, DetectRule.FlagOnce.NONE, null, null);
    }

    public DetectJndiObjectFactoryBean(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String attributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, xmlFileType, namespace, attributeName, attributeValue, attributeNamespace, flagOnceType, false, validateNamespace, documentNamespace);
        this._detectResRefElement = new DetectElement(ruleName, desc, new String[]{RES_REF_NAME_TAG}, new String[]{WEB_XML_FILE}, null, null, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                String warPath = ReportUtility.getLastArchiveFileName(key);
                Set<String> resRefNames = DetectJndiObjectFactoryBean.this.mapOfWarToResRefNames.get(warPath);
                if (resRefNames == null) {
                    resRefNames = new HashSet<String>();
                    DetectJndiObjectFactoryBean.this.mapOfWarToResRefNames.put(warPath, resRefNames);
                }
                resRefNames.add(XMLRuleUtil.getTextWithoutWhitespace(result));
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.store = store;
        super.analyze(store, detectOnce);
        this._detectResRefElement.analyze(store, detectOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectResRefElement.clearResults();
        this.mapOfWarToResRefNames.clear();
        this.mapOfBeanToJNDIValue.clear();
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        String jndiNameValue;
        Element ownerNode;
        Node parentNode;
        String classValue;
        boolean includeInResults = false;
        if (CONTAINS_WAR_PATTERN.matcher(fileName).matches() && (classValue = XMLRuleUtil.getAttributeValue((parentNode = (ownerNode = ((Attr)node).getOwnerElement()).getParentNode()).getAttributes(), NAMESPACE, "class")) != null && classValue.trim().equals("org.springframework.jndi.JndiObjectFactoryBean") && (jndiNameValue = XMLRuleUtil.getAttributeOrChildNodeValue(ownerNode, "value")) != null && jndiNameValue.length() != 0 && !jndiNameValue.contains("$") && !jndiNameValue.contains("{")) {
            List<Element> proxyInterfaceNode = XMLRuleUtil.getChildElementsByAttributeValue((Element)parentNode, NAMESPACE, PROPERTY_TAG, "name", "proxyInterface");
            for (Element el : proxyInterfaceNode) {
                String proxyInterfaceValue = XMLRuleUtil.getAttributeOrChildNodeValue(el, "value");
                if (proxyInterfaceValue == null || !proxyInterfaceValue.equals("javax.sql.DataSource")) continue;
                if (!jndiNameValue.startsWith(JAVA_COMP_ENV)) {
                    includeInResults = true;
                    continue;
                }
                includeInResults = true;
                XMLResource resource = this.store.getDocument(fileName);
                int attributeNameLine = resource.getNodeLineNumber(node);
                this.mapOfBeanToJNDIValue.put(String.valueOf(fileName) + attributeNameLine, jndiNameValue.substring(JAVA_COMP_ENV.length()));
            }
        }
        return includeInResults;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> jndiNamePropertyResults = super.getResults(store);
        for (DetailResult result : jndiNamePropertyResults) {
            String filePath = result.getFileName();
            String jndiValue = this.mapOfBeanToJNDIValue.get(String.valueOf(filePath) + result.getLineNumber());
            if (jndiValue == null) {
                finalResults.add(result);
                continue;
            }
            String warPath = ReportUtility.getLastArchiveFileName(filePath);
            Set<String> resRefNames = this.mapOfWarToResRefNames.get(warPath);
            if (resRefNames != null && resRefNames.contains(jndiValue)) continue;
            finalResults.add(result);
        }
        return finalResults;
    }
}

