/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.technology.DetailResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GetAnnotatedBehaviorChange
extends DetectClass {
    protected static final String RULE_NAME = "GetAnnotatedBehaviorChange";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.GetAnnotatedBehaviorChange";
    protected static final String[] implementsClasses = new String[]{"javax.enterprise.inject.spi.InjectionPoint"};
    protected static final String[] _methodNames = new String[]{"<init>"};
    protected static final String[] _owner = new String[]{"javax.enterprise.inject.spi.Annotated"};
    protected DetectMethod _detectAnnotatedConstructor = null;
    protected Set<String> classesImplementingInjectionPoint = new HashSet<String>();

    public GetAnnotatedBehaviorChange() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, null, implementsClasses, null, null, null, null);
    }

    public GetAnnotatedBehaviorChange(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs);
        this._detectAnnotatedConstructor = new DetectMethod(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNames, _owner, null, null, null, false, null, null, null);
    }

    @Override
    public String[] getMethodNames() {
        return _methodNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectAnnotatedConstructor.clearResults();
        this.classesImplementingInjectionPoint.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectAnnotatedConstructor.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> annotatedConstructorResults = this._detectAnnotatedConstructor.getResults(store);
        if (!annotatedConstructorResults.isEmpty()) {
            if (this.classesImplementingInjectionPoint.isEmpty()) {
                annotatedConstructorResults.clear();
            } else {
                Iterator<DetailResult> it = annotatedConstructorResults.iterator();
                while (it.hasNext()) {
                    DetailResult nextResult = it.next();
                    String fileName = nextResult.getFileName();
                    if (this.classesImplementingInjectionPoint.contains(fileName)) {
                        String ref = nextResult.getReference();
                        if (ref != null && ref.contains("getAnnotated")) continue;
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
        }
        return annotatedConstructorResults;
    }

    @Override
    protected boolean flagImplementsClass(ClassDataStore data, String fileName, boolean detectOnce) {
        if (super.flagImplementsClass(data, fileName, detectOnce)) {
            this.classesImplementingInjectionPoint.add(fileName);
        }
        return false;
    }
}

