/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ImplicitCDIBehaviorChange
extends DetectClass {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "ImplicitCDIBehaviorChange";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.ImplicitCDIBehaviorChange";
    protected static final String[] folders = new String[]{"META-INF, WEB-INF, WEB-INF/classes/META-INF"};
    protected static final Pattern[] path = new Pattern[]{Pattern.compile(".*(\\.war|\\.jar)")};
    protected static final String[] files = new String[]{"beans.xml"};
    protected static final String[] classNames = new String[]{"javax.enterprise.context.ApplicationScoped", "javax.enterprise.context.ConversationScoped", "javax.enterprise.context.Dependent", "javax.enterprise.context.NormalScope", "javax.enterprise.context.RequestScoped", "javax.enterprise.context.SessionScoped", "javax.enterprise.inject.Stereotype", "javax.decorator.Decorator", "javax.interceptor.Interceptor", "javax.ejb.Stateful", "javax.ejb.Stateless", "javax.ejb.Singleton"};
    protected DetectFile _missingBeansXml = new DetectFile("ImplicitCDIBehaviorChange", "appconversion.javaee7.cdi.ImplicitCDIBehaviorChange", path, false, folders, files, true, false, false);

    public ImplicitCDIBehaviorChange() {
        this(RULE_NAME, RULE_DESC, classNames);
    }

    public ImplicitCDIBehaviorChange(String ruleName, String desc, String[] classNames) {
        super(ruleName, desc, classNames);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._missingBeansXml.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this._missingBeansXml.analyze(store, false);
        List<DetailResult> parentResults = super.getResults(store);
        if (!parentResults.isEmpty()) {
            List<DetailResult> missingBeansXmlResults = this._missingBeansXml.getResults(store);
            HashSet<String> missingBeansXmlSet = new HashSet<String>();
            if (missingBeansXmlResults.isEmpty()) {
                parentResults.clear();
            } else {
                for (DetailResult result : missingBeansXmlResults) {
                    missingBeansXmlSet.add(result.getFileName());
                }
                Iterator<DetailResult> itr = parentResults.iterator();
                int position = -1;
                String jarString = ".jar";
                String warString = ".war";
                String shortName = null;
                while (itr.hasNext()) {
                    DetailResult result = itr.next();
                    String name2 = result.getFileName();
                    if (name2.contains(jarString)) {
                        position = name2.lastIndexOf(jarString);
                        shortName = name2.substring(0, position + 4);
                    } else if (name2.contains(warString)) {
                        position = name2.lastIndexOf(warString);
                        shortName = name2.substring(0, position + 4);
                    }
                    if (shortName != null && missingBeansXmlSet.contains(shortName)) continue;
                    itr.remove();
                }
            }
        }
        return parentResults;
    }
}

