/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InterceptorBindingAnnotationCheck
extends DetectAnnotation {
    protected static final String RULE_NAME = "InterceptorBindingAnnotationCheck";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.InterceptorBindingAnnotationCheck";
    protected static final String[] lifecycleAnnoNames = new String[]{"javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.ejb.PostActivate", "javax.ejb.PrePassivate", "javax.interceptor.AroundConstruct"};
    protected static final String interceptorAnnotation = "javax.interceptor.Interceptor";
    protected static final String interceptorBindingAnnotation = "javax.interceptor.InterceptorBinding";
    protected static final String targetAnnotation = "java.lang.annotation.Target";
    protected static final String targetAnnotationValue = "javax.lang.annotation.ElementType";
    protected static final String targetAnnotationValueTYPE = "TYPE";
    protected static final String[] targetAnnoClassNames = new String[]{"java.lang.annotation.Target"};
    protected static final String attrType = "java.lang.annotation.ElementType";
    protected static final String attrName = "value";
    protected static final String[] attrValues = new String[]{".+"};
    Map<String, String> classesWithMultipleTargets = new HashMap<String, String>();
    Set<String> annosOnClassesWithLifecycleAnnos = new HashSet<String>();
    protected DetectAnnotation _detectTarget = new DetectAnnotation("InterceptorBindingAnnotationCheck", "appconversion.javaee7.cdi.InterceptorBindingAnnotationCheck", targetAnnoClassNames, "value", null, null, null, null, false, "interface", null, null){

        @Override
        protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
            Set<AnnotationInfo> ais = ad.getAnnotationInformation(InterceptorBindingAnnotationCheck.attrType);
            if (ais.size() > 0) {
                String className = data.getClassName();
                ArrayList<String> values = new ArrayList<String>();
                for (AnnotationInfo ai : ais) {
                    values.add(ai.getAttributeValue());
                }
                if (values.contains(InterceptorBindingAnnotationCheck.targetAnnotationValueTYPE) && values.size() > 1 && data.doesContainClassAnnotation(InterceptorBindingAnnotationCheck.interceptorBindingAnnotation)) {
                    InterceptorBindingAnnotationCheck.this.classesWithMultipleTargets.put(key, className);
                    return true;
                }
            }
            return false;
        }
    };
    protected static final String[] annoNames = new String[]{lifecycleAnnoNames[0], lifecycleAnnoNames[1], lifecycleAnnoNames[2], lifecycleAnnoNames[3], lifecycleAnnoNames[4], "java.lang.annotation.Target"};

    public InterceptorBindingAnnotationCheck() {
        this(RULE_NAME, RULE_DESC, lifecycleAnnoNames, null, null, null, null, null, false, "method", null, null);
    }

    public InterceptorBindingAnnotationCheck(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    public String[] getAnnotations() {
        return annoNames;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        if (data.doesContainClassAnnotation(interceptorAnnotation)) {
            Set<String> allAnnos = data.getClassAnnotations();
            this.annosOnClassesWithLifecycleAnnos.addAll(allAnnos);
        }
        return false;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectTarget.clearResults();
        this.classesWithMultipleTargets.clear();
        this.annosOnClassesWithLifecycleAnnos.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectTarget.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> finalResults = this._detectTarget.getResults(store);
        Iterator<DetailResult> it = finalResults.iterator();
        while (it.hasNext()) {
            DetailResult nextResult = it.next();
            String fileName = nextResult.getFileName();
            String className = this.classesWithMultipleTargets.get(fileName);
            if (this.annosOnClassesWithLifecycleAnnos.contains(className)) continue;
            it.remove();
        }
        return finalResults;
    }
}

