/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ReferenceCloneMethod
extends DetectClass {
    protected static final String RULE_NAME = "ReferenceCloneMethod";
    protected static final String RULE_DESC = "appconversion.jre.189.ReferenceCloneMethod";
    protected static final String[] extendClassNames = new String[]{"java.lang.ref.Reference", "java.lang.ref.PhantomReference", "java.lang.ref.SoftReference", "java.lang.ref.WeakReference"};
    protected static final String[] _methodNames = new String[]{"clone"};
    protected static final String[] _owner = new String[]{"java.lang.Object"};
    protected DetectMethod _detectCloneMethod = null;
    List<String> classesExtendReference = new ArrayList<String>();

    public ReferenceCloneMethod() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, extendClassNames, null, null, null, null, null);
        ruleType = EnumSet.of(RuleType.JavaRule);
    }

    public ReferenceCloneMethod(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs);
        this._detectCloneMethod = new DetectMethod(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNames, _owner, null, null, null, false, null, null, null);
    }

    @Override
    public String[] getMethodNames() {
        return _methodNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectCloneMethod.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectCloneMethod.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(ClassDataStore data, String filename) {
        this.classesExtendReference.add(filename);
        return false;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> results = new ArrayList<DetailResult>();
        if (!this.classesExtendReference.isEmpty()) {
            List<DetailResult> cloneMethodResults = this._detectCloneMethod.getResults(store);
            for (DetailResult cloneResult : cloneMethodResults) {
                String fileName = cloneResult.getFileName();
                if (!this.classesExtendReference.contains(fileName)) continue;
                results.add(cloneResult);
            }
        }
        return results;
    }
}

