/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TransientFieldInSessionScope
extends DetectAnnotation {
    protected static final String RULE_NAME = "TransientFieldInSessionScope";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.TransientFieldInSessionScope";
    protected static final String[] classNames = new String[]{"javax.enterprise.context.SessionScoped"};
    protected List<DetailResult> transientFields = new ArrayList<DetailResult>();

    public TransientFieldInSessionScope() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "class", null, null);
    }

    public TransientFieldInSessionScope(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.transientFields = new ArrayList<DetailResult>();
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        Set<String> fieldNames = data.getFieldsForModifier(128, 2);
        if (fieldNames != null && !fieldNames.isEmpty()) {
            for (String fname : fieldNames) {
                this.transientFields.add(new DetailResult(RULE_NAME, key, this.getRuleDescription(), "transient", 1, Messages.getFormattedMessage(Messages.getString("Report_Reference_Field"), fname), 0));
            }
        }
        return false;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        return this.transientFields;
    }
}

