/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserTransactionLookups
extends DetectMethod {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "UserTransactionLookups";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.user.transaction";
    protected static final String ASTRIX = "*";
    protected static String[] lookupMethodName = new String[]{"lookup"};
    protected static String[] anyMethodOwner = new String[]{"*"};
    protected static final String ARGS = "java.lang.String";
    protected static final String STRING_LITERAL_VALUE = "(weblogic|javax)\\.transaction\\.UserTransaction";
    protected static final String EJB_CLASS_TAG = "ejb-class";
    protected static final String PERSISTENCE_TYPE_TAG = "persistence-type";
    protected static final String PERSISTENCE_TYPE_VALUE = "Container";
    protected static final String[] ejbJarFile = new String[]{"/ejb-jar.xml"};
    DetectElement detectCMTBean = null;
    protected Set<String> cmtList = new HashSet<String>();
    protected static List<ArgumentDetail> lookUpMethodDetails = new ArrayList<ArgumentDetail>();

    static {
        lookUpMethodDetails.add(new ArgumentDetail(0, false, false, STRING_LITERAL_VALUE, null, null));
    }

    public UserTransactionLookups() {
        this(RULE_NAME, RULE_DESC, lookupMethodName, anyMethodOwner, null, ARGS, null, DetectRule.FlagOnce.NONE, lookUpMethodDetails, null, null, false);
    }

    public UserTransactionLookups(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, DetectRule.FlagOnce flagOnceType, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions, boolean mapKeysAndValuesOneToOne) {
        super(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnceType, false, argDetails, flagCatchExceptions, flagUnhandledExceptions, mapKeysAndValuesOneToOne);
        this.detectCMTBean = new DetectElement(RULE_NAME, RULE_DESC, new String[]{PERSISTENCE_TYPE_TAG}, ejbJarFile, DetectRule.XMLFileType.ALL, false, PERSISTENCE_TYPE_VALUE, ASTRIX, DetectRule.FlagOnce.NONE, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                List<Element> cmtClassElements = XMLRuleUtil.getChildElements((Element)result.getParentNode(), UserTransactionLookups.ASTRIX, UserTransactionLookups.EJB_CLASS_TAG);
                for (Element el : cmtClassElements) {
                    UserTransactionLookups.this.cmtList.add(XMLRuleUtil.getTextWithoutWhitespace(el));
                }
                return false;
            }
        };
    }

    protected boolean flagCMTBean() {
        return false;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.detectCMTBean.clearResults();
        this.cmtList.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.detectCMTBean.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return ejbJarFile;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> results = new ArrayList<DetailResult>();
        for (DetailResult result : super.getResults(store)) {
            String fileName = result.getFileName();
            String qualifiedClassName = ReportUtility.getQualifiedClassName(fileName);
            if (this.cmtList.contains(qualifiedClassName) != this.flagCMTBean()) continue;
            results.add(result);
        }
        return results;
    }
}

