/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class CountJAXRS
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.jaxrsProviders";
    protected static final String[] classNameProviders = new String[]{"javax.ws.rs.Consumes", "javax.ws.rs.Produces", "javax.ws.rs.DELETE", "javax.ws.rs.GET", "javax.ws.rs.HEAD", "javax.ws.rs.OPTIONS", "javax.ws.rs.POST", "javax.ws.rs.PUT"};
    protected Set<String> _classNamesFlaggedProviders = new HashSet<String>();

    public CountJAXRS() {
        this("CountJAXRSProviders", RULE_DESC, classNameProviders, null, null, null, null, null, false, null, null, null);
    }

    public CountJAXRS(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._classNamesFlaggedProviders.clear();
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
        if (!shouldScan || this._classNamesFlaggedProviders.contains(key)) {
            return false;
        }
        this._classNamesFlaggedProviders.add(key);
        return true;
    }
}

