/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CountJAXWS
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.jaxwsConsumers";
    protected static final String[] classNameProviders = new String[]{"javax.xml.ws.WebServiceRef", "javax.xml.ws.WebServiceRefs", "javax.xml.ws.WebServiceClient"};
    protected static final String[] _methodNameCreateDispatch = new String[]{"createDispatch", "create"};
    protected static final String[] _ownerCreateDispatch = new String[]{"javax.xml.ws.Service"};
    protected Set<String> _classNamesFlaggedConsumers = new HashSet<String>();
    protected DetectMethod _createService = null;

    public CountJAXWS() {
        this("CountJAXWSConsumers", RULE_DESC, classNameProviders, null, null, null, null, null, false, null, null, null);
    }

    public CountJAXWS(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._createService = new DetectMethod(ruleName, RULE_DESC, _methodNameCreateDispatch, _ownerCreateDispatch, null, null, null, false, null, null, null){

            @Override
            protected boolean includeInResults(MethodDetails md, MethodInfo mi, ArrayDeque<StackDetails> sdd, String filename) {
                boolean shouldScan = ReportUtility.shouldScanClassFileForRules(filename);
                return shouldScan;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._createService.clearResults();
        this._classNamesFlaggedConsumers.clear();
    }

    @Override
    public String[] getMethodNames() {
        return _methodNameCreateDispatch;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._createService.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
        if (!shouldScan || this._classNamesFlaggedConsumers.contains(key)) {
            return false;
        }
        this._classNamesFlaggedConsumers.add(key);
        return true;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> methodResults = this._createService.getResults(store);
        if (!methodResults.isEmpty()) {
            Iterator<DetailResult> it = methodResults.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                String fileName = nextResult.getFileName();
                if (this._classNamesFlaggedConsumers.contains(fileName)) {
                    it.remove();
                    continue;
                }
                this._classNamesFlaggedConsumers.add(fileName);
            }
        }
        parentResults.addAll(methodResults);
        return parentResults;
    }
}

