/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.rules.custom.inventory.JavaEEImplementationsAlreadyProvided;
import com.ibm.ws.report.binary.rules.custom.inventory.WebSphereImplementation;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class CountJarFiles
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.JarFiles";
    protected static final String UNREFERENCED_RULE_DESCRIPTION = "com.ibm.ws.report.binary.java.UnreferencedArchives";
    private static List<Pattern> _packagesToExcludeForInventory = new ArrayList<Pattern>();
    public List<String> allClassFiles = new ArrayList<String>();
    protected static final String[] classNames;
    protected static final Pattern[] ejbJarfileNames;
    protected static final Pattern[] webFragmentfileNames;
    protected static final Pattern[] classfileNames;
    protected static final Pattern[] appClientFileNames;
    protected static final String[] applicationXmlFile;
    protected static final String[] tags;
    protected static final Pattern[] jarFileNames;
    protected DetectFile _applicationClientFiles = null;
    protected DetectFile _ejbJarFiles = null;
    protected DetectFile _webFragmentFiles = null;
    protected DetectFile _jarFiles = null;
    protected DetectFile _classFiles = null;
    protected Set<String> unusedJars = new HashSet<String>();
    protected Set<String> processedPackageImplemenations = new HashSet<String>();
    protected Set<String> usedPackageImplementaions = new HashSet<String>();
    protected Set<String> setOfUtilityJars = new HashSet<String>();
    protected Map<String, Set<String>> mapOfArchiveToPackagesItReferences = new HashMap<String, Set<String>>();
    Map<String, Set<String>> mapOfJarReferencedLocationChecksums = new HashMap<String, Set<String>>();
    Map<String, Set<String>> mapOfJarReferencedByArch = new HashMap<String, Set<String>>();
    protected DetectElement _appClientModules = null;
    protected DetectAttribute _attributeClassDefinitions = null;
    protected DetectElement _tagClassDefinitions = null;
    protected String[] allXmlFiles = new String[]{".*\\.xml"};
    Pattern qualifiedClassWithPackagePattern = Pattern.compile("(?:[a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*");
    protected Set<String> appClients = new HashSet<String>();
    protected Map<String, Set<String>> packagesPerArchive = new HashMap<String, Set<String>>();

    static {
        _packagesToExcludeForInventory.addAll(WebSphereImplementation.getWSPackages());
        _packagesToExcludeForInventory.addAll(JavaEEImplementationsAlreadyProvided.getJavaEESEPackages());
        classNames = new String[]{"javax.ejb.Stateful", "javax.ejb.Stateless", "javax.ejb.Singleton", "javax.ejb.MessageDriven"};
        ejbJarfileNames = new Pattern[]{Pattern.compile(".*/META-INF/ejb-jar\\.xml")};
        webFragmentfileNames = new Pattern[]{Pattern.compile(".*/META-INF/web-fragment\\.xml")};
        classfileNames = new Pattern[]{Pattern.compile(".*\\.class$")};
        appClientFileNames = new Pattern[]{Pattern.compile(".*/META-INF/application-client\\.xml")};
        applicationXmlFile = new String[]{"META-INF/application.xml"};
        tags = new String[]{"java"};
        jarFileNames = new Pattern[]{Pattern.compile("(.*/)?.+\\.jar")};
    }

    public CountJarFiles() {
        this("CountEJBJarFiles", RULE_DESC, classNames, null, null, null, null, null, true, "class", null, null);
    }

    public CountJarFiles(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._applicationClientFiles = new DetectFile("CountApplicationClients", RULE_DESC, appClientFileNames, false);
        this._ejbJarFiles = new DetectFile("CountEJBJarFiles", RULE_DESC, ejbJarfileNames, false);
        this._webFragmentFiles = new DetectFile("CountWebFragmentFiles", RULE_DESC, webFragmentfileNames, false);
        this._jarFiles = new DetectFile("CountUtilityJarFiles", RULE_DESC, jarFileNames, false);
        this._classFiles = new DetectFile("", "", classfileNames, false){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                CountJarFiles.this.allClassFiles.addAll(store.getMatchingFileNames(this.files[0], false, true));
                for (Map.Entry<String, Set<String>> entry : store.getMapReferencedPackageNames().entrySet()) {
                    String key = entry.getKey();
                    Set<String> value = entry.getValue();
                    Set<String> packages = CountJarFiles.this.mapOfArchiveToPackagesItReferences.get(key);
                    if (packages == null) {
                        packages = new HashSet<String>();
                        CountJarFiles.this.mapOfArchiveToPackagesItReferences.put(key, packages);
                    }
                    packages.addAll(value);
                }
            }
        };
        this._appClientModules = new DetectElement("CountApplicationClients", RULE_DESC, tags, applicationXmlFile, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String moduleName = XMLRuleUtil.getTextWithoutWhitespace(node);
                if (moduleName != null) {
                    String path = fileName.substring(0, fileName.lastIndexOf("META-INF"));
                    CountJarFiles.this.appClients.add(String.valueOf(path) + moduleName);
                }
                return false;
            }
        };
        this._attributeClassDefinitions = new DetectAttribute("attributeClassDefinitions", "attributeClassDefinitions", new String[]{"action", "bean", "embeddable", "entity", "entity-result", "form-bean", "id-class", "named-native-query"}, this.allXmlFiles, null, ".*", ".*", null, false, null, null){
            Set<String> interestedAttributeNames;
            {
                this.interestedAttributeNames = new HashSet<String>(Arrays.asList("class", "entity-class", "result-class", "type"));
            }

            @Override
            protected boolean includeInResults(String fileName, Node node) {
                String attributeName = node.getLocalName();
                if (this.interestedAttributeNames.contains(attributeName)) {
                    String qualifiedClassName = XMLRuleUtil.getTextWithoutWhitespace(node);
                    CountJarFiles.this.addXmlReference(qualifiedClassName, fileName);
                }
                return false;
            }
        };
        this._tagClassDefinitions = new DetectElement("tagClassDefinitions", "tagClassDefinitions", new String[]{"component-class", "ejb-class", "filter-class", "key-class", "injection-target-class", "listener-class", "managed-bean-class", "servlet-class", "source-class", "system-event-class", "system-event-listener-class", "value-class"}, this.allXmlFiles, ".*", null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String qualifiedClassName = XMLRuleUtil.getTextWithoutWhitespace(node);
                CountJarFiles.this.addXmlReference(qualifiedClassName, fileName);
                return false;
            }
        };
    }

    public void addXmlReference(String qualifiedClassName, String fileName) {
        if (!qualifiedClassName.isEmpty() && this.qualifiedClassWithPackagePattern.matcher(qualifiedClassName).matches()) {
            String packageName = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
            String archiveName = ReportUtility.getArchiveNamePath(fileName);
            Set<String> packages = this.mapOfArchiveToPackagesItReferences.get(archiveName);
            if (packages == null) {
                packages = new HashSet<String>();
                this.mapOfArchiveToPackagesItReferences.put(archiveName, packages);
            }
            packages.add(packageName);
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return applicationXmlFile;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._applicationClientFiles.clearResults();
        this._ejbJarFiles.clearResults();
        this._webFragmentFiles.clearResults();
        this._jarFiles.clearResults();
        this._appClientModules.clearResults();
        this._classFiles.clearResults();
        this.appClients.clear();
        this.packagesPerArchive.clear();
        this.unusedJars.clear();
        this.usedPackageImplementaions.clear();
        this.processedPackageImplemenations.clear();
        this.allClassFiles.clear();
        this.mapOfArchiveToPackagesItReferences.clear();
        this.mapOfJarReferencedLocationChecksums.clear();
        this.mapOfJarReferencedByArch.clear();
        this.setOfUtilityJars.clear();
        this._tagClassDefinitions.clearResults();
        this._attributeClassDefinitions.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._attributeClassDefinitions.analyze(store, false);
        this._tagClassDefinitions.analyze(store, false);
        this._appClientModules.analyze(store, detectOnce);
        Set<String> keys = store.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String archiveName;
                ClassDataStore data = store.getClassDataStore(key);
                String fullyQualifiedClassName = data.getClassName();
                if (!fullyQualifiedClassName.contains(".") || !(archiveName = ReportUtility.getLastArchiveFileName(key)).endsWith(".jar")) continue;
                int index = fullyQualifiedClassName.indexOf(46);
                int secondIndex = fullyQualifiedClassName.indexOf(46, index + 1);
                int thirdIndex = secondIndex > -1 ? fullyQualifiedClassName.indexOf(46, secondIndex + 1) : -1;
                String packageName = null;
                packageName = thirdIndex > -1 ? fullyQualifiedClassName.substring(0, thirdIndex) : (secondIndex > -1 ? fullyQualifiedClassName.substring(0, secondIndex) : fullyQualifiedClassName.substring(0, index));
                if (this.packagesPerArchive.containsKey(archiveName)) {
                    this.packagesPerArchive.get(archiveName).add(packageName);
                    continue;
                }
                HashSet<String> packageNames = new HashSet<String>();
                packageNames.add(packageName);
                this.packagesPerArchive.put(archiveName, packageNames);
            }
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        Set<String> archivesWithAnnotations;
        List<DetailResult> ejbAnnoResults = super.getResults(store);
        this._applicationClientFiles.analyze(store, false);
        this._ejbJarFiles.analyze(store, false);
        this._webFragmentFiles.analyze(store, false);
        this._jarFiles.analyze(store, false);
        this._classFiles.analyze(store, false);
        List<DetailResult> resultsForAppClients = this._applicationClientFiles.getResults(store);
        List<DetailResult> resultsForEjbJarFiles = this._ejbJarFiles.getResults(store);
        List<DetailResult> resultsForWebFragmentFiles = this._webFragmentFiles.getResults(store);
        List<DetailResult> allJarFiles = this._jarFiles.getResults(store);
        ArrayList<DetailResult> additionalResults = new ArrayList<DetailResult>();
        if (!allJarFiles.isEmpty()) {
            String fileName;
            HashSet<String> appClientArchives = new HashSet<String>();
            HashSet<String> ejbJarArchives = new HashSet<String>();
            HashSet webFragmentArchives = new HashSet();
            appClientArchives.addAll(this.appClients);
            for (DetailResult nextEjbJar : resultsForEjbJarFiles) {
                fileName = ReportUtility.getLastArchiveFileName(nextEjbJar.getFileName());
                if (!fileName.endsWith(".jar") || this.appClients.contains(fileName)) continue;
                ejbJarArchives.add(fileName);
            }
            for (DetailResult nextEjbAnno : ejbAnnoResults) {
                fileName = ReportUtility.getLastArchiveFileName(nextEjbAnno.getFileName());
                if (!fileName.endsWith(".jar") || this.appClients.contains(fileName)) continue;
                ejbJarArchives.add(fileName);
            }
            for (DetailResult nextAppClient : resultsForAppClients) {
                fileName = ReportUtility.getLastArchiveFileName(nextAppClient.getFileName());
                if (!fileName.endsWith(".jar") || ejbJarArchives.contains(fileName)) continue;
                appClientArchives.add(fileName);
            }
            for (DetailResult nextWebFragment : resultsForWebFragmentFiles) {
                fileName = ReportUtility.getLastArchiveFileName(nextWebFragment.getFileName());
                if (!fileName.endsWith(".jar")) continue;
                webFragmentArchives.add(fileName);
            }
            Iterator<DetailResult> it = allJarFiles.iterator();
            boolean isSharedLibFile = false;
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                String fileName2 = nextResult.getFileName();
                isSharedLibFile = store.getSharedLibraryNames().contains(fileName2);
                if (appClientArchives.contains(fileName2)) {
                    nextResult.setRuleName("CountApplicationClients");
                    continue;
                }
                if (ejbJarArchives.contains(fileName2) && !isSharedLibFile) {
                    nextResult.setRuleName("CountEJBJarFiles");
                    this.createResultForArchiveWithAnnotation(store, additionalResults, nextResult, fileName2, "DetectJARsWithAnnotations");
                    continue;
                }
                if (webFragmentArchives.contains(fileName2)) {
                    nextResult.setRuleName("CountWebFragmentFiles");
                    this.createResultForArchiveWithAnnotation(store, additionalResults, nextResult, fileName2, "DetectJARsWithAnnotations");
                    continue;
                }
                Set<String> packageNames = this.packagesPerArchive.get(fileName2);
                if (packageNames != null) {
                    StringBuilder sb = new StringBuilder();
                    for (String nextPackage : packageNames) {
                        sb.append(String.valueOf(nextPackage) + ",");
                    }
                    String packageNamesCommaSeparated = sb.substring(0, sb.length() - 1);
                    this.setOfUtilityJars.add(store.getChecksum(fileName2));
                    additionalResults.add(new DetailResult("CountUtilityJarPackages", fileName2, this.getRuleDescription(), packageNamesCommaSeparated));
                }
                this.createResultForArchiveWithAnnotation(store, additionalResults, nextResult, fileName2, "DetectUtiltyJARsWithAnnotations");
            }
        }
        if (!(archivesWithAnnotations = store.getArchiveToAnnoTypeMap().keySet()).isEmpty()) {
            for (String archive : archivesWithAnnotations) {
                if (!archive.endsWith(".war")) continue;
                this.createResultForArchiveWithAnnotation(store, additionalResults, null, archive, "DetectWARsWithAnnotations");
            }
        }
        allJarFiles.addAll(additionalResults);
        if (!store.hasNullChecksum()) {
            boolean used = false;
            String archiveContainingPackageImplementation = null;
            String archiveContainingPackageImplementationCheckSum = null;
            String jarBeingProcessed = null;
            String jarBeingProcessedCheckSum = null;
            HashMap<String, Set<String>> mapOfJarToImplementedPackages = new HashMap<String, Set<String>>();
            HashSet<String> processedApps = new HashSet<String>();
            HashMap<String, Set<String>> mapOfChecksumToArcives = new HashMap<String, Set<String>>();
            Collections.sort(this.allClassFiles);
            HashMap<String, HashSet<String>> referencedPackagesToArchiveReferencing = new HashMap<String, HashSet<String>>();
            for (String key : this.allClassFiles) {
                String packageImplementationName = ReportUtility.getPackage(key);
                if (packageImplementationName == null) continue;
                String nextArchive = ReportUtility.getArchiveNamePath(key);
                if (!nextArchive.equals(archiveContainingPackageImplementation)) {
                    if (archiveContainingPackageImplementation != null) {
                        processedApps.add(archiveContainingPackageImplementationCheckSum);
                    }
                    archiveContainingPackageImplementation = nextArchive;
                    archiveContainingPackageImplementationCheckSum = store.getChecksum(archiveContainingPackageImplementation);
                    this.updateMapOfChecksumToArcives(mapOfChecksumToArcives, archiveContainingPackageImplementation, archiveContainingPackageImplementationCheckSum);
                }
                if (processedApps.contains(archiveContainingPackageImplementationCheckSum)) continue;
                boolean isJar = archiveContainingPackageImplementation.endsWith(".jar");
                if (isJar && jarBeingProcessed == null) {
                    jarBeingProcessed = archiveContainingPackageImplementation;
                    jarBeingProcessedCheckSum = archiveContainingPackageImplementationCheckSum;
                }
                if (jarBeingProcessed != null && !jarBeingProcessed.equals(archiveContainingPackageImplementation)) {
                    if (!used) {
                        this.unusedJars.add(jarBeingProcessedCheckSum);
                    } else {
                        used = false;
                    }
                    if (isJar) {
                        jarBeingProcessed = archiveContainingPackageImplementation;
                        jarBeingProcessedCheckSum = archiveContainingPackageImplementationCheckSum;
                    } else {
                        jarBeingProcessed = null;
                        jarBeingProcessedCheckSum = null;
                    }
                }
                if (isJar) {
                    String archiveChecksum;
                    HashSet<String> implementedPackages = (HashSet<String>)mapOfJarToImplementedPackages.get(jarBeingProcessedCheckSum);
                    if (implementedPackages == null) {
                        implementedPackages = new HashSet<String>();
                        mapOfJarToImplementedPackages.put(jarBeingProcessedCheckSum, implementedPackages);
                    }
                    implementedPackages.add(packageImplementationName);
                    if (!referencedPackagesToArchiveReferencing.isEmpty()) {
                        Set archivesReferencingPackage = (Set)referencedPackagesToArchiveReferencing.get(packageImplementationName);
                        if (archivesReferencingPackage != null) {
                            for (String archiveName : (Set)referencedPackagesToArchiveReferencing.get(packageImplementationName)) {
                                String archiveReferencingImplementation;
                                archiveChecksum = store.getChecksum(archiveName);
                                String jarContainingImplementation = archiveContainingPackageImplementation.substring(archiveContainingPackageImplementation.lastIndexOf(47) + 1);
                                if (jarContainingImplementation.equals(archiveReferencingImplementation = this.getArchiveReferencingImplementation(archiveName))) continue;
                                used = true;
                                this.updateReferences(packageImplementationName, archiveContainingPackageImplementationCheckSum, archiveChecksum);
                            }
                        }
                    } else {
                        for (Map.Entry<String, Set<String>> entry : this.mapOfArchiveToPackagesItReferences.entrySet()) {
                            String archiveName = entry.getKey();
                            archiveChecksum = store.getChecksum(archiveName);
                            Set<String> referencedPackages = entry.getValue();
                            for (String referencedPackage : referencedPackages) {
                                String jarContainingImplementation = archiveContainingPackageImplementation.substring(archiveContainingPackageImplementation.lastIndexOf(47) + 1);
                                String archiveReferencingImplementation = this.getArchiveReferencingImplementation(archiveName);
                                HashSet<String> appsReferencingPackage = (HashSet<String>)referencedPackagesToArchiveReferencing.get(referencedPackage);
                                if (appsReferencingPackage == null) {
                                    appsReferencingPackage = new HashSet<String>();
                                    referencedPackagesToArchiveReferencing.put(referencedPackage, appsReferencingPackage);
                                }
                                appsReferencingPackage.add(archiveName);
                                if (!referencedPackage.equals(packageImplementationName) || jarContainingImplementation.equals(archiveReferencingImplementation)) continue;
                                used = true;
                                this.updateReferences(packageImplementationName, archiveContainingPackageImplementationCheckSum, archiveChecksum);
                            }
                        }
                    }
                }
                this.processedPackageImplemenations.add(packageImplementationName);
            }
            if (jarBeingProcessedCheckSum != null && !used) {
                this.unusedJars.add(jarBeingProcessedCheckSum);
            }
            HashSet<String> finalUnusedJars = new HashSet<String>();
            finalUnusedJars.addAll(this.unusedJars);
            for (String jarChecksum : this.unusedJars) {
                if (!this.setOfUtilityJars.contains(jarChecksum) || !this.shouldFlagUnusedJar(jarChecksum, mapOfJarToImplementedPackages)) continue;
                for (String jar : (Set)mapOfChecksumToArcives.get(jarChecksum)) {
                    allJarFiles.add(new DetailResult("Unused", null, UNREFERENCED_RULE_DESCRIPTION, jar, 1, "", 0));
                }
                Set<String> jarsUsed = this.mapOfJarReferencedByArch.get(jarChecksum);
                if (jarsUsed == null) continue;
                this.lookAtReferencedJar(jarChecksum, jarsUsed, allJarFiles, mapOfChecksumToArcives, new HashSet<String>(), finalUnusedJars);
            }
        }
        ejbAnnoResults.clear();
        resultsForAppClients.clear();
        resultsForEjbJarFiles.clear();
        resultsForWebFragmentFiles.clear();
        store.getArchiveToAnnoTypeMap().clear();
        return allJarFiles;
    }

    public String getArchiveReferencingImplementation(String archiveName) {
        if (archiveName.contains("/")) {
            return archiveName.substring(archiveName.lastIndexOf(47) + 1);
        }
        return archiveName;
    }

    public void updateReferences(String packageImplementationName, String archiveContainingPackageImplementationCheckSum, String archiveChecksum) {
        this.usedPackageImplementaions.add(packageImplementationName);
        if (this.mapOfJarReferencedLocationChecksums.containsKey(archiveContainingPackageImplementationCheckSum)) {
            Set<String> referencedJarPaths = this.mapOfJarReferencedLocationChecksums.get(archiveContainingPackageImplementationCheckSum);
            referencedJarPaths.add(archiveChecksum);
        } else {
            HashSet<String> referencedJarPaths = new HashSet<String>();
            referencedJarPaths.add(archiveChecksum);
            this.mapOfJarReferencedLocationChecksums.put(archiveContainingPackageImplementationCheckSum, referencedJarPaths);
        }
        if (this.mapOfJarReferencedByArch.containsKey(archiveChecksum)) {
            Set<String> jarReferencingLocation = this.mapOfJarReferencedByArch.get(archiveChecksum);
            jarReferencingLocation.add(archiveContainingPackageImplementationCheckSum);
        } else {
            HashSet<String> jarReferencingLocation = new HashSet<String>();
            jarReferencingLocation.add(archiveContainingPackageImplementationCheckSum);
            this.mapOfJarReferencedByArch.put(archiveChecksum, jarReferencingLocation);
        }
    }

    public void updateMapOfChecksumToArcives(Map<String, Set<String>> mapOfChecksumToArcives, String archiveName, String archiveChecksum) {
        Set<String> setOfArchives = mapOfChecksumToArcives.get(archiveChecksum);
        if (setOfArchives == null) {
            setOfArchives = new HashSet<String>();
            mapOfChecksumToArcives.put(archiveChecksum, setOfArchives);
        }
        setOfArchives.add(archiveName);
    }

    private boolean shouldFlagUnusedJar(String jarName, Map<String, Set<String>> mapOfJarNameToImplPackages) {
        boolean flag = true;
        if (mapOfJarNameToImplPackages.containsKey(jarName)) {
            Set<String> containedPackages = mapOfJarNameToImplPackages.get(jarName);
            for (String nextPackage : containedPackages) {
                for (Pattern nextPackageRegex : _packagesToExcludeForInventory) {
                    if (!nextPackageRegex.matcher(nextPackage).matches()) continue;
                    return false;
                }
            }
        }
        return flag;
    }

    private void createResultForArchiveWithAnnotation(SimpleDataStore store, List<DetailResult> additionalResults, DetailResult nextResult, String fileName, String ruleName) {
        Set annoTypes = store.getArchiveToAnnoTypeMap().get(fileName);
        if (annoTypes != null) {
            String ruleDescription = null;
            if (nextResult != null) {
                ruleDescription = nextResult.getRuleDesc();
            }
            for (Archive.AnnotationType anno : annoTypes) {
                additionalResults.add(new DetailResult(ruleName, fileName, ruleDescription, anno.name()));
            }
        }
    }

    public void lookAtReferencedJar(String refJarChecksum, Set<String> jarsUsed, List<DetailResult> allJarFiles, Map<String, Set<String>> mapOfChecksumToArcives, Set<String> processedChecksums, Set<String> unusedJars) {
        HashSet<String> newUnusedJars = new HashSet<String>();
        for (String jarChecksum : jarsUsed) {
            Set<String> referencedLocationChecksums;
            if (processedChecksums.contains(jarChecksum) || (referencedLocationChecksums = this.mapOfJarReferencedLocationChecksums.get(jarChecksum)) == null || !this.setOfUtilityJars.contains(jarChecksum)) continue;
            boolean shouldRemove = true;
            for (String referencedLocation : referencedLocationChecksums) {
                if (referencedLocation == null || unusedJars.contains(referencedLocation) || referencedLocation.equals(jarChecksum)) continue;
                shouldRemove = false;
                break;
            }
            if (!shouldRemove) continue;
            newUnusedJars.add(jarChecksum);
            unusedJars.add(jarChecksum);
            for (String refJar : mapOfChecksumToArcives.get(refJarChecksum)) {
                for (String jar : mapOfChecksumToArcives.get(jarChecksum)) {
                    allJarFiles.add(new DetailResult("Unused", null, this.ruleDescription, jar, 1, refJar, 0));
                }
            }
            processedChecksums.add(jarChecksum);
        }
        processedChecksums.add(refJarChecksum);
        for (String jarChecksum : newUnusedJars) {
            Set<String> newJarsUsed = this.mapOfJarReferencedByArch.get(jarChecksum);
            if (newJarsUsed == null) continue;
            this.lookAtReferencedJar(jarChecksum, newJarsUsed, allJarFiles, mapOfChecksumToArcives, processedChecksums, unusedJars);
        }
    }

    public Set<String> consolidateNames(Set<String> referencedLocations) {
        HashSet<String> archiveNames = new HashSet<String>();
        for (String path : referencedLocations) {
            String archiveName = path.substring(path.lastIndexOf(47) + 1);
            archiveNames.add(archiveName);
        }
        return archiveNames;
    }
}

