/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CountServlets
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "CountServlets";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.Servlets";
    protected static final String[] classNames = new String[]{"javax.servlet.annotation.WebServlet"};
    protected static final String[] tags = new String[]{"servlet"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml"};
    protected DetectElement _servlets = null;
    protected Map<String, Set<String>> _webXmlToServletClassNames = new HashMap<String, Set<String>>();
    protected Map<String, String> _fileNameToClassName = new HashMap<String, String>();

    public CountServlets() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "class", null, null);
    }

    public CountServlets(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._servlets = new DetectElement(RULE_NAME, RULE_DESC, tags, fileNames, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String className = XMLRuleUtil.getFirstChildElementValue((Element)node, "*", "servlet-class");
                if (className != null) {
                    if (CountServlets.this._webXmlToServletClassNames.containsKey(fileName)) {
                        Set<String> classNames = CountServlets.this._webXmlToServletClassNames.get(fileName);
                        classNames.add(className);
                    } else {
                        HashSet<String> classNames = new HashSet<String>();
                        classNames.add(className);
                        CountServlets.this._webXmlToServletClassNames.put(fileName, classNames);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return fileNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._servlets.clearResults();
        this._webXmlToServletClassNames.clear();
        this._fileNameToClassName.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._servlets.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> servletAnnoResults = super.getResults(store);
        List<DetailResult> webXmlServletResults = this._servlets.getResults(store);
        Iterator<DetailResult> it = servletAnnoResults.iterator();
        while (it.hasNext()) {
            DetailResult nextAnnoResult = it.next();
            String fileName = nextAnnoResult.getFileName();
            if (!fileName.contains(".war")) continue;
            String webXmlPath = String.valueOf(fileName.substring(0, fileName.lastIndexOf(".war") + 5)) + fileNames[0];
            Set<String> classNames = this._webXmlToServletClassNames.get(webXmlPath);
            String annoClassName = this._fileNameToClassName.get(fileName);
            if (classNames == null || !classNames.contains(annoClassName)) continue;
            it.remove();
        }
        servletAnnoResults.addAll(webXmlServletResults);
        return servletAnnoResults;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
        if (shouldScan) {
            this._fileNameToClassName.put(key, data.getClassName());
        }
        return shouldScan;
    }
}

