/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectSession
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectSession";
    protected static final String RULE_DESC = "DetectSession";
    protected static final String HTTP_PACKAGE = "javax.servlet.http";
    protected static final String HTTPSESSION_CLASS = "javax.servlet.http.HttpSession";
    Set<String> appsUsingSessions = null;

    public DetectSession() {
        super("DetectSession", "DetectSession", true);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.appsUsingSessions = store.getAppsUsingSessions();
        if (this.appsUsingSessions != null) {
            Set<String> keys = store.getJspKeys();
            for (String key : keys) {
                this.updateSessionUse(key);
            }
            keys = store.getClassDataStoreKeys();
            if (!keys.isEmpty()) {
                for (String key : keys) {
                    ClassDataStore data = store.getClassDataStore(key);
                    ClassOrPackageDetails[] packageDetails = data.getPackageDetails(HTTP_PACKAGE);
                    if (packageDetails == null) continue;
                    ClassOrPackageDetails[] classOrPackageDetailsArray = packageDetails;
                    int n = packageDetails.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassOrPackageDetails packageDetail = classOrPackageDetailsArray[n2];
                        Map<String, ClassOrPackageOccurrence> mapOfReferenceAndLineInfo = packageDetail.getReferenceAndLineInfo();
                        for (ClassOrPackageOccurrence packageOcurrences : mapOfReferenceAndLineInfo.values()) {
                            List<String> lineNumberClassNames = packageOcurrences.getLineNumberClassNames();
                            List<String> parameterClassNames = packageOcurrences.getParameterClassNames();
                            List<String> returnTypeClassNames = packageOcurrences.getReturnTypeClassNames();
                            if (!(lineNumberClassNames != null && lineNumberClassNames.contains(HTTPSESSION_CLASS) || parameterClassNames != null && parameterClassNames.contains(HTTPSESSION_CLASS)) && (returnTypeClassNames == null || !returnTypeClassNames.contains(HTTPSESSION_CLASS))) continue;
                            this.updateSessionUse(key);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public void updateSessionUse(String fileName) {
        String appName = ReportUtility.getFirstArchiveName(fileName);
        if (appName != null) {
            this.appsUsingSessions.add(appName);
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }
}

