/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DuplicatePackages
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.Duplicate";
    protected static final Pattern[] classFile = new Pattern[]{Constants.CLASS_FILE_REG};
    protected static final String IBMJSPPACKAGE = "_ibmjsp";
    protected static final String ORACLEJSPPACKAGE = "jsp_servlet";
    public static final Pattern CONTENT_BEFORE_CLASS_PATTERN = Pattern.compile(".*\\/");
    protected Map<String, Set<String>> mapOfPackageNamesToArchivesToFlag = new HashMap<String, Set<String>>();
    protected Map<String, String> mapOfQualifiedClassNameToArchive = new HashMap<String, String>();

    public DuplicatePackages() {
        this("DuplicatePackages", RULE_DESC, classFile, false);
    }

    public DuplicatePackages(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> matches = store.getMatchingFileNames(classFile[0], false, true);
        for (String key : matches) {
            String packageName = ReportUtility.getPackage(key);
            String qualifiedClassName = ReportUtility.getQualifiedClassName(key);
            if (packageName == null || packageName.equals(IBMJSPPACKAGE) || packageName.equals(ORACLEJSPPACKAGE)) continue;
            String archiveName = ReportUtility.getArchiveNamePath(key);
            if (this.mapOfQualifiedClassNameToArchive.containsKey(qualifiedClassName)) {
                this.addToFlagList(packageName, archiveName);
                String originalArchive = this.mapOfQualifiedClassNameToArchive.get(qualifiedClassName);
                this.addToFlagList(packageName, originalArchive);
                continue;
            }
            this.mapOfQualifiedClassNameToArchive.put(qualifiedClassName, archiveName);
        }
        StringBuilder sb = null;
        for (String key : this.mapOfPackageNamesToArchivesToFlag.keySet()) {
            ArrayList archivePath = new ArrayList(this.mapOfPackageNamesToArchivesToFlag.get(key));
            Collections.sort(archivePath);
            for (String name2 : archivePath) {
                if (sb == null) {
                    sb = new StringBuilder(name2);
                    continue;
                }
                sb.append(",");
                sb.append(name2);
            }
            this.detailResults.add(new DetailResult(this.ruleName, null, this.ruleDescription, sb.toString(), 1, key, 0));
            sb = null;
        }
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfQualifiedClassNameToArchive.clear();
        this.mapOfPackageNamesToArchivesToFlag.clear();
    }

    public void addToFlagList(String packageName, String archiveName) {
        if (this.mapOfPackageNamesToArchivesToFlag.containsKey(packageName)) {
            Set<String> archiveNames = this.mapOfPackageNamesToArchivesToFlag.get(packageName);
            archiveNames.add(archiveName);
        } else {
            HashSet<String> archiveNames = new HashSet<String>();
            archiveNames.add(archiveName);
            this.mapOfPackageNamesToArchivesToFlag.put(packageName, archiveNames);
        }
    }
}

