/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ThirdPartyImplementation
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.ThirdPartyImplementations";
    protected static final Pattern[] classFile = new Pattern[]{Constants.CLASS_FILE_REG};
    protected Map<String, List<String>> mapOfArchivesToFlag = new HashMap<String, List<String>>();
    protected static LinkedHashMap<String, EnumSet<Server>> mapOfImpsToFind = new LinkedHashMap();
    protected static LinkedHashMap<String, String> mapOfServerForPackagesToFlag = new LinkedHashMap();

    static {
        mapOfImpsToFind.put("^com\\.google\\.common\\..*", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^com\\.starla\\.smb$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.sun\\.faces$", EnumSet.of(Server.V855));
        mapOfImpsToFind.put("^com\\.sun\\.mail\\..*", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^com\\.sun\\.tools\\.jxc$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.sun\\.tools\\.ws\\.ant$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.sun\\.tools\\.xjc$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.sun\\.xml\\.bind\\.marshaller$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.tivoli\\.pd\\.as\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^com\\.tivoli\\.pdwas\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^commonj\\.sdo(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^commonj\\.timers$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^commonj\\.work$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^io\\.swagger\\.annotations$", EnumSet.of(Server.Liberty));
        mapOfImpsToFind.put("^jain\\.protocol\\.ip\\.sip(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^javassist(\\..*|$)", EnumSet.of(Server.V855));
        mapOfImpsToFind.put("^net\\.sf\\.cglib\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.abdera(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.aries\\..*", EnumSet.of(Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.axiom\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.axis2(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.bval(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.codec\\.binary$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.collections(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.digester$", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.el(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.fileupload(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.io(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.lang3$", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.apache\\.commons\\.logging(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.cxf\\.binding\\.soap\\.wsdl\\.extensions$", EnumSet.of(Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.cxf\\.databinding$", EnumSet.of(Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.el(\\..*|$)", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.felix\\.bundlerepository$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.felix\\.scr$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.http(\\..*|$)", EnumSet.of(Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.jasper\\.compiler$", EnumSet.of(Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.jasper\\.el$", EnumSet.of(Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.jasper\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.myfaces\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.neethi\\.util$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.openjpa\\..*", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.sandesha2(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.taglibs\\.standard(\\..*|$)", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.tools\\.ant(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.tools\\.bzip2$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.tools\\.mail$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.tools\\.tar$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.tools\\.zip$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.webbeans(\\..*|$)", EnumSet.of(Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.wink\\..*", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.ws\\.commons\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.ws\\.java2wsdl(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.ws\\.security(\\..*|$)", EnumSet.of(Server.Liberty));
        mapOfImpsToFind.put("^org\\.apache\\.wsif(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.apache\\.xml\\.resolver$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.codehaus\\.jackson(\\..*|$)", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.eclipse\\.ant\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.core\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.emf\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.equinox\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.higgins\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.hyades\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.jdt\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.jem\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.jface\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.jst\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.pde\\.build$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.persistence\\..*", EnumSet.of(Server.V9, Server.V855, Server.Liberty));
        mapOfImpsToFind.put("^org\\.eclipse\\.text\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.tptp\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.ui\\.workbench$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.update\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.wst\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.eclipse\\.xsd\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.glassfish\\.json(\\..*|$)", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.jboss\\.classfilewriter(\\..*|$)*", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.jboss\\.jdeparser(\\..*|$)*", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.jboss\\.logging$", EnumSet.of(Server.V9));
        mapOfImpsToFind.put("^org\\.jboss\\.weld(\\..*|$)", EnumSet.of(Server.V9, Server.Liberty));
        mapOfImpsToFind.put("^org\\.objectweb\\.asm(\\..*|$)", EnumSet.of(Server.V9, Server.Liberty));
        mapOfImpsToFind.put("^org\\.uddi\\.v3\\..*", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.uddi4j(\\..*|$)", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.w3\\.ns\\.ws_policy$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.w3\\.schema\\.xmldsig$", EnumSet.of(Server.V9, Server.V855));
        mapOfImpsToFind.put("^org\\.w3\\.www$", EnumSet.of(Server.V9));
    }

    public ThirdPartyImplementation() {
        this("ThirdPartyImplementation", RULE_DESC, classFile, false);
    }

    public ThirdPartyImplementation(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfArchivesToFlag.clear();
    }

    public static Set<String> getThirdPartyPackages() {
        return mapOfImpsToFind.keySet();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        List<String> locations;
        Set<String> matches = store.getMatchingFileNames(classFile[0], false, true);
        for (String key : matches) {
            StringBuilder servers = new StringBuilder();
            String packageName = ReportUtility.getPackage(key);
            if (packageName == null) continue;
            String archiveName = ReportUtility.getArchiveNamePath(key);
            for (String reg : mapOfImpsToFind.keySet()) {
                if (!packageName.matches(reg) || !this.shouldFlag(packageName, archiveName)) continue;
                EnumSet<Server> enumServers = mapOfImpsToFind.get(reg);
                if (!mapOfServerForPackagesToFlag.containsKey(packageName)) {
                    if (enumServers.contains((Object)Server.V855)) {
                        servers.append(Messages.getString("INVENTORY_REPORT_V855"));
                        servers.append(", ");
                    }
                    if (enumServers.contains((Object)Server.V9)) {
                        servers.append(Messages.getString("INVENTORY_REPORT_V9"));
                        servers.append(", ");
                    }
                    if (enumServers.contains((Object)Server.Liberty)) {
                        servers.append(Messages.getString("INVENTORY_REPORT_LIBERTY"));
                    }
                    if (servers.length() != 0 && servers.charAt(servers.length() - 2) == ',') {
                        servers.delete(servers.length() - 2, servers.length());
                    }
                    mapOfServerForPackagesToFlag.put(packageName, servers.toString());
                }
                if (this.mapOfArchivesToFlag.containsKey(packageName)) {
                    locations = this.mapOfArchivesToFlag.get(packageName);
                    locations.add(archiveName);
                    continue;
                }
                locations = new ArrayList<String>();
                locations.add(archiveName);
                this.mapOfArchivesToFlag.put(packageName, locations);
            }
        }
        StringBuilder sb = null;
        for (String key : this.mapOfArchivesToFlag.keySet()) {
            locations = this.mapOfArchivesToFlag.get(key);
            Collections.sort(locations);
            for (String name2 : locations) {
                if (sb == null) {
                    sb = new StringBuilder(name2);
                    continue;
                }
                sb.append(",");
                sb.append(name2);
            }
            this.detailResults.add(new DetailResult(this.ruleName, mapOfServerForPackagesToFlag.get(key), this.ruleDescription, sb.toString(), 1, key, 0));
            sb = null;
        }
    }

    public boolean shouldFlag(String packageName, String archiveName) {
        List<String> archiveNames = this.mapOfArchivesToFlag.get(packageName);
        return archiveNames == null || !archiveNames.contains(archiveName);
    }

    public static enum Server {
        Liberty,
        V9,
        V855;

    }
}

