/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.rules.DetectMultipleCriteria;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.RuleCategory;
import com.ibm.ws.report.binary.utilities.RuleHelper;
import com.ibm.ws.report.binary.utilities.eetechnologies.BeanValidationTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.CDITechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.EJBTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.ELTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.GeneralJakartaEETechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.J2EEManagementTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JAXRSTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JMSTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JPATechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JSFTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JSONBindingTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.JSPTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.MailTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.ServletTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.SpringTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.Technology;
import com.ibm.ws.report.binary.utilities.eetechnologies.WebSocketTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.XMLBindingTechnology;
import com.ibm.ws.report.binary.utilities.eetechnologies.XMLWSTechnology;
import com.ibm.ws.report.processor.ReportBuilder;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BinaryReportBuilder
extends ReportBuilder {
    public Map<String, Rule> _reportRules = new HashMap<String, Rule>();
    public Map<String, RuleCategory> _ruleCategories = new HashMap<String, RuleCategory>();
    public Map<ReportInputData.AppServer, List<Technology>> _technologies = new HashMap<ReportInputData.AppServer, List<Technology>>();
    public boolean _loadAllRules = false;

    public List<String> getSortedRulesAnalyzedForCategoriesStartingWithPrefix(String catPrefix) {
        ArrayList<String> connectivityRules = new ArrayList<String>();
        HashSet<String> allRules = new HashSet<String>();
        Set<String> mainCategoryKeys = this._ruleCategories.keySet();
        for (String nextCat : mainCategoryKeys) {
            if (!nextCat.startsWith(catPrefix)) continue;
            RuleCategory ruleCat = this._ruleCategories.get(nextCat);
            allRules.addAll(ruleCat.getAllRulesUnderThisCategory());
        }
        connectivityRules.addAll(allRules);
        Collections.sort(connectivityRules);
        return connectivityRules;
    }

    public Map<ReportInputData.AppServer, List<String>> getSortedRulesAnalyzedForCategoriesStartingWithPrefix(String catPrefix, ReportInputData.AppServer targetWas) {
        EnumMap<ReportInputData.AppServer, List<String>> connectivityRules = new EnumMap<ReportInputData.AppServer, List<String>>(ReportInputData.AppServer.class);
        connectivityRules.put(targetWas, new ArrayList());
        connectivityRules.put(ReportInputData.AppServer.LIBERTY, new ArrayList());
        connectivityRules.put(ReportInputData.AppServer.OPEN_LIBERTY, new ArrayList());
        EnumMap connectivityRulesSet = new EnumMap(ReportInputData.AppServer.class);
        connectivityRulesSet.put(targetWas, new HashSet());
        connectivityRulesSet.put(ReportInputData.AppServer.LIBERTY, new HashSet());
        connectivityRulesSet.put(ReportInputData.AppServer.OPEN_LIBERTY, new HashSet());
        Set<String> mainCategoryKeys = this._ruleCategories.keySet();
        for (String nextCat : mainCategoryKeys) {
            if (!nextCat.startsWith(catPrefix)) continue;
            RuleCategory ruleCat = this._ruleCategories.get(nextCat);
            for (ReportInputData.AppServer targetServer : EnumSet.of(targetWas, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY)) {
                if (!((Set)this.targetToCategories.get(targetServer.toString())).contains(ruleCat.getCategoryDescription())) continue;
                ((Set)connectivityRulesSet.get((Object)targetServer)).addAll(ruleCat.getAllRulesUnderThisCategory());
            }
        }
        ((List)connectivityRules.get((Object)targetWas)).addAll((Collection)connectivityRulesSet.get((Object)targetWas));
        ((List)connectivityRules.get((Object)ReportInputData.AppServer.LIBERTY)).addAll((Collection)connectivityRulesSet.get((Object)ReportInputData.AppServer.LIBERTY));
        ((List)connectivityRules.get((Object)ReportInputData.AppServer.OPEN_LIBERTY)).addAll((Collection)connectivityRulesSet.get((Object)ReportInputData.AppServer.OPEN_LIBERTY));
        Collections.sort((List)connectivityRules.get((Object)targetWas));
        Collections.sort((List)connectivityRules.get((Object)ReportInputData.AppServer.LIBERTY));
        Collections.sort((List)connectivityRules.get((Object)ReportInputData.AppServer.OPEN_LIBERTY));
        return connectivityRules;
    }

    public Map<String, String> getCategoryNamesMappedToKeys() {
        HashMap<String, String> categoryNameToKeys = new HashMap<String, String>();
        Set<String> keys = this._ruleCategories.keySet();
        for (String key : keys) {
            RuleCategory cat = this._ruleCategories.get(key);
            String catDesc = cat.getCategoryDescription();
            categoryNameToKeys.put(catDesc, key);
            if (!cat.containsSubCategories()) continue;
            Set<String> subcatKeys = cat.getSubCategoryKeys();
            for (String subcatKey : subcatKeys) {
                RuleCategory subcat = cat.getSubCategory(subcatKey);
                String subcatDesc = subcat.getCategoryDescription();
                categoryNameToKeys.put(String.valueOf(catDesc) + " / " + subcatDesc, String.valueOf(key) + " / " + subcatKey);
            }
        }
        return categoryNameToKeys;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getSortedRulesByCategories() {
        HashMap<String, Map<String, Map<String, List<String>>>> sortedRulesByCats = new HashMap<String, Map<String, Map<String, List<String>>>>();
        Set<String> keys = this._ruleCategories.keySet();
        for (String key : keys) {
            RuleCategory cat = this._ruleCategories.get(key);
            String catDesc = cat.getCategoryDescription();
            HashMap<String, Map<String, List<String>>> subcats = new HashMap<String, Map<String, List<String>>>();
            if (cat.containsSubCategories()) {
                HashMap<String, List<String>> sortedCatRulesByType = new HashMap<String, List<String>>(cat.getSortedRulesByType());
                Set<String> subcatKeys = cat.getSubCategoryKeys();
                for (String subcatKey : subcatKeys) {
                    RuleCategory subcat = cat.getSubCategory(subcatKey);
                    String subcatDesc = subcat.getCategoryDescription();
                    Map<String, List<String>> sortedRulesByType = subcat.getSortedRulesByType();
                    subcats.put(subcatDesc, sortedRulesByType);
                    if (sortedCatRulesByType.isEmpty()) continue;
                    for (Map.Entry<String, List<String>> ruleTypeToRulesEntry : sortedRulesByType.entrySet()) {
                        List<String> rules = ruleTypeToRulesEntry.getValue();
                        ((List)sortedCatRulesByType.get(ruleTypeToRulesEntry.getKey())).removeAll(rules);
                    }
                }
                if (!sortedCatRulesByType.isEmpty()) {
                    subcats.put(catDesc, sortedCatRulesByType);
                }
            } else {
                Map<String, List<String>> sortedRulesByType = cat.getSortedRulesByType();
                subcats.put(catDesc, sortedRulesByType);
            }
            sortedRulesByCats.put(catDesc, subcats);
        }
        return sortedRulesByCats;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getSortedRulesByCategories(ReportInputData.AppServer targetAppServer) {
        HashMap<String, Map<String, Map<String, List<String>>>> sortedRulesByCats = new HashMap<String, Map<String, Map<String, List<String>>>>();
        Set rulesForTarget = (Set)this.targetToCategories.get(targetAppServer.toString());
        Set<String> keys = this._ruleCategories.keySet();
        for (String key : keys) {
            RuleCategory cat = this._ruleCategories.get(key);
            String catDesc = cat.getCategoryDescription();
            HashMap<String, Map<String, List<String>>> subcats = new HashMap<String, Map<String, List<String>>>();
            if (cat.containsSubCategories()) {
                HashMap<String, List<String>> sortedCatRulesByType = new HashMap<String, List<String>>(cat.getSortedRulesByType());
                Set<String> subcatKeys = cat.getSubCategoryKeys();
                for (String subcatKey : subcatKeys) {
                    RuleCategory subcat = cat.getSubCategory(subcatKey);
                    String subcatDesc = subcat.getCategoryDescription();
                    Map<String, List<String>> sortedRulesByType = subcat.getSortedRulesByType();
                    String mergedCatString = String.valueOf(catDesc) + " / " + subcatDesc;
                    if (!rulesForTarget.contains(mergedCatString)) continue;
                    subcats.put(subcatDesc, sortedRulesByType);
                    if (sortedCatRulesByType.isEmpty()) continue;
                    for (Map.Entry<String, List<String>> ruleTypeToRulesEntry : sortedRulesByType.entrySet()) {
                        List<String> rules = ruleTypeToRulesEntry.getValue();
                        ((List)sortedCatRulesByType.get(ruleTypeToRulesEntry.getKey())).removeAll(rules);
                    }
                }
                if (!sortedCatRulesByType.isEmpty() && rulesForTarget.contains(catDesc)) {
                    subcats.put(catDesc, sortedCatRulesByType);
                }
            } else {
                Map<String, List<String>> sortedRulesByType = cat.getSortedRulesByType();
                if (rulesForTarget.contains(catDesc)) {
                    subcats.put(catDesc, sortedRulesByType);
                }
            }
            if (subcats.isEmpty()) continue;
            sortedRulesByCats.put(catDesc, subcats);
        }
        return sortedRulesByCats;
    }

    public Map<String, LinkedHashSet<String>> getRulesToRecipesMap() {
        HashMap<String, LinkedHashSet<String>> rulesToRecipes = new HashMap<String, LinkedHashSet<String>>();
        for (Rule rule : this._reportRules.values()) {
            String ruleId = rule.getRuleName();
            LinkedHashSet<String> ruleRecipes = rule.getRecipes();
            if (ruleRecipes == null) continue;
            rulesToRecipes.put(ruleId, ruleRecipes);
        }
        return rulesToRecipes;
    }

    @Override
    protected Set<String> getRuleIds(String id) {
        HashSet<String> returnIds = new HashSet<String>();
        returnIds.add(id);
        return returnIds;
    }

    @Override
    public String loadCustomRule(String className, String mainCategory, String secondaryCategory, StringBuilder desc) {
        Rule thisRule = null;
        String ruleName = null;
        try {
            Class<?> customClass = ReportBuilder.class.getClassLoader().loadClass(className);
            thisRule = (Rule)customClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RuleHelper_Rule_Not_Loaded"), className), e);
        }
        catch (IllegalAccessException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RuleHelper_Rule_Not_Loaded"), className), e);
        }
        catch (InstantiationException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RuleHelper_Rule_Not_Loaded"), className), e);
        }
        if (thisRule != null) {
            ruleName = thisRule.getRuleName();
            desc.append(thisRule.getRuleDescription());
            this._reportRules.put(ruleName, thisRule);
            if (mainCategory != null) {
                StringBuilder mergedCategory = new StringBuilder();
                RuleCategory category = null;
                if (!this._ruleCategories.containsKey(mainCategory)) {
                    category = new RuleCategory(mainCategory, secondaryCategory);
                    this._ruleCategories.put(mainCategory, category);
                } else {
                    category = this._ruleCategories.get(mainCategory);
                }
                mergedCategory.append(category.getCategoryDescription());
                if (secondaryCategory == null) {
                    category.addRule(mainCategory, thisRule);
                } else {
                    category.addRule(secondaryCategory, thisRule);
                    mergedCategory.append(" / ");
                    mergedCategory.append(category.getSubCategory(secondaryCategory).getCategoryDescription());
                }
                if (this.currentCategories != null) {
                    this.currentCategory = mergedCategory.toString();
                    this.currentCategories.add(this.currentCategory);
                }
            }
        }
        return ruleName;
    }

    @Override
    protected String loadRule(Node ruleNode, String mainCategory, String secondaryCategory, StringBuilder desc, boolean external) {
        DetectRule thisRule = null;
        String ruleName = ruleNode.getAttributes().getNamedItem("id").getNodeValue();
        if (external && !ruleName.startsWith("userDefined_")) {
            ruleName = "userDefined_" + ruleName;
        }
        String ruleDesc = ruleNode.getAttributes().getNamedItem("description").getNodeValue();
        String[] ruleRecipes = null;
        Node recipesNode = ruleNode.getAttributes().getNamedItem("recipes");
        if (recipesNode != null) {
            String ruleRecipesAttr = ruleNode.getAttributes().getNamedItem("recipes").getNodeValue();
            String newS = ruleRecipesAttr.replace(" ", "");
            ruleRecipes = newS.split(",");
        }
        Element ruleElement = (Element)ruleNode;
        Node nextChild = ruleElement.getFirstChild();
        Element firstChild = null;
        boolean validRule = true;
        while (nextChild != null) {
            if (nextChild.getNodeType() == 1) {
                if (firstChild == null) {
                    firstChild = (Element)nextChild;
                } else {
                    validRule = false;
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("RuleHelper_More_Than_One_Detect_Rule"), ruleName));
                    break;
                }
            }
            nextChild = nextChild.getNextSibling();
        }
        if (firstChild == null) {
            validRule = false;
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("RuleHelper_No_Detect_Rule"), ruleName));
        }
        if (!this._loadAllRules && this._reportRules.containsKey(ruleName)) {
            validRule = false;
            this._foundInvalidRule = true;
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(com.ibm.ws.report.Messages.getString("ReportBuilder_Duplicate_Rule_ID"), ruleName));
        }
        if (!validRule) {
            return null;
        }
        String firstChildName = firstChild.getTagName();
        if (firstChildName.equals("detectPackage")) {
            thisRule = RuleHelper.createDetectPackageRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectClass")) {
            thisRule = RuleHelper.createDetectClassRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectAnnotation")) {
            thisRule = RuleHelper.createDetectAnnotationRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectMethod") || firstChildName.equals("detectMethodParameter") || firstChildName.equals("detectConstructor") || firstChildName.equals("detectConstructorParameter")) {
            thisRule = RuleHelper.createDetectMethodRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectStringLiteral")) {
            thisRule = RuleHelper.createDetectStringLiteralRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectElement")) {
            thisRule = RuleHelper.createDetectElementRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectAttribute")) {
            thisRule = RuleHelper.createDetectAttributeRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectManifestAttribute")) {
            thisRule = RuleHelper.createDetectManifestAttributeRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectDTD")) {
            thisRule = RuleHelper.createDetectDTDRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectJspTaglib")) {
            thisRule = RuleHelper.createDetectJspTaglibRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectHtmlActionTag")) {
            thisRule = RuleHelper.createDetectHtmlActionTagRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectFile")) {
            thisRule = RuleHelper.createDetectFileRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectEnumOrField")) {
            thisRule = RuleHelper.createDetectEnumOrFieldRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectProperty")) {
            thisRule = RuleHelper.createDetectPropertyRule(firstChild, ruleName, ruleDesc);
        } else if (firstChildName.equals("detectMultipleCriteria") || firstChildName.equals("or") || firstChildName.equals("and")) {
            DetectMultipleCriteria.LogicType logicType = DetectMultipleCriteria.LogicType.OR;
            if (firstChildName.equals("and")) {
                logicType = DetectMultipleCriteria.LogicType.AND;
            }
            thisRule = RuleHelper.createDetectMultipleCriteriaRule(firstChild, ruleName, ruleDesc, logicType);
        } else if (firstChildName.equals("detectFeature")) {
            thisRule = RuleHelper.createDetectFeatureRule(this, firstChild, ruleName, ruleDesc);
        } else {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RuleHelper_Element_Not_Supported"), firstChild.getTagName()));
        }
        if (thisRule == null) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RuleHelper_Rule_Not_Loaded"), ruleName));
            ruleName = null;
        } else {
            thisRule.setRecipes(ruleRecipes);
            desc.append(thisRule.getRuleDescription());
            this._reportRules.put(ruleName, thisRule);
            if (mainCategory != null) {
                StringBuilder mergedCategory = new StringBuilder();
                RuleCategory category = null;
                if (!this._ruleCategories.containsKey(mainCategory)) {
                    category = new RuleCategory(mainCategory, secondaryCategory);
                    this._ruleCategories.put(mainCategory, category);
                } else {
                    category = this._ruleCategories.get(mainCategory);
                }
                mergedCategory.append(category.getCategoryDescription());
                if (secondaryCategory == null) {
                    category.addRule(mainCategory, thisRule);
                } else {
                    category.addRule(secondaryCategory, thisRule);
                    mergedCategory.append(" / ");
                    mergedCategory.append(category.getSubCategory(secondaryCategory).getCategoryDescription());
                }
                if (this.currentCategories != null) {
                    this.currentCategory = mergedCategory.toString();
                    this.currentCategories.add(this.currentCategory);
                }
            }
        }
        return ruleName;
    }

    public void loadJavaEERules(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion sourceJavaEEVersion, ReportInputData.JavaEEVersion targetJavaEEVersion, boolean loadAllTechRules) {
        for (Technology tech : this.getTechnologies(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion)) {
            List<String> ruleReports = null;
            ruleReports = loadAllTechRules ? tech.getAllRules() : tech.getRules();
            HashMap<String, Set<String>> reportToRuleIds = new HashMap<String, Set<String>>();
            for (String ruleReport : ruleReports) {
                HashSet<String> rulesId = new HashSet<String>();
                this.loadList(ruleReport, rulesId, ReportBuilder.ListType.Analysis);
                reportToRuleIds.put(ruleReport, rulesId);
            }
            tech.setReportToRuleIds(reportToRuleIds);
        }
    }

    private List<Technology> getTechnologies(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion sourceJavaEEVersion, ReportInputData.JavaEEVersion targetJavaEEVersion) {
        List<Technology> technologies = this._technologies.get((Object)targetAppServer);
        if (technologies == null) {
            technologies = new ArrayList<Technology>();
            technologies.add(new BeanValidationTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new CDITechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new ELTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new GeneralJakartaEETechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JMSTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JAXRSTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JPATechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JSFTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new ServletTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new EJBTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new GeneralJakartaEETechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new J2EEManagementTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new XMLBindingTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new XMLWSTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new SpringTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new MailTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new WebSocketTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JSONBindingTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            technologies.add(new JSPTechnology(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion));
            this._technologies.put(targetAppServer, technologies);
        }
        return technologies;
    }

    public void setLoadAllRules(boolean loadAllRules) {
        this._loadAllRules = loadAllRules;
    }
}

