/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.XMLHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLResource {
    private String fileName = null;
    private final Document cachedDocument;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final Pattern xmlTagPattern = Pattern.compile("(<[^!?][^(><)]+>)", 32);
    private final Map<Node, NodeInfo> nodeMap = new HashMap<Node, NodeInfo>();
    private final List<String> fileContents = new ArrayList<String>();
    private final List<CommentInfo> comments = new ArrayList<CommentInfo>();
    private final Map<Integer, Integer> lineSeparatorMap = new HashMap<Integer, Integer>();
    private int lineCount = 0;
    private final int lineSeparatorLength = lineSeparator != null ? lineSeparator.length() : 1;
    private boolean commentsRemoved = false;

    public XMLResource(InputStream is, String fileName) throws Exception {
        this.fileName = fileName;
        boolean markSupported = is.markSupported();
        if (markSupported) {
            this.loadStructureHolders(is);
        }
        if (!this.hasRootElement() && !fileName.contains("__MACOSX")) {
            throw new EmptyDocumentException("XML file " + fileName + " did not have any root element.");
        }
        this.cachedDocument = XMLHelper.getParsedDocument(is, fileName.endsWith(".xhtml"));
        if (markSupported && this.cachedDocument != null) {
            NodeList nl = this.cachedDocument.getChildNodes();
            int numNodes = nl.getLength();
            int i = 0;
            while (i < numNodes) {
                Node docNode = nl.item(i);
                this.fillNodeMap(docNode, this.lineCount);
                ++i;
            }
        }
    }

    private void loadStructureHolders(InputStream is) {
        if (this.fileContents.isEmpty()) {
            try {
                this.loadFileContents(is);
                this.emptyComments();
                this.commentsRemoved = true;
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Determining_Line_Numbers_For_File_Log"), this.fileName), e);
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Determining_Line_Numbers_For_File"), this.fileName, e.getLocalizedMessage()));
            }
        }
    }

    private String getLine(BufferedReader reader, int lineCounter) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((c = reader.read()) > -1) {
            char ch = (char)c;
            if (ch == '\n') {
                this.lineSeparatorMap.put(lineCounter, 1);
                break;
            }
            if (ch == '\r') {
                boolean skipChar = false;
                try {
                    reader.mark(2);
                    int nextC = reader.read();
                    if (nextC == -1) {
                        this.lineSeparatorMap.put(lineCounter, 1);
                        break;
                    }
                    if ((char)nextC == '\n') {
                        skipChar = true;
                        this.lineSeparatorMap.put(lineCounter, 2);
                        break;
                    }
                    this.lineSeparatorMap.put(lineCounter, 1);
                    break;
                }
                finally {
                    reader.reset();
                    if (skipChar) {
                        reader.skip(1L);
                    }
                }
            }
            sb.append(ch);
        }
        if (c > -1 || sb.length() > 0) {
            line = sb.toString();
        }
        return line;
    }

    private void loadFileContents(InputStream is) throws IOException {
        if (this.fileContents.isEmpty()) {
            InputStreamReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                String line;
                is.mark(Integer.MAX_VALUE);
                fileReader = new InputStreamReader(is, "UTF-8");
                bufferedReader = new BufferedReader(fileReader);
                int lineCounter = 0;
                while ((line = this.getLine(bufferedReader, lineCounter)) != null) {
                    CommentInfo ci;
                    if (line.contains("<!--")) {
                        ci = null;
                        if (this.comments.isEmpty()) {
                            ci = new CommentInfo();
                            ci.setStartLine(lineCounter);
                            this.comments.add(ci);
                        } else {
                            ci = this.comments.get(this.comments.size() - 1);
                            if (ci.getEndLine() != -1) {
                                ci = new CommentInfo();
                                ci.setStartLine(lineCounter);
                                this.comments.add(ci);
                            }
                        }
                    }
                    if (line.contains("-->") && (ci = this.comments.get(this.comments.size() - 1)) != null) {
                        ci.setEndLine(lineCounter);
                    }
                    this.fileContents.add(line);
                    ++lineCounter;
                }
            }
            finally {
                is.reset();
            }
            boolean isXML = false;
            for (String line : this.fileContents) {
                if (!line.contains("xml")) continue;
                isXML = true;
                break;
            }
            if (!isXML && this.fileContents.size() > 0) {
                ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with a UTF-8 encoding. Trying to read with an IBM-1047 encoding.");
                String ebcdicString = new String(this.fileContents.get(0).getBytes(), "IBM-1047");
                ebcdicString = ebcdicString.replaceAll(String.valueOf('\u0085'), System.getProperty("line.separator"));
                if (ebcdicString.contains("xml")) {
                    this.fileContents.clear();
                    this.fileContents.addAll(Arrays.asList(ebcdicString.split(System.getProperty("line.separator"))));
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with an IBM-1047 encoding. Attempting to continue using the UTF-8 encoding.");
                }
            }
        }
    }

    private void emptyComments() {
        for (CommentInfo ci : this.comments) {
            String line;
            if (ci.getStartLine() == ci.getEndLine()) {
                line = this.fileContents.get(ci.getStartLine());
                int startIdx = line.indexOf("<!--");
                int endIdx = line.indexOf("-->");
                String commentText = line.substring(startIdx + 4, endIdx);
                line = line.replace(commentText, this.getBlanks(commentText.length()));
                this.fileContents.set(ci.getStartLine(), line);
                continue;
            }
            line = this.fileContents.get(ci.getStartLine());
            String commentText = line.substring(line.indexOf("<!--") + 4);
            line = line.replace(commentText, this.getBlanks(commentText.length()));
            this.fileContents.set(ci.getStartLine(), line);
            int i = ci.getStartLine() + 1;
            while (i < ci.getEndLine()) {
                line = this.fileContents.get(i);
                this.fileContents.set(i, this.getBlanks(line.length()));
                ++i;
            }
            line = this.fileContents.get(ci.getEndLine());
            commentText = line.substring(0, line.indexOf("-->"));
            line = line.replace(commentText, this.getBlanks(commentText.length()));
            this.fileContents.set(ci.getEndLine(), line);
        }
    }

    private String getBlanks(int count) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < count) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private void fillNodeMap(Node node, int fileCounter) {
        try {
            NodeInfo ni = null;
            if (node.getNodeType() == 8 || node.getNodeType() == 3 || node.getNodeType() == 10) {
                String s = node.getTextContent();
                if (s != null) {
                    int sLoc = s.indexOf(10);
                    while (sLoc >= 0) {
                        ++this.lineCount;
                        s = s.substring(sLoc + 1);
                        sLoc = s.indexOf(10);
                    }
                }
                return;
            }
            String nodeName = 2 == node.getNodeType() ? node.getNodeName() : "<" + node.getNodeName();
            int i = fileCounter;
            while (i < this.fileContents.size()) {
                String line = this.fileContents.get(i);
                if (line.contains(nodeName)) {
                    ni = new NodeInfo();
                    ni.setLineNumber(i + 1);
                    this.nodeMap.put(node, ni);
                    int idx = line.indexOf(nodeName);
                    if (2 != node.getNodeType()) {
                        ++idx;
                    }
                    int d = 0;
                    int j = 0;
                    while (j <= ni.getLineNumber() - 2) {
                        String l = this.fileContents.get(j);
                        d += l.length();
                        d += this.getLineSeparatorLength(j);
                        ++j;
                    }
                    ni.setStartPos(d += idx);
                    break;
                }
                ++i;
            }
            if (ni != null) {
                this.lineCount = ni.getLineNumber();
            }
            if (node.hasAttributes()) {
                int startLine = this.lineCount - 1;
                int i2 = 0;
                while (i2 < node.getAttributes().getLength()) {
                    Node attNode = node.getAttributes().item(i2);
                    this.fillNodeMap(attNode, startLine);
                    ++i2;
                }
            }
            i = 0;
            while (i < node.getChildNodes().getLength()) {
                Node docNode = node.getChildNodes().item(i);
                this.fillNodeMap(docNode, this.lineCount - 1);
                ++i;
            }
        }
        catch (Exception e) {
            if (ReportUtility.isDebug()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Determining_Line_Numbers_For_File_Log"), this.fileName), e);
            }
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Determining_Line_Numbers_For_File"), this.fileName, e.getLocalizedMessage()));
        }
    }

    private int getLineSeparatorLength(int lineNumber) {
        Integer val = this.lineSeparatorMap.get(lineNumber);
        if (val != null) {
            return val;
        }
        return this.lineSeparatorLength;
    }

    private boolean hasRootElement() {
        if (this.comments != null && !this.commentsRemoved) {
            this.emptyComments();
        }
        StringBuilder fileContentsBuilder = new StringBuilder();
        for (String line : this.fileContents) {
            fileContentsBuilder.append(line);
        }
        String fileContentsString = fileContentsBuilder.toString();
        Matcher match = xmlTagPattern.matcher(fileContentsString);
        return match.find();
    }

    public Document getDocument() {
        return this.cachedDocument;
    }

    public int getNodeLineNumber(Node node) {
        NodeInfo nodeInfo = this.nodeMap.get(node);
        if (nodeInfo == null) {
            return 0;
        }
        return nodeInfo.getLineNumber();
    }

    public int getNodeLineOffset(Node node) {
        NodeInfo nodeInfo = this.nodeMap.get(node);
        if (nodeInfo == null) {
            return 0;
        }
        return nodeInfo.getStartPos();
    }

    private static class CommentInfo {
        private int startLine = -1;
        private int endLine = -1;

        public int getStartLine() {
            return this.startLine;
        }

        public void setStartLine(int startLine) {
            this.startLine = startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public void setEndLine(int endLine) {
            this.endLine = endLine;
        }
    }

    public static class EmptyDocumentException
    extends Exception {
        public EmptyDocumentException(String message) {
            super(message);
        }
    }

    private static class NodeInfo {
        private int lineNumber;
        private int startPos;

        private NodeInfo() {
        }

        protected int getLineNumber() {
            return this.lineNumber;
        }

        protected void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        protected int getStartPos() {
            return this.startPos;
        }

        protected void setStartPos(int startPos) {
            this.startPos = startPos;
        }
    }
}

