/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.rules.DetectRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRuleUtil {
    public static Node getParentNode(Node child, String namespaceURI, String targetParentNodeName) {
        boolean loop = true;
        Node node = child;
        do {
            if (node != null) {
                Node parent = node.getParentNode();
                if (parent != null) {
                    if (namespaceURI == null || namespaceURI.trim().length() == 0 || namespaceURI.trim().equals("*")) {
                        if (targetParentNodeName.equals(parent.getLocalName())) {
                            loop = false;
                            return parent;
                        }
                    } else if (namespaceURI.equals(parent.getNamespaceURI()) && targetParentNodeName.equals(parent.getLocalName())) {
                        return parent;
                    }
                    node = parent;
                    continue;
                }
                loop = false;
                continue;
            }
            loop = false;
        } while (loop);
        return null;
    }

    public static List<Node> getTagDeclarations(Document document, String fileName, String[] xmlFiles, String tagNamespace, String[] tags) {
        if (document == null || !XMLRuleUtil.isMatchingFile(fileName, xmlFiles)) {
            return Collections.emptyList();
        }
        return XMLRuleUtil.getTagDeclarations(document, tagNamespace, tags);
    }

    public static List<Node> getTagDeclarations(Document document, String tagNamespace, String[] tags) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (tags != null) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String currentTag = stringArray[n2];
                NodeList nodeList = null;
                nodeList = "".equals(tagNamespace) ? document.getElementsByTagName(currentTag.trim()) : document.getElementsByTagNameNS("*", currentTag.trim());
                if (nodeList != null) {
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        String namespace;
                        Node currentNode = nodeList.item(i);
                        if ("".equals(tagNamespace) || tagNamespace.equals("*") || (namespace = currentNode.getNamespaceURI()) != null && namespace.matches(tagNamespace)) {
                            result.add(currentNode);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        } else {
            XMLRuleUtil.getAllTagDeclarations(document.getChildNodes(), tagNamespace, result);
        }
        return result;
    }

    public static List<Node> getAllTagDeclarations(NodeList children, String namespace, List<Node> result) {
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            String nodeNamespace;
            Node nextNode = children.item(i);
            if (nextNode.getNodeType() == 1 && (namespace == null || namespace.equals("*") || (nodeNamespace = nextNode.getNamespaceURI()) != null && nodeNamespace.matches(namespace))) {
                result.add(nextNode);
                if (nextNode.hasChildNodes()) {
                    XMLRuleUtil.getAllTagDeclarations(nextNode.getChildNodes(), namespace, result);
                }
            }
            ++i;
        }
        return result;
    }

    public static List<Node> getTagDeclarationsByAttributeValue(Document document, String fileName, String[] xmlFiles, String tagNamespace, String[] tags, String attributeNamespace, String attributeName, String attributeValue) {
        List<Node> tagNodes = XMLRuleUtil.getTagDeclarations(document, fileName, xmlFiles, tagNamespace, tags);
        return XMLRuleUtil.getTagDeclarationsByAttributeValue(tagNodes, attributeNamespace, attributeName, attributeValue);
    }

    public static Node getAttributeNode(NamedNodeMap attributes, String attributeNamespace, String attributeName) {
        int numAttrs = attributes.getLength();
        int i = 0;
        while (i < numAttrs) {
            String namespace;
            Node node = attributes.item(i);
            if (("".equals(attributeNamespace) || attributeNamespace.equals("*") || (namespace = node.getNamespaceURI()) != null && namespace.matches(attributeNamespace)) && node.getLocalName().matches(attributeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static String getAttributeValue(NamedNodeMap attributes, String attributeNamespace, String attributeName) {
        int numAttrs = attributes.getLength();
        int i = 0;
        while (i < numAttrs) {
            String namespace;
            Node node = attributes.item(i);
            if (("".equals(attributeNamespace) || attributeNamespace.equals("*") || (namespace = node.getNamespaceURI()) != null && namespace.matches(attributeNamespace)) && node.getLocalName().matches(attributeName)) {
                return node.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static List<Node> getTagDeclarationsByAttributeValue(List<Node> tagNodes, String attributeNamespace, String attributeName, String attributeValue) {
        boolean exactMatch;
        ArrayList<Node> result = new ArrayList<Node>();
        boolean bl = exactMatch = attributeName.matches("[a-zA-Z]*") && "".equals(attributeNamespace);
        if (exactMatch) {
            for (Node tagNode : tagNodes) {
                Node node = tagNode.getAttributes().getNamedItem(attributeName);
                if (node == null || attributeValue != null && (node.getNodeValue() == null || !node.getNodeValue().matches(attributeValue))) continue;
                result.add(node);
            }
        } else {
            for (Node tagNode : tagNodes) {
                NamedNodeMap attrs = tagNode.getAttributes();
                int numAttrs = attrs.getLength();
                int i = 0;
                while (i < numAttrs) {
                    String namespace;
                    Node node = attrs.item(i);
                    if (("".equals(attributeNamespace) || attributeNamespace.equals("*") || (namespace = node.getNamespaceURI()) != null && namespace.matches(attributeNamespace)) && node.getLocalName().matches(attributeName) && (attributeValue == null || node.getNodeValue() != null && node.getNodeValue().matches(attributeValue))) {
                        result.add(node);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public static List<Node> getTagDeclarationsByNodeOrAttributeValue(Document document, String fileName, String[] xmlFiles, String tagNamespace, String value, boolean preserveWhiteSpace, boolean skipRootElementAttributes) {
        boolean checkNamespace = tagNamespace != null && !tagNamespace.equals("") && !tagNamespace.equals("*");
        ArrayList<Node> result = new ArrayList<Node>();
        return XMLRuleUtil.getTagDeclarationsByNodeOrAttributeValue(document.getChildNodes(), tagNamespace, value, preserveWhiteSpace, skipRootElementAttributes, checkNamespace, result);
    }

    public static List<Node> getTagDeclarationsByNodeOrAttributeValue(NodeList children, String namespace, String value, boolean preserveWhiteSpace, boolean skipRootElementAttributes, boolean checkNamespace, List<Node> result) {
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            String nodeNamespace;
            Node nextNode = children.item(i);
            if (!checkNamespace || (nodeNamespace = nextNode.getNamespaceURI()) != null && nodeNamespace.matches(namespace)) {
                NamedNodeMap attrs;
                String text = XMLRuleUtil.getElmentNodeTextContent(nextNode);
                if (text != null) {
                    if (!preserveWhiteSpace) {
                        text = text.replaceAll("\\s+", "");
                    }
                    if (text.matches(value)) {
                        result.add(nextNode);
                    }
                }
                if (!skipRootElementAttributes && (attrs = nextNode.getAttributes()) != null) {
                    int numAttrs = attrs.getLength();
                    int j = 0;
                    while (j < numAttrs) {
                        String nodeAttrValue;
                        String nextAttrNodeNS;
                        Node nextAttrNode = attrs.item(j);
                        if ((!checkNamespace || (nextAttrNodeNS = nextNode.getNamespaceURI()) != null && nextAttrNodeNS.matches(namespace)) && (nodeAttrValue = nextAttrNode.getNodeValue()) != null && nodeAttrValue.matches(value)) {
                            result.add(nextAttrNode);
                        }
                        ++j;
                    }
                }
                if (nextNode.hasChildNodes()) {
                    XMLRuleUtil.getTagDeclarationsByNodeOrAttributeValue(nextNode.getChildNodes(), namespace, value, preserveWhiteSpace, false, checkNamespace, result);
                }
            }
            ++i;
        }
        return result;
    }

    public static List<Node> getTagDeclarationsByNodeValue(Document document, String fileName, String[] xmlFiles, String tagNamespace, String[] tags, String value, boolean preserveWhiteSpace) {
        List<Node> tagNodes = XMLRuleUtil.getTagDeclarations(document, fileName, xmlFiles, tagNamespace, tags);
        return XMLRuleUtil.getTagDeclarationsByNodeValue(tagNodes, value, preserveWhiteSpace);
    }

    public static List<Node> getTagDeclarationsByNodeValue(List<Node> tagNodes, String value, boolean preserveWhiteSpace) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node tagNode : tagNodes) {
            String text = XMLRuleUtil.getElmentNodeTextContent(tagNode);
            if (text == null) continue;
            if (!preserveWhiteSpace) {
                text = text.replaceAll("\\s+", "");
            }
            if (!text.matches(value)) continue;
            result.add(tagNode);
        }
        return result;
    }

    public static String getElmentNodeTextContent(Node n) {
        Node textChild = n.getFirstChild();
        if (textChild != null && textChild.getNodeType() != 8) {
            return textChild.getNodeValue();
        }
        return null;
    }

    public static List<Node> getDoctypeDTDReference(Document document, String fileName, String[] xmlFiles, String dtdName, boolean flagNullDocTypeWhenNoVersionAttrExists) {
        return XMLRuleUtil.getDoctypeDTDReference(document, fileName, xmlFiles, null, dtdName, flagNullDocTypeWhenNoVersionAttrExists);
    }

    public static List<Node> getDoctypeDTDReference(Document document, String fileName, String[] xmlFiles, String rootTag, String dtdName, boolean flagNullDocTypeWhenNoVersionAttrExists) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (document == null || !XMLRuleUtil.isMatchingFile(fileName, xmlFiles)) {
            return result;
        }
        DocumentType docType = document.getDoctype();
        Element root = document.getDocumentElement();
        if (rootTag != null && !root.getNodeName().equals(rootTag)) {
            return result;
        }
        if (flagNullDocTypeWhenNoVersionAttrExists) {
            String version = XMLRuleUtil.getAttributeValue(root.getAttributes(), "*", "version");
            if (docType == null && (version == null || version.equals("")) || docType != null && docType.getSystemId() != null && docType.getSystemId().matches(dtdName)) {
                result.add(root);
            }
        } else if (docType != null && docType.getSystemId() != null && docType.getSystemId().matches(dtdName)) {
            result.add(root);
        }
        return result;
    }

    public static String getDocumentTypeSystemId(Document document) {
        String result = null;
        DocumentType docType = document.getDoctype();
        if (docType != null) {
            return docType.getSystemId();
        }
        return result;
    }

    public static boolean isMatchingFile(String fileName, String[] xmlFiles) {
        String[] stringArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String xmlFile = stringArray[n2];
            if (XMLRuleUtil.isMatchingFile(fileName, xmlFile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMatchingFile(String fileName, String xmlFile) {
        String normalizedFileName = fileName.replace("\\", "/");
        boolean bool = xmlFile.contains("*") || xmlFile.contains("+") || xmlFile.contains("$") || xmlFile.contains("|") || xmlFile.contains("(") ? normalizedFileName.matches(xmlFile) : (xmlFile.startsWith(".") ? normalizedFileName.endsWith(xmlFile) : (xmlFile.indexOf(47) >= 0 ? normalizedFileName.endsWith(xmlFile) : normalizedFileName.equalsIgnoreCase(xmlFile)));
        return bool;
    }

    public static String getTextWithoutWhitespace(Node node) {
        if (node == null) {
            return null;
        }
        String text = node.getTextContent();
        if (text != null) {
            text = text.replaceAll("\\s+", "");
        }
        return text;
    }

    public static List<Element> getChildElements(Element parent, String namespaceURI, String targetName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parent.getElementsByTagNameNS(namespaceURI, targetName);
        int i = 0;
        while (i < children.getLength()) {
            Element childElement = (Element)children.item(i);
            if (namespaceURI == null || namespaceURI.trim().length() == 0 || namespaceURI.trim().equals("*")) {
                if (targetName.equals(childElement.getLocalName())) {
                    list.add(childElement);
                }
            } else if (namespaceURI.equals(childElement.getNamespaceURI()) && targetName.equals(childElement.getLocalName())) {
                list.add(childElement);
            }
            ++i;
        }
        return list;
    }

    public static List<Element> getChildElementsByAttributeValue(Element parent, String namespaceURI, String tagName, String attributeName, String attributeValuesRegex) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = null;
        children = namespaceURI != null ? parent.getElementsByTagNameNS(namespaceURI, tagName) : parent.getElementsByTagName(tagName);
        int i = 0;
        while (i < children.getLength()) {
            Element childElement = (Element)children.item(i);
            if (namespaceURI == null || namespaceURI.trim().length() == 0 || namespaceURI.trim().equals("*")) {
                String nameAttrValue;
                Node nameAttr;
                NamedNodeMap nodeAttributes;
                if (tagName.equals(childElement.getLocalName()) && (nodeAttributes = childElement.getAttributes()) != null && (nameAttr = nodeAttributes.getNamedItem(attributeName)) != null && (nameAttrValue = nameAttr.getNodeValue()).matches(attributeValuesRegex)) {
                    list.add(childElement);
                }
            } else if (namespaceURI.equals(childElement.getNamespaceURI()) && tagName.equals(childElement.getLocalName())) {
                list.add(childElement);
            }
            ++i;
        }
        return list;
    }

    public static Element getFirstChildElement(Element parent, String namespaceURI, String targetName) {
        NodeList children = parent.getElementsByTagNameNS(namespaceURI, targetName);
        int i = 0;
        while (i < children.getLength()) {
            Element childElement = (Element)children.item(i);
            if (namespaceURI == null || namespaceURI.trim().length() == 0 || namespaceURI.trim().equals("*") ? targetName.equals(childElement.getLocalName()) : namespaceURI.equals(childElement.getNamespaceURI()) && targetName.equals(childElement.getLocalName())) {
                return childElement;
            }
            ++i;
        }
        return null;
    }

    public static String getFirstChildElementValue(Element parent, String namespaceURI, String targetName) {
        Element childElement = XMLRuleUtil.getFirstChildElement(parent, namespaceURI, targetName);
        if (childElement != null) {
            return XMLRuleUtil.getTextWithoutWhitespace(childElement);
        }
        return null;
    }

    public static String getNodeValue(Node parent, String childNodeName) {
        Node firstChild;
        String nodeValue = null;
        Node node = XMLRuleUtil.getFirstChildNode(parent, childNodeName);
        if (node != null && (firstChild = node.getFirstChild()) != null && (nodeValue = firstChild.getNodeValue()) != null) {
            nodeValue = nodeValue.trim();
        }
        return nodeValue;
    }

    public static Node getFirstChildNode(Node parent, String childNodeName) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNodeName.equals(childNode.getLocalName())) {
                return childNode;
            }
            ++i;
        }
        return null;
    }

    public static boolean validateXMLFile(Document doc, DetectRule.XMLFileType xmlFileType) {
        boolean validFile = true;
        if (xmlFileType != null) {
            switch (xmlFileType) {
                case SPRING: {
                    validFile = XMLRuleUtil.isSpringBeansFile(doc);
                    break;
                }
            }
        }
        return validFile;
    }

    public static String getAttributeOrChildNodeValue(Node theNode, String nodeNameToFind) {
        String value = null;
        Node node = XMLRuleUtil.getAttributeOrChildNode(theNode, nodeNameToFind);
        if (node != null && (value = node.getTextContent()) != null) {
            value = value.replaceAll("\\s+", "");
        }
        return value;
    }

    public static Node getAttributeOrChildNode(Node theNode, String nodeNameToFind) {
        if (theNode == null) {
            return null;
        }
        Node node = theNode.getAttributes().getNamedItem(nodeNameToFind);
        if (node == null) {
            NodeList childNodes = theNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node possibleChild = childNodes.item(i);
                if (nodeNameToFind.equals(possibleChild.getLocalName())) {
                    node = possibleChild;
                }
                ++i;
            }
        }
        return node;
    }

    private static boolean isSpringBeansFile(Document doc) {
        String docTypeSysId;
        Element root = doc.getDocumentElement();
        if (XMLRuleUtil.isNodeNameValid(root, "beans")) {
            NamedNodeMap attrs = root.getAttributes();
            Node attrNode = null;
            int i = 0;
            while (i < attrs.getLength()) {
                attrNode = attrs.item(i);
                if (attrNode.getNodeValue().contains("springframework.org/schema/beans")) {
                    return true;
                }
                ++i;
            }
        }
        return (docTypeSysId = XMLRuleUtil.getDocumentTypeSystemId(doc)) != null && docTypeSysId.contains("springframework.org/dtd/spring-beans");
    }

    private static boolean isNodeNameValid(Node node, String name2) {
        String nodeName = node.getNodeName();
        if (nodeName != null) {
            int index = (nodeName = nodeName.trim()).indexOf(58);
            if (index > -1) {
                nodeName = nodeName.substring(index + 1);
            }
            return nodeName.equals(name2);
        }
        return false;
    }
}

