/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.Constants;
import com.ibm.ws.report.utilities.DetailResultComparator;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportUtility {
    private static boolean debugMode = false;
    private static boolean isWebApp = false;
    private static String logName;
    private static String standardErrLogName;
    private static Level debugFilterLevel;
    public static String OS;
    public static String buildAgent;
    public static String buildID;
    public static String latestCommit;
    public static final String NON_BREAKING_HYPHENS = "&#8209;&#8209;";
    public static final String HELP = "/help";
    public static ThreadLocal<String> helpPrefix;
    public static ThreadLocal<String> htmlLanguageAttribute;
    public static final Locale spanishLocale;
    public static final Locale ptLocale;
    public static final String[] boldedOptionsArr;
    public static final Set<String> boldedOptions;
    private static ThreadLocal<Locale> threadLocale;
    public static final ThreadLocal<Logger> logger;
    private static ThreadLocal<ByteArrayOutputStream> outputStream;
    private static PrintStream err;
    private static ThreadLocal<Boolean> ignoreExcludePackages;
    private static Pattern _includePackagesRegex;
    private static Pattern _excludePackagesRegex;
    private static boolean _checkIncludePackages;
    private static boolean _checkExcludePackages;
    private static boolean _checkDefaultExcludePackages;
    private static Pattern _excludePackagesDefaultRegex;
    private static int _severeCount;
    private static int _warningCount;
    private static boolean _isTAScan;
    private static boolean _noProgressIndicator;
    private static String _timestamp;
    private static Set<String> _filesWithParsingError;
    public static final Pattern PACKAGES_VALIDATION_REGEX;
    public static final char DASH = '/';
    public static final char DOT = '.';
    public static final String EAR = ".ear";
    public static final String WAR = ".war";
    public static final String MATCH_NON_FULLY_QUALIFIED_PATH_REG = "^(?![A-Z]:\\/|\\/).*";
    public static final Pattern MATCH_TEXT_PATTERN;
    public static final Pattern STRING_WITH_NO_DASH_PATTERN;
    public static final Pattern CONTENT_BEFORE_LAST_ARCHIVE_PATTERN;
    public static final Pattern CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN;
    public static final Pattern WEB_CONTENT_AND_CLASSES_FOLDER_PATTERN;
    public static final Pattern CONTENT_BEFORE_CLASS_NAME_PATTERN;
    public static final Pattern CONTENT_BEFORE_ARCHIVE_PATTERN;
    public static final Pattern REMAINING_CONTENT_AFTER_WAR_PATTERN;
    public static final Pattern CONTAINS_2_OR_MORE_ARCHIVES_PATTERN;
    public static final Pattern EAR_ARCHIVE_PATTERN;
    public static final Pattern WAR_ARCHIVE_PATTERN;
    public static final Pattern FIRST_ARCHIVE_ONWARDS_PATTERN;
    public static final Pattern TOP_ARCHIVE_PATTERN;
    public static final String MATCH_CONTENT_AFTER_FIRST_ARCHIVE = "(?<=\\.ear|war|jar|rar)/.*";
    public static final String BAR_CHART_SCRIPT_LOCATION = "/resources/inventoryReportBarChart.js";
    public static final String COPY_BUTTON_SCRIPT_LOCATION = "/resources/copyButton.js";
    public static final String SCRIPT_LOCATION = "/resources/report.js";
    public static final String SCRIPT_LOCATION_IE = "/resources/inventoryReportIE.js";
    public static final String STYLE_LOCATION = "/resources/consolidated.css";
    private static Map<Character, String> encodedHTMLEntitiesMap;
    private static Pattern matchHTMLEntities;
    private static Map<Character, String> encodedJSEntitiesMap;
    private static Pattern matchJSEntities;

    static {
        standardErrLogName = "";
        debugFilterLevel = null;
        OS = System.getProperty("os.name").toLowerCase();
        helpPrefix = new ThreadLocal();
        htmlLanguageAttribute = new ThreadLocal();
        spanishLocale = new Locale("es");
        ptLocale = new Locale("pt", "BR");
        boldedOptionsArr = new String[]{"excludePackages", "includePackages", "excludeFiles"};
        boldedOptions = new HashSet<String>(Arrays.asList(boldedOptionsArr));
        threadLocale = new ThreadLocal();
        logger = new ThreadLocal();
        outputStream = new ThreadLocal();
        err = null;
        ignoreExcludePackages = new ThreadLocal();
        _includePackagesRegex = null;
        _excludePackagesRegex = null;
        _checkIncludePackages = false;
        _checkExcludePackages = false;
        _checkDefaultExcludePackages = false;
        _excludePackagesDefaultRegex = null;
        _severeCount = 0;
        _warningCount = 0;
        _isTAScan = false;
        _noProgressIndicator = false;
        _timestamp = "";
        PACKAGES_VALIDATION_REGEX = Pattern.compile("(?:[0-9a-zA-Z_]+(\\.|/)?)+\\*?(\\s*,\\s*(?:[0-9a-zA-Z_]+(\\.|/)?)+\\*?)*\\s*,?\\s*");
        MATCH_TEXT_PATTERN = Pattern.compile(">([^\\<\\>]+?)<");
        STRING_WITH_NO_DASH_PATTERN = Pattern.compile("^[^\\/]+$");
        CONTENT_BEFORE_LAST_ARCHIVE_PATTERN = Pattern.compile("(.*)(?<=\\.(war|jar|rar)\\/)");
        CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN = Pattern.compile("(.*)(?<=\\.(war|jar|rar))");
        WEB_CONTENT_AND_CLASSES_FOLDER_PATTERN = Pattern.compile("(.*)(?<=classes\\/)");
        CONTENT_BEFORE_CLASS_NAME_PATTERN = Pattern.compile(".*(?=\\/)");
        CONTENT_BEFORE_ARCHIVE_PATTERN = Pattern.compile("(.*\\/)(?=\\w+\\.(war|jar|rar))");
        REMAINING_CONTENT_AFTER_WAR_PATTERN = Pattern.compile("([a-zA-Z]:)?\\/.*");
        CONTAINS_2_OR_MORE_ARCHIVES_PATTERN = Pattern.compile("(.*\\.[wjre]ar){2,}.*");
        EAR_ARCHIVE_PATTERN = Pattern.compile(".*\\.ear\\/");
        WAR_ARCHIVE_PATTERN = Pattern.compile(".*\\.war\\/");
        FIRST_ARCHIVE_ONWARDS_PATTERN = Pattern.compile("(?=[^\\/]+\\.(war|jar|rar)).*");
        TOP_ARCHIVE_PATTERN = Pattern.compile("[^\\/]+(?<=\\.)(?)(war|ear)");
        encodedHTMLEntitiesMap = new HashMap<Character, String>();
        encodedHTMLEntitiesMap.put(Character.valueOf('&'), "&amp;");
        encodedHTMLEntitiesMap.put(Character.valueOf('<'), "&lt;");
        encodedHTMLEntitiesMap.put(Character.valueOf('>'), "&gt;");
        encodedHTMLEntitiesMap.put(Character.valueOf('\"'), "&quot;");
        encodedHTMLEntitiesMap.put(Character.valueOf('\''), "&#x27;");
        encodedHTMLEntitiesMap.put(Character.valueOf('/'), "&#x2F;");
        matchHTMLEntities = Pattern.compile(".*(<|>|&|\"|'|/).*");
        encodedJSEntitiesMap = new HashMap<Character, String>();
        encodedJSEntitiesMap.put(Character.valueOf('\\'), "\\u005C");
        encodedJSEntitiesMap.put(Character.valueOf('\''), "\\u027");
        encodedJSEntitiesMap.put(Character.valueOf('\"'), "\\u0022");
        encodedJSEntitiesMap.put(Character.valueOf('>'), "\\u003E");
        encodedJSEntitiesMap.put(Character.valueOf('<'), "\\u003C");
        encodedJSEntitiesMap.put(Character.valueOf('&'), "\\u0026");
        encodedJSEntitiesMap.put(Character.valueOf('='), "\\u003D");
        encodedJSEntitiesMap.put(Character.valueOf('-'), "\\u002D");
        encodedJSEntitiesMap.put(Character.valueOf(';'), "\\u003B");
        encodedJSEntitiesMap.put(Character.valueOf('`'), "\\u0060");
        matchJSEntities = Pattern.compile(".*(<|>|&|\"|'|/|\\\\|=|;|`).*");
    }

    private ReportUtility() {
    }

    public static void initiateLogger(boolean debug, boolean webApp) {
        ReportUtility.initiateLogger(debug, webApp, null);
    }

    public static void initiateLogger(boolean debug, boolean webApp, Map<String, Level> mapOfLogArgs) {
        ReportUtility.initiateLogger(debug, webApp, false, mapOfLogArgs, null);
    }

    public static void initiateLogger(boolean debug, boolean webApp, boolean turnOffLog, final Map<String, Level> mapOfLogArgs, String logLocation) {
        logger.set(Logger.getLogger(ReportUtility.class.getName(), null));
        logger.get().setLevel(Level.INFO);
        debugMode = debug;
        isWebApp = webApp;
        _severeCount = 0;
        _warningCount = 0;
        _filesWithParsingError = new HashSet<String>();
        if (webApp) {
            outputStream.set(new ByteArrayOutputStream());
        } else {
            logger.get().setUseParentHandlers(false);
        }
        Formatter formatter = ReportUtility.getFormatter();
        if (debugMode) {
            String time;
            _timestamp = time = new SimpleDateFormat("yy.MM.dd_HH.mm.ss").format(new Date()).replace(' ', '_');
            String logDir = ReportUtility.createLogFolderIfNotExists("logs", logLocation);
            try {
                logName = "trace_" + time + ".log";
                logName = String.valueOf(logDir) + logName;
                FileHandler fileHandler = new FileHandler(logName, true);
                fileHandler.setFormatter(formatter);
                fileHandler.setLevel(mapOfLogArgs != null ? Level.ALL : Constants.defaultLogLevel);
                logger.get().addHandler(fileHandler);
            }
            catch (IOException e) {
                logger.get().log(Level.SEVERE, e.getLocalizedMessage(), e);
                logger.get().setUseParentHandlers(true);
            }
            logger.get().setLevel(mapOfLogArgs != null ? Level.ALL : Constants.defaultLogLevel);
            if (mapOfLogArgs != null) {
                if (mapOfLogArgs.containsKey("*")) {
                    debugFilterLevel = mapOfLogArgs.get("*");
                    mapOfLogArgs.remove("*");
                } else {
                    debugFilterLevel = Constants.defaultLogLevel;
                }
                logger.get().setFilter(new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        String recordQualifiedClassName = record.getSourceClassName();
                        String recordPackageName = recordQualifiedClassName.substring(0, recordQualifiedClassName.lastIndexOf(46));
                        Level recordLevel = record.getLevel();
                        boolean isLoggable = debugFilterLevel.intValue() <= recordLevel.intValue();
                        for (Map.Entry entry : mapOfLogArgs.entrySet()) {
                            String filterPackage = (String)entry.getKey();
                            Level filterLevel = (Level)entry.getValue();
                            if (filterPackage.endsWith("*")) {
                                String resolvedPackage = filterPackage.replace("*", "");
                                boolean endsWithDot = false;
                                if (resolvedPackage.endsWith(".")) {
                                    endsWithDot = true;
                                    resolvedPackage = resolvedPackage.substring(0, resolvedPackage.length() - 1);
                                }
                                if ((!endsWithDot || !resolvedPackage.equals(recordPackageName)) && !recordPackageName.startsWith(resolvedPackage) && !recordQualifiedClassName.startsWith(resolvedPackage)) continue;
                                isLoggable = filterLevel.intValue() <= recordLevel.intValue();
                                break;
                            }
                            if (!filterPackage.equals(recordPackageName) && !filterPackage.equals(recordQualifiedClassName)) continue;
                            isLoggable = filterLevel.intValue() <= recordLevel.intValue();
                            break;
                        }
                        if (isLoggable) {
                            ReportUtility.countErrors(record);
                        }
                        return isLoggable;
                    }
                });
            } else {
                logger.get().setFilter(new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        ReportUtility.countErrors(record);
                        return true;
                    }
                });
            }
            try {
                standardErrLogName = String.valueOf(logDir) + "std_err_" + time + ".log";
                File stdErr = new File(standardErrLogName);
                err = new PrintStream(stdErr);
                System.setErr(err);
            }
            catch (Exception e) {
                logger.get().log(Level.WARNING, e.getLocalizedMessage(), e);
                logger.get().setUseParentHandlers(true);
            }
        } else {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            if (turnOffLog) {
                handler.setLevel(Level.OFF);
            }
            logger.get().addHandler(handler);
            if (turnOffLog) {
                logger.get().setLevel(Level.OFF);
            }
        }
    }

    public static void setIgnoreExcludePackages(boolean value) {
        ignoreExcludePackages.set(value);
    }

    private static String createLogFolderIfNotExists(String directory, String logLocation) {
        boolean useFolder = true;
        boolean useLogLocation = false;
        File directoryFile = null;
        if (logLocation != null) {
            directoryFile = new File(String.valueOf(logLocation) + File.separator + directory);
            useLogLocation = !directoryFile.exists() ? directoryFile.mkdirs() : directoryFile.isDirectory();
        }
        if (!useLogLocation) {
            directoryFile = new File(directory);
            useFolder = !directoryFile.exists() ? directoryFile.mkdir() : directoryFile.isDirectory();
        }
        String logDir = "";
        if (useLogLocation) {
            logDir = String.valueOf(logLocation) + File.separator + directory + File.separator;
        } else if (useFolder) {
            logDir = String.valueOf(directory) + File.separator;
        }
        return logDir;
    }

    public static void setBuildVariables() {
        String buildDetailsFileName = "/resources/buildDetails.properties";
        try {
            InputStream buildProp = ReportUtility.class.getResourceAsStream(buildDetailsFileName);
            if (buildProp != null) {
                Properties props = new Properties();
                props.load(buildProp);
                Constants.buildAgent = props.getProperty("buildAgent");
                Constants.buildID = props.getProperty("buildID");
                Constants.latestCommit = props.getProperty("latestCommit");
            } else {
                logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Found"), buildDetailsFileName));
            }
        }
        catch (IOException e) {
            logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), buildDetailsFileName), e);
        }
    }

    public static String getLogName() {
        return logName;
    }

    public static String getStandardErrorLogName() {
        return standardErrLogName;
    }

    public static void cleanLog() {
        Handler[] targets = logger.get().getHandlers();
        int i = 0;
        while (i < targets.length) {
            Handler h = targets[i];
            logger.get().removeHandler(h);
            try {
                h.close();
            }
            catch (Exception exception) {}
            ++i;
        }
        try {
            if (err != null) {
                err.close();
            }
        }
        catch (Exception exception) {}
        logger.get().setLevel(Level.INFO);
        logger.get().setUseParentHandlers(true);
    }

    private static Formatter getFormatter() {
        Formatter formatter = isWebApp ? new Formatter(){

            @Override
            public String format(LogRecord record) {
                return "<li>" + record.getLevel() + ": " + record.getMessage() + "</li>";
            }
        } : (debugMode ? new Formatter(){
            private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
                builder.append(record.getLevel());
                builder.append(" (").append(record.getSourceClassName()).append(".");
                builder.append(record.getSourceMethodName()).append(") : ");
                builder.append(this.formatMessage(record));
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println();
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    builder.append(sw.toString());
                }
                builder.append(System.getProperty("line.separator"));
                return builder.toString();
            }
        } : new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getLevel() + ": " + record.getMessage() + System.getProperty("line.separator");
            }
        });
        return formatter;
    }

    public static String getLogOutputStream() {
        return outputStream.get().toString();
    }

    public static boolean isDebug() {
        return debugMode;
    }

    public static boolean shouldExceptionsBeLogged() {
        if (debugFilterLevel != null) {
            return debugFilterLevel.intValue() < Level.INFO.intValue();
        }
        return false;
    }

    public static boolean isWebApp() {
        return isWebApp;
    }

    public static int getSevereCount() {
        return _severeCount;
    }

    public static int getWarningCount() {
        return _warningCount;
    }

    public static boolean validPackages(String packages) {
        Matcher m = PACKAGES_VALIDATION_REGEX.matcher(packages);
        return m.find() ? m.group().equals(packages) : false;
    }

    public static synchronized void setLocale(Locale locale) {
        threadLocale.set(locale);
        String threadLang = threadLocale.get().getLanguage();
        String threadCountry = threadLocale.get().getCountry();
        htmlLanguageAttribute.set(threadLang);
        if (threadLang.equals("cs")) {
            helpPrefix.set("/help/cs");
        } else if (threadLang.equals("de")) {
            helpPrefix.set("/help/de");
        } else if (threadLang.equals("hu")) {
            helpPrefix.set("/help/hu");
        } else if (threadLang.equals("pl")) {
            helpPrefix.set("/help/pl");
        } else if (threadLang.equals("ru")) {
            helpPrefix.set("/help/ru");
        } else if (threadLang.equals("ro")) {
            helpPrefix.set("/help/ro");
        } else if (threadLang.equals(Locale.FRENCH.getLanguage())) {
            helpPrefix.set("/help/fr");
        } else if (threadLang.equals(Locale.ITALIAN.getLanguage())) {
            helpPrefix.set("/help/it");
        } else if (threadLang.equals(Locale.GERMAN.getLanguage())) {
            helpPrefix.set("/help/de");
        } else if (threadLang.equals(spanishLocale.getLanguage())) {
            helpPrefix.set("/help/es");
        } else if (threadLang.equals(Locale.JAPANESE.getLanguage())) {
            helpPrefix.set("/help/ja");
        } else if (threadLang.equals(Locale.KOREAN.getLanguage())) {
            helpPrefix.set("/help/ko");
        } else if (threadLang.equals(ptLocale.getLanguage())) {
            if (threadCountry.equals(ptLocale.getCountry())) {
                helpPrefix.set("/help/pt/BR");
                htmlLanguageAttribute.set("pt-br");
            }
        } else if (threadLang.equals(Locale.CHINESE.getLanguage())) {
            if (threadCountry.equals(Locale.TRADITIONAL_CHINESE.getCountry())) {
                helpPrefix.set("/help/zh/TW");
                htmlLanguageAttribute.set("zh-Hant");
            } else {
                helpPrefix.set("/help/zh/CN");
                htmlLanguageAttribute.set("zh-Hans");
            }
        } else {
            helpPrefix.set(HELP);
        }
    }

    public static Locale getLocale() {
        Locale locale = threadLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getLastArchiveFileName(String fileName) {
        Matcher m = Pattern.compile(".*(?<=\\.[ejrw]ar)").matcher(fileName);
        if (m.find()) {
            return m.group();
        }
        return fileName;
    }

    public static String getSubDir(String fullPath, String dirPath, String archiveName) {
        String subDir = null;
        String regex = "(?<=" + dirPath + "/).*(?=/" + archiveName + ")";
        Matcher m = Pattern.compile(regex).matcher(fullPath);
        if (m.find()) {
            subDir = m.group();
        }
        return subDir;
    }

    public static String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    public static String getFileNameNoExt(String filePath) {
        String fileName = ReportUtility.getFileName(filePath);
        return fileName.substring(0, fileName.length() - 4);
    }

    public static String getAttributeValue(String attribute, String element) {
        String value = null;
        element = element.replaceAll("\n", "");
        Pattern attributePattern = "text".equals(attribute) ? MATCH_TEXT_PATTERN : Pattern.compile(String.valueOf(attribute) + "=\"(.+?)\"");
        Matcher m = attributePattern.matcher(element);
        if (m.find()) {
            value = m.group(1);
        }
        return value;
    }

    public static String getPackage(String key) {
        String packageName = CONTENT_BEFORE_LAST_ARCHIVE_PATTERN.matcher(key).replaceFirst("");
        if (packageName.contains("WEB-INF/classes/")) {
            packageName = WEB_CONTENT_AND_CLASSES_FOLDER_PATTERN.matcher(packageName).replaceFirst("");
        }
        if (STRING_WITH_NO_DASH_PATTERN.matcher(packageName).matches()) {
            return null;
        }
        Matcher m = CONTENT_BEFORE_CLASS_NAME_PATTERN.matcher(packageName);
        if (m.find()) {
            packageName = m.group();
        }
        return packageName.replace('/', '.');
    }

    public static String getArchiveNamePath(String classFilePath) {
        return ReportUtility.getArchiveNamePath(classFilePath, false);
    }

    public static File getSystemTempDirectory() {
        File systemTempDir = null;
        String systemTempDirName = System.getProperty("java.io.tmpdir");
        if (systemTempDirName != null) {
            systemTempDir = new File(systemTempDirName);
        }
        return systemTempDir;
    }

    public static File createTempJaxrpcPrevalAppDirectory(File jaxrpcPrevalDir, String appPath) {
        File subdirectory = null;
        if (jaxrpcPrevalDir != null && jaxrpcPrevalDir.exists()) {
            subdirectory = new File(jaxrpcPrevalDir, ReportUtility.getFileNameNoExt(appPath));
            subdirectory.mkdir();
            boolean success = subdirectory.exists();
            if (!success) {
                subdirectory = null;
            }
        }
        return subdirectory;
    }

    public static File createTempJaxrpcPrevalDirectory(String prefix) {
        File subdirectory = null;
        File systemTempDir = ReportUtility.getSystemTempDirectory();
        if (systemTempDir != null && systemTempDir.exists()) {
            String suffix = Long.toString(System.nanoTime());
            subdirectory = new File(systemTempDir, String.valueOf(prefix) + suffix);
            subdirectory.mkdir();
            boolean success = subdirectory.exists();
            if (!success) {
                subdirectory = null;
            }
        }
        return subdirectory;
    }

    public static String getArchiveNamePath(String classFilePath, boolean keepFullPath) {
        if (classFilePath.matches(MATCH_NON_FULLY_QUALIFIED_PATH_REG) && !CONTAINS_2_OR_MORE_ARCHIVES_PATTERN.matcher(classFilePath).matches()) {
            Matcher m = TOP_ARCHIVE_PATTERN.matcher(classFilePath);
            if (m.find()) {
                classFilePath = m.group();
            }
            return classFilePath;
        }
        Matcher m = CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN.matcher(classFilePath);
        if (m.find()) {
            classFilePath = m.group();
        }
        if (!keepFullPath && !classFilePath.matches(MATCH_NON_FULLY_QUALIFIED_PATH_REG)) {
            return classFilePath;
        }
        if (classFilePath.contains(EAR)) {
            classFilePath = EAR_ARCHIVE_PATTERN.matcher(classFilePath).replaceFirst("");
        } else if (classFilePath.contains(WAR)) {
            classFilePath = WAR_ARCHIVE_PATTERN.matcher(classFilePath).replaceFirst("");
        }
        m = FIRST_ARCHIVE_ONWARDS_PATTERN.matcher(classFilePath);
        if (m.find()) {
            classFilePath = m.group();
        }
        return classFilePath;
    }

    public static void sortStringJSONArray(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < jsonArray.size()) {
            list.add((String)jsonArray.get(i));
            ++i;
        }
        jsonArray.clear();
        Collections.sort(list);
        for (String item : list) {
            jsonArray.add(item);
        }
    }

    public static String getQualifiedClassName(String fileName) {
        String qualifiedClassName = String.valueOf(ReportUtility.getPackage(fileName)) + "." + fileName.replaceFirst(".*/", "");
        qualifiedClassName = qualifiedClassName.replace(".class", "");
        return qualifiedClassName;
    }

    public static String getFirstArchiveName(String fileName) {
        String topArchiveName = fileName.replaceAll(MATCH_CONTENT_AFTER_FIRST_ARCHIVE, "");
        return topArchiveName.replaceAll(".*/", "");
    }

    public static String getLastPreviousArchivePath(String archiveNamePath) {
        archiveNamePath = archiveNamePath.replaceFirst("[^\\/]+\\.[ejrw]ar$", "");
        return ReportUtility.getLastArchiveFileName(archiveNamePath);
    }

    public static boolean containMoreThanOneArchive(String fileName) {
        return CONTAINS_2_OR_MORE_ARCHIVES_PATTERN.matcher(fileName).matches();
    }

    public static String minifyCSS(String source) {
        StringWriter result = new StringWriter();
        try {
            CssCompressor compressor = new CssCompressor(new StringReader(source));
            compressor.compress(result, -1);
        }
        catch (Exception e) {
            logger.get().log(Level.SEVERE, Messages.getString("ReportBuilder_Minify_Error"), e);
            return null;
        }
        return result.toString();
    }

    public static String minifyJS(String source) {
        StringWriter result = new StringWriter();
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor(new StringReader(source), null);
            compressor.compress(result, -1, true, false, false, false);
        }
        catch (Exception e) {
            logger.get().log(Level.SEVERE, Messages.getString("ReportBuilder_Minify_Error"), e);
            return null;
        }
        return result.toString();
    }

    public static String getSharedJS() {
        StringBuilder jsStringBuilder = new StringBuilder();
        String js = ReportUtility.loadFileAsString(SCRIPT_LOCATION_IE);
        if (js != null) {
            jsStringBuilder.append(js);
            js = ReportUtility.loadFileAsString(SCRIPT_LOCATION);
            if (js != null) {
                js = js.replace("SHOW_RULE_HELP", Messages.getString("ANALYSIS_REPORT_SHOW_RULE_HELP"));
                js = js.replace("CLOSE_RULE_HELP", Messages.getString("ANALYSIS_REPORT_CLOSE_RULE_HELP"));
                js = js.replace("SHOW_RESULTS", Messages.getString("ANALYSIS_REPORT_SHOW_RESULTS"));
                js = js.replace("CLOSE_RESULTS", Messages.getString("ANALYSIS_REPORT_CLOSE_RESULTS"));
                js = js.replace("CLOSE_DETAILS", Messages.getString("INVENTORY_REPORT_CLOSE_DETAILS"));
                js = js.replace("SHOW_DETAILS", Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                js = js.replace("SHOW_LESS", Messages.getString("ANALYSIS_REPORT_SHOW_LESS"));
                js = js.replace("SHOW_MORE", Messages.getString("ANALYSIS_REPORT_SHOW_MORE"));
                jsStringBuilder.append(js);
            }
        }
        return jsStringBuilder.toString();
    }

    public static String loadRuleHelpBody(String fileName, Locale locale) throws FileNotFoundException {
        ReportUtility.setLocale(locale);
        String prefix = helpPrefix.get();
        String fileContents = ReportUtility.loadFileAsString(String.valueOf(prefix) + fileName);
        return ReportUtility.helpFilePostProcessing(fileContents, fileName);
    }

    /*
     * Unable to fully structure code
     */
    public static String buildCopyArea(String content, String type) {
        block3: {
            sb = new StringBuilder();
            typeTitle = String.valueOf(type.substring(0, 1).toUpperCase()) + type.substring(1);
            sb.append("<div id=\"").append(type.toLowerCase()).append("-copyarea\">\n");
            sb.append("<div class=\"copyButton\">\n");
            sb.append("<svg id= '").append(type.toLowerCase()).append("-copyimg' src='guides_copy_button.svg' onmousedown='copy").append(typeTitle).append("()' onmouseup='copy").append(typeTitle).append("ButtonResetBorder()' onfocus='' alt='copy button icon' width='18' height='21' xmlns='http://www.w3.org/2000/svg'>\n");
            sb.append("<g fill='#5E6B8D' fill-rule='nonzero'>\n");
            sb.append("<path d='M12.857 5.25V1a1 1 0 0 0-1-1H1a1 1 0 0 0-1 1v13.75a1 1 0 0 0 1 1h4.143V20a1 1 0 0 0 1 1H17a1 1 0 0 0 1-1V6.25a1 1 0 0 0-1-1h-4.143zm-7.714 7.875H2.57v-10.5h7.715V5.25H6.143a1 1 0 0 0-1 1v6.875zm10.286 5.25H7.714v-10.5h7.715v10.5z'/>\n");
            sb.append("<rect x='9' y='9.188' width='5.143' height='2.625' rx='1'/>\n");
            sb.append("<rect x='9' y='13.125' width='5.143' height='2.625' rx='1'/>\n");
            sb.append("</g>\n");
            sb.append("</svg>\n");
            sb.append("</div>");
            sb.append("<div id='").append(type).append("Input'>\n");
            sb.append("<code>");
            codeContent = content.replace("<", "&lt;").replace(">", "&gt;");
            m = Pattern.compile("&lt;.*&gt;").matcher(codeContent);
            indent = 0;
            if (!"rewriteGradleConfig".equals(type)) ** GOTO lbl47
            sb.append(codeContent);
            break block3;
lbl-1000:
            // 1 sources

            {
                line = m.group();
                if (line.startsWith("&lt;/")) {
                    --indent;
                }
                indentPrefix = "";
                i = 0;
                while (i < indent) {
                    indentPrefix = String.valueOf(indentPrefix) + "    ";
                    ++i;
                }
                sb.append(indentPrefix).append(line).append('\n');
                if (line.endsWith("/&gt;") || line.contains("&lt;/") || line.startsWith("&lt;!") || line.startsWith("&lt;?")) continue;
                ++indent;
lbl47:
                // 3 sources

                ** while (m.find())
            }
        }
        sb.append("</code>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
        return sb.toString();
    }

    public static String helpFilePostProcessing(String fileContents, String fileName) throws FileNotFoundException {
        String tableElement = "<table";
        String h3WithId = "<h3>";
        String prefix = helpPrefix.get();
        if (fileContents == null) {
            throw new FileNotFoundException();
        }
        boolean useDefaultHelpTitle = false;
        if (!(fileContents != null && fileContents.length() != 0 || prefix.equals(HELP))) {
            fileContents = ReportUtility.loadFileAsString(HELP + fileName);
            useDefaultHelpTitle = true;
        }
        String helpBodyContents = null;
        if (fileContents != null) {
            fileContents = fileContents.replaceAll("<script[\\s\\S]*?(\\/>|\\/script>)", "");
            fileContents = fileContents.replaceAll("<form[\\s\\S]*?(\\/>|\\/form>)", "");
            fileContents = fileContents.replaceAll("<\\?php[\\s\\S]*?\\?>", "");
            int startIndex = fileContents.indexOf("<body");
            int endIndex = fileContents.indexOf("</body>");
            if (startIndex > -1 && endIndex > -1 && endIndex > startIndex) {
                helpBodyContents = fileContents.substring(startIndex, endIndex + "</body>".length());
                String helpTitle = "";
                int index = helpBodyContents.indexOf("<p");
                if (!useDefaultHelpTitle) {
                    int spanIndex = helpBodyContents.indexOf("<span");
                    int h2Index = helpBodyContents.indexOf("<h2");
                    if (spanIndex > -1 && spanIndex < index) {
                        int titleIndex = helpBodyContents.indexOf(62, spanIndex);
                        int endTitleIndex = helpBodyContents.indexOf("</span>", titleIndex);
                        helpTitle = helpBodyContents.substring(titleIndex + 1, endTitleIndex);
                    } else if (h2Index > -1 && h2Index < index) {
                        int titleIndex = helpBodyContents.indexOf(62, h2Index);
                        int endTitleIndex = helpBodyContents.indexOf("</h2>", titleIndex);
                        helpTitle = helpBodyContents.substring(titleIndex + 1, endTitleIndex);
                    }
                }
                h3WithId = String.valueOf(h3WithId) + helpTitle + "</h3>\n";
                int endDivIndex = helpBodyContents.lastIndexOf("</div>");
                if (index > -1 && endDivIndex > -1 && endDivIndex > index) {
                    helpBodyContents = helpBodyContents.substring(index, endDivIndex);
                }
                String tableSummary = "<table summary=\"" + Messages.getString("ANALYSIS_REPORT_TABLE_SUMMARY_HELP") + "\"";
                helpBodyContents = helpBodyContents.replace(tableElement, tableSummary);
                helpBodyContents = String.valueOf(h3WithId) + helpBodyContents;
            } else {
                helpBodyContents = "<h3>Rule desc not found</h3>\n";
            }
        } else {
            helpBodyContents = "<h3>Rule desc not found</h3>\n";
        }
        return helpBodyContents;
    }

    public static String loadFileAsString(String fileName) {
        String contents = null;
        InputStream file = ReportUtility.class.getResourceAsStream(fileName);
        try {
            try {
                String line;
                if (file == null) {
                    file = new FileInputStream(new File(fileName));
                }
                StringBuilder out = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(file, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                    out.append(System.getProperty("line.separator"));
                }
                contents = out.toString();
                if (fileName.toLowerCase().endsWith(".html") && !contents.contains("html")) {
                    String ebcdicContents;
                    logger.get().log(Level.FINE, "No html content in " + fileName + " when read with UTF-8 encoding. Attempting to read with IBM-1047 encoding");
                    file.close();
                    file = ReportUtility.class.getResourceAsStream(fileName);
                    if (file == null) {
                        file = new FileInputStream(new File(fileName));
                    }
                    if ((ebcdicContents = ReportUtility.getFileStringEbcdic(file)).contains("html")) {
                        contents = ebcdicContents;
                    } else {
                        logger.get().log(Level.FINE, "No html content in: " + fileName + " when read with IBM-1047 encoding. File loaded with UTF-8 will be used.");
                    }
                }
            }
            catch (UnsupportedEncodingException e1) {
                if (ReportUtility.isDebug()) {
                    logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), fileName), e1);
                } else {
                    logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), fileName));
                }
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception e) {
                    logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
                }
            }
            catch (IOException e) {
                block28: {
                    if (ReportUtility.isDebug()) {
                        logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), fileName), e);
                        break block28;
                    }
                    logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), fileName));
                }
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception e2) {
                    logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e2);
                }
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {
                logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
            }
        }
        return contents;
    }

    public static String getRuleNameForHTML(String ruleName) {
        if (ruleName.contains("<") || ruleName.contains(">")) {
            return ruleName.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return ruleName;
    }

    public static String filterUppercaseFileExtension(String pathName) {
        if (pathName.matches(".*\\.(?i)(([ejwr]ar)|([ec]ba))")) {
            return String.valueOf(pathName.substring(0, pathName.length() - 4)) + pathName.toLowerCase().substring(pathName.length() - 4);
        }
        return pathName;
    }

    public static void writeHtmlTag(StringBuilder sb) {
        sb.append("<!DOCTYPE html>\n");
        sb.append("<html lang=\"").append(htmlLanguageAttribute.get()).append("\">\n");
    }

    public static void writeJSONHeader(OrderedJSONObject reportObject, String reportType, String reportVersion, JSONArray reportOptions) {
        reportObject.put("report", reportType);
        reportObject.put("version", reportVersion);
        reportObject.put("productVersion", "23.0.0.5");
        reportObject.put("productRelease", "23.0.0.5");
        reportObject.put("buildID", Constants.buildID);
        reportObject.put("options", reportOptions);
    }

    public static void writeHeader(StringBuilder sb, String title, String author, boolean includeExternalJS, int numColumns) {
        ReportUtility.writeHeader(sb, title, author, includeExternalJS, numColumns, false);
    }

    public static void writeHeader(StringBuilder sb, String title, String author, boolean includeExternalJS, int numColumns, boolean isSourceScanner) {
        sb.append("<head>\n");
        sb.append("<meta charset=\"utf-8\">\n");
        sb.append("<title>");
        sb.append(title);
        sb.append("</title>\n");
        sb.append("<meta name=\"description\" content=\"");
        sb.append(title);
        sb.append("\">\n");
        sb.append("<meta name=\"author\" content=\"");
        sb.append(author);
        sb.append(" V");
        sb.append("23.0.0.5");
        sb.append(" B");
        sb.append(Constants.buildID);
        sb.append("\">\n");
        if (includeExternalJS) {
            ReportUtility.pullInExternalJS(sb);
        }
        ReportUtility.writeEmbeddedCSS(sb, numColumns, isSourceScanner);
        sb.append("</head>\n");
    }

    public static void writeEmbeddedCSS(StringBuilder sb, int numColumns, boolean isSourceScanner) {
        String css = ReportUtility.loadFileAsString(STYLE_LOCATION);
        if (css != null) {
            css = css.replaceAll("NUMBER_OF_COLUMNS", Integer.toString(numColumns));
            sb.append("<style type=\"text/css\">\n");
            if (!isSourceScanner) {
                String minifiedCSS = ReportUtility.minifyCSS(css);
                if (minifiedCSS != null) {
                    sb.append(minifiedCSS);
                }
            } else {
                sb.append(css);
            }
            sb.append("</style>\n");
        }
    }

    public static void pullInExternalJS(StringBuilder sb) {
        sb.append("<script type=\"text/javascript\" src=\"https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/downloads/wamt/ApplicationBinaryTP/rave/rave.min.js\" charset=\"utf-8\"></script>\n");
        String js = ReportUtility.loadFileAsString(BAR_CHART_SCRIPT_LOCATION);
        if (js != null) {
            sb.append("<script type=\"text/javascript\">\n");
            sb.append(js);
            sb.append("</script>\n");
        }
        if ((js = ReportUtility.loadFileAsString(COPY_BUTTON_SCRIPT_LOCATION)) != null) {
            sb.append("<script type=\"text/javascript\">\n");
            String minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                sb.append(minifiedJS);
            }
            sb.append("</script>\n");
        }
    }

    public static String getOptions(Map<String, String> options, boolean isHTML) {
        StringBuilder sb = new StringBuilder();
        if (options != null) {
            boolean addSpace = false;
            for (String key : options.keySet()) {
                if (boldedOptions.contains(key)) continue;
                String option = options.get(key);
                if (addSpace) {
                    sb.append(" ");
                } else {
                    addSpace = true;
                }
                if (isHTML) {
                    option = ReportUtility.encodeHTMLEntities(option);
                }
                sb.append(ReportUtility.replace(ReportUtility.replace(option, "--", NON_BREAKING_HYPHENS), ",", ", "));
            }
        }
        return sb.toString();
    }

    public static String getOptions(String[] options, boolean isHTML) {
        StringBuilder sb = new StringBuilder();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                String option = options[i];
                if (i > 0) {
                    sb.append(" ");
                }
                if (isHTML) {
                    option = ReportUtility.encodeHTMLEntities(option);
                }
                sb.append(ReportUtility.replace(ReportUtility.replace(option, "--", NON_BREAKING_HYPHENS), ",", ", "));
                ++i;
            }
        }
        return sb.toString();
    }

    public static String encodeHTMLEntities(String option) {
        if (option == null) {
            return null;
        }
        if (matchHTMLEntities.matcher(option).matches()) {
            StringBuilder sb = new StringBuilder();
            Set<Character> htmlEntitiesToEncode = encodedHTMLEntitiesMap.keySet();
            char[] charSeq = option.toCharArray();
            int i = 0;
            while (i < charSeq.length) {
                char c = charSeq[i];
                if (htmlEntitiesToEncode.contains(Character.valueOf(c))) {
                    sb.append(encodedHTMLEntitiesMap.get(Character.valueOf(c)));
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return option;
    }

    public static String encodeJSEntities(String option) {
        if (option == null) {
            return null;
        }
        if (matchJSEntities.matcher(option).matches()) {
            StringBuilder sb = new StringBuilder();
            Set<Character> jsEntitiesToEncode = encodedJSEntitiesMap.keySet();
            char[] charSeq = option.toCharArray();
            int i = 0;
            while (i < charSeq.length) {
                char c = charSeq[i];
                if (jsEntitiesToEncode.contains(Character.valueOf(c))) {
                    sb.append(encodedJSEntitiesMap.get(Character.valueOf(c)));
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return option;
    }

    public static void writeOptions(StringBuilder sb, String[] optionKeys, String[] optionValues) {
        int i = 0;
        String[] stringArray = optionValues;
        int n = optionValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null) {
                String[] splitStr = value.split("=");
                if (splitStr.length > 1 && (splitStr[0].equals("--excludeFiles") || splitStr[0].equals("--excludePackages") || splitStr[0].equals("--includePackages"))) {
                    ReportUtility.writeOptions(sb, Messages.getString(optionKeys[i]), splitStr[1]);
                } else {
                    ReportUtility.writeOptions(sb, Messages.getString(optionKeys[i]), value);
                }
            }
            ++i;
            ++n2;
        }
    }

    public static void writeOptions(StringBuilder sb, String optionKey, String optionValue) {
        if (optionValue.length() > 0) {
            sb.append("<p><b>");
            sb.append(optionKey);
            sb.append(":</b> <span class=\"courier\">");
            sb.append(optionValue);
            sb.append("</span>");
            sb.append("</p>\n");
        }
    }

    public static String replace(String text, String searchString, String replacement) {
        if (text.isEmpty() || searchString.isEmpty() || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = (increase < 0 ? 0 : increase) * 16;
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String[] split(String text, String searchString) {
        if (text.isEmpty() || searchString.isEmpty()) {
            return new String[]{text};
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return new String[]{text};
        }
        int replLength = searchString.length();
        ArrayList<String> result = new ArrayList<String>();
        while (end != -1) {
            result.add(text.substring(start, end));
            start = end + replLength;
            end = text.indexOf(searchString, start);
        }
        result.add(text.substring(start));
        return result.toArray(new String[0]);
    }

    public static void sortDetailResults(List<DetailResult> ruleResults) {
        Collections.sort(ruleResults, new DetailResultComparator());
    }

    public static int writeOutStream(File outputFile, String output) throws Exception {
        return ReportUtility.writeOutStream(outputFile, output, Level.INFO);
    }

    public static int writeOutStream(File outputFile, String output, Level successLevel) throws Exception {
        return ReportUtility.writeOutStream(outputFile, output, successLevel, true);
    }

    public static int writeOutStream(File outputFile, String output, Level successLevel, boolean logStatus) throws Exception {
        return ReportUtility.writeOutStream(outputFile, output, successLevel, logStatus, "UTF-8");
    }

    public static int writeOutStream(File outputFile, String output, Level successLevel, boolean logStatus, String characterEncoding) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter out = null;
        boolean fileWritten = true;
        try {
            fos = new FileOutputStream(outputFile);
            out = new OutputStreamWriter((OutputStream)fos, characterEncoding);
            try {
                out.write(output);
                if (logStatus) {
                    ReportUtility.writeToSystemOut(successLevel, Messages.getFormattedMessage(Messages.getString("REPORT_FILE_WRITTEN"), outputFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                if (logStatus) {
                    if (ReportUtility.isDebug()) {
                        logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("REPORT_WRITE_ERROR_LOG"), outputFile.getAbsolutePath()), e);
                    } else {
                        logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("REPORT_WRITE_ERROR"), outputFile.getAbsolutePath(), e.getMessage()));
                    }
                }
                fileWritten = false;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            } else if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (!fileWritten) {
                return 2;
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        } else if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
        if (!fileWritten) {
            return 2;
        }
        return 0;
    }

    public static <T extends Iterable> T nullGuard(T item) {
        return (T)(item == null ? Collections.EMPTY_LIST : item);
    }

    public static <T> T[] nullGuard(T[] item) {
        return item == null ? Collections.EMPTY_LIST.toArray() : item;
    }

    public static void loadExcludeIncludeDetails(boolean checkDefaultExcludePackages, Pattern excludePackagesDefaultRegex, boolean checkExcludePackages, Pattern excludePackagesRegex, boolean checkIncludePackages, Pattern includePackagesRegex) {
        _checkDefaultExcludePackages = checkDefaultExcludePackages;
        _excludePackagesRegex = excludePackagesRegex;
        _checkIncludePackages = checkIncludePackages;
        _checkExcludePackages = checkExcludePackages;
        _includePackagesRegex = includePackagesRegex;
        _excludePackagesDefaultRegex = excludePackagesDefaultRegex;
    }

    public static boolean shouldScanClassFileForRules(String key) {
        String className = ReportUtility.getQualifiedClassName(key);
        if (ignoreExcludePackages.get().booleanValue()) {
            return true;
        }
        if (className != null) {
            className = className.replace('.', '/');
            if (_checkDefaultExcludePackages) {
                if (_excludePackagesDefaultRegex.matcher(className).matches()) {
                    return false;
                }
            } else {
                if (_checkExcludePackages && _excludePackagesRegex.matcher(className).matches()) {
                    return false;
                }
                if (_checkIncludePackages) {
                    return _includePackagesRegex.matcher(className).matches();
                }
            }
        }
        return true;
    }

    public static String getFileStringEbcdic(InputStream file) throws IOException {
        StringBuilder out = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(file, "IBM-1047"));
            while ((line = reader.readLine()) != null) {
                out.append(line);
                out.append(System.getProperty("line.separator"));
            }
            reader.close();
            String xmlString = out.toString();
            String string = xmlString = xmlString.replaceAll(String.valueOf('\u0085'), System.getProperty("line.separator"));
            return string;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {
                logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
            }
        }
    }

    public static void writeToSystemOut(String message) {
        ReportUtility.writeToSystemOut(Level.INFO, message);
    }

    public static void writeToSystemOut(Level level, String message) {
        if (_isTAScan && !_noProgressIndicator) {
            logger.get().log(level, message);
        } else {
            System.out.println(message);
        }
    }

    public static void countErrors(LogRecord record) {
        Level level = record.getLevel();
        if (level.equals(Level.SEVERE)) {
            ++_severeCount;
        } else if (level.equals(Level.WARNING)) {
            ++_warningCount;
        }
    }

    public static void setTaMode(boolean taMode) {
        _isTAScan = taMode;
    }

    public static boolean isTAScan() {
        return _isTAScan;
    }

    public static void setNoProgressIndicator(boolean noProgressIndicator) {
        _noProgressIndicator = noProgressIndicator;
    }

    public static boolean getNoProgressIndicator() {
        return _noProgressIndicator;
    }

    public static String getTimestamp() {
        return _timestamp;
    }

    public static String getFilesWithParsingError() {
        String fileList = "";
        if (_filesWithParsingError.size() > 0) {
            for (String file : _filesWithParsingError) {
                fileList = String.valueOf(fileList) + file + "\n";
            }
            fileList.substring(0, fileList.length() - 1);
        }
        return fileList;
    }

    public static void addFileWithParsingError(String filePath, Exception e) {
        logger.get().log(Level.FINE, "Could not process the " + filePath + " file due to the following exception:\n" + e.toString());
        _filesWithParsingError.add(filePath);
    }

    public static void addSessionPersistenceTypeToClusterJson(OrderedJSONObject jsonObject, QosSessionPersistenceType sessionPersistenceType) {
        switch (sessionPersistenceType) {
            case DATABASE: {
                jsonObject.put("replicationType", "database");
                break;
            }
            case MEMORY_TO_MEMORY: {
                jsonObject.put("replicationType", "memory");
                break;
            }
            default: {
                jsonObject.put("replicationType", (Object)null);
            }
        }
    }

    public static void addTransactionLogTypeToClusterJson(OrderedJSONObject jsonObject, QosTransactionLogType transactionLogType) {
        switch (transactionLogType) {
            case DATABASE: {
                jsonObject.put("transactionLogType", "database");
                break;
            }
            case FILE: {
                jsonObject.put("transactionLogType", "file");
                break;
            }
            default: {
                jsonObject.put("transactionLogType", (Object)null);
            }
        }
    }

    public static void addClusterTypeAndMinMaxToClusterJson(OrderedJSONObject clusterObject, boolean isDynamicCluster, String effectiveMin, String effectiveMax, String numClusterMembers) {
        if (isDynamicCluster) {
            clusterObject.put("type", "dynamic");
            clusterObject.put("minSize", effectiveMin);
            clusterObject.put("maxSize", effectiveMax);
        } else {
            clusterObject.put("type", "static");
            clusterObject.put("minSize", numClusterMembers);
            clusterObject.put("maxSize", numClusterMembers);
        }
    }
}

