/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

public enum RewriteDependency {
    LIBERTY("org.openrewrite.recipe", "rewrite-liberty", "1.0.0", "org\\.openrewrite\\.\\w+\\.liberty\\..*"),
    MIGRATE_JAVA("org.openrewrite.recipe", "rewrite-migrate-java", "2.0.9", "org\\.openrewrite\\.java\\.migrate\\..*");

    private final String groupId;
    private final String artifactId;
    private final String version;
    protected Pattern recipePattern = null;
    private static final Map<String, RewriteDependency> lookupArtifact;
    protected static Map<String, RewriteDependency> knownRecipeDependencies;

    static {
        lookupArtifact = new HashMap<String, RewriteDependency>();
        knownRecipeDependencies = new HashMap<String, RewriteDependency>();
        for (RewriteDependency dependency : EnumSet.allOf(RewriteDependency.class)) {
            lookupArtifact.put(dependency.artifactId, dependency);
        }
    }

    private RewriteDependency(String groupId, String artifactId, String version, String recipeRegex) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.recipePattern = Pattern.compile(recipeRegex);
    }

    public static RewriteDependency resolveRecipeDependency(String recipeId) {
        if (knownRecipeDependencies.containsKey(recipeId)) {
            return knownRecipeDependencies.get(recipeId);
        }
        for (RewriteDependency dependency : EnumSet.allOf(RewriteDependency.class)) {
            if (!dependency.recipePattern.matcher(recipeId).matches()) continue;
            knownRecipeDependencies.put(recipeId, dependency);
            return dependency;
        }
        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RewriteConfigWriter_Unknown_Recipe"), recipeId));
        knownRecipeDependencies.put(recipeId, null);
        return null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.artifactId;
    }
}

