/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.ws.report.utilities.ReportUtility;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static Pattern scriptPattern = Pattern.compile("\\<script[^>]+\\>([\\s\\S]+?)<\\/script");

    public static Document getParsedDocument(InputStream is) throws Exception {
        return XMLHelper.getParsedDocument(is, false);
    }

    public static Document getParsedDocument(InputStream is, boolean isXHTML) throws Exception {
        Document thisDocument = null;
        if (is != null) {
            try {
                Matcher m;
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                if (impl == null) {
                    System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
                    registry = DOMImplementationRegistry.newInstance();
                    impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                }
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                f.setNamespaceAware(true);
                f.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder builder = f.newDocumentBuilder();
                BufferedInputStream bis = new BufferedInputStream(is);
                byte[] contents = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int nextByte;
                    while ((nextByte = bis.read()) != -1) {
                        baos.write(nextByte);
                    }
                    contents = baos.toByteArray();
                }
                finally {
                    if (baos != null) {
                        baos.close();
                    }
                }
                String xmlString = new String(contents, "UTF-8");
                if (!xmlString.contains("xml")) {
                    ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with a UTF-8 encoding. Trying to read with an IBM-1047 encoding.");
                    String ebcdicString = new String(contents, "IBM-1047");
                    ebcdicString = ebcdicString.replaceAll(String.valueOf('\u0085'), System.getProperty("line.separator"));
                    if (ebcdicString.contains("xml")) {
                        xmlString = ebcdicString;
                    } else {
                        ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with an IBM-1047 encoding. Attempting to parse using the UTF-8 encoding.");
                    }
                }
                if (isXHTML && (m = scriptPattern.matcher(xmlString)).find()) {
                    String scriptContent = m.group(1);
                    String encodedScriptContent = scriptContent.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&#38;").replace("'", "&#39;").replace("\"", "&#34;");
                    xmlString = xmlString.replace(scriptContent, encodedScriptContent);
                }
                InputSource in = new InputSource(new StringReader(xmlString));
                thisDocument = builder.parse(in);
                thisDocument.normalize();
            }
            catch (ClassNotFoundException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (InstantiationException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (Exception e) {
                throw e;
            }
        }
        return thisDocument;
    }

    public static String getStringFromDocument(Document doc, boolean isCompleteFile) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (!isCompleteFile) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        transformer.transform(domSource, result);
        return writer.toString().replace("?><", "?>" + System.getProperty("line.separator") + "<");
    }
}

